#include "file_system.h"

PSPOS_SingletonCpp( CFileSystem );

CFileSystem::CFileSystem( void ) :
    EnvironmentPath( "./" )
{
    PSPOS_CreateSingleton( CFileSystem );
}

CFileSystem::~CFileSystem( void )
{
    PSPOS_DestroySingleton( CFileSystem );
}

void CFileSystem::SetEnvironmentPath( CString & environment_path )
{
    EnvironmentPath = environment_path;
    EnvironmentPath.Replace( '/', '\\' );

    if( EnvironmentPath[ EnvironmentPath.GetLength() - 1 ] != '/' )
        EnvironmentPath += '/';
}

const CString & CFileSystem::GetEnvironmentPath( void ) const
{
    return EnvironmentPath;
}

void CFileSystem::SetPathList( const CText & path_list )
{
    uint32 path_index;

    PathList = path_list;

    for( path_index = 0 ; path_index < PathList.GetLinesCount() ; path_index ++ )
    {
        CString & path = PathList.GetLine( path_index );
        
        path.Replace( '/', '\\' );

        if( path[ path.GetLength() - 1 ] != '/' )
            path += '/';

        if( path.GetLength() > 0 && path[ 0 ] == '/' )
            path.Remove( 0 );
    }
}

bool CFileSystem::FindFullPath( CString & full_path, CString file_path ) const
{
    CString compliant_file_path;
    uint32 path_index;

    compliant_file_path = file_path;

    if( compliant_file_path.GetLength() == 0 )
        return false;

    compliant_file_path.Replace( '/', '\\' );

    if( compliant_file_path[ 0 ] == '/' )
        compliant_file_path.Remove( 0 );

    full_path = EnvironmentPath + compliant_file_path;

    if( DoesFileExist( full_path ) )
        return true;

    for( path_index = 0 ; path_index < PathList.GetLinesCount() ; path_index ++ )
    {
        full_path = EnvironmentPath + PathList.GetLine( path_index ) + compliant_file_path;
    
        if( DoesFileExist( full_path ) )
            return true;
    }

    return false;
}

bool CFileSystem::DoesFileExist( CString file_path ) const
{
    int file;

    file = sceIoOpen( file_path.GetBuffer(), PSP_O_RDONLY, 0777 );

    if( file < 0 )
        return false;

    sceIoClose( file );

    return true;
}
