#ifndef _KERNEL_FILE_SYSTEM_H_
    #define _KERNEL_FILE_SYSTEM_H_

    #include "libs.h"

    #define KERNEL_FileSystem() CFileSystem::GetInstance()

    class CFileSystem
    {      
        PSPOS_SingletonH( CFileSystem );

    public:

        CFileSystem( void );
        ~CFileSystem( void );

        void SetEnvironmentPath( CString & environment_path );
        const CString & GetEnvironmentPath( void ) const;
        void SetPathList( const CText & path_list );

        bool FindFullPath( CString & full_path, CString file_path ) const;
        bool DoesFileExist( CString file_path ) const;

    private:

        CString EnvironmentPath;
        CText PathList;
    };
#endif

