#ifndef _KERNEL_MODULE_MANAGER_H_
    #define _KERNEL_MODULE_MANAGER_H_

    #include "libs.h"

    #define KERNEL_ModuleManager() CModuleManager::GetInstance()

    class CModuleManager
    {    
        PSPOS_SingletonH( CModuleManager );

    public:

        CModuleManager( void );
        ~CModuleManager( void );

        bool FindModuleByName( CModule ** module, ulong * index, CString module_name ) const;
        bool FindModuleByType( CModule ** module, ulong * index, const MODULE_TYPE & module_type ) const;
        bool FindModuleNameByType( CString & module_name, const MODULE_TYPE & module_type ) const;
        bool FindModuleIndex( ulong * index, CModule & module ) const;
        
        void Initialize( void );
        void Finalize( void );
        void Update( void );

        void StartModules( void );
        void StopModules( void );
        bool StartModule( CModule & module, bool it_has_to_manage_array = true );
        bool StopModule( CModule & module, bool it_has_to_manage_array = true );
        bool StartModule( CString module_name, CString module_path );
        bool StopModule( CString module_name );
        
    private:

        void AttachKernelModule( CModule & module );
        void DetachKernelModule( CModule & module );
        void CreateProcFile( CModule & module );
        void DestroyProcFile( CModule & module );
        void UpdateLibraries( void );

    private:

        CList< CModule * > ModuleArray;
    };

#endif

