#ifndef _TERMINAL_H_
    #define _TERMINAL_H_

    #include "libs.h"
    
    class CTerminal
    {
    public:

        CTerminal( void );
        ~CTerminal( void );

        void SetPath( const CString & path );
        const CString & GetPath( void ) const;
        void SetHasEchoOn( bool it_has_echo_on );

        bool Initialize( void );
        void Finalize( void );
        void Update( void );

        void Write( CString string );
        void Clear( void );

    private:

        void CheckInput( void );
        void Render( void );
        
    private:

        CString Path;
        int CursorSpeed;
        ulong MaximumLineCount;
        ulong MaximumCommandCount;
        ulong ScreenLineCount;

        CText LineArray, CommandArray;
        ulong LineIndex, CommandIndex;
        uint32 CursorIndex;
        bool ItHasEchoOn;
    };
#endif
