uses routines,playmods,map,polygons;

const vidseg = $a000;
      zf = 256;
      zc = 256;
      xc = 160;
      yc = 100;

      ylevel = 0;
      xlevel = 0;
      zlevel = 0;

      zmove = 1;
      ambient = 255;
      xinc = 0;
      yinc = 0;
      zinc = 256;

      wavey = 24;
      diff = 16;
      xgap = 40;
      yrand = 0;
      zgap = 40;

      wp = 4;
      hp = 4;
      points = wp*hp;
      faces = 6*3;

      face : array[1..faces,1..3] of byte =
        ((1,2,5),(2,6,5),
         (2,3,6),(3,7,6),
         (3,4,7),(4,8,7), {}

         (5,6,9),(6,10,9),
         (6,7,10),(7,11,10),
         (7,8,11),(8,12,11),

         (9,10,13),(10,14,13),
         (10,11,14),(11,15,14),
         (11,12,15),(12,16,15));

      sinsize = 360;

      skip = 4;

var virseg : word;
    virscr : pointer;
    loop : word;
    ox,oy,oz : integer;
    stab,ctab : array[0..sinsize] of real;
    point,trans : array[1..points,1..3] of integer;
    pal : array[0..255,1..3] of byte;
    xphi,yphi,zphi : integer;
    palOK : boolean;
    frames : word;
    loppu : boolean;
    trackstatus : miscdata;
    status : miscdata;
    pphi : array[1..points] of word;

procedure rotate;

var x,y,z : integer;
    sinix,kosix,
    siniy,kosiy,
    siniz,kosiz : real;

begin
  sinix := stab[xphi shr 8];
  kosix := ctab[xphi shr 8];
  siniy := stab[yphi shr 8];
  kosiy := ctab[yphi shr 8];
  siniz := stab[zphi shr 8];
  kosiz := ctab[zphi shr 8];
  for loop:=1 to points do begin
    x := point[loop,1];
    y := point[loop,2];
    z := point[loop,3];
{
                                                         
                    cy*cz          cy*sz          -sy    
     [X]*[Y]*[Z] =  sx*sy*cz-cx*sz sx*sy*sz+cx*cz  sx*cy 
                    cx*sy*cz+sx*sz cx*sy*sz-sx*cz  cx*cy 
                                                         
}
    trans[loop,1]:=round((kosiy*kosiz*x)+((sinix*siniy*kosiz*y)-(kosix*siniz*y))+
                         ((kosix*siniy*kosiz*z)+(sinix*siniz*z)));
    trans[loop,2]:=round((kosiy*siniz*x)+((sinix*siniy*siniz*y)+(kosix*kosiz*y))+
                         ((kosix*siniy*siniz*z)-(sinix*kosiz*z)));
    trans[loop,3]:=round((-siniy*x)+(sinix*kosiy*y)+(kosix*kosiy*z));
  end;
  if xphi shr 8<sinsize then xphi:=xphi+xinc else xphi:=0;
  if yphi shr 8<sinsize then yphi:=yphi+yinc else yphi:=0;
  if zphi shr 8<sinsize then zphi:=zphi+zinc else zphi:=0;
end;

procedure DrawObj;
var f,p : word;
    dx,dy,dz : integer;
    sx,sy : array[1..3] of integer;
    c : array[1..3] of byte;

function inrange(value:integer):byte;
begin
  if value<0 then inrange:=0;
  if value>255 then inrange:=255;
end;

begin
  { ei tartte sorttia }
  for f:=1 to faces do begin
    for p:=1 to 3 do begin
{      gx = x * 256 / z + 160 ; keskipiste = ruudun keskipiste
       gy = y * 256 / z + 100 ; (320x200-tila) }
      dx:=ox+trans[face[f,p],1];
      dy:=oy+trans[face[f,p],2];
      dz:=oz+trans[face[f,p],3];
      if dz=256 then dz:=257; { aika n0l0 ;}
      sx[p]:=round(dx shl 8 / (zf-dz)) + xc;
      sy[p]:=round(dy shl 8 / (zf-dz)) + yc;
      c[p]:=inrange(trans[face[f,p],3]);
    end;
    if c[1]+c[2]+c[3]>0 then
    gouraud_poly_real(virseg,sx[1],sy[1],
                             sx[2],sy[2],
                             sx[3],sy[3],
                             c[1],c[2],c[3]);
  end;
end;

procedure NullObject;
var f,h,w,p:word;
begin
  h:=0;
  for p:=1 to points do begin
   pphi[p]:=h;
   if h<sinsize-diff then inc(h,diff) else h:=0;
  end;
  xphi:=0;
  yphi:=0;
  zphi:=0;
  ox:=0; oy:=0;
  oz:=-1024;
  p:=1;
  for h:=0 to hp-1 do
    for w:=0 to wp-1 do begin
      point[p,1]:=-60+(w*xgap);
      point[p,2]:=ylevel;
      point[p,3]:=60+(-h*zgap);
      inc(p);
    end;
   f:=1;
   h:=0;
end;

procedure waveobj;
var p:word;
begin
  for p:=1 to points do begin
    if pphi[p]<sinsize then inc(pphi[p],4) else pphi[p]:=0;
    point[p,2]:=ylevel+round(stab[pphi[p]]*wavey);
  end;
end;

begin
  cls(vidseg);
  randomize;
  getmem(virscr,320*200);
  virseg:=seg(virscr^);

  for loop:=0 to sinsize do ctab[loop]:=cos(loop*pi/(sinsize div 2));
  for loop:=0 to sinsize do stab[loop]:=sin(loop*pi/(sinsize div 2));

  loppu:=false;
  mode($13);
  loadpal('pal1.pal');
  for loop:=0 to 255 do setcol(loop,63-(loop div 4),63,63-(loop div 4));
  nullObject;
  repeat
    waveobj;
    rotate;
    if oz<0 then inc(oz,2);
    cls(virseg);
    drawobj;
    retrace;
    flip(virseg,vidseg);
  until (keypressed)or(loppu);
  freemem(virscr,320*200);
end.

