uniform vec4 LightColor;
uniform float SpecularPower;
uniform float LightIntensity;

uniform sampler2D diffuseMap;
uniform sampler2D bumpMap;
varying vec2 Texcoord;

varying vec3 LightDirection;
varying vec3 ViewDirection;
varying vec3 Normal;

vec4 diffuseColor;
vec4 SpecularColor;

void main(void)
{
//	if (!gl_FrontFacing)
//	{
//		Normal = Normal * -1;
//	}

	// Check if we have a bump map attched
	if(textureSize(bumpMap, 0).x > 1)
	{
		vec3 nLightDirection = normalize(LightDirection);
		vec3 nNormal = normalize( (texture2D(bumpMap, Texcoord).xyz * 2.0) - 1.0);

		float NDotL = dot( nNormal, nLightDirection );
	
		vec3 Reflection = normalize(((2.0 * nNormal) * NDotL) - nLightDirection);
		vec3 nViewDirection = normalize(ViewDirection);
		float RDotV = max(0.0, dot(Reflection, nViewDirection));
	
		vec4 diffuseColor = texture2D(diffuseMap, Texcoord) + gl_FrontMaterial.diffuse;
		vec4 DiffuseColor = diffuseColor * NDotL * LightIntensity * LightColor;
		vec4 AmbientColor = gl_FrontMaterial.ambient * diffuseColor;
		vec4 SpecularColor = gl_FrontMaterial.specular * pow(RDotV, SpecularPower);
	
		gl_FragColor = DiffuseColor + AmbientColor + SpecularColor;  
	}

	else
	{
		vec3 nLightDirection = normalize(LightDirection);
		vec3 nNormal = normalize(Normal);
		
		float NDotL = dot( nNormal, nLightDirection );
   
		vec3 Reflection = normalize(((2.0 * nNormal) * NDotL) - nLightDirection);
		vec3 nViewDirection = normalize(ViewDirection);
		float RDotV = max(0.0, dot(Reflection, nViewDirection));
		// Check if we have a diffuse map attched
		if(textureSize(diffuseMap, 0).x > 1)
		{
			diffuseColor = texture2D(diffuseMap, Texcoord);
		}

		else
		{
			diffuseColor = gl_FrontMaterial.diffuse;
		}
		vec4 DiffuseColor = diffuseColor * NDotL;
		vec4 AmbientColor = gl_FrontMaterial.ambient * diffuseColor;

		SpecularColor = gl_FrontMaterial.specular * pow(RDotV, SpecularPower);

		gl_FragColor = DiffuseColor + AmbientColor + SpecularColor;
	}
}