# BCNDemo (working title) script
# authors:
# E. Jakobs (edwin@scene.nl)

from modpp import *;
import widgets
import math
import shapegen
import random
import scene as scenelib
from tools import *

# -------------------

platformManager = PlatformManager.getSingleton()
renderDevice = platformManager.createRenderDevice()

renderDevice.setConfigOption("fullscreen", "true")


outputWindow = widgets.ExtendedWindow("?? (party version)", 0, 0, 640, 480)
outputTarget = renderDevice.createMainWindow(outputWindow)

def onClose(window):
  exitPlayer()

outputWindow.onClose = onClose

schedMan = SchedulerManagerSingleton.getSingleton()

scheduler = CompositionScheduler()
scheduler.setRenderTarget(outputTarget)

schedMan.addScheduler(scheduler)
eventManager = EventManager.getSingleton()

root = Root();
scheduler.setRootNode(root);
scheduler.setSound("music/303f-voorlimpninja.mp3")

# ------------

ass = 0


noisyScene = Scene()

texman = TextureManager.getSingleton()

noisyScene2 = Scene()


def setupNoisyScene(scene):

  meshLoader = MeshLoader()

  sphereMesh0 = meshLoader.loadMesh("noisy.pck", 2)
  sphereMesh0.thisown = 0
  sphereNode0 = scene.getRootNode().createChild()
  sphereNode0.setPosition(Vector3(0, -40, 0))
  sphereNode0.setScale(0.15)
#  q = Quaternion()
#  q.fromAngleAxis(3.14/2, Vector3(1,0,0))
#  sphereNode0.setRotation(q)
  
  sphereEntity0 = Entity()
  sphereMaterial0 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
  sphereMaterial0.setAmbient(Color(0,0,0,1))
  sphereMaterial0.setDiffuse(Color(0,0,0,1))
  sphereMaterial0.thisown = 0

  dirtmap = texman.createFromFile("textures/dirtmap.tga")
  
  sphereEntity0.setMesh(sphereMesh0)
  sphereEntity0.setMaterial(sphereMaterial0)
  sphereEntity0.thisown = 0
  sphereNode0.addObject(sphereEntity0)

  # create a light
  light = Light()
  light.thisown = 0
  light.setDiffuse(Color(1,1,1,1))
  
  # create a node for the light
  lightNode = scenelib.SceneNode(scene, scene.getRootNode())
  lightNode.addObject(light)
  lightNode.onDraw = noisyLightHandler
  lightNode.__disown__()  
  


class NoisyCamera(BaseCamera):
  def __init__(self):
    BaseCamera.__init__(self)
    self.speed = 100
    self.setFov(3.1415 / 2.0)

# niets meer aan doen
  def onUpdate(self, pt, ct):
    t = .432 + ct * 0.05
    position = Vector3(math.sin(t), math.cos(t),0)

    if position.length() < .91:
      position = position.normalize() * .91

    if position.length() > .96:
      position = position.normalize() * .96
    
    self.target(position * 140 , Vector3(0.01, 0.01, 0.01))


class NoisyCamera2(BaseCamera):
  def __init__(self):
    BaseCamera.__init__(self)
    self.speed = 100
    self.setFov(3.1415 / 2.0)

  def onUpdate(self, pt, ct):
    t = 2.501 + ct * 0.05
    position = Vector3(math.sin(t*.96), math.cos(t*0.73),  0)

    if position.length() < .91:
      position = position.normalize() * .91

    if position.length() > .96:
      position = position.normalize() * .96
    
    self.target(position * 140 , Vector3(0.01, 0.01, 0.01))


def noisyLightHandler(self, pt, ct):
  position = Vector3(math.cos(0.89*ct),0,math.sin(ct)) * 100
  self.setPosition(position)
#  print ct


setupNoisyScene(noisyScene)


noisyCamera = NoisyCamera()
noisyCamera2 = NoisyCamera2()


noisyScene.thisown = 0
noisySceneRenderer = SceneRenderer()
noisySceneRenderer.setScene(noisyScene)

noisySceneRenderer.setCamera(noisyCamera)

noisySceneRenderer2 = SceneRenderer()
noisySceneRenderer2.setScene(noisyScene)
noisySceneRenderer2.setCamera(noisyCamera2)


image = Image("textures/glare_0.png")
image2 = Image("textures/glare_1.png")

image_1 = Image("textures/glare_0.png")
image2_1 = Image("textures/glare_1.png")


aap = CrossFade()



# ---
blur = Blur()
blur.getParameter("spread").setDefaultValue(1.0)
noise = Noise()
noise.getParameter("intensity").setDefaultValue(0.2)
#print "sched"

#scheduleChain(scheduler, 0, 1000, [image, noisySceneRenderer, blur, noise, root])
crossFade1 = CrossFade()
crossFade2 = CrossFade()
sceneFade = CrossFade()


kfc = KeyframeController()
kfc.addKey(0, 0)
kfc.addKey(14, 0)
kfc.addKey(15, 1)
kfc.addKey(33.9, 1)
kfc.addKey(35, 0)

kfc.addKey(34.7+5.875,0)
kfc.addKey(34.7+5.875+1,1)

kfc.addKey(41.7+5.875,1)
kfc.addKey(41.7+5.875+1,0)

kfc.addKey(48.6+5.875,0)
kfc.addKey(48.6+5.875+1,1)


kfc_crossFade1 = KeyframeController()

kfc_crossFade1.addKey(0, 0)
kfc_crossFade1.addKey(33.9, 0)
kfc_crossFade1.addKey(35, 1)

kfc_crossFade1.addKey(35 + 3.475, 1)
kfc_crossFade1.addKey(35 + 3.475+1, 0)


kfc_crossFade2 = KeyframeController()
kfc_crossFade2.addKey(0, 0)

kfc_crossFade2.addKey(31.3,0)
kfc_crossFade2.addKey(32.3,1)

kfc_crossFade2.addKey(34.7+5.875,1)
kfc_crossFade2.addKey(34.7+5.875+1,0)

 
sceneFade.getParameter("mix").addController(kfc)
crossFade2.getParameter("mix").addController(kfc_crossFade2)
crossFade1.getParameter("mix").addController(kfc_crossFade1)


scheduler.schedule(0, 55.6, image_1, crossFade1, "a")
scheduler.schedule(0, 55.6, image2_1, crossFade1, "b")

scheduler.schedule(0, 55.6, image2, crossFade2, "a")
scheduler.schedule(0, 55.6, image, crossFade2, "b")



scheduler.schedule(0, 55.6, crossFade2, noisySceneRenderer, "in")
scheduler.schedule(0, 55.6, crossFade1, noisySceneRenderer2, "in")

#scheduler.schedule(0, 1000, crossFade, noisySceneRenderer, "in")
scheduler.schedule(0, 55.6, noisySceneRenderer, sceneFade, "a")
scheduler.schedule(0, 55.6, noisySceneRenderer2, sceneFade, "b")


scheduler.schedule(0, 55.6, sceneFade,  blur, "in")

scheduler.schedule(0, 55.6, blur, noise, "in")
scheduler.schedule(0, 55.6, noise, root, "in")




# --------------------------------------------

tunnelSpeed = 230.414
#tunnelSpeed = 50


spline = Spline()
spline.addPoint(-300, Vector3(0, 0, 0))

spline.addPoint(3000000, Vector3(0, 0, 0))

class TunnelTiler(BaseSceneNode):

  def __init__(self, scene, parent):
    BaseSceneNode.__init__(self, scene, parent)

    # create materials
    self.tunnelMaterial = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
    self.tunnelMaterial2 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
    self.tunnelMaterial3 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
    self.tunnelMaterial4 = SimpleMaterial("../../shaders/scene_explode.vsa", "../../shaders/scene_default.ac")

    self.tunnelMaterial5 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
    self.tunnelMaterial6 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")

    self.laserMaterial = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
    self.darkMaterial = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
    self.darkMaterial.setAmbient(Color(0.1,0.1,0.1,0))
    self.darkMaterial.setDiffuse(Color(0.8,0.8,0.8,0))

#    self.neonMaterial1 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
#    self.neonMaterial2 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
#    self.neonMaterial3 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")


    # the base tunnel material
    self.tunnelMaterial.setAmbient(Color(0.1, 0.1, 0.1, 0))
    self.tunnelMaterial.setDiffuse(Color(2, 2, 2, 2))

    # material used for lights
    self.tunnelMaterial2.setAmbient(Color(0.9, 0.1, 0.1, 0))
    self.tunnelMaterial2.setDiffuse(Color(0, .5, 0, 0))

    # material used for white lights
    self.tunnelMaterial5.setAmbient(Color(0.1, 0.1, 0.1, 1))
    self.tunnelMaterial5.setDiffuse(Color(0.9, 0, 0, 1))
    self.tunnelMaterial5.setBlending(BO_ADD, BF_ONE, BF_ONE)


    self.tunnelMaterial3.setAmbient(Color(0.1, 0.1, 0.1, 0))
    self.tunnelMaterial3.setDiffuse(Color(2, 2, 2, 2))
#    self.tunnelMaterial3.setBlending(BO_ADD, BF_ONE, BF_ONE)

 
    

    self.tunnelMaterial4.setAmbient(Color(0.1, 0.1, 0.1, 0))
    self.tunnelMaterial4.setDiffuse(Color(2, 2, 2, 2))
    self.tunnelMaterial4.getVertexShaderParameters().setConstant(35, Vector3(0.5, 0, 0))

    self.tunnelMaterial6.setAmbient(Color(0, 0, 0, 0))
    self.tunnelMaterial6.setDiffuse(Color(0, 0, 0, 0))

    self.laserMaterial.setAmbient(Color(1, 0.9, .7, 1))
    self.laserMaterial.setDiffuse(Color(0, 0, 0))

#    self.neonMaterial1.setAmbient(Color(0.2, 0.8, 0.3, 0))
#    self.neonMaterial1.setDiffuse(Color(0.3, 0.2, 0.1, 0))

#    self.neonMaterial2.setAmbient(Color(0.2, 0.3, 0.8, 0))
#    self.neonMaterial2.setDiffuse(Color(0.3, 0.1, 0.2, 0))

#    self.neonMaterial3.setAmbient(Color(0.8, 0.3, 0.2, 0))
#    self.neonMaterial3.setDiffuse(Color(0.2, 0.2, 0.2, 0))

    # load shapes
    shapeLoader = ShapeLoader() 
    self.shapeMesh = []
    for i in xrange(33):
#      print i
      self.shapeMesh.append(shapeLoader.loadShape("shapes/mooi_%s.eps.tris" % i ))
#      print self.shapeMesh[-1].getMass().x, self.shapeMesh[-1].getMass().y


    # load meshes
    meshLoader = MeshLoader()
    


    
    self.tunnelMesh = []
    self.tunnelMesh.append(meshLoader.loadMesh("tunnel.pck", 3)) # elbow

    self.tunnelMesh.append(meshLoader.loadMesh("tunnel.pck", 1)) # met lampjes
#    self.tunnelMesh[1].getSubMesh(0).setMaterial(self.tunnelMaterial4)
    self.tunnelMesh[1].getSubMesh(1).setMaterial(self.tunnelMaterial2)
    

    self.tunnelMesh.append(meshLoader.loadMesh("tunnel.pck", 2)) 
    self.tunnelMesh.append(meshLoader.loadMesh("tunnel.pck", 4))

    seg = meshLoader.loadMesh("tunnel.pck", 5)
    seg.getSubMesh(1).setMaterial(self.tunnelMaterial2)
    self.tunnelMesh.append(seg)

    self.tunnelMesh.append(meshLoader.loadMesh("tunnel.pck", 4))
    self.tunnelMesh.append(meshLoader.loadMesh("tunnel.pck", 4))

    jumper = meshLoader.loadMesh("tunnel.pck", 7)
    jumper.getSubMesh(0).setMaterial(self.tunnelMaterial5)
    self.tunnelMesh.append(jumper)

    space = meshLoader.loadMesh("tunnel.pck", 9)
    space.getSubMesh(0).setMaterial(self.tunnelMaterial6)
    self.tunnelMesh.append(space)

    space = meshLoader.loadMesh("tunnel.pck", 10)
    space.getSubMesh(0).setMaterial(self.tunnelMaterial6)
    self.tunnelMesh.append(space)

    space = meshLoader.loadMesh("tunnel.pck", 11)
    space.getSubMesh(0).setMaterial(self.tunnelMaterial6)
    self.tunnelMesh.append(space)

    space = meshLoader.loadMesh("tunnel.pck", 12)
    space.getSubMesh(0).setMaterial(self.tunnelMaterial6)
    self.tunnelMesh.append(space)




    for i in xrange(8):
      tournesol = meshLoader.loadMesh("tietjes.pck", i+1)
      tournesol.getSubMesh(0).setMaterial(self.tunnelMaterial3)
      self.tunnelMesh.append(tournesol)
     
    space = meshLoader.loadMesh("beams.pck", 1)
    space.getSubMesh(0).setMaterial(self.laserMaterial)
    space.getSubMesh(1).setMaterial(self.darkMaterial)
    self.tunnelMesh.append(space)
    
    
    self.segments = []
    self.entities = []
    self.shapeEntities = []
    self.shapeNodes = []
    self.distance = 100
    self.segmentCount = 7

    self.count = 0
    self.center = Vector3(0,0,0)

    # setup the base orientation
    self.baseOrientation = Quaternion()
    self.baseOrientation.fromAngleAxis(3.14/2, Vector3(1, 0, 0))

    # setup initial config
    for i in xrange(self.segmentCount):

      child = self.createChild()
      child.__disown__()
      self.segments.append(child)
      
      # set the position
      child.setPosition(Vector3(0,self.center.y,self.distance*self.segmentCount -  i*self.distance))

      # set the orientation
      child.setRotation(self.baseOrientation)

      tunnelEntity = Entity()
      tunnelEntity.thisown = 0
      tunnelEntity.setMaterial(self.tunnelMaterial)
      if i == 0:
        tunnelEntity.setMaterial(self.tunnelMaterial3)
      
      tunnelEntity.setMesh(self.tunnelMesh[1])
      self.entities.append(tunnelEntity)
      child.addObject(tunnelEntity)

# ---
      child = self.createChild()
      child.__disown__()
      self.shapeNodes.append(child)
      
      # set the position
      child.setPosition(Vector3(0,self.center.y,self.distance*self.segmentCount -  i*self.distance))

      shapeEntity = Entity()
      shapeEntity.thisown = 0
      shapeEntity.setMaterial(self.tunnelMaterial5)

      idx = random.random() * 12
      idx = int(idx)
      
      shapeEntity.setMesh(self.shapeMesh[idx])
#      child.setRotation(self.baseOrientation)
      child.setScale(10)

      self.shapeEntities.append(shapeEntity)
      child.addObject(shapeEntity)


# --

    self.up = Vector3(0,0,0)
    self.brokenCount = 0
    self.spiralRotate = 0
  

  # ----------
  def onUpdate(self, pt, ct):

    #    self.tunnelMaterial4.getVertexShaderParameters().setConstant(35, Vector3(math.cos(ct)*0.5 + 0.5, math.cos(ct*1.32)+1, 0))

    camera = self.getScene().getCamera()
    if ct > 134:
      up = Vector3(0, 0, 0)
      up.x = math.sin(ct*0.1-134*0.1)
      up.y = math.cos(ct*0.1-134*0.1)
      up.z = 0
      camera.setUp(up)


    i = 0


    
    for segment in self.segments:

      if segment.getPosition().z - camera.pos.z > self.distance:

        oldPos = segment.getPosition()
        newPos = Vector3(0, 0, 0)
        newPos.y = self.center.y
        newPos.x = self.center.x
        newPos.z = oldPos.z - self.segmentCount * self.distance


        # add the new position to the camera spline
        spline.addPoint(-newPos.z - 100,
                        self.center,
                        self.center - self.up * .4,
                        self.center + self.up * .2)

        # set random rotation around the z axis
        angle = 3.1415 * (2.0/6.0) * round(random.random() * 6.0)
        rot = Quaternion()
        rot.fromAngleAxis(angle, Vector3(0, 0, 1))
        segment.setRotation(rot * self.baseOrientation)


        mesh = int(round(random.random() * 8))
        mesh -= 3
        if mesh < 0:
          mesh = 0

        if ct < 81.5:
          if mesh == 0:
            mesh = 1
          



        if ct > 79.5 and ct < 81.5:
          mesh = 7


        # outside
        if ct > 81.5 and ct < 102:
          mesh = 8

        if ct > 102 and ct < 106:
          mesh = 9
          q = Quaternion()
          q.fromAngleAxis(-3.1415/2 + self.spiralRotate * -3.1415/3, Vector3(0, 0, 1))
          self.spiralRotate += 1
          segment.setRotation(q * self.baseOrientation)

        if ct > 106 and ct < 108.5:
          mesh = 10
          q = Quaternion()
          q.fromAngleAxis(-3.1415/2 + self.spiralRotate * -3.1415/3, Vector3(0, 0, 1))
          self.spiralRotate += 3
          segment.setRotation(q * self.baseOrientation)          

        if ct > 108.5 and ct < 109:
          mesh = 11

        # neon part
        if ct > 136 and ct < 148.7:
          mesh = 13 + random.randint(0,5)

          q = Quaternion()
          q.fromAngleAxis(0, Vector3(0, 1 ,0))
          segment.setRotation(q)

        # outside again
        if ct > 148.7:
          mesh = len(self.tunnelMesh)-1
          q = Quaternion()
          q.fromAngleAxis(3.14/2, Vector3(0, 1 ,0))
          r = Quaternion()
          r.fromAngleAxis(random.random() * 3.1415* 2.0, Vector3(0, 0, 1))
          
          segment.setRotation(r)


        # do we need to render 'broken' segments?
#        if self.brokenCount > 0:
#          mesh = 6
#          self.brokenCount -= 1

        # are we at the start of a broken tunnel?
#        if mesh == 5:
#          self.brokenCount = 3

        # are we processing an elbow? if so adjust the center
        # (the position where new segments are created) with respect
        # to the z-axis rotation
        if (mesh == 0):
          self.up = Vector3(0,10,0)
          r = Matrix4()
          r.makeRotateZ(angle)
          self.up = r * self.up
          self.center += self.up
        
        segment.setPosition(newPos)



#        self.entities[i].setMesh(self.kakShape)
        self.entities[i].setMesh(self.tunnelMesh[mesh])
      i = i + 1

    i = 0
    for shape in self.shapeNodes:
      if shape.getPosition().z - camera.pos.z > self.distance:
        oldPos = shape.getPosition()
        newPos = Vector3(0, 0, 0)
        newPos.y = self.center.y - 5
        newPos.x = self.center.x - 2
        newPos.z = oldPos.z - self.segmentCount * self.distance
        shape.setPosition(newPos)
        idx = random.random() * (len(self.shapeMesh)-1) 
        self.shapeEntities[i].setMesh(self.shapeMesh[int(idx)])
        self.shapeEntities[i].setVisible(False)

    if ct > 105.5 and ct < 107.5:
      c = 1.0- (107.5 - ct)/2
      self.tunnelMaterial6.setAmbient(Color(c,c,c,c))



# -------------------------------------------

class TunnelCamera(BaseCamera):
  def __init__(self, startTime):
    BaseCamera.__init__(self)
    self.speed = tunnelSpeed
    self.setFov(3.1415 / 2.0)
    self.startTime = startTime
    self.pos = 0
    self.distance = 30

  def onUpdate(self, pt, ct):

    dist = self.distance

    t = ct - self.startTime


#    x = math.cos(t)*30
#    y = math.sin(t)*30

    x = 60
    y = 0


    if ct < 89:
      x = 0
    else:
      if ct > 89:
        x = (1.0 - (90 - ct) )
        if x < 0:
          x = 0
        if x > 5:
          x = 5
        x = 60 * x*0.2*(x/5.0)

    if ct > 105.5:
      x = 60-(ct-105.5)*20
      if x < 0:
        x = 0

    if ct > 120:
      x = 0
    if ct > 150:
      x = (1.0 - (151 - ct) )
      if x < 0:
        x = 0
      if x > 5:
        x = 5
      x = 60 * x*0.2*(x/5.0)

#    if ct > 166.5:
#      x = 60-(ct-166.5)*20
#      if x < 0:
#        x = 0

    x2 = 0
    y2 = 0
      
    if ct > 120+34.955:
      global ass
      if not ass == 0:
        x = math.sin(2341.321*ass) * 150
        y = math.sin(341.215*ass) * 150
        dist = 200

 

#    if ct > 81.75:
#      self.setFov(3.1415/1.7)
    

    key = spline.getPointLinear(-1*(300 - t*self.speed))
    key2 = spline.getPointLinear(-1*(300 - t*self.speed - dist))

    self.pos = Vector3(key.x, key.y, 300-t*self.speed)
    self.target(Vector3(x + key.x, y + key.y, 300 - t*self.speed),
                  Vector3(x2 + key2.x, y2 +key2.y, 300 - t*self.speed - dist))



# ---------------------

class TunnelLightNode(BaseSceneNode):
  def __init__(self, scene, parent, light, startTime):
    BaseSceneNode.__init__(self, scene, parent)
    self.startTime = startTime
    self.speed = tunnelSpeed
    self.light = light
    self.offset = 70

  def onUpdate(self, pt, ct):

    if ct > 100:
      global tunnelTiler
      tunnelTiler.tunnelMaterial3.setAmbient(Color(0.1, 0.1, 0.3, 0))
      tunnelTiler.tunnelMaterial3.setDiffuse(Color(0, .5, 0, 0))
      tunnelTiler.tunnelMaterial3.setBlending(BO_ADD, BF_ONE, BF_ONE)


    t = ct - self.startTime
    key = spline.getPointLinear(-1*(300-t*self.speed-self.offset))
    pos = Vector3(key.x,key.y,300-t*self.speed-self.offset)
    self.setPosition(pos)

    if ct < 83.7:
      self.light.setDiffuse(Color(0.2,0.2,0.2,0))
    else:
      delta = 1.0 - ((83.7 - ct))

      if delta > 1:
        delta = 1
      
      
      self.light.setDiffuse(Color(delta,delta,delta,delta))
      
    if ct > 145:
      self.offset = -20
    
    if ct > 90 and ct < 110:
      pos.y -= 40.0 * math.cos(ct)
      pos.x += 40.0 * math.sin(ct)
      pos.z += 90
      self.setPosition(pos)


# ----
shakeAmount = 0
shakeTime = 0.0

class RingNode(BaseSceneNode):
  def __init__(self, scene, parent, speed, scale, scaling, _id):
    BaseSceneNode.__init__(self, scene, parent)
    self.speed = speed
    self.lastTime = 0.08 + 60/138.0
    self.aapLength = 2*60.0/138.0
    self.angle = 0
    self.scaling = scaling
    self.scale = scale
    self.setScale(self.scale)
    self.scaleSpeed = random.random() * 2 + 2
    self.id = _id
    



  def onUpdate(self, pt, ct):
    if ct < 85:
      self.getObject(0).setVisible(False)
    elif ct > 110:
      self.getObject(0).setVisible(False)
    else:
        self.getObject(0).setVisible(True)

  #    self.getParent().removeChild(self)

      

    global shakeTime
    global shakeAmount
    
    if not ct == shakeTime:
      shakeTime = ct
      shakeAmount = random.random() * 2
      
  
    q = Quaternion()
    self.angle += (ct-pt) * self.speed

    q.fromAngleAxis(self.angle,Vector3(0,1,0))
    self.setRotation(q)

    
#    if ct - self.lastTime > self.aapLength:

#      self.lastTime = ct
#      self.aapLength = 4*60.0/138.0
#      aapje = [-1,1][random.random() < 0.5]

#      if self.scaling:
#        self.speed *= -1
#        self.scale = random.random()*0.05 + 0.10

    if self.scaling:
      aap = 1 -( math.fmod(ct+0.08, 60.0/138.0) / (60.0/138.0))
      aap2 = 1 -( math.fmod(ct+0.08 + 60/138.0, 120.0/138.0) / (120.0/138.0))
      aap = aap * aap2
      aap2 = (1-aap2) * aap2
      self.angle += aap2 * 0.5
      self.setScale(self.scale + aap*0.01)
    else:
#      aap = 1 -( math.fmod(ct+0.08, 60.0/138.0) / (60.0/138.0))
      self.setPosition(Vector3(0, shakeAmount, 0))
      
      # 1:32.573
#      q.fromAngleAxis(self.angle + aap2 * 2,Vector3(0,1,0))
#      self.setRotation(q)
    if self.id == 7:
      if ct  > 104.3:
        self.setPosition(Vector3(0,(ct-104.3)*750,0))

    if self.id == 9:
      a = 104.3+2*(60.0/138.0)
      if ct  > a:
        self.setPosition(Vector3(0,(ct-a)*750,0))

    if self.id == 8:
      a = 104.3+4*(60.0/138.0)
      if ct  > a:
        self.setPosition(Vector3(0,(ct-a)*750,0))

      

      
      

class PandurBaseNode(BaseSceneNode):
  def __init__(self, scene, parent, speed, startTime, startPos):
    BaseSceneNode.__init__(self, scene, parent)
    self.speed = speed
    self.startTime = startTime
    self.startPos = startPos
    self.startSpeed = speed

    q = Quaternion()
    q.fromAngleAxis(3.1415/2, Vector3(1,0,0))
    self.setRotation(q)

    self.offset = 0

  def onUpdate(self, pt, ct):
    t = ct - self.startTime


    if ct > 103.5:
      self.speed -= (ct-pt) * 10
        

    self.setPosition(self.startPos + Vector3(0, 0, -self.offset))

    if ct > 90.4:
      self.offset += (ct-pt) * self.speed

      
def setupPandurScene(scene, parent):
  meshLoader = MeshLoader()
  material = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
  material.setDiffuse(Color(1,1,1))

  materialLight = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
  materialLight.setDiffuse(Color(0,0,0))
  materialLight.setAmbient(Color(1,0,0))

  materialLight2 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
  materialLight2.setDiffuse(Color(2,2,2))
  materialLight2.setAmbient(Color(0,0,0))



  materialDark = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
  materialDark.setDiffuse(Color(.5,.5,.5))
  materialDark.setAmbient(Color(0,0,0))


  material.thisown = 0
  materialLight.thisown = 0
  materialLight2.thisown = 0
  materialDark.thisown = 0


  # the mesh used for the turrets
  for i in xrange(10):

    aapje = 1
    if i in [1,2,3,4,5,6]:
      aapje = 1
    else:
      aapje = -1

    if not i in [7,8,9]:
      aapje /= 4.0
    

    
    node = RingNode(scene, parent, (random.random()*0.5+0.5) * aapje, 0.14, i in [7,8,9], i)
    node.__disown__()
    node.setScale(0.1)
    
    mesh = meshLoader.loadMesh("pandur.pck", 1+i)
    entity = Entity()
    entity.thisown = 0
    entity.setMesh(mesh)
    entity.setMaterial(material)
#    entity.setVisible(False)

    node.addObject(entity)
    if i in [7,8,9]:
      mesh.getSubMesh(1).setMaterial(materialLight)
    if i in [0]:
      mesh.getSubMesh(2).setMaterial(materialDark)
    if i in [1,2,3,4,5,6]:
      mesh.getSubMesh(0).setMaterial(materialDark)
    if i in [0]:
      mesh.getSubMesh(1).setMaterial(materialLight2)

# --


class SatBaseNode(BaseSceneNode):
  def __init__(self, scene, parent):
    BaseSceneNode.__init__(self, scene, parent)
    self.lastTime = 0
    self.aapLength = random.random() * 5
    self.angle = 0

  def onUpdate(self, pt, ct):

    if ct > 120+36.555:
      self.getObject(0).setVisible(True)
    else:
      self.getObject(0).setVisible(False)
      return


class SatSceneNode(BaseSceneNode):
  def __init__(self, scene, parent, speed, startTime, startPos):
    BaseSceneNode.__init__(self, scene, parent)
    self.speed = speed
    self.startTime = startTime
    self.startPos = startPos
    self.startPos.x = 0
    self.startPos.y = 0
    self.startSpeed = speed

    q = Quaternion()
    q.fromAngleAxis(3.1415/2, Vector3(1,0,0))
    self.setRotation(q)

    self.offset = 0

  def onUpdate(self, pt, ct):

    
#    t = ct - self.startTime
#    if ct > 183.5:
#      self.speed -= (ct-pt) * 10
    magic = -0.00

#    q = Quaternion()
#    q.fromAngleAxis(3.1415/2, Vector3(1,0,0))
#    self.setRotation(q)

    x = tunnelTiler.segments[0].getPosition().x
    y = tunnelTiler.segments[0].getPosition().y

    t = ct - 55.6

    self.setPosition(Vector3(x,y,300 - t*tunnelSpeed - 200))


"""
    if ct > 145-magic and ct < 146.33-magic:
      self.offset += (ct-pt) * self.speed*0.1

    if ct > 146.33-magic:
      self.offset += (ct-pt) * self.speed

    if ct > 166 and ct < 168:
      self.speed += 0.05


    if ct > 120+34.955 and ct < 196:

      t = ct- (120+34.955)
      t *= 0.1
        
      q = Quaternion()
      q.fromAngleAxis(t, Vector3(1,0,0))
      r = Quaternion()
      r.fromAngleAxis(t,Vector3(0,1,0))
      self.setRotation(q*r)

"""

#---



class SatSegNode(BaseSceneNode):
  def __init__(self, scene, parent, rot):
    BaseSceneNode.__init__(self, scene, parent)
    self.rot = rot * 3.1415*0.5
    self.lastA = 0
    self.lastT = 0
    

  def onUpdate(self, pt, ct):
    
    t = 0
    if ct > 146:
      t = (ct-146) * 0.1
      
    d = math.sin(t)*20+20
    x = -math.cos(self.rot) * d
    z = math.sin(self.rot) * d
    self.setPosition(Vector3(x, 50*(2.0/5), z))

    if ct > 120+36.555:
      self.getObject(0).setVisible(True)
    else:
      self.getObject(0).setVisible(False)



    if ct > 120+34.955 and ct < 196:

      
      a = 1.0 - (math.fmod(ct-(120+33.044),240.0/138.0) / (240/138.0))
#      print a, self.lastA
      if a > 0.98 and ct-self.lastT > 0.1:
        self.lastA = a
        self.lastT = ct
        global ass
        ass += 1



def setupSatScene(scene, parent):
  meshLoader = MeshLoader()
  material = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
  material.setDiffuse(Color(1,1,1))

  materialLight = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
  materialLight.setDiffuse(Color(1,1,1))
  materialLight.setAmbient(Color(0,0,0))

  # aan de buitenkant is het fijn en warm
  materialLight2 = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
  materialLight2.setDiffuse(Color(1,1,1))
  materialLight2.setAmbient(Color(0.2,0.2,0.2))



  materialDark = SimpleMaterial("../../shaders/scene_default.vsa", "../../shaders/scene_default.ac")
  materialDark.setDiffuse(Color(0,0,0))
  materialDark.setAmbient(Color(0,0,0))


  material.thisown = 0
  materialLight.thisown = 0
  materialLight2.thisown = 0
  materialDark.thisown = 0


  # the mesh used for the turrets
  for i in [0,1,2,3,4]:

    node = None
    if i == 0:
      node = SatBaseNode(scene, parent)
    else:
      node = SatSegNode(scene, parent, i-1)
      
    node.__disown__()
    node.setScale(0.3)
    if i in [1,2,3,4]:
      q = Quaternion()
      q.fromAngleAxis(3.14/2.0 * (i-1),Vector3(0,1,0))
      node.setRotation(q)
      node.setPosition(Vector3(0,50*(2.0/5) ,0))

    a = i
    if a > 2:
      a = 2
    
    mesh = meshLoader.loadMesh("sat.pck", i+1)
    entity = Entity()
    entity.thisown = 0
    entity.setMesh(mesh)

    if i in [1,2,3,4]:
      entity.setMaterial(materialLight2)
    else:
      entity.setMaterial(material)

    node.addObject(entity)

# --

tunnelBack = Image("textures/wtf.png")
tunnelBack.touch()
tunnelBackBlack = Image("textures/neger.png")
tunnelBackBlack.touch()

tunnelCrossFade = CrossFade()


tunnelScene = Scene()
tunnelScene.thisown = 0

tunnelTiler = TunnelTiler(tunnelScene, tunnelScene.getRootNode())

tunnelCamera = TunnelCamera(55.6)

tunnelLight = Light()
tunnelLight.setDiffuse(Color(1,1,.98,1))
tunnelLightNode = TunnelLightNode(tunnelScene, tunnelScene.getRootNode(), tunnelLight, 55.6)
tunnelLightNode.addObject(tunnelLight)

tunnelSceneRenderer = SceneRenderer()
tunnelSceneRenderer.setScene(tunnelScene)
tunnelSceneRenderer.setCamera(tunnelCamera)


#pandurNode = tunnelScene.getRootNode().createChild()
pandurNode = PandurBaseNode(tunnelScene, tunnelScene.getRootNode(), tunnelSpeed-0.1, 55.6, Vector3(0,0,300 - (90.6 -55.6) * tunnelSpeed ))
pandurNode.setPosition(Vector3(0, 0,  300 - (98-55.6) *tunnelSpeed))

satNode = SatSceneNode(tunnelScene, tunnelScene.getRootNode(), tunnelSpeed-0.1, 55.6, Vector3(0,0,300 - (146.62 -55.6) * tunnelSpeed ))
satNode.setPosition(Vector3(0, 0,  300 - (146.62-55.6) *tunnelSpeed))

setupPandurScene(tunnelScene, pandurNode)
setupSatScene(tunnelScene, satNode)


darkBack = Image("textures/darkness.png")

#scheduler.schedule(55.6, 155.6, tunnelSceneRenderer, root, "in")
scheduler.schedule(55.6, 80.6, tunnelBack, tunnelCrossFade, "a")
scheduler.schedule(55.6, 155.6, tunnelBackBlack, tunnelCrossFade, "b")

scheduler.schedule(55.6+80.6, 155.6-80.6, darkBack, tunnelCrossFade, "a")



tunnelKFC = KeyframeController()
tunnelKFC.addKey(0, 0)
tunnelKFC.addKey(83.5, 0)
tunnelKFC.addKey(84, 1)

tunnelKFC.addKey(106.5, 1)
tunnelKFC.addKey(108.5, 0)


tunnelKFC.addKey(149.7, 0)
tunnelKFC.addKey(150.7, 1)

tunnelCrossFade.getParameter("mix").addController(tunnelKFC)


endFader = CrossFade()
endFaderKFC = KeyframeController()
endFader.getParameter("mix").addController(endFaderKFC)


img33 = Image("textures/neger.png")

endFaderKFC.addKey(0,0)
endFaderKFC.addKey(180+14,0)
endFaderKFC.addKey(180+15,1)

endFaderKFC.addKey(180+130,1)

scheduler.schedule(82, 155.6, tunnelCrossFade, tunnelSceneRenderer, "in")
scheduleChain(scheduler,55.6, 180+12-55.6, [tunnelSceneRenderer, blur, noise, root])
scheduler.schedule(180+12,  50, tunnelSceneRenderer, endFader, "b")
scheduler.schedule(180+12, 50 ,img33, endFader, "a")

scheduleChain(scheduler,180+12, 50, [endFader, blur, noise, root])
scheduler.setStartTime(0)



