/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils;

import io.lacuna.artifex.Bezier2;
import io.lacuna.artifex.Box;
import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Interval;
import io.lacuna.artifex.Line2;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.utils.Equations;
import io.lacuna.artifex.utils.Scalars;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.LinearList;
import java.util.Arrays;
import java.util.Comparator;

public class Intersections {
    public static final double FAT_LINE_PARAMETRIC_RESOLUTION = 1.0E-7;
    public static final double FAT_LINE_SPATIAL_EPSILON = 1.0E-6;
    public static final double PARAMETRIC_EPSILON = 1.0E-6;
    public static final double SPATIAL_EPSILON = 1.0E-10;
    public static final int MAX_CUBIC_CUBIC_INTERSECTIONS = 9;
    public static final Box2 PARAMETRIC_BOUNDS = Box.box(Vec.vec(0.0, 0.0), Vec.vec(1.0, 1.0));

    public static double min(double a2, double b) {
        return a2 < b ? a2 : b;
    }

    public static double max(double a2, double b) {
        return a2 > b ? a2 : b;
    }

    public static Vec2[] subdivisionCurveCurve(Curve2 a2, Curve2 b) {
        LinearList queue = new LinearList();
        CurveInterval[] as = CurveInterval.from(a2);
        CurveInterval[] bs = CurveInterval.from(b);
        for (CurveInterval ap : as) {
            for (CurveInterval bp : bs) {
                ((LinearList)queue.addLast(ap)).addLast(bp);
            }
        }
        boolean collinearCheck = false;
        int iterations = 0;
        LinearList<Vec2> acc = new LinearList<Vec2>();
        while (queue.size() > 0L) {
            if (iterations > 32 && !collinearCheck) {
                collinearCheck = true;
                Vec2[] is = Intersections.collinearIntersection(a2, b);
                if (Intersections.isCollinear(a2, b, is)) {
                    return is;
                }
            }
            ++iterations;
            CurveInterval cb = (CurveInterval)queue.popLast();
            CurveInterval ca = (CurveInterval)queue.popLast();
            if (!ca.intersects(cb)) continue;
            if (ca.isFlat && cb.isFlat) {
                ca.intersections(cb, acc);
                continue;
            }
            for (CurveInterval ap : ca.split()) {
                for (CurveInterval bp : cb.split()) {
                    ((LinearList)queue.addLast(ap)).addLast(bp);
                }
            }
        }
        return Intersections.normalize((Vec2[])acc.toArray(Vec2[]::new));
    }

    public static double signedDistance(Vec2 p, Vec2 a2, Vec2 b) {
        Vec2 d = b.sub(a2);
        return (Vec2.cross(p, d) + Vec2.cross(b, a2)) / d.length();
    }

    public static Interval fatLineWidth(Curve2 c) {
        if (c instanceof Line2) {
            return Interval.interval(0.0, 0.0);
        }
        if (c instanceof Bezier2.QuadraticBezier2) {
            Bezier2.QuadraticBezier2 b = (Bezier2.QuadraticBezier2)c;
            return Interval.interval(0.0, Intersections.signedDistance(b.p1, b.p0, b.p2) / 2.0);
        }
        if (c instanceof Bezier2.CubicBezier2) {
            double d2;
            Bezier2.CubicBezier2 b = (Bezier2.CubicBezier2)c;
            double d1 = Intersections.signedDistance(b.p1, b.p0, b.p3);
            double k = d1 * (d2 = Intersections.signedDistance(b.p2, b.p0, b.p3)) < 0.0 ? 0.4444444444444444 : 0.75;
            return Interval.interval(Intersections.min(0.0, Intersections.min(d1, d2)) * k, Intersections.max(0.0, Intersections.max(d1, d2)) * k);
        }
        throw new IllegalStateException();
    }

    public static Vec2[] convexHull(Vec2 a2, Vec2 b, Bezier2.QuadraticBezier2 c) {
        Vec2 p0 = Vec.vec(0.0, Intersections.signedDistance(c.p0, a2, b));
        Vec2 p1 = Vec.vec(0.5, Intersections.signedDistance(c.p1, a2, b));
        Vec2 p2 = Vec.vec(1.0, Intersections.signedDistance(c.p2, a2, b));
        return new Vec2[]{p0, p1, p2, p0};
    }

    public static Vec2[] convexHull(Vec2 a2, Vec2 b, Bezier2.CubicBezier2 c) {
        double d2;
        Vec2 p0 = Vec.vec(0.0, Intersections.signedDistance(c.p0, a2, b));
        Vec2 p1 = Vec.vec(0.3333333333333333, Intersections.signedDistance(c.p1, a2, b));
        Vec2 p2 = Vec.vec(0.6666666666666666, Intersections.signedDistance(c.p2, a2, b));
        Vec2 p3 = Vec.vec(1.0, Intersections.signedDistance(c.p3, a2, b));
        double d1 = Intersections.signedDistance(p1, p0, p3);
        if (d1 * (d2 = Intersections.signedDistance(p2, p0, p3)) < 0.0) {
            return new Vec2[]{p0, p1, p3, p2, p0};
        }
        double k = d1 / d2;
        if (k >= 2.0) {
            return new Vec2[]{p0, p1, p3, p0};
        }
        if (k <= 0.5) {
            return new Vec2[]{p0, p2, p3, p0};
        }
        return new Vec2[]{p0, p1, p2, p3, p0};
    }

    public static Vec2[] convexHull(Vec2 a2, Vec2 b, Curve2 c) {
        if (c instanceof Bezier2.QuadraticBezier2) {
            return Intersections.convexHull(a2, b, (Bezier2.QuadraticBezier2)c);
        }
        if (c instanceof Bezier2.CubicBezier2) {
            return Intersections.convexHull(a2, b, (Bezier2.CubicBezier2)c);
        }
        throw new IllegalStateException();
    }

    public static Interval clipHull(Interval fatLine, Vec2[] hull) {
        double lo = Double.POSITIVE_INFINITY;
        double hi = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < hull.length - 1; ++i) {
            if (!fatLine.contains(hull[i].y)) continue;
            lo = Intersections.min(lo, hull[i].x);
            hi = Intersections.max(hi, hull[i].x);
        }
        for (double y : new double[]{fatLine.lo, fatLine.hi}) {
            for (int i = 0; i < hull.length - 1; ++i) {
                Vec2 a2 = hull[i];
                Vec2 b = hull[i + 1];
                if (!Interval.interval(a2.y, b.y).contains(y)) continue;
                if (a2.y == b.y) {
                    lo = Intersections.min(lo, Intersections.min(a2.x, b.x));
                    hi = Intersections.max(lo, Intersections.max(a2.x, b.x));
                    continue;
                }
                double t2 = Scalars.lerp(a2.x, b.x, (y - a2.y) / (b.y - a2.y));
                lo = Intersections.min(lo, t2);
                hi = Intersections.max(hi, t2);
            }
        }
        return hi < lo ? Interval.EMPTY : Interval.interval(lo, hi);
    }

    public static Interval quantize(Interval t2) {
        double resolution = 1.0E-7;
        double lo = Intersections.min(1.0 - resolution, Math.floor(t2.lo / resolution) * resolution);
        double hi = Intersections.max(lo + resolution, Math.ceil(t2.hi / resolution) * resolution);
        return Interval.interval(lo, hi);
    }

    public static void addIntersections(FatLine a2, FatLine b, IList<Vec2> acc) {
        Line2 la = a2.line();
        Line2 lb = b.line();
        Vec2 av = la.end().sub(la.start());
        Vec2 bv = lb.end().sub(lb.start());
        Vec2 asb = la.start().sub(lb.start());
        double d = Vec2.cross(av, bv);
        Vec2 i = Vec.vec(Vec2.cross(bv, asb) / d, Vec2.cross(av, asb) / d);
        if (((Box2)PARAMETRIC_BOUNDS.expand(0.1)).contains(i)) {
            acc.addLast(Box.box(a2.t, b.t).lerp(i));
        }
    }

    public static FatLine clip(FatLine subject, FatLine clipper) {
        Vec2[] hull = Intersections.convexHull(clipper.range.start(), clipper.range.end(), subject.range);
        Interval normalized = Intersections.clipHull(clipper.line.expand(1.0E-6), hull);
        return normalized.isEmpty() ? null : new FatLine(subject.curve, subject.t.lerp(normalized));
    }

    public static Vec2[] fatLineCurveCurve(Curve2 a2, Curve2 b) {
        LinearList queue = new LinearList();
        FatLine[] as = FatLine.from(a2);
        FatLine[] bs = FatLine.from(b);
        for (FatLine ap : as) {
            for (FatLine bp : bs) {
                ((LinearList)queue.addLast(ap)).addLast(bp);
            }
        }
        int iterations = 0;
        boolean collinearCheck = false;
        LinearList<Vec2> acc = new LinearList<Vec2>();
        block2: while (queue.size() > 0L) {
            double bSize;
            double kb;
            double aSize;
            double ka;
            if (iterations > 32 && !collinearCheck) {
                collinearCheck = true;
                Vec2[] is = Intersections.collinearIntersection(a2, b);
                if (Intersections.isCollinear(a2, b, is)) {
                    return is;
                }
            }
            FatLine lb = (FatLine)queue.popLast();
            FatLine la = (FatLine)queue.popLast();
            do {
                FatLine laPrime;
                ++iterations;
                if (!la.intersects(lb)) continue block2;
                if (la.isFlat() && lb.isFlat()) {
                    Intersections.addIntersections(la, lb, acc);
                    continue block2;
                }
                aSize = la.t.size();
                bSize = lb.t.size();
                FatLine lbPrime = Intersections.clip(lb, la);
                if (lbPrime == null || (laPrime = Intersections.clip(la, lb = lbPrime)) == null) continue block2;
                la = laPrime;
            } while (!(Intersections.max(ka = la.t.size() / aSize, kb = lb.t.size() / bSize) > 0.8));
            for (FatLine ap : la.split()) {
                for (FatLine bp : lb.split()) {
                    ((LinearList)queue.addLast(ap)).addLast(bp);
                }
            }
        }
        return Intersections.normalize((Vec2[])acc.toArray(Vec2[]::new));
    }

    public static double round(double n, double epsilon) {
        if (Scalars.equals(n, 0.0, epsilon)) {
            return 0.0;
        }
        if (Scalars.equals(n, 1.0, epsilon)) {
            return 1.0;
        }
        return n;
    }

    private static boolean isCollinear(Curve2 a2, Curve2 b, Vec2[] is) {
        if (is.length != 2) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            Vec2 pb;
            double t2 = (double)i / 9.0;
            Vec2 pa = a2.position(Scalars.lerp(is[0].x, is[1].x, t2));
            if (Vec.equals(pa, pb = b.position(Scalars.lerp(is[0].y, is[1].y, t2)), 1.0E-10)) continue;
            return false;
        }
        return true;
    }

    public static Vec2[] normalize(Vec2[] intersections2) {
        Vec2 i;
        int readIdx;
        int limit = intersections2.length;
        if (limit == 0) {
            return intersections2;
        }
        int writeIdx = 0;
        for (readIdx = 0; readIdx < limit; ++readIdx) {
            i = intersections2[readIdx].map(n -> Intersections.round(n, 1.0E-6));
            if (!PARAMETRIC_BOUNDS.contains(i)) continue;
            intersections2[writeIdx++] = i;
        }
        limit = writeIdx;
        if (limit > 1) {
            Arrays.sort(intersections2, 0, limit, Comparator.comparingDouble(v -> v.y));
            writeIdx = -1;
            for (readIdx = 0; readIdx < limit; ++readIdx) {
                i = intersections2[readIdx];
                if (writeIdx >= 0 && Scalars.equals(intersections2[writeIdx].y, i.y, 1.0E-14)) continue;
                intersections2[++writeIdx] = i;
            }
            limit = writeIdx + 1;
        }
        if (limit > 1) {
            Arrays.sort(intersections2, 0, limit, Comparator.comparingDouble(v -> v.x));
            writeIdx = -1;
            for (readIdx = 0; readIdx < limit; ++readIdx) {
                i = intersections2[readIdx];
                if (writeIdx >= 0 && Scalars.equals(intersections2[writeIdx].x, i.x, 1.0E-14)) continue;
                intersections2[++writeIdx] = i;
            }
            limit = writeIdx + 1;
        }
        Vec2[] result2 = new Vec2[limit];
        System.arraycopy(intersections2, 0, result2, 0, limit);
        return result2;
    }

    public static Vec2[] collinearIntersection(Curve2 a2, Curve2 b) {
        LinearList result2 = new LinearList();
        for (int i = 0; i < 2; ++i) {
            double s2;
            double tb = b.nearestPoint(a2.position(i));
            if (tb <= 0.0) {
                s2 = Intersections.round(a2.nearestPoint(b.start()), 1.0E-6);
                if (!(0.0 <= s2) || !(s2 <= 1.0)) continue;
                result2.addLast(Vec.vec(s2, 0.0));
                continue;
            }
            if (tb >= 1.0) {
                s2 = Intersections.round(a2.nearestPoint(b.end()), 1.0E-6);
                if (!(0.0 <= s2) || !(s2 <= 1.0)) continue;
                result2.addLast(Vec.vec(s2, 1.0));
                continue;
            }
            result2.addLast(Vec.vec(i, tb));
        }
        if (result2.size() == 2L && Vec.equals((Vec)result2.nth(0L), (Vec)result2.nth(1L), 1.0E-6)) {
            result2.popLast();
        }
        return (Vec2[])result2.toArray(Vec2[]::new);
    }

    public static Vec2[] lineCurve(Line2 a2, Curve2 b) {
        if (b instanceof Line2) {
            return Intersections.lineLine(a2, (Line2)b);
        }
        if (b.isFlat(1.0E-10)) {
            return Intersections.lineLine(a2, Line2.line(b.start(), b.end()));
        }
        if (b instanceof Bezier2.QuadraticBezier2) {
            return Intersections.lineQuadratic(a2, (Bezier2.QuadraticBezier2)b);
        }
        return Intersections.lineCubic(a2, (Bezier2.CubicBezier2)b);
    }

    public static Vec2[] lineLine(Line2 a2, Line2 b) {
        Vec2 bv;
        Vec2 av = a2.end().sub(a2.start());
        double d = Vec2.cross(av, bv = b.end().sub(b.start()));
        if (Math.abs(d) < 1.0E-6) {
            Vec2[] is = Intersections.collinearIntersection(a2, b);
            if (Arrays.stream(is).allMatch(v -> Vec.equals(a2.position(v.x), b.position(v.y), 1.0E-10))) {
                return is;
            }
            if (Math.abs(d) == 0.0) {
                return new Vec2[0];
            }
        }
        Vec2 asb = a2.start().sub(b.start());
        double s2 = Vec2.cross(bv, asb) / d;
        double t2 = Vec2.cross(av, asb) / d;
        return new Vec2[]{Vec.vec(s2, t2)};
    }

    public static Vec2[] lineQuadratic(Line2 p, Bezier2.QuadraticBezier2 q) {
        Vec2 a2 = q.p0.add(q.p1.mul(-2.0)).add(q.p2);
        Vec2 b = q.p0.mul(-2.0).add(q.p1.mul(2.0));
        Vec2 c = q.p0;
        Vec2 dir = p.end().sub(p.start());
        Vec2 n = Vec.vec(-dir.y, dir.x);
        double[] roots = Equations.solveQuadratic(Vec.dot(n, a2), Vec.dot(n, b), Vec.dot(n, c) + Vec2.cross(p.start(), p.end()));
        Vec2[] result2 = new Vec2[roots.length];
        if (Scalars.equals(dir.x, 0.0, 1.0E-14)) {
            double y0 = p.start().y;
            for (int i = 0; i < roots.length; ++i) {
                double t2 = roots[i];
                double y1 = q.position((double)t2).y;
                result2[i] = Vec.vec((y1 - y0) / dir.y, t2);
            }
        } else {
            double x0 = p.start().x;
            for (int i = 0; i < roots.length; ++i) {
                double t3 = roots[i];
                double x1 = q.position((double)t3).x;
                result2[i] = Vec.vec((x1 - x0) / dir.x, t3);
            }
        }
        return result2;
    }

    public static Vec2[] lineCubic(Line2 p, Bezier2.CubicBezier2 q) {
        Vec2 a2 = q.p0.mul(-1.0).add(q.p1.mul(3.0)).add(q.p2.mul(-3.0)).add(q.p3);
        Vec2 b = q.p0.mul(3.0).add(q.p1.mul(-6.0)).add(q.p2.mul(3.0));
        Vec2 c = q.p0.mul(-3.0).add(q.p1.mul(3.0));
        Vec2 d = q.p0;
        Vec2 dir = p.end().sub(p.start());
        double dLen = dir.length();
        Vec2 n = Vec.vec(-dir.y, dir.x);
        double[] roots = Equations.solveCubic(Vec.dot(n, a2), Vec.dot(n, b), Vec.dot(n, c), Vec.dot(n, d) + Vec2.cross(p.start(), p.end()));
        Vec2[] result2 = new Vec2[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            double t2 = roots[i];
            Vec2 v = q.position(t2).sub(p.start());
            double vLen = v.length();
            double s2 = vLen / dLen * Math.signum(Vec.dot(dir, v));
            result2[i] = Vec.vec(s2, t2);
        }
        return result2;
    }

    public static Vec2[] intersections(Curve2 a2, Curve2 b) {
        if (!((Box2)a2.bounds().expand(1.0E-10)).intersects(b.bounds())) {
            return new Vec2[0];
        }
        if (a2 instanceof Line2) {
            return Intersections.normalize(Intersections.lineCurve((Line2)a2, b));
        }
        if (b instanceof Line2) {
            Vec2[] result2 = Intersections.normalize(Intersections.lineCurve((Line2)b, a2));
            for (int i = 0; i < result2.length; ++i) {
                result2[i] = result2[i].swap();
            }
            return result2;
        }
        return Intersections.fatLineCurveCurve(a2, b);
    }

    public static class FatLine {
        public final Curve2 curve;
        public final Curve2 range;
        public final Interval t;
        public final Interval line;

        FatLine(Curve2 curve, Interval t2) {
            this.curve = curve;
            this.t = Intersections.quantize(t2);
            this.range = curve.range(this.t);
            this.line = Intersections.fatLineWidth(this.range);
        }

        public static FatLine[] from(Curve2 c) {
            double[] ts = c.inflections();
            Arrays.sort(ts);
            if (ts.length == 0) {
                return new FatLine[]{new FatLine(c, Interval.interval(0.0, 1.0))};
            }
            FatLine[] result2 = new FatLine[ts.length + 1];
            for (int i = 0; i < result2.length; ++i) {
                double lo = i == 0 ? 0.0 : ts[i - 1];
                double hi = i == result2.length - 1 ? 1.0 : ts[i];
                result2[i] = new FatLine(c, Interval.interval(lo, hi));
            }
            return result2;
        }

        public double mid() {
            return this.t.lerp(0.5);
        }

        public boolean isFlat() {
            return this.t.size() < 1.0E-6 || this.line.size() <= 1.0E-10;
        }

        public Box2 bounds() {
            return Box.box(this.range.start(), this.range.end());
        }

        public boolean intersects(FatLine l) {
            return ((Box2)this.bounds().expand(1.0E-9)).intersects(l.bounds());
        }

        public FatLine[] split() {
            if (this.isFlat()) {
                return new FatLine[]{this};
            }
            return new FatLine[]{new FatLine(this.curve, Interval.interval(this.t.lo, this.mid())), new FatLine(this.curve, Interval.interval(this.mid(), this.t.hi))};
        }

        public Line2 line() {
            return Line2.line(this.range.start(), this.range.end());
        }
    }

    public static class CurveInterval {
        public final Curve2 curve;
        public final boolean isFlat;
        public final double tLo;
        public final double tHi;
        public final Vec2 pLo;
        public final Vec2 pHi;

        public CurveInterval(Curve2 curve, double tLo, double tHi, Vec2 pLo, Vec2 pHi) {
            this.curve = curve;
            this.tLo = tLo;
            this.tHi = tHi;
            this.pLo = pLo;
            this.pHi = pHi;
            this.isFlat = Vec.equals(pLo, pHi, 1.0E-10) || tHi - tLo < 1.0E-6 || curve.range(tLo, tHi).isFlat(1.0E-10);
        }

        public Box2 bounds() {
            return Box.box(this.pLo, this.pHi);
        }

        public boolean intersects(CurveInterval c) {
            return ((Box2)this.bounds().expand(1.0E-10)).intersects(c.bounds());
        }

        public CurveInterval[] split() {
            if (this.isFlat) {
                return new CurveInterval[]{this};
            }
            double tMid = (this.tLo + this.tHi) / 2.0;
            Vec2 pMid = this.curve.position(tMid);
            return new CurveInterval[]{new CurveInterval(this.curve, this.tLo, tMid, this.pLo, pMid), new CurveInterval(this.curve, tMid, this.tHi, pMid, this.pHi)};
        }

        public static CurveInterval[] from(Curve2 c) {
            double[] ts = c.inflections();
            Arrays.sort(ts);
            if (ts.length == 0) {
                return new CurveInterval[]{new CurveInterval(c, 0.0, 1.0, c.start(), c.end())};
            }
            CurveInterval[] ls = new CurveInterval[ts.length + 1];
            for (int i = 0; i < ls.length; ++i) {
                double lo = i == 0 ? 0.0 : ts[i - 1];
                double hi = i == ls.length - 1 ? 1.0 : ts[i];
                ls[i] = new CurveInterval(c, lo, hi, c.position(lo), c.position(hi));
            }
            return ls;
        }

        public void intersections(CurveInterval c, IList<Vec2> acc) {
            for (Vec2 i : Intersections.lineLine(Line2.line(this.pLo, this.pHi), Line2.line(c.pLo, c.pHi))) {
                if (!((Box2)PARAMETRIC_BOUNDS.expand(1.0E-6)).contains(i)) continue;
                acc.addLast(Vec.lerp(Vec.vec(this.tLo, c.tLo), Vec.vec(this.tHi, c.tHi), i));
            }
        }

        public String toString() {
            return "[" + this.tLo + ", " + this.tHi + "]";
        }
    }
}

