/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.Graphs;
import io.lacuna.bifurcan.IEdge;
import io.lacuna.bifurcan.IGraph;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.Map;
import io.lacuna.bifurcan.Maps;
import io.lacuna.bifurcan.Set;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class DirectedGraph<V, E>
implements IGraph<V, E> {
    private static final Object DEFAULT = new Object();
    private static final Set EMPTY_SET = new Set();
    private final Object editor;
    private Map<V, Map<V, E>> out;
    private Map<V, Set<V>> in;

    public DirectedGraph() {
        this(false, new Map(), new Map());
    }

    public DirectedGraph(ToIntFunction<V> hashFn, BiPredicate<V, V> equalsFn) {
        this(false, new Map(hashFn, equalsFn), new Map(hashFn, equalsFn));
    }

    private DirectedGraph(boolean linear, Map<V, Map<V, E>> out, Map<V, Set<V>> in) {
        this.editor = linear ? new Object() : null;
        this.out = out;
        this.in = in;
    }

    @Override
    public Set<V> vertices() {
        return this.out.keys();
    }

    @Override
    public Iterable<IEdge<V, E>> edges() {
        return () -> this.out.entries().stream().flatMap(outer -> ((Map)outer.value()).entries().stream().map(inner -> new Graphs.Edge(inner.value(), inner.key(), outer.key()))).iterator();
    }

    @Override
    public E edge(V from, V to) {
        Map m = (Map)this.out.get(from).orElseThrow(() -> new IllegalArgumentException("no such edge"));
        Object e = m.get(to, DEFAULT);
        if (e == DEFAULT) {
            throw new IllegalArgumentException("no such edge");
        }
        return (E)e;
    }

    @Override
    public Set<V> in(V vertex) {
        Set s2 = this.in.get(vertex, null);
        if (s2 == null) {
            if (this.out.contains(vertex)) {
                return EMPTY_SET;
            }
            throw new IllegalArgumentException("no such vertex");
        }
        return s2;
    }

    @Override
    public Set<V> out(V vertex) {
        return ((Map)this.out.get(vertex).orElseThrow(() -> new IllegalArgumentException("no such vertex"))).keys();
    }

    @Override
    public <U> DirectedGraph<V, U> mapEdges(Function<IEdge<V, E>, U> f) {
        return new DirectedGraph<V, E>(this.isLinear(), this.out.mapValues((u, m) -> m.mapValues((v, e) -> f.apply(new Graphs.Edge<Object, Object>(e, u, v)))), this.in);
    }

    @Override
    public DirectedGraph<V, E> link(V from, V to, E edge, BinaryOperator<E> merge) {
        Object editor = this.isLinear() ? this.editor : new Object();
        Map<Map<V, E>, Map<Map<V, E>, E>> outPrime = this.out.update(from, m -> {
            if (m == null) {
                m = new Map<Object, Object>(this.out.keyHash(), this.out.keyEquality());
            }
            return m.put(to, edge, merge, editor);
        }, editor);
        outPrime = outPrime.update((Map<V, E>)to, m -> {
            if (m == null) {
                m = new Map(this.out.keyHash(), this.out.keyEquality());
            }
            return m;
        }, editor);
        Map<Set<V>, Set<Set<V>>> inPrime = this.in.update(to, s2 -> {
            if (s2 == null) {
                s2 = new Set<Object>(this.out.keyHash(), this.out.keyEquality());
            }
            return s2.add(from, editor);
        }, editor);
        if (this.isLinear()) {
            this.out = outPrime;
            this.in = inPrime;
            return this;
        }
        return new DirectedGraph<Set<V>, E>(false, outPrime, inPrime);
    }

    @Override
    public DirectedGraph<V, E> unlink(V from, V to) {
        if (this.out.get(from).map(m -> m.contains(to)).orElse(false).booleanValue()) {
            Object editor = this.isLinear() ? this.editor : new Object();
            Map<Map<V, E>, Map<Map<V, E>, E>> outPrime = this.out.update(from, m -> m.remove(to, editor), editor);
            Map<Set<V>, Set<Set<V>>> inPrime = this.in.update(to, s2 -> s2.remove(from, editor), editor);
            if (this.isLinear()) {
                this.out = outPrime;
                this.in = inPrime;
                return this;
            }
            return new DirectedGraph<Set<V>, E>(false, outPrime, inPrime);
        }
        return this;
    }

    @Override
    public DirectedGraph<V, E> add(V vertex) {
        if (this.out.contains(vertex)) {
            return this;
        }
        Object editor = this.isLinear() ? this.editor : new Object();
        Map outPrime = this.out.put(vertex, new Map(), Maps.MERGE_LAST_WRITE_WINS, editor);
        if (this.isLinear()) {
            this.out = outPrime;
            return this;
        }
        return new DirectedGraph(false, outPrime, this.in);
    }

    @Override
    public DirectedGraph<V, E> remove(V vertex) {
        if (this.out.contains(vertex)) {
            Object editor = this.isLinear() ? this.editor : new Object();
            IMap<Object, Set<V>> inPrime = this.in;
            for (Object v : ((Map)this.out.get(vertex).get()).keys()) {
                inPrime = inPrime.update(v, s2 -> s2.remove(vertex, editor), editor);
            }
            IMap<Object, Map<Object, Object>> outPrime = this.out;
            for (Object v : this.in.get((Set)vertex, EMPTY_SET)) {
                outPrime = outPrime.update(v, m -> m.remove(vertex, editor), editor);
            }
            inPrime = inPrime.remove((Object)vertex);
            outPrime = outPrime.remove((Object)vertex);
            if (this.isLinear()) {
                this.out = outPrime;
                this.in = inPrime;
                return this;
            }
            return new DirectedGraph<V, E>(false, outPrime, inPrime);
        }
        return this;
    }

    @Override
    public DirectedGraph<V, E> merge(IGraph<V, E> graph, BinaryOperator<E> merge) {
        if (graph instanceof DirectedGraph) {
            DirectedGraph g = (DirectedGraph)graph;
            return new DirectedGraph<V, E>(this.isLinear(), this.out.merge(g.out, (a2, b) -> a2.merge((IMap)b, merge)), this.in.merge(g.in, Set::union));
        }
        return (DirectedGraph)Graphs.merge(this, graph, merge);
    }

    @Override
    public DirectedGraph<V, E> select(ISet<V> vertices) {
        return new DirectedGraph<V, E>(this.isLinear(), ((Map)this.out.intersection((ISet)vertices)).mapValues((x, m) -> m.intersection(vertices)), ((Map)this.in.intersection((ISet)vertices)).mapValues((x, s2) -> s2.intersection(vertices)));
    }

    @Override
    public DirectedGraph<V, E> forked() {
        return this.isLinear() ? new DirectedGraph<V, E>(false, this.out, this.in) : this;
    }

    @Override
    public DirectedGraph<V, E> linear() {
        return this.isLinear() ? this : new DirectedGraph<V, E>(true, this.out, this.in);
    }

    @Override
    public boolean isLinear() {
        return this.editor != null;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public DirectedGraph<V, E> transpose() {
        return new DirectedGraph<V, E>(this.isLinear(), this.out.mapValues((u, x) -> this.in.get(u, DirectedGraph.EMPTY_SET).map.mapValues((v, y) -> this.edge(v, u))), this.out.mapValues((x, m) -> m.keys()));
    }

    @Override
    public ToIntFunction<V> vertexHash() {
        return this.out.keyHash();
    }

    @Override
    public BiPredicate<V, V> vertexEquality() {
        return this.out.keyEquality();
    }

    public int hashCode() {
        return this.out.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectedGraph) {
            return ((DirectedGraph)obj).out.equals(this.out);
        }
        if (obj instanceof IGraph) {
            return Graphs.equals(this, (IGraph)obj);
        }
        return false;
    }

    @Override
    public DirectedGraph<V, E> clone() {
        return this.isLinear() ? new DirectedGraph<V, E>(this.isLinear(), this.out.clone(), this.in.clone()) : this;
    }

    public String toString() {
        return this.out.toString();
    }
}

