/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRAttribute
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPE;
    public static final int VALUE;
    public static final int SIZE;

    public EXRAttribute(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), EXRAttribute.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[256]")
    public ByteBuffer name() {
        return EXRAttribute.nname(this.address());
    }

    @NativeType(value="char[256]")
    public String nameString() {
        return EXRAttribute.nnameString(this.address());
    }

    @NativeType(value="char[256]")
    public ByteBuffer type() {
        return EXRAttribute.ntype(this.address());
    }

    @NativeType(value="char[256]")
    public String typeString() {
        return EXRAttribute.ntypeString(this.address());
    }

    @Nullable
    @NativeType(value="unsigned char *")
    public ByteBuffer value() {
        return EXRAttribute.nvalue(this.address());
    }

    public int size() {
        return EXRAttribute.nsize(this.address());
    }

    public EXRAttribute name(@NativeType(value="char[256]") ByteBuffer value) {
        EXRAttribute.nname(this.address(), value);
        return this;
    }

    public EXRAttribute type(@NativeType(value="char[256]") ByteBuffer value) {
        EXRAttribute.ntype(this.address(), value);
        return this;
    }

    public EXRAttribute value(@Nullable @NativeType(value="unsigned char *") ByteBuffer value) {
        EXRAttribute.nvalue(this.address(), value);
        return this;
    }

    public EXRAttribute set(ByteBuffer name, ByteBuffer type2, @Nullable ByteBuffer value) {
        this.name(name);
        this.type(type2);
        this.value(value);
        return this;
    }

    public EXRAttribute set(EXRAttribute src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EXRAttribute malloc() {
        return EXRAttribute.wrap(EXRAttribute.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static EXRAttribute calloc() {
        return EXRAttribute.wrap(EXRAttribute.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static EXRAttribute create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return EXRAttribute.wrap(EXRAttribute.class, MemoryUtil.memAddress(container), container);
    }

    public static EXRAttribute create(long address) {
        return EXRAttribute.wrap(EXRAttribute.class, address);
    }

    @Nullable
    public static EXRAttribute createSafe(long address) {
        return address == 0L ? null : EXRAttribute.wrap(EXRAttribute.class, address);
    }

    public static Buffer malloc(int capacity) {
        return EXRAttribute.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(EXRAttribute.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return EXRAttribute.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRAttribute.__create(capacity, SIZEOF);
        return EXRAttribute.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return EXRAttribute.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : EXRAttribute.wrap(Buffer.class, address, capacity);
    }

    public static EXRAttribute mallocStack() {
        return EXRAttribute.mallocStack(MemoryStack.stackGet());
    }

    public static EXRAttribute callocStack() {
        return EXRAttribute.callocStack(MemoryStack.stackGet());
    }

    public static EXRAttribute mallocStack(MemoryStack stack) {
        return EXRAttribute.wrap(EXRAttribute.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRAttribute callocStack(MemoryStack stack) {
        return EXRAttribute.wrap(EXRAttribute.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return EXRAttribute.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return EXRAttribute.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRAttribute.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRAttribute.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    public static ByteBuffer ntype(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)TYPE, 256);
    }

    public static String ntypeString(long struct) {
        return MemoryUtil.memASCII(struct + (long)TYPE);
    }

    @Nullable
    public static ByteBuffer nvalue(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)VALUE), EXRAttribute.nsize(struct));
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NAME, value.remaining());
    }

    public static void ntype(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)TYPE, value.remaining());
    }

    public static void nvalue(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)VALUE, MemoryUtil.memAddressSafe(value));
        EXRAttribute.nsize(struct, value == null ? 0 : value.remaining());
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void validate(long struct) {
        if (EXRAttribute.nsize(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)VALUE));
        }
    }

    public static void validate(long array, int count2) {
        for (int i = 0; i < count2; ++i) {
            EXRAttribute.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = EXRAttribute.__struct(EXRAttribute.__array(1, 256), EXRAttribute.__array(1, 256), EXRAttribute.__member(POINTER_SIZE), EXRAttribute.__member(4), EXRAttribute.__padding(4, true));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        VALUE = layout.offsetof(2);
        SIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<EXRAttribute, Buffer>
    implements NativeResource {
        private static final EXRAttribute ELEMENT_FACTORY = EXRAttribute.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected EXRAttribute getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[256]")
        public ByteBuffer name() {
            return EXRAttribute.nname(this.address());
        }

        @NativeType(value="char[256]")
        public String nameString() {
            return EXRAttribute.nnameString(this.address());
        }

        @NativeType(value="char[256]")
        public ByteBuffer type() {
            return EXRAttribute.ntype(this.address());
        }

        @NativeType(value="char[256]")
        public String typeString() {
            return EXRAttribute.ntypeString(this.address());
        }

        @Nullable
        @NativeType(value="unsigned char *")
        public ByteBuffer value() {
            return EXRAttribute.nvalue(this.address());
        }

        public int size() {
            return EXRAttribute.nsize(this.address());
        }

        public Buffer name(@NativeType(value="char[256]") ByteBuffer value) {
            EXRAttribute.nname(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="char[256]") ByteBuffer value) {
            EXRAttribute.ntype(this.address(), value);
            return this;
        }

        public Buffer value(@Nullable @NativeType(value="unsigned char *") ByteBuffer value) {
            EXRAttribute.nvalue(this.address(), value);
            return this;
        }
    }
}

