/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BatchBuilder;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.CircleBatch;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Circle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0012\u001a\u00020\u0010J\"\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018J\u0014\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/openrndr/draw/CircleBatchBuilder;", "Lorg/openrndr/draw/BatchBuilder;", "drawer", "Lorg/openrndr/draw/Drawer;", "(Lorg/openrndr/draw/Drawer;)V", "entries", "", "Lorg/openrndr/draw/CircleBatchBuilder$Entry;", "getEntries", "()Ljava/util/List;", "batch", "Lorg/openrndr/draw/CircleBatch;", "existingBatch", "circle", "", "x", "", "y", "radius", "position", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/shape/Circle;", "circles", "centers", "", "radii", "Entry", "openrndr-core"})
public final class CircleBatchBuilder
extends BatchBuilder {
    @NotNull
    private final List<Entry> entries;

    @NotNull
    public final List<Entry> getEntries() {
        return this.entries;
    }

    public final void circle(double x, double y, double radius) {
        this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), new Vector3(x, y, 0.0), new Vector2(radius, radius)));
    }

    public final void circle(@NotNull Vector2 position, double radius) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), position.getXy0(), new Vector2(radius, radius)));
    }

    public final void circle(@NotNull Circle circle) {
        Intrinsics.checkNotNullParameter(circle, "circle");
        this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), circle.getCenter().getXy0(), new Vector2(circle.getRadius(), circle.getRadius())));
    }

    public final void circles(@NotNull List<Circle> circles) {
        Intrinsics.checkNotNullParameter(circles, "circles");
        for (Circle circle : circles) {
            this.circle(circle);
        }
    }

    public final void circles(@NotNull List<Vector2> centers, double radius) {
        Intrinsics.checkNotNullParameter(centers, "centers");
        for (Vector2 center : centers) {
            this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), center.getXy0(), new Vector2(radius, radius)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void circles(@NotNull List<Vector2> centers, @NotNull List<Double> radii) {
        Intrinsics.checkNotNullParameter(centers, "centers");
        Intrinsics.checkNotNullParameter(radii, "radii");
        int n = centers.size() == radii.size() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = 0;
        n2 = ((Collection)centers).size();
        while (n < n2) {
            void i;
            this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), centers.get((int)i).getXy0(), new Vector2(((Number)radii.get((int)i)).doubleValue(), ((Number)radii.get((int)i)).doubleValue())));
            ++i;
        }
    }

    @NotNull
    public final CircleBatch batch(@Nullable CircleBatch existingBatch) {
        Object object = existingBatch;
        if (object == null || (object = ((CircleBatch)object).getGeometry()) == null) {
            object = VertexBufferKt.vertexBuffer$default(BatchesKt.getCircleFormat(), this.entries.size(), null, 4, null);
        }
        Object geometry = object;
        VertexBuffer.DefaultImpls.put$default((VertexBuffer)geometry, 0, new Function1<BufferWriter, Unit>(this){
            final /* synthetic */ CircleBatchBuilder this$0;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                for (Entry entry : this.this$0.getEntries()) {
                    $this$put.write(entry.getOffset());
                    $this$put.write(entry.getRadius());
                }
            }
            {
                this.this$0 = circleBatchBuilder;
                super(1);
            }
        }, 1, null);
        Object object2 = existingBatch;
        if (object2 == null || (object2 = ((CircleBatch)object2).getDrawStyle()) == null) {
            object2 = VertexBufferKt.vertexBuffer$default(BatchesKt.getDrawStyleFormat(), this.entries.size(), null, 4, null);
        }
        Object drawStyle = object2;
        VertexBuffer.DefaultImpls.put$default((VertexBuffer)drawStyle, 0, new Function1<BufferWriter, Unit>(this){
            final /* synthetic */ CircleBatchBuilder this$0;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                for (Entry entry : this.this$0.getEntries()) {
                    ColorRGBa colorRGBa = entry.getFill();
                    if (colorRGBa == null) {
                        colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
                    }
                    $this$put.write(colorRGBa);
                    ColorRGBa colorRGBa2 = entry.getStroke();
                    if (colorRGBa2 == null) {
                        colorRGBa2 = ColorRGBa.Companion.getTRANSPARENT();
                    }
                    $this$put.write(colorRGBa2);
                    $this$put.write(entry.getStroke() == null ? 0.0f : (float)entry.getStrokeWeight());
                }
            }
            {
                this.this$0 = circleBatchBuilder;
                super(1);
            }
        }, 1, null);
        CircleBatch circleBatch = existingBatch;
        if (circleBatch == null) {
            circleBatch = new CircleBatch((VertexBuffer)geometry, (VertexBuffer)drawStyle);
        }
        return circleBatch;
    }

    public static /* synthetic */ CircleBatch batch$default(CircleBatchBuilder circleBatchBuilder, CircleBatch circleBatch, int n, Object object) {
        if ((n & 1) != 0) {
            circleBatch = null;
        }
        return circleBatchBuilder.batch(circleBatch);
    }

    public CircleBatchBuilder(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        super(drawer);
        boolean bl = false;
        this.entries = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/openrndr/draw/CircleBatchBuilder$Entry;", "", "fill", "Lorg/openrndr/color/ColorRGBa;", "stroke", "strokeWeight", "", "offset", "Lorg/openrndr/math/Vector3;", "radius", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/color/ColorRGBa;Lorg/openrndr/color/ColorRGBa;DLorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector2;)V", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "getOffset", "()Lorg/openrndr/math/Vector3;", "getRadius", "()Lorg/openrndr/math/Vector2;", "getStroke", "getStrokeWeight", "()D", "openrndr-core"})
    public static final class Entry {
        @Nullable
        private final ColorRGBa fill;
        @Nullable
        private final ColorRGBa stroke;
        private final double strokeWeight;
        @NotNull
        private final Vector3 offset;
        @NotNull
        private final Vector2 radius;

        @Nullable
        public final ColorRGBa getFill() {
            return this.fill;
        }

        @Nullable
        public final ColorRGBa getStroke() {
            return this.stroke;
        }

        public final double getStrokeWeight() {
            return this.strokeWeight;
        }

        @NotNull
        public final Vector3 getOffset() {
            return this.offset;
        }

        @NotNull
        public final Vector2 getRadius() {
            return this.radius;
        }

        public Entry(@Nullable ColorRGBa fill2, @Nullable ColorRGBa stroke, double strokeWeight, @NotNull Vector3 offset2, @NotNull Vector2 radius) {
            Intrinsics.checkNotNullParameter(offset2, "offset");
            Intrinsics.checkNotNullParameter(radius, "radius");
            this.fill = fill2;
            this.stroke = stroke;
            this.strokeWeight = strokeWeight;
            this.offset = offset2;
            this.radius = radius;
        }
    }
}

