/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ArrayCubemap;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.CubemapSide;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.draw.Session;
import org.openrndr.internal.Driver;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u0000 12\u00020\u0001:\u00011J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0007H&J,\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u0007H&J,\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u0007H&J$\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u0007H&J\b\u0010 \u001a\u00020\u0015H&J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H&J\b\u0010&\u001a\u00020\u0015H&J6\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u00032\b\b\u0002\u0010+\u001a\u00020\u000f2\b\b\u0002\u0010,\u001a\u00020\u0007H&J6\u0010-\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020)2\b\b\u0002\u0010/\u001a\u00020\u00032\b\b\u0002\u00100\u001a\u00020\u000f2\b\b\u0002\u0010,\u001a\u00020\u0007H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u00062"}, d2={"Lorg/openrndr/draw/Cubemap;", "", "format", "Lorg/openrndr/draw/ColorFormat;", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "levels", "", "getLevels", "()I", "session", "Lorg/openrndr/draw/Session;", "getSession", "()Lorg/openrndr/draw/Session;", "type", "Lorg/openrndr/draw/ColorType;", "getType", "()Lorg/openrndr/draw/ColorType;", "width", "getWidth", "bind", "", "textureUnit", "copyTo", "target", "Lorg/openrndr/draw/ArrayCubemap;", "layer", "fromLevel", "toLevel", "Lorg/openrndr/draw/ColorBuffer;", "fromSide", "Lorg/openrndr/draw/CubemapSide;", "destroy", "filter", "min", "Lorg/openrndr/draw/MinifyingFilter;", "mag", "Lorg/openrndr/draw/MagnifyingFilter;", "generateMipmaps", "read", "side", "Ljava/nio/ByteBuffer;", "targetFormat", "targetType", "level", "write", "source", "sourceFormat", "sourceType", "Companion", "openrndr-core"})
public interface Cubemap {
    public static final Companion Companion = org.openrndr.draw.Cubemap$Companion.$$INSTANCE;

    @Nullable
    public Session getSession();

    public int getWidth();

    @NotNull
    public ColorFormat getFormat();

    @NotNull
    public ColorType getType();

    public int getLevels();

    public void copyTo(@NotNull ArrayCubemap var1, int var2, int var3, int var4);

    public void copyTo(@NotNull Cubemap var1, int var2, int var3);

    public void copyTo(@NotNull ColorBuffer var1, @NotNull CubemapSide var2, int var3, int var4);

    public void filter(@NotNull MinifyingFilter var1, @NotNull MagnifyingFilter var2);

    public void bind(int var1);

    public void generateMipmaps();

    public void destroy();

    public void read(@NotNull CubemapSide var1, @NotNull ByteBuffer var2, @NotNull ColorFormat var3, @NotNull ColorType var4, int var5);

    public void write(@NotNull CubemapSide var1, @NotNull ByteBuffer var2, @NotNull ColorFormat var3, @NotNull ColorType var4, int var5);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static /* synthetic */ void copyTo$default(Cubemap cubemap, ArrayCubemap arrayCubemap, int n, int n2, int n3, int n4, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTo");
            }
            if ((n4 & 4) != 0) {
                n2 = 0;
            }
            if ((n4 & 8) != 0) {
                n3 = 0;
            }
            cubemap.copyTo(arrayCubemap, n, n2, n3);
        }

        public static /* synthetic */ void copyTo$default(Cubemap cubemap, Cubemap cubemap2, int n, int n2, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTo");
            }
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            cubemap.copyTo(cubemap2, n, n2);
        }

        public static /* synthetic */ void copyTo$default(Cubemap cubemap, ColorBuffer colorBuffer, CubemapSide cubemapSide, int n, int n2, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTo");
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            cubemap.copyTo(colorBuffer, cubemapSide, n, n2);
        }

        public static /* synthetic */ void bind$default(Cubemap cubemap, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bind");
            }
            if ((n2 & 1) != 0) {
                n = 0;
            }
            cubemap.bind(n);
        }

        public static /* synthetic */ void read$default(Cubemap cubemap, CubemapSide cubemapSide, ByteBuffer byteBuffer, ColorFormat colorFormat, ColorType colorType, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
            }
            if ((n2 & 4) != 0) {
                colorFormat = cubemap.getFormat();
            }
            if ((n2 & 8) != 0) {
                colorType = cubemap.getType();
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            cubemap.read(cubemapSide, byteBuffer, colorFormat, colorType, n);
        }

        public static /* synthetic */ void write$default(Cubemap cubemap, CubemapSide cubemapSide, ByteBuffer byteBuffer, ColorFormat colorFormat, ColorType colorType, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n2 & 4) != 0) {
                colorFormat = cubemap.getFormat();
            }
            if ((n2 & 8) != 0) {
                colorType = cubemap.getType();
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            cubemap.write(cubemapSide, byteBuffer, colorFormat, colorType, n);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00062\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ$\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ*\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ*\u0010\u0019\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u001b"}, d2={"Lorg/openrndr/draw/Cubemap$Companion;", "", "()V", "create", "Lorg/openrndr/draw/Cubemap;", "width", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "levels", "session", "Lorg/openrndr/draw/Session;", "fromFile", "file", "Ljava/io/File;", "formatHint", "Lorg/openrndr/draw/ImageFileFormat;", "fromFiles", "filenames", "", "fromUrl", "url", "", "fromUrls", "urls", "openrndr-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final Cubemap create(int width, @NotNull ColorFormat format, @NotNull ColorType type2, int levels2, @Nullable Session session) {
            Intrinsics.checkNotNullParameter((Object)format, "format");
            Intrinsics.checkNotNullParameter((Object)type2, "type");
            Cubemap cubemap = Driver.Companion.getInstance().createCubemap(width, format, type2, levels2, session);
            return cubemap;
        }

        public static /* synthetic */ Cubemap create$default(Companion companion, int n, ColorFormat colorFormat, ColorType colorType, int n2, Session session, int n3, Object object) {
            if ((n3 & 2) != 0) {
                colorFormat = ColorFormat.RGBa;
            }
            if ((n3 & 4) != 0) {
                colorType = ColorType.UINT8;
            }
            if ((n3 & 8) != 0) {
                n2 = -1;
            }
            if ((n3 & 0x10) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.create(n, colorFormat, colorType, n2, session);
        }

        @NotNull
        public final Cubemap fromUrl(@NotNull String url, @Nullable ImageFileFormat formatHint, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(url, "url");
            Cubemap cubemap = Driver.Companion.getInstance().createCubemapFromUrls(CollectionsKt.listOf(url), formatHint, session);
            return cubemap;
        }

        public static /* synthetic */ Cubemap fromUrl$default(Companion companion, String string, ImageFileFormat imageFileFormat, Session session, int n, Object object) {
            if ((n & 4) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.fromUrl(string, imageFileFormat, session);
        }

        @NotNull
        public final Cubemap fromUrls(@NotNull List<String> urls, @Nullable ImageFileFormat formatHint, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(urls, "urls");
            return Driver.Companion.getInstance().createCubemapFromUrls(urls, formatHint, session);
        }

        public static /* synthetic */ Cubemap fromUrls$default(Companion companion, List list, ImageFileFormat imageFileFormat, Session session, int n, Object object) {
            if ((n & 4) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.fromUrls(list, imageFileFormat, session);
        }

        @NotNull
        public final Cubemap fromFile(@NotNull File file, @Nullable ImageFileFormat formatHint, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(file, "file");
            return Driver.Companion.getInstance().createCubemapFromFiles(CollectionsKt.listOf(file.getAbsolutePath()), formatHint, session);
        }

        public static /* synthetic */ Cubemap fromFile$default(Companion companion, File file, ImageFileFormat imageFileFormat, Session session, int n, Object object) {
            if ((n & 4) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.fromFile(file, imageFileFormat, session);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Cubemap fromFiles(@NotNull List<? extends File> filenames, @Nullable ImageFileFormat formatHint, @Nullable Session session) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(filenames, "filenames");
            Iterable iterable = filenames;
            Driver driver = Driver.Companion.getInstance();
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getAbsolutePath();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            return driver.createCubemapFromFiles((List<String>)collection, formatHint, session);
        }

        public static /* synthetic */ Cubemap fromFiles$default(Companion companion, List list, ImageFileFormat imageFileFormat, Session session, int n, Object object) {
            if ((n & 4) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.fromFiles(list, imageFileFormat, session);
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

