/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\b\u0086\u0001\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/draw/ImageFileFormat;", "", "mimeType", "", "extensions", "", "(Ljava/lang/String;ILjava/lang/String;Ljava/util/List;)V", "getExtensions", "()Ljava/util/List;", "getMimeType", "()Ljava/lang/String;", "JPG", "PNG", "DDS", "EXR", "Companion", "openrndr-core"})
public final class ImageFileFormat
extends Enum<ImageFileFormat> {
    public static final /* enum */ ImageFileFormat JPG;
    public static final /* enum */ ImageFileFormat PNG;
    public static final /* enum */ ImageFileFormat DDS;
    public static final /* enum */ ImageFileFormat EXR;
    private static final /* synthetic */ ImageFileFormat[] $VALUES;
    @NotNull
    private final String mimeType;
    @NotNull
    private final List<String> extensions;
    public static final Companion Companion;

    static {
        ImageFileFormat[] imageFileFormatArray = new ImageFileFormat[4];
        ImageFileFormat[] imageFileFormatArray2 = imageFileFormatArray;
        imageFileFormatArray[0] = JPG = new ImageFileFormat("image/jpeg", CollectionsKt.listOf("jpg", "jpeg"));
        imageFileFormatArray[1] = PNG = new ImageFileFormat("image/png", CollectionsKt.listOf("png"));
        imageFileFormatArray[2] = DDS = new ImageFileFormat("image/vnd.ms-dds", CollectionsKt.listOf("dds"));
        imageFileFormatArray[3] = EXR = new ImageFileFormat("image/x-exr", CollectionsKt.listOf("exr"));
        $VALUES = imageFileFormatArray;
        Companion = new Companion(null);
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    @NotNull
    public final List<String> getExtensions() {
        return this.extensions;
    }

    private ImageFileFormat(String mimeType, List<String> extensions) {
        this.mimeType = mimeType;
        this.extensions = extensions;
    }

    public static ImageFileFormat[] values() {
        return (ImageFileFormat[])$VALUES.clone();
    }

    public static ImageFileFormat valueOf(String string) {
        return Enum.valueOf(ImageFileFormat.class, string);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/draw/ImageFileFormat$Companion;", "", "()V", "guessFromExtension", "Lorg/openrndr/draw/ImageFileFormat;", "file", "Ljava/io/File;", "openrndr-core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ImageFileFormat guessFromExtension(@NotNull File file) {
            ImageFileFormat imageFileFormat;
            String string;
            Intrinsics.checkNotNullParameter(file, "file");
            String string2 = FilesKt.getExtension(file);
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toLowerCase()");
            switch (string = string4) {
                case "jpg": 
                case "jpeg": {
                    imageFileFormat = JPG;
                    break;
                }
                case "png": {
                    imageFileFormat = PNG;
                    break;
                }
                case "dds": {
                    imageFileFormat = DDS;
                    break;
                }
                case "exr": {
                    imageFileFormat = EXR;
                    break;
                }
                default: {
                    void extension;
                    throw (Throwable)new IllegalArgumentException("unsupported format: \"" + (String)extension + '\"');
                }
            }
            return imageFileFormat;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

