/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.keyframer;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.extra.keyframer.ExpressionException;
import org.openrndr.extra.keyframer.ExpressionsKt;
import org.openrndr.extra.keyframer.FunctionExtensions;
import org.openrndr.extra.keyframer.Hold;
import org.openrndr.extra.keyframer.Keyframer;
import org.openrndr.extra.keyframer.Keyframer$WhenMappings;
import org.openrndr.extra.keyframer.KeyframerChannel;
import org.openrndr.extra.keyframer.KeyframerFormat;
import org.openrndr.extras.easing.Easing;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001:\b'()*+,-.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0086\u0002J8\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ8\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ8\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ<\u0010\u001f\u001a\u00020\u00122\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00100!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0019\u001a\u00020\u001aJ:\u0010#\u001a\u00020\u00122\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00102\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010&\u001a\u00020\u0005H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00100\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/openrndr/extra/keyframer/Keyframer;", "", "()V", "channels", "", "", "Lorg/openrndr/extra/keyframer/KeyframerChannel;", "getChannels", "()Ljava/util/Map;", "currentTime", "", "duration", "getDuration", "()D", "parameters", "prototypes", "", "invoke", "", "time", "loadFromJson", "file", "Ljava/io/File;", "format", "Lorg/openrndr/extra/keyframer/KeyframerFormat;", "functions", "Lorg/openrndr/extra/keyframer/FunctionExtensions;", "url", "Ljava/net/URL;", "loadFromJsonString", "json", "loadFromKeyObjects", "keys", "", "externalParameters", "loadFromObjects", "dict", "resolvePrototype", "prototypeNames", "CompoundChannel", "DoubleArrayChannel", "DoubleChannel", "RGBChannel", "RGBaChannel", "Vector2Channel", "Vector3Channel", "Vector4Channel", "orx-keyframer"})
public class Keyframer {
    private double currentTime;
    @NotNull
    private final Map<String, KeyframerChannel> channels;
    private final Map<String, Double> parameters;
    private final Map<String, Map<String, Object>> prototypes;

    public final void invoke(double time2) {
        this.currentTime = time2;
    }

    public final double getDuration() {
        Object v0;
        Iterable $this$maxByOrNull$iv = this.channels.values();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                KeyframerChannel it = (KeyframerChannel)maxElem$iv;
                boolean bl = false;
                double maxValue$iv = it.duration();
                do {
                    Object e$iv = iterator$iv.next();
                    KeyframerChannel it2 = (KeyframerChannel)e$iv;
                    $i$a$-maxByOrNull-Keyframer$duration$1 = false;
                    double v$iv = it2.duration();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        KeyframerChannel keyframerChannel = v0;
        return keyframerChannel != null ? keyframerChannel.duration() : 0.0;
    }

    @NotNull
    public final Map<String, KeyframerChannel> getChannels() {
        return this.channels;
    }

    public final void loadFromJson(@NotNull File file, @NotNull KeyframerFormat format, @NotNull Map<String, Double> parameters2, @NotNull FunctionExtensions functions2) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(functions2, "functions");
        boolean bl = file.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "failed to load keyframer from json: '" + file.getAbsolutePath() + "' does not exist.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        try {
            this.loadFromJsonString(FilesKt.readText$default(file, null, 1, null), format, parameters2, functions2);
        }
        catch (ExpressionException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error loading from '").append(file.getPath()).append("': ");
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
        }
    }

    public static /* synthetic */ void loadFromJson$default(Keyframer keyframer, File file, KeyframerFormat keyframerFormat, Map map2, FunctionExtensions functionExtensions, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadFromJson");
        }
        if ((n & 2) != 0) {
            keyframerFormat = KeyframerFormat.SIMPLE;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            functionExtensions = FunctionExtensions.Companion.getEMPTY();
        }
        keyframer.loadFromJson(file, keyframerFormat, map2, functionExtensions);
    }

    public final void loadFromJson(@NotNull URL url, @NotNull KeyframerFormat format, @NotNull Map<String, Double> parameters2, @NotNull FunctionExtensions functions2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(functions2, "functions");
        try {
            URL uRL = url;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes(uRL);
            boolean bl2 = false;
            boolean bl3 = false;
            this.loadFromJsonString(new String(byArray, charset), format, parameters2, functions2);
        }
        catch (ExpressionException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error loading ").append((Object)format).append(" from '").append(url).append("': ");
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
        }
        catch (IllegalStateException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error loading ").append((Object)format).append(" from '").append(url).append("': ");
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
        }
    }

    public static /* synthetic */ void loadFromJson$default(Keyframer keyframer, URL uRL, KeyframerFormat keyframerFormat, Map map2, FunctionExtensions functionExtensions, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadFromJson");
        }
        if ((n & 2) != 0) {
            keyframerFormat = KeyframerFormat.SIMPLE;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            functionExtensions = FunctionExtensions.Companion.getEMPTY();
        }
        keyframer.loadFromJson(uRL, keyframerFormat, map2, functionExtensions);
    }

    public final void loadFromJsonString(@NotNull String json, @NotNull KeyframerFormat format, @NotNull Map<String, Double> parameters2, @NotNull FunctionExtensions functions2) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(functions2, "functions");
        switch (Keyframer$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                try {
                    Type type2 = new TypeToken<List<? extends Map<String, ? extends Object>>>(){}.getType();
                    Object t2 = new Gson().fromJson(json, type2);
                    Intrinsics.checkNotNullExpressionValue(t2, "Gson().fromJson(json, type)");
                    List keys2 = (List)t2;
                    this.loadFromKeyObjects(keys2, parameters2, functions2);
                    break;
                }
                catch (JsonSyntaxException e) {
                    Throwable throwable = e.getCause();
                    String keys2 = "Error parsing simple Keyframer data: " + (throwable != null ? throwable.getMessage() : null);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(keys2.toString());
                }
                catch (NullPointerException e) {
                    Throwable throwable = e.getCause();
                    String keys2 = "Error parsing simple Keyframer data: " + (throwable != null ? throwable.getMessage() : null);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(keys2.toString());
                }
            }
            case 2: {
                try {
                    Type type3 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                    Object t3 = new Gson().fromJson(json, type3);
                    Intrinsics.checkNotNullExpressionValue(t3, "Gson().fromJson(json, type)");
                    Map keys3 = (Map)t3;
                    this.loadFromObjects(keys3, parameters2, functions2);
                    break;
                }
                catch (JsonSyntaxException e) {
                    Throwable throwable = e.getCause();
                    String string = "Error parsing full Keyframer data: " + (throwable != null ? throwable.getMessage() : null);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
    }

    public static /* synthetic */ void loadFromJsonString$default(Keyframer keyframer, String string, KeyframerFormat keyframerFormat, Map map2, FunctionExtensions functionExtensions, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadFromJsonString");
        }
        if ((n & 2) != 0) {
            keyframerFormat = KeyframerFormat.SIMPLE;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            functionExtensions = FunctionExtensions.Companion.getEMPTY();
        }
        keyframer.loadFromJsonString(string, keyframerFormat, map2, functionExtensions);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadFromObjects(@NotNull Map<String, ? extends Object> dict, @NotNull Map<String, Double> externalParameters, @NotNull FunctionExtensions functions2) {
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Intrinsics.checkNotNullParameter(dict, "dict");
        Intrinsics.checkNotNullParameter(externalParameters, "externalParameters");
        Intrinsics.checkNotNullParameter(functions2, "functions");
        this.parameters.clear();
        this.parameters.putAll(externalParameters);
        this.prototypes.clear();
        Object object3 = dict.get("parameters");
        if (!(object3 instanceof Map)) {
            object3 = null;
        }
        Map map2 = (Map)object3;
        if (map2 != null) {
            object2 = map2;
            bl2 = false;
            bl = false;
            Map lp = object2;
            boolean bl3 = false;
            Map map3 = lp;
            boolean bl4 = false;
            for (Map.Entry entry : map3.entrySet()) {
                double d;
                Object k;
                Map<String, Double> map4;
                Object k2 = entry.getKey();
                Map<String, Double> map5 = this.parameters;
                try {
                    double d2;
                    map4 = map5;
                    k = k2;
                    Object candidate = entry.getValue();
                    if (candidate instanceof Double) {
                        d2 = ((Number)candidate).doubleValue();
                    } else if (candidate instanceof String) {
                        Double d3 = ExpressionsKt.evaluateExpression((String)candidate, this.parameters, functions2);
                        if (d3 == null) {
                            String string = "could not evaluate expression: '" + candidate + '\'';
                            boolean bl5 = false;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        d2 = d3;
                    } else if (candidate instanceof Integer) {
                        d2 = ((Number)candidate).intValue();
                    } else {
                        if (!(candidate instanceof Float)) {
                            String string = "unknown type for parameter '" + (String)entry.getKey() + '\'';
                            boolean bl6 = false;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        d2 = ((Number)candidate).floatValue();
                    }
                    d = d2;
                }
                catch (ExpressionException expressionException) {
                    void e;
                    Map<String, Double> map6 = map5;
                    Object k3 = k2;
                    StringBuilder stringBuilder = new StringBuilder().append("error in 'parameters': ");
                    String string = e.getMessage();
                    if (string != null) {
                        throw (Throwable)new ExpressionException(stringBuilder.append(string).append(' ').toString());
                    }
                    string = "";
                    throw (Throwable)new ExpressionException(stringBuilder.append(string).append(' ').toString());
                }
                map4.put((String)k, d);
            }
        }
        this.parameters.putAll(externalParameters);
        Object object4 = dict.get("prototypes");
        if (!(object4 instanceof Map)) {
            object4 = null;
        }
        Map map7 = (Map)object4;
        if (map7 != null) {
            object2 = map7;
            bl2 = false;
            bl = false;
            Map it = object2;
            boolean bl7 = false;
            this.prototypes.putAll(it);
        }
        if (!((object = dict.get("keys")) instanceof List)) {
            object = null;
        }
        List list = (List)object;
        if (list == null) return;
        object2 = list;
        bl2 = false;
        bl = false;
        Object keys2 = object2;
        boolean bl8 = false;
        this.loadFromKeyObjects((List<? extends Map<String, ? extends Object>>)keys2, this.parameters, functions2);
    }

    public static /* synthetic */ void loadFromObjects$default(Keyframer keyframer, Map map2, Map map3, FunctionExtensions functionExtensions, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadFromObjects");
        }
        if ((n & 2) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            functionExtensions = FunctionExtensions.Companion.getEMPTY();
        }
        keyframer.loadFromObjects(map2, map3, functionExtensions);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> resolvePrototype(String prototypeNames) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        boolean bl;
        CharSequence charSequence;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)prototypeNames, new String[]{" "}, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            charSequence = it;
            bl = false;
            void v0 = charSequence;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string2 = ((Object)StringsKt.trim((CharSequence)v0)).toString();
            collection.add(string2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl3 = false;
            charSequence = it;
            bl = false;
            if (!(!StringsKt.isBlank(charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List prototypeTokens = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = prototypeTokens;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Map<String, Object> map2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            String it2 = (String)element$iv$iv;
            boolean bl5 = false;
            if (this.prototypes.get(it2) == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            Map<String, Object> it$iv$iv = map2;
            boolean bl8 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List prototypeRefs = (List)destination$iv$iv2;
        $i$f$mapNotNull = false;
        Map computed = new LinkedHashMap();
        for (Map ref : prototypeRefs) {
            computed.putAll(ref);
        }
        return computed;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadFromKeyObjects(@NotNull List<? extends Map<String, ? extends Object>> keys2, @NotNull Map<String, Double> externalParameters, @NotNull FunctionExtensions functions2) {
        void lastTime;
        void $this$flatMapTo$iv$iv;
        Iterable $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(keys2, "keys");
        Intrinsics.checkNotNullParameter(externalParameters, "externalParameters");
        Intrinsics.checkNotNullParameter(functions2, "functions");
        if (externalParameters != this.parameters) {
            this.parameters.clear();
            this.parameters.putAll(externalParameters);
        }
        Ref.DoubleRef doubleRef = new Ref.DoubleRef();
        doubleRef.element = 0.0;
        Iterable $this$mapNotNull$iv = KClasses.getMemberProperties(Reflection.getOrCreateKotlinClass(this.getClass()));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KProperty1 it = (KProperty1)element$iv$iv;
            boolean bl2 = false;
            KProperty1 kProperty1 = it;
            if (!(kProperty1 instanceof KProperty1)) {
                kProperty1 = null;
            }
            if (kProperty1 == null) continue;
            KProperty1 kProperty12 = kProperty1;
            boolean bl3 = false;
            boolean bl4 = false;
            KProperty1 it$iv$iv = kProperty12;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KProperty1 it = (KProperty1)element$iv$iv;
            boolean bl = false;
            KCallablesJvm.setAccessible(it, true);
            if (!(it.getDelegate(this) instanceof CompoundChannel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv2;
            Object it = (KProperty1)element$iv$iv;
            boolean bl6 = false;
            Object object = it.getDelegate(this);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.extra.keyframer.Keyframer.CompoundChannel");
            }
            it = new Pair<String, CompoundChannel>(it.getName(), (CompoundChannel)object);
            bl6 = false;
            bl.put(((Pair)it).getFirst(), ((Pair)it).getSecond());
        }
        Map channelDelegates = destination$iv$iv2;
        Iterable $this$flatMap$iv = channelDelegates.values();
        boolean $i$f$flatMap = false;
        $this$associateTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            CompoundChannel channel = (CompoundChannel)element$iv$iv;
            boolean bl = false;
            String[] $this$map$iv = channel.getKeys();
            boolean $i$f$map = false;
            String[] bl2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var21_39 = $this$mapTo$iv$iv;
            int n = ((void)var21_39).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var25_45 = item$iv$iv = var21_39[i];
                Collection collection = destination$iv$iv3;
                boolean bl7 = false;
                void var28_48 = it;
                collection.add(var28_48);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        Set channelKeys = CollectionsKt.toSet((List)destination$iv$iv2);
        for (CompoundChannel delegate : channelDelegates.values()) {
            delegate.reset();
        }
        $i$f$flatMap = false;
        Map expressionContext = new LinkedHashMap();
        expressionContext.putAll(this.parameters);
        expressionContext.put("t", 0.0);
        loadFromKeyObjects.1 $fun$easingFunctionFromName$1 = loadFromKeyObjects.1.INSTANCE;
        Function2<Map<String, ? extends Object>, String, Unit> $fun$handleKey$2 = new Function2<Map<String, ? extends Object>, String, Unit>(this, (Ref.DoubleRef)lastTime, expressionContext, functions2, channelKeys){
            final /* synthetic */ Keyframer this$0;
            final /* synthetic */ Ref.DoubleRef $lastTime;
            final /* synthetic */ Map $expressionContext;
            final /* synthetic */ FunctionExtensions $functions;
            final /* synthetic */ Set $channelKeys;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void invoke(@NotNull Map<String, ? extends Object> key, @NotNull String path) {
                int candidate32;
                Object it;
                void $this$filterTo$iv$iv;
                Function4<Double, Double, Double, Double, Double> function4;
                double d;
                double candidate22;
                boolean bl;
                Object object;
                block95: {
                    block94: {
                        Intrinsics.checkNotNullParameter(key, "key");
                        Intrinsics.checkNotNullParameter(path, "path");
                        Object object2 = key.get("prototypes");
                        if (!(object2 instanceof String)) {
                            object2 = null;
                        }
                        if ((object = (String)object2) == null) break block94;
                        String string = object;
                        bl = false;
                        boolean bl2 = false;
                        String it2 = string;
                        boolean bl3 = false;
                        object = Keyframer.access$resolvePrototype(this.this$0, it2);
                        if (object != null) break block95;
                    }
                    object = MapsKt.emptyMap();
                }
                Object prototype = object;
                bl = false;
                Map computed = new LinkedHashMap<K, V>();
                computed.putAll(prototype);
                computed.putAll(key);
                try {
                    double d2;
                    V candidate22 = computed.get("time");
                    if (candidate22 == null) {
                        d2 = this.$lastTime.element;
                    } else if (candidate22 instanceof String) {
                        Double d3 = ExpressionsKt.evaluateExpression((String)candidate22, this.$expressionContext, this.$functions);
                        if (d3 == null) {
                            Function0<String> function0 = new Function0<String>(candidate22){
                                final /* synthetic */ Object $candidate;

                                @NotNull
                                public final String invoke() {
                                    return "unknown value format for time : " + this.$candidate;
                                }
                                {
                                    this.$candidate = object;
                                    super(0);
                                }
                            };
                            boolean bl4 = false;
                            throw (Throwable)new IllegalStateException(function0.toString());
                        }
                        d2 = d3;
                    } else if (candidate22 instanceof Double) {
                        d2 = ((Number)candidate22).doubleValue();
                    } else if (candidate22 instanceof Integer) {
                        d2 = ((Number)candidate22).intValue();
                    } else {
                        if (!(candidate22 instanceof Float)) {
                            String string = "unknown time format for '" + candidate22 + '\'';
                            boolean bl5 = false;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        d2 = ((Number)candidate22).floatValue();
                    }
                    candidate22 = d2;
                }
                catch (ExpressionException expressionException) {
                    StringBuilder stringBuilder = new StringBuilder().append("error in ").append(path).append(".'time': ");
                    String string = expressionException.getMessage();
                    if (string != null) {
                        throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                    }
                    string = "";
                    throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                }
                double time2 = candidate22;
                try {
                    double d4;
                    V v = computed.get("duration");
                    if (v == null) {
                        d4 = 0.0;
                    } else if (v instanceof String) {
                        Double d5 = ExpressionsKt.evaluateExpression((String)v, this.$expressionContext, this.$functions);
                        if (d5 == null) {
                            Function0<String> function0 = new Function0<String>(v){
                                final /* synthetic */ Object $candidate;

                                @NotNull
                                public final String invoke() {
                                    return "unknown value format for time : " + this.$candidate;
                                }
                                {
                                    this.$candidate = object;
                                    super(0);
                                }
                            };
                            boolean bl6 = false;
                            throw (Throwable)new IllegalStateException(function0.toString());
                        }
                        d4 = d5;
                    } else if (v instanceof Integer) {
                        d4 = ((Number)v).intValue();
                    } else if (v instanceof Float) {
                        d4 = ((Number)v).floatValue();
                    } else {
                        if (!(v instanceof Double)) {
                            String string = "unknown duration type for '" + v;
                            boolean bl7 = false;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        d4 = ((Number)v).doubleValue();
                    }
                    d = d4;
                }
                catch (ExpressionException e) {
                    StringBuilder stringBuilder = new StringBuilder().append("error in ").append(path).append(".'duration': ");
                    String string = e.getMessage();
                    if (string != null) {
                        throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                    }
                    string = "";
                    throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                }
                double duration2 = d;
                try {
                    Function4<Double, Double, Double, Double, Double> function42;
                    V v = computed.get("easing");
                    if (v == null) {
                        function42 = Easing.Linear.getFunction();
                    } else {
                        if (!(v instanceof String)) {
                            String e = "unknown easing for '" + v + '\'';
                            boolean bl8 = false;
                            throw (Throwable)new IllegalStateException(e.toString());
                        }
                        function42 = loadFromKeyObjects.1.INSTANCE.invoke((String)v);
                    }
                    function4 = function42;
                }
                catch (IllegalStateException e) {
                    StringBuilder stringBuilder = new StringBuilder().append("error in ").append(path).append(".'easing': ");
                    String string = e.getMessage();
                    if (string != null) {
                        throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                    }
                    string = "";
                    throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                }
                Function4<Double, Double, Double, Double, Double> function43 = function4;
                Hold hold = Hold.HoldNone;
                Set<String> reservedKeys = SetsKt.setOf("time", "easing", "hold");
                Map $this$filter$iv = computed;
                boolean $i$f$filter2 = false;
                Map map2 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                void var19_54 = $this$filterTo$iv$iv;
                boolean bl9 = false;
                for (Map.Entry<K, V> entry : var19_54.entrySet()) {
                    it = entry;
                    boolean bl10 = false;
                    if (!(!reservedKeys.contains(it.getKey()))) continue;
                    destination$iv$iv.put(entry.getKey(), entry.getValue());
                }
                $this$filter$iv = destination$iv$iv;
                $i$f$filter2 = false;
                for (Map.Entry<K, V> channelCandidate : $this$filter$iv.entrySet()) {
                    double d6;
                    Object object3;
                    void $this$getOrPut$iv;
                    if (!this.$channelKeys.contains(channelCandidate.getKey())) continue;
                    Map<String, KeyframerChannel> $i$f$filter2 = this.this$0.getChannels();
                    K key$iv = channelCandidate.getKey();
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl11 = false;
                        KeyframerChannel answer$iv = new KeyframerChannel();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv;
                    }
                    KeyframerChannel channel = (KeyframerChannel)object3;
                    Double d7 = channel.lastValue();
                    double lastValue = d7 != null ? d7 : 0.0;
                    this.$expressionContext.put("v", lastValue);
                    Double d8 = channel.lastTime();
                    double lastTime = d8 != null ? d8 : 0.0;
                    this.$expressionContext.put("d", time2 - lastTime);
                    if (channelCandidate.getValue() instanceof Map) {
                        Double d9;
                        boolean bl12;
                        Function4<Double, Double, Double, Double, Double> function44;
                        double d10;
                        V v = channelCandidate.getValue();
                        if (v == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                        }
                        Map valueMap = (Map)v;
                        try {
                            double d11;
                            V v2 = valueMap.get("value");
                            if (v2 == null) {
                                it = "no value for '" + (String)channelCandidate.getKey() + '\'';
                                boolean bl10 = false;
                                throw (Throwable)new IllegalStateException(it.toString());
                            }
                            if (v2 instanceof Double) {
                                d11 = ((Number)v2).doubleValue();
                            } else if (v2 instanceof String) {
                                Double d12 = ExpressionsKt.evaluateExpression((String)v2, this.$expressionContext, this.$functions);
                                if (d12 == null) {
                                    it = "unknown value format for key '" + (String)channelCandidate.getKey() + "' : " + v2;
                                    boolean bl10 = false;
                                    throw (Throwable)new IllegalStateException(it.toString());
                                }
                                d11 = d12;
                            } else {
                                if (!(v2 instanceof Integer)) {
                                    it = "unknown value type for key '" + (String)channelCandidate.getKey() + "' : " + v2;
                                    boolean bl10 = false;
                                    throw (Throwable)new IllegalStateException(it.toString());
                                }
                                d11 = ((Number)v2).intValue();
                            }
                            d10 = d11;
                        }
                        catch (ExpressionException e) {
                            StringBuilder stringBuilder = new StringBuilder().append("error in ").append(path).append(".'").append((String)channelCandidate.getKey()).append("': ");
                            String string = e.getMessage();
                            if (string != null) {
                                throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                            }
                            string = "";
                            throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                        }
                        double value = d10;
                        V candidate = valueMap.get("easing");
                        if (candidate == null) {
                            function44 = function43;
                        } else {
                            if (!(candidate instanceof String)) {
                                String e = "unknown easing for '" + candidate + '\'';
                                boolean bl13 = false;
                                throw (Throwable)new IllegalStateException(e.toString());
                            }
                            function44 = loadFromKeyObjects.1.INSTANCE.invoke((String)candidate);
                        }
                        Function4<Double, Double, Double, Double, Double> function45 = function44;
                        try {
                            Double d13;
                            V candidate4 = valueMap.get("duration");
                            if (candidate4 == null) {
                                d13 = null;
                            } else if (candidate4 instanceof Double) {
                                d13 = (Double)candidate4;
                            } else if (candidate4 instanceof String) {
                                Double d14 = ExpressionsKt.evaluateExpression((String)candidate4, this.$expressionContext, this.$functions);
                                if (d14 == null) {
                                    String string = "unknown value format for key '" + (String)channelCandidate.getKey() + "' : " + candidate4;
                                    bl12 = false;
                                    throw (Throwable)new IllegalStateException(string.toString());
                                }
                                d13 = (double)d14;
                            } else {
                                if (!(candidate4 instanceof Integer)) {
                                    String string = "unknown value type for key '" + (String)channelCandidate.getKey() + "' : " + candidate4;
                                    bl12 = false;
                                    throw (Throwable)new IllegalStateException(string.toString());
                                }
                                d13 = ((Number)candidate4).intValue();
                            }
                            d9 = d13;
                        }
                        catch (ExpressionException e) {
                            StringBuilder stringBuilder = new StringBuilder().append("error in ").append(path).append(".'").append((String)channelCandidate.getKey()).append("': ");
                            String string = e.getMessage();
                            if (string != null) {
                                throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                            }
                            string = "";
                            throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                        }
                        Double dictDuration = d9;
                        if (dictDuration == null) continue;
                        if (dictDuration <= 0.0) {
                            boolean bl14 = false;
                            System.out.println(lastTime);
                            double d15 = time2 + dictDuration;
                            bl12 = false;
                            System.out.println(d15);
                            boolean bl15 = false;
                            System.out.println(lastValue);
                            double d16 = time2 + dictDuration;
                            bl12 = false;
                            channel.add(Math.max(lastTime, d16), lastValue, Easing.Linear.getFunction(), hold);
                            channel.add(time2, value, function45, hold);
                            continue;
                        }
                        channel.add(time2, lastValue, Easing.Linear.getFunction(), hold);
                        channel.add(time2 + dictDuration, value, function45, hold);
                        continue;
                    }
                    try {
                        double d17;
                        V candidate = channelCandidate.getValue();
                        if (candidate instanceof Double) {
                            d17 = ((Number)candidate).doubleValue();
                        } else if (candidate instanceof String) {
                            Double d18 = ExpressionsKt.evaluateExpression((String)candidate, this.$expressionContext, this.$functions);
                            if (d18 == null) {
                                String string = "unknown value format for key '" + (String)channelCandidate.getKey() + "' : " + candidate;
                                boolean dictDuration = false;
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                            d17 = d18;
                        } else {
                            if (!(candidate instanceof Integer)) {
                                String string = "unknown value type for key '" + (String)channelCandidate.getKey() + "' : " + candidate;
                                boolean dictDuration = false;
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                            d17 = ((Number)candidate).intValue();
                        }
                        d6 = d17;
                    }
                    catch (ExpressionException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("error in ").append(path).append(".'").append((String)channelCandidate.getKey()).append("': ");
                        String string = e.getMessage();
                        if (string != null) {
                            throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                        }
                        string = "";
                        throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                    }
                    double value = d6;
                    channel.add(time2, value, function43, hold);
                }
                this.$lastTime.element = time2 + duration2;
                this.$expressionContext.put("t", this.$lastTime.element);
                if (!computed.containsKey("repeat")) return;
                V v = computed.get("repeat");
                if (!(v instanceof Map)) {
                    v = null;
                }
                Map map3 = (Map)v;
                if (map3 == null) {
                    String string = "'repeat' should be a map";
                    boolean channel = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Map repeatObject = map3;
                try {
                    int n;
                    V candidate32 = repeatObject.get("count");
                    if (candidate32 == null) {
                        n = 1;
                    } else if (candidate32 instanceof Integer) {
                        n = ((Number)candidate32).intValue();
                    } else if (candidate32 instanceof Double) {
                        n = (int)((Number)candidate32).doubleValue();
                    } else {
                        if (!(candidate32 instanceof String)) {
                            String lastValue = "unknown value type for count: '" + candidate32;
                            boolean bl16 = false;
                            throw (Throwable)new IllegalStateException(lastValue.toString());
                        }
                        Double d19 = ExpressionsKt.evaluateExpression((String)candidate32, this.$expressionContext, this.$functions);
                        if (d19 == null) {
                            String lastValue = "cannot evaluate expression for count: '" + candidate32 + '\'';
                            boolean bl17 = false;
                            throw (Throwable)new IllegalStateException(lastValue.toString());
                        }
                        n = MathKt.roundToInt(d19);
                    }
                    candidate32 = n;
                }
                catch (ExpressionException e) {
                    StringBuilder stringBuilder = new StringBuilder().append("error in ").append(path).append(".repeat.'count': ");
                    String string = e.getMessage();
                    if (string != null) {
                        throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                    }
                    string = "";
                    throw (Throwable)new ExpressionException(stringBuilder.append(string).toString());
                }
                int count2 = candidate32;
                V v3 = repeatObject.get("keys");
                if (!(v3 instanceof List)) {
                    v3 = null;
                }
                List list = (List)v3;
                if (list == null) {
                    String e = "no repeat keys";
                    boolean bl18 = false;
                    throw (Throwable)new IllegalStateException(e.toString());
                }
                List repeatKeys = list;
                int e = 0;
                int n = count2;
                while (e < n) {
                    void i;
                    this.$expressionContext.put("rep", (double)i);
                    for (Map repeatKey : repeatKeys) {
                        this.invoke(repeatKey, path + ".repeat");
                    }
                    ++i;
                }
            }
            {
                this.this$0 = keyframer;
                this.$lastTime = doubleRef;
                this.$expressionContext = map2;
                this.$functions = functionExtensions;
                this.$channelKeys = set;
                super(2);
            }
        };
        boolean destination$iv$iv22 = false;
        for (Map key : (Iterable)keys2) {
            void index;
            $fun$handleKey$2.invoke((Map<String, Object>)((Map<String, ? extends Object>)key), "keys[" + (int)index + ']');
            ++index;
        }
    }

    public Keyframer() {
        boolean bl = false;
        this.channels = new LinkedHashMap();
        bl = false;
        this.parameters = new LinkedHashMap();
        bl = false;
        this.prototypes = new LinkedHashMap();
    }

    public static final /* synthetic */ void access$setCurrentTime$p(Keyframer $this, double d) {
        $this.currentTime = d;
    }

    public static final /* synthetic */ Map access$resolvePrototype(Keyframer $this, String prototypeNames) {
        return $this.resolvePrototype(prototypeNames);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/extra/keyframer/Keyframer$CompoundChannel;", "", "keys", "", "", "defaultValues", "", "(Lorg/openrndr/extra/keyframer/Keyframer;[Ljava/lang/String;[Ljava/lang/Double;)V", "cachedValues", "[Ljava/lang/Double;", "channelTimes", "compoundChannels", "Lorg/openrndr/extra/keyframer/KeyframerChannel;", "[Lorg/openrndr/extra/keyframer/KeyframerChannel;", "getKeys", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getValue", "compound", "", "reset", "", "orx-keyframer"})
    public class CompoundChannel {
        private Double[] channelTimes;
        private KeyframerChannel[] compoundChannels;
        private Double[] cachedValues;
        @NotNull
        private final String[] keys;
        private final Double[] defaultValues;

        /*
         * WARNING - void declaration
         */
        public void reset() {
            int n = 0;
            int n2 = this.channelTimes.length;
            while (n < n2) {
                void i;
                this.channelTimes[i] = Double.NEGATIVE_INFINITY;
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final double getValue(int compound) {
            double d;
            if (this.compoundChannels[compound] == null) {
                this.compoundChannels[compound] = Keyframer.this.getChannels().get(this.keys[compound]);
            }
            if (this.compoundChannels[compound] != null) {
                if (this.channelTimes[compound] == Keyframer.this.currentTime && this.cachedValues[compound] != null) {
                    Double d2 = this.cachedValues[compound];
                    d = d2 != null ? d2.doubleValue() : this.defaultValues[compound].doubleValue();
                } else {
                    void var2_2;
                    Object object = this.compoundChannels[compound];
                    double value = object != null && (object = ((KeyframerChannel)object).value(Keyframer.this.currentTime)) != null ? ((Double)object).doubleValue() : this.defaultValues[compound].doubleValue();
                    this.cachedValues[compound] = value;
                    d = var2_2;
                }
            } else {
                d = this.defaultValues[compound];
            }
            return d;
        }

        @NotNull
        public final String[] getKeys() {
            return this.keys;
        }

        public CompoundChannel(@NotNull String[] keys2, Double[] defaultValues) {
            int it;
            Double d;
            Object[] objectArray;
            int n;
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Intrinsics.checkNotNullParameter(defaultValues, "defaultValues");
            this.keys = keys2;
            this.defaultValues = defaultValues;
            int n2 = this.keys.length;
            CompoundChannel compoundChannel = this;
            Object[] objectArray2 = new Double[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3;
                n = n3++;
                objectArray = objectArray2;
                boolean bl = false;
                objectArray[n] = d = Double.valueOf(Double.NEGATIVE_INFINITY);
            }
            objectArray = objectArray2;
            compoundChannel.channelTimes = objectArray;
            n2 = this.keys.length;
            compoundChannel = this;
            objectArray2 = new KeyframerChannel[n2];
            n3 = 0;
            while (n3 < n2) {
                it = n3;
                n = n3++;
                objectArray = objectArray2;
                boolean bl = false;
                d = null;
                objectArray[n] = d;
            }
            objectArray = objectArray2;
            compoundChannel.compoundChannels = objectArray;
            n2 = this.keys.length;
            compoundChannel = this;
            objectArray2 = new Double[n2];
            n3 = 0;
            while (n3 < n2) {
                it = n3;
                n = n3++;
                objectArray = objectArray2;
                boolean bl = false;
                d = null;
                objectArray[n] = d;
            }
            objectArray = objectArray2;
            compoundChannel.cachedValues = objectArray;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0086\u0002\u00a8\u0006\f"}, d2={"Lorg/openrndr/extra/keyframer/Keyframer$DoubleChannel;", "Lorg/openrndr/extra/keyframer/Keyframer$CompoundChannel;", "Lorg/openrndr/extra/keyframer/Keyframer;", "key", "", "defaultValue", "", "(Lorg/openrndr/extra/keyframer/Keyframer;Ljava/lang/String;D)V", "getValue", "keyframer", "property", "Lkotlin/reflect/KProperty;", "orx-keyframer"})
    public final class DoubleChannel
    extends CompoundChannel {
        final /* synthetic */ Keyframer this$0;

        public final double getValue(@NotNull Keyframer keyframer, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(keyframer, "keyframer");
            Intrinsics.checkNotNullParameter(property, "property");
            return this.getValue(0);
        }

        public DoubleChannel(@NotNull Keyframer this$0, String key, double defaultValue) {
            Intrinsics.checkNotNullParameter(key, "key");
            this.this$0 = this$0;
            super(new String[]{key}, new Double[]{defaultValue});
        }

        public /* synthetic */ DoubleChannel(Keyframer keyframer, String string, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                d = 0.0;
            }
            this(keyframer, string, d);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0086\u0002\u00a8\u0006\r"}, d2={"Lorg/openrndr/extra/keyframer/Keyframer$Vector2Channel;", "Lorg/openrndr/extra/keyframer/Keyframer$CompoundChannel;", "Lorg/openrndr/extra/keyframer/Keyframer;", "keys", "", "", "defaultValue", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/extra/keyframer/Keyframer;[Ljava/lang/String;Lorg/openrndr/math/Vector2;)V", "getValue", "keyframer", "property", "Lkotlin/reflect/KProperty;", "orx-keyframer"})
    public final class Vector2Channel
    extends CompoundChannel {
        final /* synthetic */ Keyframer this$0;

        @NotNull
        public final Vector2 getValue(@NotNull Keyframer keyframer, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(keyframer, "keyframer");
            Intrinsics.checkNotNullParameter(property, "property");
            return new Vector2(this.getValue(0), this.getValue(1));
        }

        public Vector2Channel(@NotNull Keyframer this$0, @NotNull String[] keys2, Vector2 defaultValue) {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
            this.this$0 = this$0;
            super(keys2, new Double[]{defaultValue.getX(), defaultValue.getY()});
        }

        public /* synthetic */ Vector2Channel(Keyframer keyframer, String[] stringArray, Vector2 vector2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                vector2 = Vector2.Companion.getZERO();
            }
            this(keyframer, stringArray, vector2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0086\u0002\u00a8\u0006\r"}, d2={"Lorg/openrndr/extra/keyframer/Keyframer$Vector3Channel;", "Lorg/openrndr/extra/keyframer/Keyframer$CompoundChannel;", "Lorg/openrndr/extra/keyframer/Keyframer;", "keys", "", "", "defaultValue", "Lorg/openrndr/math/Vector3;", "(Lorg/openrndr/extra/keyframer/Keyframer;[Ljava/lang/String;Lorg/openrndr/math/Vector3;)V", "getValue", "keyframer", "property", "Lkotlin/reflect/KProperty;", "orx-keyframer"})
    public final class Vector3Channel
    extends CompoundChannel {
        final /* synthetic */ Keyframer this$0;

        @NotNull
        public final Vector3 getValue(@NotNull Keyframer keyframer, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(keyframer, "keyframer");
            Intrinsics.checkNotNullParameter(property, "property");
            return new Vector3(this.getValue(0), this.getValue(1), this.getValue(2));
        }

        public Vector3Channel(@NotNull Keyframer this$0, @NotNull String[] keys2, Vector3 defaultValue) {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
            this.this$0 = this$0;
            super(keys2, new Double[]{defaultValue.getX(), defaultValue.getY(), defaultValue.getZ()});
        }

        public /* synthetic */ Vector3Channel(Keyframer keyframer, String[] stringArray, Vector3 vector3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                vector3 = Vector3.Companion.getZERO();
            }
            this(keyframer, stringArray, vector3);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0086\u0002\u00a8\u0006\r"}, d2={"Lorg/openrndr/extra/keyframer/Keyframer$Vector4Channel;", "Lorg/openrndr/extra/keyframer/Keyframer$CompoundChannel;", "Lorg/openrndr/extra/keyframer/Keyframer;", "keys", "", "", "defaultValue", "Lorg/openrndr/math/Vector4;", "(Lorg/openrndr/extra/keyframer/Keyframer;[Ljava/lang/String;Lorg/openrndr/math/Vector4;)V", "getValue", "keyframer", "property", "Lkotlin/reflect/KProperty;", "orx-keyframer"})
    public final class Vector4Channel
    extends CompoundChannel {
        final /* synthetic */ Keyframer this$0;

        @NotNull
        public final Vector4 getValue(@NotNull Keyframer keyframer, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(keyframer, "keyframer");
            Intrinsics.checkNotNullParameter(property, "property");
            return new Vector4(this.getValue(0), this.getValue(1), this.getValue(2), this.getValue(3));
        }

        public Vector4Channel(@NotNull Keyframer this$0, @NotNull String[] keys2, Vector4 defaultValue) {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
            this.this$0 = this$0;
            super(keys2, new Double[]{defaultValue.getX(), defaultValue.getY(), defaultValue.getZ(), defaultValue.getW()});
        }

        public /* synthetic */ Vector4Channel(Keyframer keyframer, String[] stringArray, Vector4 vector4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                vector4 = Vector4.Companion.getZERO();
            }
            this(keyframer, stringArray, vector4);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0086\u0002\u00a8\u0006\r"}, d2={"Lorg/openrndr/extra/keyframer/Keyframer$RGBaChannel;", "Lorg/openrndr/extra/keyframer/Keyframer$CompoundChannel;", "Lorg/openrndr/extra/keyframer/Keyframer;", "keys", "", "", "defaultValue", "Lorg/openrndr/color/ColorRGBa;", "(Lorg/openrndr/extra/keyframer/Keyframer;[Ljava/lang/String;Lorg/openrndr/color/ColorRGBa;)V", "getValue", "keyframer", "property", "Lkotlin/reflect/KProperty;", "orx-keyframer"})
    public final class RGBaChannel
    extends CompoundChannel {
        final /* synthetic */ Keyframer this$0;

        @NotNull
        public final ColorRGBa getValue(@NotNull Keyframer keyframer, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(keyframer, "keyframer");
            Intrinsics.checkNotNullParameter(property, "property");
            return new ColorRGBa(this.getValue(0), this.getValue(1), this.getValue(2), this.getValue(3), null, 16, null);
        }

        public RGBaChannel(@NotNull Keyframer this$0, @NotNull String[] keys2, ColorRGBa defaultValue) {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
            this.this$0 = this$0;
            super(keys2, new Double[]{defaultValue.getR(), defaultValue.getG(), defaultValue.getB(), defaultValue.getA()});
        }

        public /* synthetic */ RGBaChannel(Keyframer keyframer, String[] stringArray, ColorRGBa colorRGBa, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                colorRGBa = ColorRGBa.Companion.getWHITE();
            }
            this(keyframer, stringArray, colorRGBa);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0086\u0002\u00a8\u0006\r"}, d2={"Lorg/openrndr/extra/keyframer/Keyframer$RGBChannel;", "Lorg/openrndr/extra/keyframer/Keyframer$CompoundChannel;", "Lorg/openrndr/extra/keyframer/Keyframer;", "keys", "", "", "defaultValue", "Lorg/openrndr/color/ColorRGBa;", "(Lorg/openrndr/extra/keyframer/Keyframer;[Ljava/lang/String;Lorg/openrndr/color/ColorRGBa;)V", "getValue", "keyframer", "property", "Lkotlin/reflect/KProperty;", "orx-keyframer"})
    public final class RGBChannel
    extends CompoundChannel {
        final /* synthetic */ Keyframer this$0;

        @NotNull
        public final ColorRGBa getValue(@NotNull Keyframer keyframer, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(keyframer, "keyframer");
            Intrinsics.checkNotNullParameter(property, "property");
            return new ColorRGBa(this.getValue(0), this.getValue(1), this.getValue(2), 0.0, null, 24, null);
        }

        public RGBChannel(@NotNull Keyframer this$0, @NotNull String[] keys2, ColorRGBa defaultValue) {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
            this.this$0 = this$0;
            super(keys2, new Double[]{defaultValue.getR(), defaultValue.getG(), defaultValue.getB()});
        }

        public /* synthetic */ RGBChannel(Keyframer keyframer, String[] stringArray, ColorRGBa colorRGBa, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                colorRGBa = ColorRGBa.Companion.getWHITE();
            }
            this(keyframer, stringArray, colorRGBa);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0086\u0002\u00a8\u0006\r"}, d2={"Lorg/openrndr/extra/keyframer/Keyframer$DoubleArrayChannel;", "Lorg/openrndr/extra/keyframer/Keyframer$CompoundChannel;", "Lorg/openrndr/extra/keyframer/Keyframer;", "keys", "", "", "defaultValue", "", "(Lorg/openrndr/extra/keyframer/Keyframer;[Ljava/lang/String;[D)V", "getValue", "keyframer", "property", "Lkotlin/reflect/KProperty;", "orx-keyframer"})
    public final class DoubleArrayChannel
    extends CompoundChannel {
        final /* synthetic */ Keyframer this$0;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final double[] getValue(@NotNull Keyframer keyframer, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(keyframer, "keyframer");
            Intrinsics.checkNotNullParameter(property, "property");
            double[] result2 = new double[this.getKeys().length];
            int n = 0;
            int n2 = this.getKeys().length;
            while (n < n2) {
                void i;
                result2[i] = this.getValue((int)i);
                ++i;
            }
            return result2;
        }

        public DoubleArrayChannel(@NotNull Keyframer this$0, @NotNull String[] keys2, double[] defaultValue) {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
            this.this$0 = this$0;
            super(keys2, ArraysKt.toTypedArray(defaultValue));
        }

        public /* synthetic */ DoubleArrayChannel(Keyframer keyframer, String[] stringArray, double[] dArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                dArray = new double[stringArray.length];
            }
            this(keyframer, stringArray, dArray);
        }
    }
}

