/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extras.imageFit;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Drawer;
import org.openrndr.extras.imageFit.FitMethod;
import org.openrndr.extras.imageFit.ImageFitKt$WhenMappings;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a@\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u001ad\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\u0012"}, d2={"fitRectangle", "Lkotlin/Pair;", "Lorg/openrndr/shape/Rectangle;", "src", "dest", "horizontalPosition", "", "verticalPosition", "fitMethod", "Lorg/openrndr/extras/imageFit/FitMethod;", "imageFit", "Lorg/openrndr/draw/Drawer;", "img", "Lorg/openrndr/draw/ColorBuffer;", "x", "y", "width", "height", "orx-image-fit"})
public final class ImageFitKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Rectangle, Rectangle> fitRectangle(@NotNull Rectangle src, @NotNull Rectangle dest, double horizontalPosition, double verticalPosition, @NotNull FitMethod fitMethod) {
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(dest, "dest");
        Intrinsics.checkNotNullParameter((Object)fitMethod, "fitMethod");
        double sourceWidth = src.getWidth();
        double sourceHeight = src.getHeight();
        double targetX = 0.0;
        double targetY = 0.0;
        double targetWidth = 0.0;
        double targetHeight = 0.0;
        Rectangle source = null;
        Rectangle target2 = null;
        Vector2 vector2 = dest.getCorner();
        double d = vector2.component1();
        double y = vector2.component2();
        double width = dest.getWidth();
        double height = dest.getHeight();
        switch (ImageFitKt$WhenMappings.$EnumSwitchMapping$0[fitMethod.ordinal()]) {
            case 1: {
                void x;
                targetWidth = width;
                targetHeight = height;
                if (width <= targetWidth) {
                    targetWidth = width;
                    targetHeight = sourceHeight / sourceWidth * width;
                }
                if (height <= targetHeight) {
                    targetHeight = height;
                    targetWidth = sourceWidth / sourceHeight * height;
                }
                void left = x;
                void right = x + width - targetWidth;
                double top = y;
                double bottom = y + height - targetHeight;
                targetX = MappingKt.map$default(-1.0, 1.0, (double)left, (double)right, horizontalPosition, false, 32, null);
                targetY = MappingKt.map$default(-1.0, 1.0, top, bottom, verticalPosition, false, 32, null);
                source = new Rectangle(0.0, 0.0, sourceWidth, sourceHeight);
                target2 = new Rectangle(targetX, targetY, targetWidth, targetHeight);
                break;
            }
            case 2: {
                void x;
                targetWidth = sourceWidth;
                targetHeight = sourceHeight;
                if (sourceWidth <= targetWidth) {
                    targetWidth = sourceWidth;
                    targetHeight = height / width * sourceWidth;
                }
                if (sourceHeight <= targetHeight) {
                    targetHeight = sourceHeight;
                    targetWidth = width / height * sourceHeight;
                }
                double left = 0.0;
                double right = sourceWidth - targetWidth;
                double top = 0.0;
                double bottom = sourceHeight - targetHeight;
                targetX = MappingKt.map$default(-1.0, 1.0, left, right, horizontalPosition, false, 32, null);
                targetY = MappingKt.map$default(-1.0, 1.0, top, bottom, verticalPosition, false, 32, null);
                source = new Rectangle(targetX, targetY, targetWidth, targetHeight);
                target2 = new Rectangle((double)x, y, width, height);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new Pair<Rectangle, Rectangle>(source, target2);
    }

    public static /* synthetic */ Pair fitRectangle$default(Rectangle rectangle, Rectangle rectangle2, double d, double d2, FitMethod fitMethod, int n, Object object) {
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x10) != 0) {
            fitMethod = FitMethod.Cover;
        }
        return ImageFitKt.fitRectangle(rectangle, rectangle2, d, d2, fitMethod);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Rectangle, Rectangle> imageFit(@NotNull Drawer $this$imageFit, @NotNull ColorBuffer img, double x, double y, double width, double height, double horizontalPosition, double verticalPosition, @NotNull FitMethod fitMethod) {
        void source;
        Intrinsics.checkNotNullParameter($this$imageFit, "$this$imageFit");
        Intrinsics.checkNotNullParameter(img, "img");
        Intrinsics.checkNotNullParameter((Object)fitMethod, "fitMethod");
        Pair<Rectangle, Rectangle> pair = ImageFitKt.fitRectangle(img.getBounds(), new Rectangle(x, y, width, height), horizontalPosition, verticalPosition, fitMethod);
        Rectangle rectangle = pair.component1();
        Rectangle target2 = pair.component2();
        $this$imageFit.image(img, (Rectangle)source, target2);
        return new Pair<void, Rectangle>(source, target2);
    }

    public static /* synthetic */ Pair imageFit$default(Drawer drawer, ColorBuffer colorBuffer, double d, double d2, double d3, double d4, double d5, double d6, FitMethod fitMethod, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = colorBuffer.getWidth();
        }
        if ((n & 0x10) != 0) {
            d4 = colorBuffer.getHeight();
        }
        if ((n & 0x20) != 0) {
            d5 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d6 = 0.0;
        }
        if ((n & 0x80) != 0) {
            fitMethod = FitMethod.Cover;
        }
        return ImageFitKt.imageFit(drawer, colorBuffer, d, d2, d3, d4, d5, d6, fitMethod);
    }
}

