/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.draw.KernMode;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J2\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001cJ\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J8\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0004H\u0002J:\u0010(\u001a\u00020\u00102\u0006\u0010!\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010*\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/openrndr/internal/FontImageMapDrawer;", "", "()V", "maxQuads", "", "quads", "queuedInstances", "getQueuedInstances", "()I", "setQueuedInstances", "(I)V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "drawText", "", "context", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "text", "", "x", "", "y", "drawTexts", "texts", "", "positions", "Lorg/openrndr/math/Vector2;", "flush", "insertCharacterQuad", "fontMap", "Lorg/openrndr/draw/FontImageMap;", "bw", "Lorg/openrndr/draw/BufferWriter;", "character", "", "instance", "queueText", "Lorg/openrndr/draw/FontMap;", "tracking", "kerning", "Lorg/openrndr/draw/KernMode;", "openrndr-core"})
public final class FontImageMapDrawer {
    private final ShadeStyleManager shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "font-image-map", new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

        @NotNull
        public final String invoke(@NotNull ShadeStructure p1) {
            Intrinsics.checkNotNullParameter(p1, "p1");
            return ((ShaderGenerators)this.receiver).fontImageMapVertexShader(p1);
        }
    }, null, null, null, new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

        @NotNull
        public final String invoke(@NotNull ShadeStructure p1) {
            Intrinsics.checkNotNullParameter(p1, "p1");
            return ((ShaderGenerators)this.receiver).fontImageMapFragmentShader(p1);
        }
    }, 28, null);
    private final int maxQuads;
    private final VertexBuffer vertices;
    private int quads;
    private int queuedInstances;

    public final void drawText(@NotNull DrawContext context, @NotNull DrawStyle drawStyle, @NotNull String text2, double x, double y) {
        block4: {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
            Intrinsics.checkNotNullParameter(text2, "text");
            FontMap fontMap = drawStyle.getFontMap();
            if (!(fontMap instanceof FontImageMap)) {
                fontMap = null;
            }
            FontImageMap fontImageMap = (FontImageMap)fontMap;
            if (fontImageMap == null) break block4;
            FontImageMap fontImageMap2 = fontImageMap;
            boolean bl = false;
            boolean bl2 = false;
            FontImageMap fontMap2 = fontImageMap2;
            boolean bl3 = false;
            double cursorX = 0.0;
            double cursorY = 0.0;
            BufferWriter bw = this.vertices.getShadow().writer();
            bw.setPosition(this.vertices.getVertexFormat().getSize() * this.quads * 6);
            Character lastChar = null;
            CharSequence $this$forEach$iv = text2;
            boolean $i$f$forEach = false;
            CharSequence charSequence = $this$forEach$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                GlyphMetrics metrics;
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl4 = false;
                Character lc = lastChar;
                GlyphMetrics glyphMetrics = fontMap2.getGlyphMetrics().get(Character.valueOf(it));
                if (glyphMetrics == null) {
                    glyphMetrics = metrics = MapsKt.getValue(fontMap2.getGlyphMetrics(), Character.valueOf(' '));
                }
                if (drawStyle.getKerning() == KernMode.METRIC) {
                    cursorX += lc != null ? fontMap2.kerning(lc.charValue(), it) : 0.0;
                }
                this.insertCharacterQuad(fontMap2, bw, it, x + cursorX + metrics.getLeftSideBearing(), y + cursorY + metrics.getYBitmapShift() / fontMap2.getContentScale(), 0);
                cursorX += metrics.getAdvanceWidth();
                lastChar = Character.valueOf(it);
            }
            this.flush(context, drawStyle);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drawTexts(@NotNull DrawContext context, @NotNull DrawStyle drawStyle, @NotNull List<String> texts, @NotNull List<Vector2> positions) {
        block5: {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
            Intrinsics.checkNotNullParameter(texts, "texts");
            Intrinsics.checkNotNullParameter(positions, "positions");
            FontMap fontMap = drawStyle.getFontMap();
            if (!(fontMap instanceof FontImageMap)) {
                fontMap = null;
            }
            FontImageMap fontImageMap = (FontImageMap)fontMap;
            if (fontImageMap == null) break block5;
            FontImageMap fontImageMap2 = fontImageMap;
            boolean bl = false;
            boolean bl2 = false;
            FontImageMap fontMap2 = fontImageMap2;
            boolean bl3 = false;
            int instance = 0;
            for (Pair pair : CollectionsKt.zip((Iterable)texts, (Iterable)positions)) {
                void text2;
                String string = (String)pair.component1();
                Vector2 position = (Vector2)pair.component2();
                double cursorX = 0.0;
                double cursorY = 0.0;
                BufferWriter bw = this.vertices.getShadow().writer();
                bw.setPosition(this.vertices.getVertexFormat().getSize() * this.quads * 6);
                Character lastChar = null;
                CharSequence $this$forEach$iv = (CharSequence)text2;
                boolean $i$f$forEach = false;
                CharSequence charSequence = $this$forEach$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    GlyphMetrics glyphMetrics;
                    char element$iv;
                    char it = element$iv = charSequence.charAt(i);
                    boolean bl4 = false;
                    Character lc = lastChar;
                    if (drawStyle.getKerning() == KernMode.METRIC) {
                        cursorX += lc != null ? fontMap2.kerning(lc.charValue(), it) : 0.0;
                    }
                    if ((glyphMetrics = fontMap2.getGlyphMetrics().get(Character.valueOf(it))) == null) {
                        glyphMetrics = MapsKt.getValue(fontMap2.getGlyphMetrics(), Character.valueOf(' '));
                    }
                    GlyphMetrics metrics = glyphMetrics;
                    this.insertCharacterQuad(fontMap2, bw, it, position.getX() + cursorX + metrics.getXBitmapShift() / fontMap2.getContentScale(), position.getY() + cursorY + metrics.getYBitmapShift() / fontMap2.getContentScale(), instance);
                    cursorX += metrics.getAdvanceWidth();
                    lastChar = Character.valueOf(it);
                }
                int n = instance;
                instance = n + 1;
            }
            this.flush(context, drawStyle);
        }
    }

    public final int getQueuedInstances() {
        return this.queuedInstances;
    }

    public final void setQueuedInstances(int n) {
        this.queuedInstances = n;
    }

    public final void queueText(@NotNull FontMap fontMap, @NotNull String text2, double x, double y, double tracking, @NotNull KernMode kerning) {
        Intrinsics.checkNotNullParameter(fontMap, "fontMap");
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter((Object)kerning, "kerning");
        BufferWriter bw = this.vertices.getShadow().writer();
        bw.setPosition(this.vertices.getVertexFormat().getSize() * this.quads * 6);
        FontImageMap cfr_ignored_0 = (FontImageMap)fontMap;
        double cursorX = 0.0;
        double cursorY = 0.0;
        Character lastChar = null;
        CharSequence $this$forEach$iv = text2;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            GlyphMetrics glyphMetrics;
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            boolean bl = false;
            Character lc = lastChar;
            GlyphMetrics metrics = ((FontImageMap)fontMap).getGlyphMetrics().get(Character.valueOf(it));
            if (metrics == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            GlyphMetrics m = glyphMetrics;
            boolean bl4 = false;
            if (kerning == KernMode.METRIC) {
                cursorX += lc != null ? ((FontImageMap)fontMap).kerning(lc.charValue(), it) : 0.0;
            }
            this.insertCharacterQuad((FontImageMap)fontMap, bw, it, x + cursorX + m.getLeftSideBearing() / ((FontImageMap)fontMap).getContentScale(), y + cursorY + m.getYBitmapShift() / ((FontImageMap)fontMap).getContentScale(), this.queuedInstances);
            cursorX += m.getAdvanceWidth() + tracking;
            lastChar = Character.valueOf(it);
        }
        int n = this.queuedInstances;
        this.queuedInstances = n + 1;
    }

    public static /* synthetic */ void queueText$default(FontImageMapDrawer fontImageMapDrawer, FontMap fontMap, String string, double d, double d2, double d3, KernMode kernMode, int n, Object object) {
        if ((n & 0x10) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x20) != 0) {
            kernMode = KernMode.METRIC;
        }
        fontImageMapDrawer.queueText(fontMap, string, d, d2, d3, kernMode);
    }

    public final void flush(@NotNull DrawContext context, @NotNull DrawStyle drawStyle) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        if (this.quads > 0) {
            this.vertices.getShadow().uploadElements(0, this.quads * 6);
            Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
            shader2.begin();
            context.applyToShader(shader2);
            Driver.Companion.getInstance().setState(drawStyle);
            drawStyle.applyToShader(shader2);
            FontMap fontMap = drawStyle.getFontMap();
            if (fontMap == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            }
            ((FontImageMap)fontMap).getTexture().bind(0);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.TRIANGLES, 0, this.quads * 6);
            shader2.end();
            this.quads = 0;
        }
        this.queuedInstances = 0;
    }

    private final void insertCharacterQuad(FontImageMap fontMap, BufferWriter bw, char character, double x, double y, int instance) {
        IntRectangle rectangle;
        IntRectangle intRectangle = fontMap.getMap().get(Character.valueOf(character));
        if (intRectangle == null) {
            intRectangle = rectangle = fontMap.getMap().get(Character.valueOf(' '));
        }
        if (rectangle != null) {
            float pad = 1.0f;
            float u0 = ((float)rectangle.getX() - pad) / (float)fontMap.getTexture().getWidth();
            float u1 = u0 + (1.0f + pad * (float)2 + (float)rectangle.getWidth()) / (float)fontMap.getTexture().getWidth();
            float v0 = ((float)rectangle.getY() - pad) / (float)fontMap.getTexture().getHeight();
            float v1 = v0 + (1.0f + pad * (float)2 + (float)rectangle.getHeight()) / (float)fontMap.getTexture().getHeight();
            float x0 = (float)x - pad;
            float x1 = x0 + (float)rectangle.getWidth() / (float)fontMap.getContentScale() + pad * (float)2;
            float y0 = (float)y - pad;
            float y1 = y0 + (float)rectangle.getHeight() / (float)fontMap.getContentScale() + pad * (float)2;
            float s0 = 0.0f;
            float t0 = 0.0f;
            float s1 = 1.0f;
            float t1 = 1.0f;
            float w = x1 - x0;
            float h = y1 - y0;
            float z = this.quads;
            float floatInstance = instance;
            if (this.quads < this.maxQuads) {
                BufferWriter bufferWriter = bw;
                boolean bl = false;
                boolean bl2 = false;
                BufferWriter $this$apply = bufferWriter;
                boolean bl3 = false;
                $this$apply.write(u0, v0);
                $this$apply.write(s0, t0, w, h);
                $this$apply.write(x0, y0, z);
                $this$apply.write(floatInstance);
                $this$apply.write(u1, v0);
                $this$apply.write(s1, t0, w, h);
                $this$apply.write(x1, y0, z);
                $this$apply.write(floatInstance);
                $this$apply.write(u1, v1);
                $this$apply.write(s1, t1, w, h);
                $this$apply.write(x1, y1, z);
                $this$apply.write(floatInstance);
                $this$apply.write(u0, v0);
                $this$apply.write(s0, t0, w, h);
                $this$apply.write(x0, y0, z);
                $this$apply.write(floatInstance);
                $this$apply.write(u0, v1);
                $this$apply.write(s0, t1, w, h);
                $this$apply.write(x0, y1, z);
                $this$apply.write(floatInstance);
                $this$apply.write(u1, v1);
                $this$apply.write(s1, t1, w, h);
                $this$apply.write(x1, y1, z);
                $this$apply.write(floatInstance);
                int n = this.quads;
                this.quads = n + 1;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public FontImageMapDrawer() {
        void $this$apply;
        this.maxQuads = 20000;
        VertexFormat vertexFormat2 = new VertexFormat();
        boolean bl = false;
        boolean bl2 = false;
        VertexFormat vertexFormat3 = vertexFormat2;
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        FontImageMapDrawer fontImageMapDrawer = this;
        boolean bl3 = false;
        VertexFormat.textureCoordinate$default((VertexFormat)$this$apply, 2, 0, 2, null);
        VertexFormat.attribute$default((VertexFormat)$this$apply, "bounds", VertexElementType.VECTOR4_FLOAT32, 0, 4, null);
        $this$apply.position(3);
        VertexFormat.attribute$default((VertexFormat)$this$apply, "instance", VertexElementType.FLOAT32, 0, 4, null);
        Unit unit = Unit.INSTANCE;
        fontImageMapDrawer.vertices = VertexBuffer.Companion.createDynamic$default(companion, vertexFormat2, 6 * this.maxQuads, null, 4, null);
    }
}

