/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorEnterCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowCloseCallbackI;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.system.MemoryStack;
import org.openrndr.Application;
import org.openrndr.Configuration;
import org.openrndr.CursorType;
import org.openrndr.DropEvent;
import org.openrndr.Extension;
import org.openrndr.Fullscreen;
import org.openrndr.KeyEvent;
import org.openrndr.KeyEventType;
import org.openrndr.KeyModifier;
import org.openrndr.MouseButton;
import org.openrndr.MouseEvent;
import org.openrndr.MouseEventType;
import org.openrndr.PresentationMode;
import org.openrndr.Program;
import org.openrndr.ProgramEvent;
import org.openrndr.ProgramEventType;
import org.openrndr.UnfocusBehaviour;
import org.openrndr.WindowEvent;
import org.openrndr.WindowEventType;
import org.openrndr.WindowMultisample;
import org.openrndr.animatable.Animatable;
import org.openrndr.animatable.Clock;
import org.openrndr.draw.Drawer;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ApplicationGLFWGL3;
import org.openrndr.internal.gl3.ApplicationGLFWGL3$WhenMappings;
import org.openrndr.internal.gl3.ApplicationGLFWGL3Kt;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.ProgramRenderTargetGL3;
import org.openrndr.math.IntVector2;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010D\u001a\u00020EH\u0002J\b\u0010F\u001a\u00020EH\u0002J\n\u0010G\u001a\u0004\u0018\u00010HH\u0002J\b\u0010I\u001a\u00020EH\u0016J\b\u0010J\u001a\u00020EH\u0016J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020M0L2\u0006\u0010N\u001a\u00020OH\u0002J\u0006\u0010P\u001a\u00020EJ\b\u0010Q\u001a\u00020EH\u0016J\b\u0010R\u001a\u00020EH\u0016J\b\u0010S\u001a\u00020EH\u0016J\b\u0010T\u001a\u00020EH\u0002R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020!@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020+X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010;\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010\u0019\"\u0004\b=\u0010\u001bR$\u0010>\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010\u0019\"\u0004\b@\u0010\u001bR$\u0010A\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010\u000b\"\u0004\bC\u0010\r\u00a8\u0006U"}, d2={"Lorg/openrndr/internal/gl3/ApplicationGLFWGL3;", "Lorg/openrndr/Application;", "program", "Lorg/openrndr/Program;", "configuration", "Lorg/openrndr/Configuration;", "(Lorg/openrndr/Program;Lorg/openrndr/Configuration;)V", "value", "", "clipboardContents", "getClipboardContents", "()Ljava/lang/String;", "setClipboardContents", "(Ljava/lang/String;)V", "cursorCache", "", "Lorg/openrndr/CursorType;", "", "getCursorCache", "()Ljava/util/Map;", "cursorCache$delegate", "Lkotlin/Lazy;", "Lorg/openrndr/math/Vector2;", "cursorPosition", "getCursorPosition", "()Lorg/openrndr/math/Vector2;", "setCursorPosition", "(Lorg/openrndr/math/Vector2;)V", "cursorType", "getCursorType", "()Lorg/openrndr/CursorType;", "setCursorType", "(Lorg/openrndr/CursorType;)V", "", "cursorVisible", "getCursorVisible", "()Z", "setCursorVisible", "(Z)V", "drawRequested", "exitRequested", "fixWindowSize", "presentationMode", "Lorg/openrndr/PresentationMode;", "getPresentationMode", "()Lorg/openrndr/PresentationMode;", "setPresentationMode", "(Lorg/openrndr/PresentationMode;)V", "realCursorPosition", "realWindowTitle", "seconds", "", "getSeconds", "()D", "setupCalled", "vaos", "", "window", "windowFocused", "windowPosition", "getWindowPosition", "setWindowPosition", "windowSize", "getWindowSize", "setWindowSize", "windowTitle", "getWindowTitle", "setWindowTitle", "createPrimaryWindow", "", "deliverEvents", "drawFrame", "", "exit", "loop", "modifierSet", "", "Lorg/openrndr/KeyModifier;", "mods", "", "preloop", "requestDraw", "requestFocus", "setup", "setupSizes", "openrndr-gl3"})
public final class ApplicationGLFWGL3
extends Application {
    private boolean windowFocused;
    private long window;
    private String realWindowTitle;
    private boolean exitRequested;
    private final boolean fixWindowSize;
    private boolean setupCalled;
    @NotNull
    private PresentationMode presentationMode;
    private Vector2 realCursorPosition;
    private boolean cursorVisible;
    private final Lazy cursorCache$delegate;
    @NotNull
    private CursorType cursorType;
    private final int[] vaos;
    private boolean drawRequested;
    private final Program program;
    private final Configuration configuration;

    @Override
    @NotNull
    public PresentationMode getPresentationMode() {
        return this.presentationMode;
    }

    @Override
    public void setPresentationMode(@NotNull PresentationMode presentationMode) {
        Intrinsics.checkNotNullParameter((Object)presentationMode, "<set-?>");
        this.presentationMode = presentationMode;
    }

    @Override
    @NotNull
    public Vector2 getCursorPosition() {
        return this.realCursorPosition;
    }

    @Override
    public void setCursorPosition(@NotNull Vector2 value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.realCursorPosition = value;
        GLFW.glfwSetCursorPos(this.window, value.getX(), value.getY());
    }

    @Override
    public boolean getCursorVisible() {
        return this.cursorVisible;
    }

    @Override
    public void setCursorVisible(boolean value) {
        this.cursorVisible = value;
        if (value) {
            GLFW.glfwSetInputMode(this.window, 208897, 212993);
        } else {
            GLFW.glfwSetInputMode(this.window, 208897, 212994);
        }
    }

    private final Map<CursorType, Long> getCursorCache() {
        Lazy lazy = this.cursorCache$delegate;
        ApplicationGLFWGL3 applicationGLFWGL3 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public CursorType getCursorType() {
        return this.cursorType;
    }

    @Override
    public void setCursorType(@NotNull CursorType value) {
        Intrinsics.checkNotNullParameter((Object)value, "value");
        if (value != this.cursorType) {
            Long l;
            Map<CursorType, Long> $this$getOrPut$iv = this.getCursorCache();
            boolean $i$f$getOrPut = false;
            Long value$iv = $this$getOrPut$iv.get((Object)value);
            if (value$iv == null) {
                int n;
                boolean bl = false;
                switch (ApplicationGLFWGL3$WhenMappings.$EnumSwitchMapping$0[value.ordinal()]) {
                    case 1: {
                        n = 221185;
                        break;
                    }
                    case 2: {
                        n = 221186;
                        break;
                    }
                    case 3: {
                        n = 221188;
                        break;
                    }
                    case 4: {
                        n = 221187;
                        break;
                    }
                    case 5: {
                        n = 221189;
                        break;
                    }
                    case 6: {
                        n = 221190;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                int glfwCursor = n;
                Long answer$iv = GLFW.glfwCreateStandardCursor(glfwCursor);
                $this$getOrPut$iv.put(value, answer$iv);
                l = answer$iv;
            } else {
                l = value$iv;
            }
            long cursor = ((Number)l).longValue();
            GLFW.glfwSetCursor(this.window, cursor);
            this.cursorType = value;
        }
    }

    @Override
    @NotNull
    public Vector2 getWindowSize() {
        int[] w = new int[1];
        int[] h = new int[1];
        GLFW.glfwGetWindowSize(this.window, w, h);
        return new Vector2(this.fixWindowSize ? (double)w[0] / this.program.getWindow().getScale().getX() : (double)w[0], this.fixWindowSize ? (double)h[0] / this.program.getWindow().getScale().getY() : (double)h[0]);
    }

    @Override
    public void setWindowSize(@NotNull Vector2 value) {
        Intrinsics.checkNotNullParameter(value, "value");
        GLFW.glfwSetWindowSize(this.window, this.fixWindowSize ? (int)(value.getX() * this.program.getWindow().getScale().getX()) : (int)value.getX(), this.fixWindowSize ? (int)(value.getY() * this.program.getWindow().getScale().getY()) : (int)value.getY());
    }

    @Override
    @NotNull
    public Vector2 getWindowPosition() {
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetWindowPos(this.window, x, y);
        return new Vector2(this.fixWindowSize ? (double)x[0] / this.program.getWindow().getScale().getX() : (double)x[0], this.fixWindowSize ? (double)y[0] / this.program.getWindow().getScale().getY() : (double)y[0]);
    }

    @Override
    public void setWindowPosition(@NotNull Vector2 value) {
        Intrinsics.checkNotNullParameter(value, "value");
        GLFW.glfwSetWindowPos(this.window, this.fixWindowSize ? (int)(value.getX() * this.program.getWindow().getScale().getX()) : (int)value.getX(), this.fixWindowSize ? (int)(value.getY() * this.program.getWindow().getScale().getY()) : (int)value.getY());
    }

    @Override
    @Nullable
    public String getClipboardContents() {
        String string;
        try {
            String result2 = GLFW.glfwGetClipboardString(this.window);
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    @Override
    public void setClipboardContents(@Nullable String value) {
        if (value == null) {
            throw (Throwable)new RuntimeException("clipboard contents can't be null");
        }
        GLFW.glfwSetClipboardString(this.window, value);
    }

    @Override
    public double getSeconds() {
        return GLFW.glfwGetTime();
    }

    @Override
    @NotNull
    public String getWindowTitle() {
        return this.realWindowTitle;
    }

    @Override
    public void setWindowTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        GLFW.glfwSetWindowTitle(this.window, value);
        this.realWindowTitle = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setup() {
        void readyFrames;
        int requestHeight;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(139270, 1);
        GLFW.glfwWindowHint(139272, 204801);
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, this.configuration.getWindowResizable() ? 1 : 0);
        GLFW.glfwWindowHint(131077, this.configuration.getHideWindowDecorations() ? 0 : 1);
        WindowMultisample c = this.configuration.getMultisample();
        if (c instanceof WindowMultisample.SampleCount) {
            GLFW.glfwWindowHint(135181, ((WindowMultisample.SampleCount)c).getCount());
        } else if (Intrinsics.areEqual(c, WindowMultisample.SystemDefault.INSTANCE)) {
            GLFW.glfwWindowHint(135181, -1);
        } else if (Intrinsics.areEqual(c, WindowMultisample.Disabled.INSTANCE)) {
            GLFW.glfwWindowHint(135181, 0);
        }
        GLFW.glfwWindowHint(135169, 8);
        GLFW.glfwWindowHint(135170, 8);
        GLFW.glfwWindowHint(135171, 8);
        GLFW.glfwWindowHint(135174, 8);
        GLFW.glfwWindowHint(135173, 24);
        if (this.configuration.getWindowAlwaysOnTop()) {
            GLFW.glfwWindowHint(131079, 1);
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().info(setup.1.INSTANCE);
        if (DriverGL3Kt.getUseDebugContext()) {
            GLFW.glfwWindowHint(139271, 1);
        }
        float[] xscale = new float[1];
        float[] yscale = new float[1];
        GLFW.glfwGetMonitorContentScale(GLFW.glfwGetPrimaryMonitor(), xscale, yscale);
        if (this.configuration.getFullscreen() == Fullscreen.SET_DISPLAY_MODE) {
            xscale[0] = 1.0f;
            yscale[0] = 1.0f;
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(xscale, yscale){
            final /* synthetic */ float[] $xscale;
            final /* synthetic */ float[] $yscale;

            @Nullable
            public final Object invoke() {
                return "content scale " + this.$xscale[0] + ' ' + this.$yscale[0];
            }
            {
                this.$xscale = fArray;
                this.$yscale = fArray2;
                super(0);
            }
        });
        this.program.getWindow().setScale(new Vector2(xscale[0], yscale[0]));
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(setup.3.INSTANCE);
        List<DriverVersionGL> versions = DriverGL3.Companion.candidateVersions();
        for (int versionIndex = 0; this.window == 0L && versionIndex < versions.size(); ++versionIndex) {
            long l;
            GLFW.glfwWindowHint(139266, versions.get(versionIndex).getMajorVersion());
            GLFW.glfwWindowHint(139267, versions.get(versionIndex).getMinorVersion());
            if (this.configuration.getFullscreen() == Fullscreen.DISABLED) {
                int adjustedWidth = this.fixWindowSize ? (int)(xscale[0] * (float)this.configuration.getWidth()) : this.configuration.getWidth();
                int adjustedHeight = this.fixWindowSize ? (int)(yscale[0] * (float)this.configuration.getHeight()) : this.configuration.getHeight();
                l = GLFW.glfwCreateWindow(adjustedWidth, adjustedHeight, this.configuration.getTitle(), 0L, ApplicationGLFWGL3Kt.getPrimaryWindow());
            } else {
                ApplicationGLFWGL3Kt.access$getLogger$p().info(setup.4.INSTANCE);
                int requestWidth = this.configuration.getWidth();
                requestHeight = this.configuration.getHeight();
                if (this.configuration.getFullscreen() == Fullscreen.CURRENT_DISPLAY_MODE) {
                    GLFWVidMode mode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
                    if (mode != null) {
                        requestWidth = mode.width();
                        requestHeight = mode.height();
                    } else {
                        throw (Throwable)new RuntimeException("failed to determine current video mode");
                    }
                }
                l = GLFW.glfwCreateWindow(requestWidth, requestHeight, this.configuration.getTitle(), GLFW.glfwGetPrimaryMonitor(), ApplicationGLFWGL3Kt.getPrimaryWindow());
            }
            this.window = l;
        }
        if (this.window == 0L) {
            throw (Throwable)new IllegalStateException("Window creation failed");
        }
        if (this.configuration.getWindowSetIcon()) {
            int x22;
            ByteBuffer buf;
            ByteBuffer byteBuffer = buf = BufferUtils.createByteBuffer(65536);
            if (byteBuffer == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)byteBuffer).rewind();
            requestHeight = 0;
            int n = 128;
            while (requestHeight < n) {
                void y;
                int n2 = 0;
                int n3 = 128;
                while (n2 < n3) {
                    buf.putInt((int)4290825215L);
                    ++x22;
                }
                ++y;
            }
            ((Buffer)buf).flip();
            AutoCloseable autoCloseable = MemoryStack.stackPush();
            n = 0;
            x22 = 0;
            Throwable x22 = null;
            try {
                Object it = (MemoryStack)autoCloseable;
                boolean bl = false;
                GLFW.glfwSetWindowIcon(this.window, GLFWImage.mallocStack(1, (MemoryStack)it).width(128).height(128).pixels(buf));
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                x22 = it;
                throw it;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, x22);
            }
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            @Nullable
            public final Object invoke() {
                return "window created: " + ApplicationGLFWGL3.access$getWindow$p(this.this$0);
            }
            {
                this.this$0 = applicationGLFWGL3;
                super(0);
            }
        });
        MemoryStack buf = MemoryStack.stackPush();
        boolean bl = false;
        boolean bl2 = false;
        MemoryStack stack = buf;
        boolean bl3 = false;
        IntBuffer pWidth = stack.mallocInt(1);
        IntBuffer pHeight = stack.mallocInt(1);
        GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        if (this.configuration.getPosition() == null) {
            if (vidmode != null) {
                GLFW.glfwSetWindowPos(this.window, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
            }
        } else {
            IntVector2 intVector2 = this.configuration.getPosition();
            if (intVector2 != null) {
                IntVector2 intVector22 = intVector2;
                boolean bl4 = false;
                boolean bl5 = false;
                IntVector2 it = intVector22;
                boolean bl6 = false;
                GLFW.glfwSetWindowPos(this.window, it.getX(), it.getY());
            }
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(setup.8.INSTANCE);
        GLFW.glfwMakeContextCurrent(this.window);
        if (this.configuration.getVsync()) {
            boolean enableTearControl = false;
            GLFW.glfwSwapInterval(1);
        }
        Ref.IntRef enableTearControl = new Ref.IntRef();
        enableTearControl.element = 0;
        GLFW.glfwSetWindowRefreshCallback(this.window, new GLFWWindowRefreshCallbackI(this, (Ref.IntRef)readyFrames){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Ref.IntRef $readyFrames;

            public final void invoke(long it) {
                if (this.$readyFrames.element > 0) {
                    if (ApplicationGLFWGL3.access$getSetupCalled$p(this.this$0)) {
                        ApplicationGLFWGL3.access$drawFrame(this.this$0);
                    }
                    GLFW.glfwSwapBuffers(ApplicationGLFWGL3.access$getWindow$p(this.this$0));
                }
                int n = this.$readyFrames.element;
                this.$readyFrames.element = n + 1;
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$readyFrames = intRef;
            }
        });
        GLFW.glfwSetFramebufferSizeCallback(this.window, new GLFWFramebufferSizeCallbackI(this, (Ref.IntRef)readyFrames){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Ref.IntRef $readyFrames;

            public final void invoke(long window, int width, int height) {
                ApplicationGLFWGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(window, width, height){
                    final /* synthetic */ long $window;
                    final /* synthetic */ int $width;
                    final /* synthetic */ int $height;

                    @Nullable
                    public final Object invoke() {
                        return "resizing window (" + this.$window + ") to " + this.$width + 'x' + this.$height + ' ';
                    }
                    {
                        this.$window = l;
                        this.$width = n;
                        this.$height = n2;
                        super(0);
                    }
                });
                if (this.$readyFrames.element > 0) {
                    ApplicationGLFWGL3.access$setupSizes(this.this$0);
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSized().trigger(new WindowEvent(WindowEventType.RESIZED, ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize(), true));
                }
                int n = this.$readyFrames.element;
                this.$readyFrames.element = n + 1;
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$readyFrames = intRef;
            }
        });
        GLFW.glfwSetWindowPosCallback(this.window, new GLFWWindowPosCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long $noName_0, int x, int y) {
                ApplicationGLFWGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(this, x, y){
                    final /* synthetic */ setup.11 this$0;
                    final /* synthetic */ int $x;
                    final /* synthetic */ int $y;

                    @Nullable
                    public final Object invoke() {
                        return "window (" + ApplicationGLFWGL3.access$getWindow$p(this.this$0.this$0) + ") has moved to " + this.$x + ' ' + this.$y;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$x = n;
                        this.$y = n2;
                        super(0);
                    }
                });
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getMoved().trigger(new WindowEvent(WindowEventType.MOVED, new Vector2(x, y), new Vector2(0.0, 0.0), true));
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        GLFW.glfwSetWindowFocusCallback(this.window, new GLFWWindowFocusCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long $noName_0, boolean focused) {
                ApplicationGLFWGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(this, focused){
                    final /* synthetic */ setup.12 this$0;
                    final /* synthetic */ boolean $focused;

                    @Nullable
                    public final Object invoke() {
                        return "window (" + ApplicationGLFWGL3.access$getWindow$p(this.this$0.this$0) + ") focus has changed; focused=" + this.$focused;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$focused = bl;
                        super(0);
                    }
                });
                ApplicationGLFWGL3.access$setWindowFocused$p(this.this$0, focused);
                if (focused) {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getFocused().trigger(new WindowEvent(WindowEventType.FOCUSED, ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize(), true));
                } else {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getUnfocused().trigger(new WindowEvent(WindowEventType.FOCUSED, ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize(), false));
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        GLFW.glfwSetWindowCloseCallback(this.window, new GLFWWindowCloseCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long window) {
                ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(window){
                    final /* synthetic */ long $window;

                    @Nullable
                    public final Object invoke() {
                        return "window (" + this.$window + ") closed";
                    }
                    {
                        this.$window = l;
                        super(0);
                    }
                });
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getClosed().trigger(new WindowEvent(WindowEventType.CLOSED, ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize(), true));
                ApplicationGLFWGL3.access$setExitRequested$p(this.this$0, true);
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(setup.14.INSTANCE);
        ApplicationGLFWGL3 applicationGLFWGL3 = this;
        bl2 = false;
        boolean bl7 = false;
        ApplicationGLFWGL3 $this$run = applicationGLFWGL3;
        boolean bl8 = false;
        int adjustedMinimumWidth = $this$run.fixWindowSize ? (int)(xscale[0] * (float)$this$run.configuration.getMinimumWidth()) : $this$run.configuration.getMinimumWidth();
        int adjustedMinimumHeight = $this$run.fixWindowSize ? (int)(yscale[0] * (float)$this$run.configuration.getMinimumHeight()) : $this$run.configuration.getMinimumHeight();
        int adjustedMaximumWidth = $this$run.fixWindowSize && $this$run.configuration.getMaximumWidth() != Integer.MAX_VALUE ? (int)(xscale[0] * (float)$this$run.configuration.getMaximumWidth()) : $this$run.configuration.getMaximumWidth();
        int adjustedMaximumHeight = $this$run.fixWindowSize && $this$run.configuration.getMaximumHeight() != Integer.MAX_VALUE ? (int)(yscale[0] * (float)$this$run.configuration.getMaximumHeight()) : $this$run.configuration.getMaximumHeight();
        GLFW.glfwSetWindowSizeLimits($this$run.window, adjustedMinimumWidth, adjustedMinimumHeight, adjustedMaximumWidth, adjustedMaximumHeight);
        Animatable.Companion.clock(new Clock(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public long getTime() {
                return (long)(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getSeconds() * 1000.0);
            }

            public long getTimeNanos() {
                return (long)(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getSeconds() * 1000000.0);
            }
            {
                this.this$0 = this$0;
            }
        });
        GLFW.glfwShowWindow(this.window);
        GLFW.glfwSwapBuffers(this.window);
    }

    private final void createPrimaryWindow() {
        if (ApplicationGLFWGL3Kt.getPrimaryWindow() == 0L) {
            GLFW.glfwSetErrorCallback(GLFWErrorCallback.create(createPrimaryWindow.1.INSTANCE));
            if (!GLFW.glfwInit()) {
                throw (Throwable)new IllegalStateException("Unable to initialize GLFW");
            }
            String title = "OPENRNDR primary window";
            List<DriverVersionGL> versions = DriverGL3.Companion.candidateVersions();
            GLFW.glfwDefaultWindowHints();
            GLFW.glfwWindowHint(139270, 1);
            GLFW.glfwWindowHint(139272, 204801);
            GLFW.glfwWindowHint(135169, 8);
            GLFW.glfwWindowHint(135170, 8);
            GLFW.glfwWindowHint(135171, 8);
            GLFW.glfwWindowHint(135174, 8);
            GLFW.glfwWindowHint(135173, 24);
            GLFW.glfwWindowHint(131076, 0);
            DriverVersionGL foundVersion = null;
            for (DriverVersionGL version : versions) {
                GLFW.glfwWindowHint(139266, version.getMajorVersion());
                GLFW.glfwWindowHint(139267, version.getMinorVersion());
                ApplicationGLFWGL3Kt.setPrimaryWindow(GLFW.glfwCreateWindow(640, 480, title, 0L, 0L));
                if (ApplicationGLFWGL3Kt.getPrimaryWindow() == 0L) continue;
                foundVersion = version;
                break;
            }
            if (ApplicationGLFWGL3Kt.getPrimaryWindow() == 0L) {
                throw (Throwable)new IllegalStateException("primary window could not be created");
            }
            DriverVersionGL driverVersionGL = foundVersion;
            if (driverVersionGL == null) {
                String string = "no version found";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Driver.Companion.setDriver(new DriverGL3(driverVersionGL));
        }
    }

    public final void preloop() {
        GL.createCapabilities();
        if (DriverGL3Kt.getUseDebugContext()) {
            GLUtil.setupDebugMessageCallback();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public void run() {
                ApplicationGLFWGL3Kt.access$getLogger$p().debug(preloop.run.1.INSTANCE);
                for (Extension extension : ApplicationGLFWGL3.access$getProgram$p(this.this$0).getExtensions()) {
                    extension.shutdown(ApplicationGLFWGL3.access$getProgram$p(this.this$0));
                }
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getExtensions().clear();
            }
            {
                this.this$0 = this$0;
            }
        });
        this.program.setDriver(Driver.Companion.getInstance());
        this.program.setDrawer(new Drawer(Driver.Companion.getInstance()));
        ProgramRenderTargetGL3 defaultRenderTarget2 = new ProgramRenderTargetGL3(this.program);
        defaultRenderTarget2.bind();
        this.setupSizes();
        this.program.getDrawer().ortho();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loop() {
        void lastMouseButtonDown;
        void lastDragPosition;
        void down;
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.1.INSTANCE);
        this.preloop();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = Vector2.Companion.getZERO();
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = MouseButton.NONE;
        boolean bl = false;
        Set modifiers = new LinkedHashSet();
        GLFW.glfwSetKeyCallback(this.window, new GLFWKeyCallbackI(this, modifiers){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Set $modifiers;

            public final void invoke(long $noName_0, int key, int scancode, int action, int mods) {
                String string;
                switch (key) {
                    case 32: {
                        string = "space";
                        break;
                    }
                    case 257: {
                        string = "enter";
                        break;
                    }
                    case 258: {
                        string = "tab";
                        break;
                    }
                    case 256: {
                        string = "escape";
                        break;
                    }
                    case 265: {
                        string = "arrow-up";
                        break;
                    }
                    case 264: {
                        string = "arrow-down";
                        break;
                    }
                    case 263: {
                        string = "arrow-left";
                        break;
                    }
                    case 262: {
                        string = "arrow-right";
                        break;
                    }
                    case 283: {
                        string = "print-screen";
                        break;
                    }
                    case 267: {
                        string = "page-down";
                        break;
                    }
                    case 266: {
                        string = "page-up";
                        break;
                    }
                    case 268: {
                        string = "home";
                        break;
                    }
                    case 269: {
                        string = "end";
                        break;
                    }
                    case 259: {
                        string = "backspace";
                        break;
                    }
                    case 342: {
                        string = "left-alt";
                        break;
                    }
                    case 346: {
                        string = "right-alt";
                        break;
                    }
                    case 341: {
                        string = "left-control";
                        break;
                    }
                    case 345: {
                        string = "right-control";
                        break;
                    }
                    case 260: {
                        string = "insert";
                        break;
                    }
                    case 261: {
                        string = "delete";
                        break;
                    }
                    case 340: {
                        string = "left-shift";
                        break;
                    }
                    case 344: {
                        string = "right-shift";
                        break;
                    }
                    case 343: {
                        string = "left-super";
                        break;
                    }
                    case 347: {
                        string = "right-super";
                        break;
                    }
                    case 290: {
                        string = "f1";
                        break;
                    }
                    case 291: {
                        string = "f2";
                        break;
                    }
                    case 292: {
                        string = "f3";
                        break;
                    }
                    case 293: {
                        string = "f4";
                        break;
                    }
                    case 294: {
                        string = "f5";
                        break;
                    }
                    case 295: {
                        string = "f6";
                        break;
                    }
                    case 296: {
                        string = "f7";
                        break;
                    }
                    case 297: {
                        string = "f8";
                        break;
                    }
                    case 298: {
                        string = "f9";
                        break;
                    }
                    case 299: {
                        string = "f10";
                        break;
                    }
                    case 300: {
                        string = "f11";
                        break;
                    }
                    case 301: {
                        string = "f12";
                        break;
                    }
                    case 280: {
                        string = "caps-lock";
                        break;
                    }
                    default: {
                        String string2 = GLFW.glfwGetKeyName(key, scancode);
                        if (string2 == null) {
                            string2 = "<null>";
                        }
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue(string2, "glfwGetKeyName(key, scancode) ?: \"<null>\"");
                    }
                }
                String name = string;
                switch (action) {
                    case 1: {
                        boolean bl;
                        KeyModifier keyModifier;
                        Collection collection;
                        if (key == 342 || key == 346) {
                            collection = this.$modifiers;
                            keyModifier = KeyModifier.ALT;
                            bl = false;
                            collection.add(keyModifier);
                        }
                        if (key == 341 || key == 345) {
                            collection = this.$modifiers;
                            keyModifier = KeyModifier.CTRL;
                            bl = false;
                            collection.add(keyModifier);
                        }
                        if (key == 340 || key == 344) {
                            collection = this.$modifiers;
                            keyModifier = KeyModifier.SHIFT;
                            bl = false;
                            collection.add(keyModifier);
                        }
                        if (key == 343 || key == 347) {
                            collection = this.$modifiers;
                            keyModifier = KeyModifier.SUPER;
                            bl = false;
                            collection.add(keyModifier);
                        }
                        ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyDown().trigger(new KeyEvent(KeyEventType.KEY_DOWN, key, name, this.$modifiers, false, 16, null));
                        ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getPressedKeys().add(name);
                        break;
                    }
                    case 0: {
                        boolean bl;
                        KeyModifier keyModifier;
                        Collection collection;
                        if (key == 342 || key == 346) {
                            collection = this.$modifiers;
                            keyModifier = KeyModifier.ALT;
                            bl = false;
                            collection.remove((Object)((Object)keyModifier));
                        }
                        if (key == 341 || key == 345) {
                            collection = this.$modifiers;
                            keyModifier = KeyModifier.CTRL;
                            bl = false;
                            collection.remove((Object)((Object)keyModifier));
                        }
                        if (key == 340 || key == 344) {
                            collection = this.$modifiers;
                            keyModifier = KeyModifier.SHIFT;
                            bl = false;
                            collection.remove((Object)((Object)keyModifier));
                        }
                        if (key == 343 || key == 347) {
                            collection = this.$modifiers;
                            keyModifier = KeyModifier.SUPER;
                            bl = false;
                            collection.remove((Object)((Object)keyModifier));
                        }
                        ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyUp().trigger(new KeyEvent(KeyEventType.KEY_UP, key, name, this.$modifiers, false, 16, null));
                        ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getPressedKeys().remove(name);
                        break;
                    }
                    case 2: {
                        ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyRepeat().trigger(new KeyEvent(KeyEventType.KEY_REPEAT, key, name, this.$modifiers, false, 16, null));
                        break;
                    }
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$modifiers = set;
            }
        });
        GLFW.glfwSetCharCallback(this.window, new GLFWCharCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long $noName_0, int codepoint) {
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getCharacter().trigger(new Program.CharacterEvent((char)codepoint, SetsKt.<T>emptySet(), false, 4, null));
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        GLFW.glfwSetDropCallback(this.window, new GLFWDropCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(long $noName_0, int count2, long names) {
                void $this$mapTo$iv$iv;
                ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(count2){
                    final /* synthetic */ int $count;

                    @Nullable
                    public final Object invoke() {
                        return this.$count + " file(s) have been dropped";
                    }
                    {
                        this.$count = n;
                        super(0);
                    }
                });
                PointerBuffer pointers = PointerBuffer.create(names, count2);
                Iterable $this$map$iv = RangesKt.until(0, count2);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    File file = new File(pointers.getStringUTF8((int)it));
                    collection.add(file);
                }
                List files = (List)destination$iv$iv;
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getDrop().trigger(new DropEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), files));
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        GLFW.glfwSetScrollCallback(this.window, new GLFWScrollCallbackI(this, modifiers){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Set $modifiers;

            public final void invoke(long $noName_0, double xoffset, double yoffset) {
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getScrolled().trigger(new MouseEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), new Vector2(xoffset, yoffset), Vector2.Companion.getZERO(), MouseEventType.SCROLLED, MouseButton.NONE, this.$modifiers));
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$modifiers = set;
            }
        });
        GLFW.glfwSetWindowIconifyCallback(this.window, new GLFWWindowIconifyCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long $noName_0, boolean iconified) {
                if (iconified) {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getMinimized().trigger(new WindowEvent(WindowEventType.MINIMIZED, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), false));
                } else {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getRestored().trigger(new WindowEvent(WindowEventType.RESTORED, ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize(), true));
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        GLFW.glfwSetCursorEnterCallback(this.window, new GLFWCursorEnterCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long $noName_0, boolean entered) {
                if (entered) {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getEntered().trigger(new MouseEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.ENTERED, MouseButton.NONE, SetsKt.<T>emptySet()));
                } else {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getExited().trigger(new MouseEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.EXITED, MouseButton.NONE, SetsKt.<T>emptySet()));
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        GLFW.glfwSetMouseButtonCallback(this.window, new GLFWMouseButtonCallbackI(this, (Ref.BooleanRef)down, (Ref.ObjectRef)lastDragPosition, (Ref.ObjectRef)lastMouseButtonDown, modifiers){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Ref.BooleanRef $down;
            final /* synthetic */ Ref.ObjectRef $lastDragPosition;
            final /* synthetic */ Ref.ObjectRef $lastMouseButtonDown;
            final /* synthetic */ Set $modifiers;

            public final void invoke(long $noName_0, int button, int action, int mods) {
                MouseButton mouseButton;
                switch (button) {
                    case 0: {
                        mouseButton = MouseButton.LEFT;
                        break;
                    }
                    case 1: {
                        mouseButton = MouseButton.RIGHT;
                        break;
                    }
                    case 2: {
                        mouseButton = MouseButton.CENTER;
                        break;
                    }
                    default: {
                        mouseButton = MouseButton.NONE;
                    }
                }
                MouseButton mouseButton2 = mouseButton;
                BitSet buttonsDown = new BitSet();
                if (action == 1) {
                    this.$down.element = true;
                    this.$lastDragPosition.element = ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition();
                    this.$lastMouseButtonDown.element = mouseButton2;
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getButtonDown().trigger(new MouseEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_DOWN, mouseButton2, this.$modifiers));
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPressedButtons().add(mouseButton2);
                    buttonsDown.set(button, true);
                }
                if (action == 0) {
                    this.$down.element = false;
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getButtonUp().trigger(new MouseEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_UP, mouseButton2, this.$modifiers));
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPressedButtons().remove((Object)((Object)mouseButton2));
                    buttonsDown.set(button, false);
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$down = booleanRef;
                this.$lastDragPosition = objectRef;
                this.$lastMouseButtonDown = objectRef2;
                this.$modifiers = set;
            }
        });
        GLFW.glfwSetCursorPosCallback(this.window, new GLFWCursorPosCallbackI(this, modifiers, (Ref.BooleanRef)down, (Ref.ObjectRef)lastDragPosition, (Ref.ObjectRef)lastMouseButtonDown){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Set $modifiers;
            final /* synthetic */ Ref.BooleanRef $down;
            final /* synthetic */ Ref.ObjectRef $lastDragPosition;
            final /* synthetic */ Ref.ObjectRef $lastMouseButtonDown;

            public final void invoke(long $noName_0, double xpos, double ypos) {
                Vector2 position = ApplicationGLFWGL3.access$getFixWindowSize$p(this.this$0) ? new Vector2(xpos, ypos).div(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getScale()) : new Vector2(xpos, ypos);
                ApplicationGLFWGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(xpos, ypos, position){
                    final /* synthetic */ double $xpos;
                    final /* synthetic */ double $ypos;
                    final /* synthetic */ Vector2 $position;

                    @Nullable
                    public final Object invoke() {
                        return "mouse moved " + this.$xpos + ' ' + this.$ypos + " -- " + this.$position;
                    }
                    {
                        this.$xpos = d;
                        this.$ypos = d2;
                        this.$position = vector2;
                        super(0);
                    }
                });
                ApplicationGLFWGL3.access$setRealCursorPosition$p(this.this$0, position);
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getMoved().trigger(new MouseEvent(position, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.MOVED, MouseButton.NONE, this.$modifiers));
                if (this.$down.element) {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getDragged().trigger(new MouseEvent(position, Vector2.Companion.getZERO(), position.minus((Vector2)this.$lastDragPosition.element), MouseEventType.DRAGGED, (MouseButton)((Object)this.$lastMouseButtonDown.element), this.$modifiers));
                    this.$lastDragPosition.element = position;
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$modifiers = set;
                this.$down = booleanRef;
                this.$lastDragPosition = objectRef;
                this.$lastMouseButtonDown = objectRef2;
            }
        });
        if (this.configuration.getShowBeforeSetup()) {
            ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.10.INSTANCE);
            GL33C.glDepthMask(true);
            GL33C.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            GL33C.glClear(17664);
            GLFW.glfwSwapBuffers(this.window);
            GL33C.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            GL33C.glClear(17664);
            GL33C.glDepthMask(false);
            GLFW.glfwSwapBuffers(this.window);
            GLFW.glfwPollEvents();
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().info(loop.11.INSTANCE);
        ApplicationGLFWGL3Kt.access$getLogger$p().info(loop.12.INSTANCE);
        ApplicationGLFWGL3Kt.access$getLogger$p().info(loop.13.INSTANCE);
        if (this.configuration.getHideCursor()) {
            GLFW.glfwSetInputMode(this.window, 208897, 212994);
        }
        if (this.configuration.getVsync()) {
            if (GLFW.glfwExtensionSupported("GLX_EXT_swap_control_tear") || GLFW.glfwExtensionSupported("WGL_EXT_swap_control_tear")) {
                GLFW.glfwSwapInterval(-1);
            } else {
                GLFW.glfwSwapInterval(1);
            }
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.14.INSTANCE);
        Throwable setupException = null;
        try {
            this.program.setup();
        }
        catch (Throwable t2) {
            setupException = t2;
        }
        Throwable throwable = setupException;
        if (throwable != null) {
            t2 = throwable;
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable it = t2;
            boolean bl4 = false;
            ApplicationGLFWGL3Kt.access$getLogger$p().error(loop.15.1.INSTANCE);
            throw it;
        }
        this.setupCalled = true;
        Throwable exception = null;
        while (!this.exitRequested && !GLFW.glfwWindowShouldClose(this.window)) {
            if (this.getPresentationMode() == PresentationMode.AUTOMATIC || this.drawRequested) {
                this.drawRequested = false;
                exception = this.drawFrame();
                if (exception != null) {
                    ApplicationGLFWGL3Kt.access$getLogger$p().error(loop.16.INSTANCE);
                    break;
                }
                GLFW.glfwSwapBuffers(this.window);
            }
            if (!this.windowFocused && this.configuration.getUnfocusBehaviour() == UnfocusBehaviour.THROTTLE) {
                Thread.sleep(100L);
            }
            if (this.getPresentationMode() == PresentationMode.AUTOMATIC) {
                GLFW.glfwPollEvents();
                continue;
            }
            Thread.sleep(1L);
            GLFW.glfwPollEvents();
            this.deliverEvents();
            this.program.getDispatcher().execute();
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.17.INSTANCE);
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.18.INSTANCE);
        for (Extension extension : this.program.getExtensions()) {
            extension.shutdown(this.program);
        }
        this.program.getExtensions().clear();
        this.program.getEnded().trigger(new ProgramEvent(ProgramEventType.ENDED));
        Callbacks.glfwFreeCallbacks(this.window);
        GLFW.glfwDestroyWindow(this.window);
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.19.INSTANCE);
        Throwable throwable2 = exception;
        if (throwable2 != null) {
            Throwable throwable3 = throwable2;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable it = throwable3;
            boolean bl7 = false;
            ApplicationGLFWGL3Kt.access$getLogger$p().info(loop.20.1.INSTANCE);
            throw it;
        }
    }

    private final void deliverEvents() {
        this.program.getWindow().getDrop().deliver();
        this.program.getWindow().getSized().deliver();
        this.program.getWindow().getUnfocused().deliver();
        this.program.getWindow().getFocused().deliver();
        this.program.getWindow().getMinimized().deliver();
        this.program.getWindow().getRestored().deliver();
        this.program.getKeyboard().getKeyDown().deliver();
        this.program.getKeyboard().getKeyUp().deliver();
        this.program.getKeyboard().getKeyRepeat().deliver();
        this.program.getKeyboard().getCharacter().deliver();
        this.program.getMouse().getMoved().deliver();
        this.program.getMouse().getScrolled().deliver();
        this.program.getMouse().getButtonDown().deliver();
        this.program.getMouse().getButtonUp().deliver();
        this.program.getMouse().getDragged().deliver();
        this.program.getMouse().getEntered().deliver();
        this.program.getMouse().getExited().deliver();
    }

    private final Throwable drawFrame() {
        this.setupSizes();
        GL33C.glBindVertexArray(this.vaos[0]);
        this.program.getDrawer().reset();
        this.program.getDrawer().ortho();
        this.deliverEvents();
        this.program.getDispatcher().execute();
        try {
            ApplicationGLFWGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(this){
                final /* synthetic */ ApplicationGLFWGL3 this$0;

                @Nullable
                public final Object invoke() {
                    return "window: " + (int)ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize().getX() + 'x' + (int)ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize().getY() + " program: " + ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWidth() + 'x' + ApplicationGLFWGL3.access$getProgram$p(this.this$0).getHeight();
                }
                {
                    this.this$0 = applicationGLFWGL3;
                    super(0);
                }
            });
            this.program.drawImpl();
        }
        catch (Throwable e) {
            ApplicationGLFWGL3Kt.access$getLogger$p().error(drawFrame.2.INSTANCE);
            return e;
        }
        return null;
    }

    private final void setupSizes() {
        float[] wcsx = new float[1];
        float[] wcsy = new float[1];
        GLFW.glfwGetWindowContentScale(this.window, wcsx, wcsy);
        this.program.getWindow().setScale(new Vector2(wcsx[0], wcsy[0]));
        int[] fbw = new int[1];
        int[] fbh = new int[1];
        GLFW.glfwGetFramebufferSize(this.window, fbw, fbh);
        GL33C.glViewport(0, 0, fbw[0], fbh[0]);
        double d = (double)fbw[0] / this.program.getWindow().getScale().getX();
        boolean bl = false;
        this.program.setWidth((int)Math.ceil(d));
        d = (double)fbh[0] / this.program.getWindow().getScale().getY();
        bl = false;
        this.program.setHeight((int)Math.ceil(d));
        this.program.getDrawer().setWidth(this.program.getWidth());
        this.program.getDrawer().setHeight(this.program.getHeight());
    }

    private final Set<KeyModifier> modifierSet(int mods) {
        boolean bl = false;
        Set modifiers = new LinkedHashSet();
        if ((mods & 1) != 0) {
            modifiers.add(KeyModifier.SHIFT);
        }
        if ((mods & 4) != 0) {
            modifiers.add(KeyModifier.ALT);
        }
        if ((mods & 2) != 0) {
            modifiers.add(KeyModifier.CTRL);
        }
        if ((mods & 8) != 0) {
            modifiers.add(KeyModifier.SUPER);
        }
        return modifiers;
    }

    @Override
    public void exit() {
        this.exitRequested = true;
    }

    @Override
    public void requestDraw() {
        this.drawRequested = true;
    }

    @Override
    public void requestFocus() {
        GLFW.glfwFocusWindow(this.window);
    }

    /*
     * Unable to fully structure code
     */
    public ApplicationGLFWGL3(@NotNull Program program, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter(program, "program");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        super();
        this.program = program;
        this.configuration = configuration;
        this.windowFocused = true;
        this.realWindowTitle = this.configuration.getTitle();
        v0 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(v0, "System.getProperty(\"os.name\")");
        if (StringsKt.contains((CharSequence)v0, "windows", true)) ** GOTO lbl-1000
        v1 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(v1, "System.getProperty(\"os.name\")");
        if (StringsKt.contains((CharSequence)v1, "linux", true)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        this.fixWindowSize = v2;
        this.presentationMode = PresentationMode.AUTOMATIC;
        this.realCursorPosition = new Vector2(0.0, 0.0);
        this.cursorVisible = true;
        this.cursorCache$delegate = LazyKt.lazy(cursorCache.2.INSTANCE);
        this.cursorType = CursorType.ARROW_CURSOR;
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(1.INSTANCE);
        ApplicationGLFWGL3Kt.access$getLogger$p().trace(2.INSTANCE);
        this.program.setApplication(this);
        this.createPrimaryWindow();
        this.vaos = new int[1];
        this.drawRequested = true;
    }

    public static final /* synthetic */ long access$getWindow$p(ApplicationGLFWGL3 $this) {
        return $this.window;
    }

    public static final /* synthetic */ void access$setWindow$p(ApplicationGLFWGL3 $this, long l) {
        $this.window = l;
    }

    public static final /* synthetic */ boolean access$getSetupCalled$p(ApplicationGLFWGL3 $this) {
        return $this.setupCalled;
    }

    public static final /* synthetic */ void access$setSetupCalled$p(ApplicationGLFWGL3 $this, boolean bl) {
        $this.setupCalled = bl;
    }

    public static final /* synthetic */ Throwable access$drawFrame(ApplicationGLFWGL3 $this) {
        return $this.drawFrame();
    }

    public static final /* synthetic */ void access$setupSizes(ApplicationGLFWGL3 $this) {
        $this.setupSizes();
    }

    public static final /* synthetic */ Program access$getProgram$p(ApplicationGLFWGL3 $this) {
        return $this.program;
    }

    public static final /* synthetic */ boolean access$getWindowFocused$p(ApplicationGLFWGL3 $this) {
        return $this.windowFocused;
    }

    public static final /* synthetic */ void access$setWindowFocused$p(ApplicationGLFWGL3 $this, boolean bl) {
        $this.windowFocused = bl;
    }

    public static final /* synthetic */ boolean access$getExitRequested$p(ApplicationGLFWGL3 $this) {
        return $this.exitRequested;
    }

    public static final /* synthetic */ void access$setExitRequested$p(ApplicationGLFWGL3 $this, boolean bl) {
        $this.exitRequested = bl;
    }

    public static final /* synthetic */ boolean access$getFixWindowSize$p(ApplicationGLFWGL3 $this) {
        return $this.fixWindowSize;
    }

    public static final /* synthetic */ Vector2 access$getRealCursorPosition$p(ApplicationGLFWGL3 $this) {
        return $this.realCursorPosition;
    }

    public static final /* synthetic */ void access$setRealCursorPosition$p(ApplicationGLFWGL3 $this, Vector2 vector2) {
        $this.realCursorPosition = vector2;
    }
}

