/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.LinearType;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0006\u0010\u0018\u001a\u00020\u0000J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/math/Polar;", "Lorg/openrndr/math/LinearType;", "theta", "", "radius", "(DD)V", "cartesian", "Lorg/openrndr/math/Vector2;", "getCartesian", "()Lorg/openrndr/math/Vector2;", "getRadius", "()D", "getTheta", "component1", "component2", "copy", "div", "s", "equals", "", "other", "", "hashCode", "", "makeSafe", "minus", "plus", "times", "toString", "", "Companion", "openrndr-math"})
public final class Polar
implements LinearType<Polar> {
    private final double theta;
    private final double radius;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Polar makeSafe() {
        return new Polar(FunctionsKt.mod(this.theta, 360.0), this.radius);
    }

    @NotNull
    public final Vector2 getCartesian() {
        return Vector2.Companion.fromPolar(this);
    }

    @Override
    @NotNull
    public Polar plus(@NotNull Polar s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        return new Polar(this.theta + s2.theta, this.radius + s2.radius);
    }

    @Override
    @NotNull
    public Polar minus(@NotNull Polar s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        return new Polar(this.theta - s2.theta, this.radius - s2.radius);
    }

    @NotNull
    public final Polar times(@NotNull Polar s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        return new Polar(this.theta * s2.theta, this.radius * s2.radius);
    }

    @Override
    @NotNull
    public Polar times(double s2) {
        return new Polar(this.theta * s2, this.radius * s2);
    }

    @Override
    @NotNull
    public Polar div(double s2) {
        return new Polar(this.theta / s2, this.radius / s2);
    }

    public final double getTheta() {
        return this.theta;
    }

    public final double getRadius() {
        return this.radius;
    }

    public Polar(double theta, double radius) {
        this.theta = theta;
        this.radius = radius;
    }

    public /* synthetic */ Polar(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        this(d, d2);
    }

    public final double component1() {
        return this.theta;
    }

    public final double component2() {
        return this.radius;
    }

    @NotNull
    public final Polar copy(double theta, double radius) {
        return new Polar(theta, radius);
    }

    public static /* synthetic */ Polar copy$default(Polar polar, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = polar.theta;
        }
        if ((n & 2) != 0) {
            d2 = polar.radius;
        }
        return polar.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Polar(theta=" + this.theta + ", radius=" + this.radius + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.theta);
        long l2 = Double.doubleToLongBits(this.radius);
        return (int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Polar)) break block3;
                Polar polar = (Polar)object;
                if (Double.compare(this.theta, polar.theta) != 0 || Double.compare(this.radius, polar.radius) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/math/Polar$Companion;", "", "()V", "fromVector", "Lorg/openrndr/math/Polar;", "vector", "Lorg/openrndr/math/Vector2;", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Polar fromVector(@NotNull Vector2 vector) {
            double d;
            Intrinsics.checkNotNullParameter(vector, "vector");
            double r = vector.getLength();
            if (r == 0.0) {
                d = 0.0;
            } else {
                double d2 = vector.getY();
                double d3 = vector.getX();
                boolean bl = false;
                d = Math.toDegrees(Math.atan2(d2, d3));
            }
            return new Polar(d, r);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

