/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.platform;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.platform.GenericPlatformDriver;
import org.openrndr.platform.MacOSPlatformDriver;
import org.openrndr.platform.PlatformDriver;
import org.openrndr.platform.PlatformType;
import org.openrndr.platform.WindowsPlatformDriver;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u0004H\u0002J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/platform/Platform;", "", "()V", "driver", "Lorg/openrndr/platform/PlatformDriver;", "type", "Lorg/openrndr/platform/PlatformType;", "getType", "()Lorg/openrndr/platform/PlatformType;", "cacheDirectory", "Ljava/io/File;", "programName", "", "instantiateDriver", "supportDirectory", "tempDirectory", "openrndr-core"})
public final class Platform {
    private static final PlatformDriver driver;
    public static final Platform INSTANCE;

    private final PlatformDriver instantiateDriver() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "System.getProperty(\"os.name\")");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toLowerCase()");
        String os = string4;
        return StringsKt.startsWith$default(os, "windows", false, 2, null) ? (PlatformDriver)new WindowsPlatformDriver() : (StringsKt.startsWith$default(os, "mac", false, 2, null) ? (PlatformDriver)new MacOSPlatformDriver() : (PlatformDriver)new GenericPlatformDriver());
    }

    @NotNull
    public final PlatformType getType() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "System.getProperty(\"os.name\")");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toLowerCase()");
        String os = string4;
        return StringsKt.startsWith$default(os, "windows", false, 2, null) ? PlatformType.WINDOWS : (StringsKt.startsWith$default(os, "mac", false, 2, null) ? PlatformType.MAC : PlatformType.GENERIC);
    }

    @NotNull
    public final File tempDirectory() {
        return driver.temporaryDirectory();
    }

    @NotNull
    public final File cacheDirectory(@NotNull String programName) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        return driver.cacheDirectory(programName);
    }

    @NotNull
    public final File supportDirectory(@NotNull String programName) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        return driver.supportDirectory(programName);
    }

    private Platform() {
    }

    static {
        Platform platform;
        INSTANCE = platform = new Platform();
        driver = platform.instantiateDriver();
    }
}

