/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Vector2;
import org.openrndr.shape.OrientedEllipse;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\tJ\u000e\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\tJ\u0011\u0010*\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000H\u0086\u0002J\u0018\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u00032\b\b\u0002\u0010-\u001a\u00020\u0003J\u0018\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020\u00032\b\b\u0002\u00100\u001a\u00020\u0003J\u0011\u00101\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\u0002J\t\u00102\u001a\u000203H\u00d6\u0001J\u000e\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u00066"}, d2={"Lorg/openrndr/shape/Ellipse;", "", "x", "", "y", "xRadius", "yRadius", "(DDDD)V", "center", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/math/Vector2;DD)V", "getCenter", "()Lorg/openrndr/math/Vector2;", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "getXRadius", "()D", "getYRadius", "component1", "component2", "component3", "copy", "div", "scale", "equals", "", "other", "hashCode", "", "minus", "right", "moved", "Lorg/openrndr/shape/OrientedEllipse;", "offset", "movedTo", "position", "plus", "scaled", "xScale", "yScale", "scaledTo", "xFitRadius", "yFitRadius", "times", "toString", "", "withOrientation", "degrees", "openrndr-core"})
public final class Ellipse {
    @NotNull
    private final Vector2 center;
    private final double xRadius;
    private final double yRadius;

    @NotNull
    public final OrientedEllipse moved(@NotNull Vector2 offset2) {
        Intrinsics.checkNotNullParameter(offset2, "offset");
        return new OrientedEllipse(this.center.plus(offset2), this.xRadius, this.yRadius, 0.0, 8, null);
    }

    @NotNull
    public final OrientedEllipse movedTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return new OrientedEllipse(position, this.xRadius, this.yRadius, 0.0, 8, null);
    }

    @NotNull
    public final OrientedEllipse scaled(double xScale, double yScale) {
        return new OrientedEllipse(this.center, this.xRadius * xScale, this.yRadius * yScale, 0.0, 8, null);
    }

    public static /* synthetic */ OrientedEllipse scaled$default(Ellipse ellipse, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return ellipse.scaled(d, d2);
    }

    @NotNull
    public final OrientedEllipse scaledTo(double xFitRadius, double yFitRadius) {
        return new OrientedEllipse(this.center, xFitRadius, yFitRadius, 0.0, 8, null);
    }

    public static /* synthetic */ OrientedEllipse scaledTo$default(Ellipse ellipse, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return ellipse.scaledTo(d, d2);
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final OrientedEllipse withOrientation(double degrees) {
        return new OrientedEllipse(this.center, this.xRadius, this.yRadius, degrees);
    }

    @NotNull
    public final ShapeContour getContour() {
        return this.withOrientation(0.0).getContour();
    }

    @NotNull
    public final Ellipse times(double scale2) {
        return new Ellipse(this.center.times(scale2), this.xRadius * scale2, this.yRadius * scale2);
    }

    @NotNull
    public final Ellipse div(double scale2) {
        return new Ellipse(this.center.div(scale2), this.xRadius / scale2, this.yRadius / scale2);
    }

    @NotNull
    public final Ellipse plus(@NotNull Ellipse right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Ellipse(this.center.plus(right.center), this.xRadius + right.xRadius, this.yRadius + right.yRadius);
    }

    @NotNull
    public final Ellipse minus(@NotNull Ellipse right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Ellipse(this.center.minus(right.center), this.xRadius - right.xRadius, this.yRadius - right.yRadius);
    }

    @NotNull
    public final Vector2 getCenter() {
        return this.center;
    }

    public final double getXRadius() {
        return this.xRadius;
    }

    public final double getYRadius() {
        return this.yRadius;
    }

    public Ellipse(@NotNull Vector2 center, double xRadius, double yRadius) {
        Intrinsics.checkNotNullParameter(center, "center");
        this.center = center;
        this.xRadius = xRadius;
        this.yRadius = yRadius;
    }

    public Ellipse(double x, double y, double xRadius, double yRadius) {
        this(new Vector2(x, y), xRadius, yRadius);
    }

    @NotNull
    public final Vector2 component1() {
        return this.center;
    }

    public final double component2() {
        return this.xRadius;
    }

    public final double component3() {
        return this.yRadius;
    }

    @NotNull
    public final Ellipse copy(@NotNull Vector2 center, double xRadius, double yRadius) {
        Intrinsics.checkNotNullParameter(center, "center");
        return new Ellipse(center, xRadius, yRadius);
    }

    public static /* synthetic */ Ellipse copy$default(Ellipse ellipse, Vector2 vector2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = ellipse.center;
        }
        if ((n & 2) != 0) {
            d = ellipse.xRadius;
        }
        if ((n & 4) != 0) {
            d2 = ellipse.yRadius;
        }
        return ellipse.copy(vector2, d, d2);
    }

    @NotNull
    public String toString() {
        return "Ellipse(center=" + this.center + ", xRadius=" + this.xRadius + ", yRadius=" + this.yRadius + ")";
    }

    public int hashCode() {
        Vector2 vector2 = this.center;
        long l = Double.doubleToLongBits(this.xRadius);
        long l2 = Double.doubleToLongBits(this.yRadius);
        return ((vector2 != null ? ((Object)vector2).hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Ellipse)) break block3;
                Ellipse ellipse = (Ellipse)object;
                if (!Intrinsics.areEqual(this.center, ellipse.center) || Double.compare(this.xRadius, ellipse.xRadius) != 0 || Double.compare(this.yRadius, ellipse.yRadius) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

