/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u0016\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002H\u0007\u001a\u0016\u0010\r\u001a\u00020\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0007\u001a$\u0010\u000f\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\b\"\u001b\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005\u00a8\u0006\u0013"}, d2={"bounds", "Lorg/openrndr/shape/Rectangle;", "", "Lorg/openrndr/math/Vector2;", "getVector2Bounds", "(Ljava/util/List;)Lorg/openrndr/shape/Rectangle;", "getRectangleBounds", "intersects", "", "a", "b", "rectangleBounds", "rectangles", "vector2Bounds", "points", "map", "sourceRectangle", "targetRectangle", "clamp", "openrndr-core"})
public final class RectangleKt {
    @Deprecated(message="use List<Vector2>.bounds instead")
    @NotNull
    public static final Rectangle vector2Bounds(@NotNull List<Vector2> points) {
        Intrinsics.checkNotNullParameter(points, "points");
        return RectangleKt.getVector2Bounds(points);
    }

    @JvmName(name="getVector2Bounds")
    @NotNull
    public static final Rectangle getVector2Bounds(@NotNull List<Vector2> $this$bounds) {
        Intrinsics.checkNotNullParameter($this$bounds, "$this$bounds");
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        Iterable $this$forEach$iv = $this$bounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vector2 it = (Vector2)element$iv;
            boolean bl = false;
            double d = minX;
            double d2 = it.getX();
            boolean bl2 = false;
            minX = Math.min(d, d2);
            d = maxX;
            d2 = it.getX();
            bl2 = false;
            maxX = Math.max(d, d2);
            d = minY;
            d2 = it.getY();
            bl2 = false;
            minY = Math.min(d, d2);
            d = maxY;
            d2 = it.getY();
            bl2 = false;
            maxY = Math.max(d, d2);
        }
        return new Rectangle(new Vector2(minX, minY), maxX - minX, maxY - minY);
    }

    @Deprecated(message="use List<Rectangle>.bounds instead")
    @NotNull
    public static final Rectangle rectangleBounds(@NotNull List<Rectangle> rectangles) {
        Intrinsics.checkNotNullParameter(rectangles, "rectangles");
        return RectangleKt.getRectangleBounds(rectangles);
    }

    @JvmName(name="getRectangleBounds")
    @NotNull
    public static final Rectangle getRectangleBounds(@NotNull List<Rectangle> $this$bounds) {
        Intrinsics.checkNotNullParameter($this$bounds, "$this$bounds");
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        Iterable $this$forEach$iv = $this$bounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rectangle it = (Rectangle)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual(it, Rectangle.Companion.getEMPTY()) ^ true)) continue;
            double d = minX;
            double d2 = it.getX();
            boolean bl2 = false;
            minX = Math.min(d, d2);
            d = maxX;
            d2 = it.getX() + it.getWidth();
            bl2 = false;
            maxX = Math.max(d, d2);
            d = minY;
            d2 = it.getY();
            bl2 = false;
            minY = Math.min(d, d2);
            d = maxY;
            d2 = it.getY() + it.getHeight();
            bl2 = false;
            maxY = Math.max(d, d2);
        }
        return new Rectangle(new Vector2(minX, minY), maxX - minX, maxY - minY);
    }

    public static final boolean intersects(@NotNull Rectangle a2, @NotNull Rectangle b) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        boolean above = a2.getY() + a2.getHeight() < b.getY();
        boolean below = a2.getY() > b.getY() + b.getHeight();
        boolean rightOf = a2.getX() > b.getX() + b.getWidth();
        boolean leftOf = a2.getX() + a2.getWidth() < b.getX();
        return !above && !below && !leftOf && !rightOf;
    }

    @NotNull
    public static final Vector2 map(@NotNull Vector2 $this$map, @NotNull Rectangle sourceRectangle, @NotNull Rectangle targetRectangle, boolean clamp) {
        Intrinsics.checkNotNullParameter($this$map, "$this$map");
        Intrinsics.checkNotNullParameter(sourceRectangle, "sourceRectangle");
        Intrinsics.checkNotNullParameter(targetRectangle, "targetRectangle");
        Vector2 remapped = $this$map.minus(sourceRectangle.getCorner()).div(sourceRectangle.getDimensions()).times(targetRectangle.getDimensions()).plus(targetRectangle.getCorner());
        return clamp ? FunctionsKt.clamp(remapped, targetRectangle.getCorner(), targetRectangle.getCorner().plus(targetRectangle.getDimensions())) : remapped;
    }

    public static /* synthetic */ Vector2 map$default(Vector2 vector2, Rectangle rectangle, Rectangle rectangle2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return RectangleKt.map(vector2, rectangle, rectangle2, bl);
    }
}

