/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a)\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"sampleEquidistant", "", "Lorg/openrndr/math/Vector2;", "segments", "count", "", "Lorg/openrndr/math/Vector3;", "pieces", "sampleEquidistant3D", "openrndr-core"})
public final class ShapeToolsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Vector2> sampleEquidistant(@NotNull List<Vector2> segments, int count2) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        boolean bl = false;
        List result2 = new ArrayList();
        if (segments.isEmpty()) {
            return result2;
        }
        double totalLength = 0.0;
        int n = 0;
        int n2 = segments.size() - 1;
        while (n < n2) {
            void i;
            totalLength += segments.get((int)i).minus(segments.get((int)(i + true))).getLength();
            ++i;
        }
        double spacing = totalLength / (double)(count2 - 1);
        double remaining = 0.0;
        Vector2 cursor = null;
        if (count2 > 0) {
            result2.add(new Vector2(segments.get(0).getX(), segments.get(0).getY()));
        }
        int n3 = 0;
        int n4 = segments.size() - 1;
        while (n3 < n4) {
            void i;
            Vector2 direction = segments.get((int)(i + true)).minus(segments.get((int)i));
            double segmentLength = direction.getLength();
            if (segmentLength + remaining < spacing) {
                remaining += segmentLength;
            } else {
                double skipLength = RangesKt.coerceAtLeast(spacing - remaining, 0.0);
                int pointsFromSegment = 1 + MathKt.roundToInt((segmentLength - skipLength) / spacing);
                double skipT = skipLength / segmentLength;
                double spaceT = spacing / segmentLength;
                Vector2 start2 = segments.get((int)i);
                double t2 = skipT;
                int n5 = 0;
                int n6 = pointsFromSegment;
                while (n5 < n6) {
                    void n7;
                    if (t2 < 1.000001) {
                        cursor = start2.plus(direction.times(t2));
                        t2 += spaceT;
                        result2.add(cursor);
                    }
                    ++n7;
                }
                remaining = (1.0 - (t2 - spaceT)) * segmentLength;
            }
            ++i;
        }
        if (count2 >= 2) {
            if (result2.size() == count2) {
                result2.set(CollectionsKt.getLastIndex(result2), CollectionsKt.last(segments));
            } else {
                result2.add(CollectionsKt.last(segments));
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="sampleEquidistant3D")
    @NotNull
    public static final List<Vector3> sampleEquidistant3D(@NotNull List<Vector3> pieces, int count2) {
        Intrinsics.checkNotNullParameter(pieces, "pieces");
        boolean bl = false;
        List result2 = new ArrayList();
        if (pieces.isEmpty()) {
            return result2;
        }
        double totalLength = 0.0;
        int n = 0;
        int n2 = pieces.size() - 1;
        while (n < n2) {
            void i;
            totalLength += pieces.get((int)i).minus(pieces.get((int)(i + true))).getLength();
            ++i;
        }
        double spacing = totalLength / (double)count2;
        double runLength = 0.0;
        Vector3 cursor = null;
        result2.add(pieces.get(0));
        int n3 = 0;
        int n4 = pieces.size() - 1;
        while (n3 < n4) {
            void i;
            Vector3 piece = pieces.get((int)i).minus(pieces.get((int)(i + true)));
            double pieceLength = piece.getLength();
            if (pieceLength + runLength < spacing) {
                runLength += pieceLength;
            } else {
                double skip = RangesKt.coerceAtLeast(spacing - runLength, 0.0);
                if (skip < 0.0) {
                    throw (Throwable)new RuntimeException("skip < 0 - " + skip);
                }
                int newPieces = (int)((pieceLength - skip) / spacing);
                double skipT = skip / pieceLength;
                double spaceT = spacing / pieceLength;
                Vector3 direction = pieces.get((int)(i + true)).minus(pieces.get((int)i));
                Vector3 start2 = pieces.get((int)i);
                double t2 = skipT;
                int n5 = 0;
                int n6 = 1 + newPieces;
                while (n5 < n6) {
                    void n7;
                    cursor = start2.plus(direction.times(t2));
                    t2 += spaceT;
                    result2.add(cursor);
                    ++n7;
                }
                runLength = pieceLength - skip - (double)newPieces * spacing;
            }
            ++i;
        }
        result2.add(pieces.get(pieces.size() - 1));
        return result2;
    }
}

