/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector3;
import org.openrndr.shape.LineSegment3D;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0010\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J0\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/openrndr/shape/internal/BezierCubicSampler3D;", "", "()V", "direction", "", "Lorg/openrndr/math/Vector3;", "distanceTolerance", "", "getDistanceTolerance", "()D", "setDistanceTolerance", "(D)V", "distanceToleranceSquare", "points", "recursionLimit", "", "sample", "Lkotlin/Pair;", "", "x1", "x2", "x3", "x4", "", "level", "Companion", "openrndr-core"})
public final class BezierCubicSampler3D {
    private final int recursionLimit;
    private final List<Vector3> points;
    private final List<Vector3> direction;
    private double distanceToleranceSquare;
    private double distanceTolerance;
    private static final double colinearityEpsilon;
    private static final double angleToleranceEpsilon;
    public static final Companion Companion;

    public final double getDistanceTolerance() {
        return this.distanceTolerance;
    }

    public final void setDistanceTolerance(double d) {
        this.distanceTolerance = d;
    }

    @NotNull
    public final Pair<List<Vector3>, List<Vector3>> sample(@NotNull Vector3 x1, @NotNull Vector3 x2, @NotNull Vector3 x3, @NotNull Vector3 x4) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        Intrinsics.checkNotNullParameter(x4, "x4");
        this.distanceToleranceSquare = this.distanceTolerance * this.distanceTolerance;
        this.points.clear();
        this.points.add(x1);
        this.sample(x1, x2, x3, x4, 0);
        this.points.add(x4);
        this.direction.add(x4.minus(x3));
        return new Pair<List<Vector3>, List<Vector3>>(this.points, this.direction);
    }

    private final void sample(Vector3 x1, Vector3 x2, Vector3 x3, Vector3 x4, int level) {
        if (level > this.recursionLimit) {
            return;
        }
        Vector3 x12 = x1.plus(x2).times(0.5);
        Vector3 x23 = x2.plus(x3).times(0.5);
        Vector3 x34 = x3.plus(x4).times(0.5);
        Vector3 x123 = x12.plus(x23).times(0.5);
        Vector3 x234 = x23.plus(x34).times(0.5);
        Vector3 x1234 = x123.plus(x234).times(0.5);
        double dx = x4.getX() - x1.getX();
        double dy = x4.getY() - x1.getY();
        double dz = x4.getZ() - x1.getZ();
        double d2 = new LineSegment3D(x1, x4).squaredDistance(x2);
        double d3 = new LineSegment3D(x1, x4).squaredDistance(x3);
        boolean p1 = d2 > colinearityEpsilon;
        boolean p0 = d3 > colinearityEpsilon;
        int p = (p1 ? 2 : 0) + (p0 ? 1 : 0);
        double k = 0.0;
        double da1 = 0.0;
        double da2 = 0.0;
        double da3 = 0.0;
        switch (p) {
            case 0: {
                k = dx * dx + dy * dy + dz * dz;
                if (k == 0.0) {
                    d2 = x1.minus(x2).getSquaredLength();
                    d3 = x4.minus(x3).getSquaredLength();
                } else {
                    k = 1.0 / k;
                    da1 = x2.getX() - x1.getX();
                    da2 = x2.getY() - x1.getY();
                    da3 = x2.getZ() - x1.getZ();
                    d2 = k * (da1 * dx + da2 * dy + da3 * dz);
                    da1 = x3.getX() - x1.getX();
                    da2 = x3.getY() - x1.getY();
                    da3 = x3.getZ() - x1.getZ();
                    d3 = k * (da1 * dx + da2 * dy + da3 * dz);
                    if (d2 > 0.0 && d2 < 1.0 && d3 > 0.0 && d3 < 1.0) {
                        return;
                    }
                    d2 = d2 <= 0.0 ? x2.minus(x1).getSquaredLength() : (d2 >= 1.0 ? x2.minus(x4).getSquaredLength() : BezierCubicSampler3D.Companion.squareDistance(x2.getX(), x2.getY(), x2.getZ(), x1.getX() + d2 * dx, x1.getY() + d2 * dy, x1.getZ() + d2 * dz));
                    double d = d3 <= 0.0 ? BezierCubicSampler3D.Companion.squareDistance(x3.getX(), x3.getY(), x3.getZ(), x1.getX(), x1.getY(), x1.getZ()) : (d3 = d3 >= 1.0 ? BezierCubicSampler3D.Companion.squareDistance(x3.getX(), x3.getY(), x3.getZ(), x4.getX(), x4.getY(), x4.getZ()) : BezierCubicSampler3D.Companion.squareDistance(x3.getX(), x3.getY(), x3.getZ(), x1.getX() + d3 * dx, x1.getY() + d3 * dy, x1.getZ() + d3 * dz));
                }
                if (d2 > d3) {
                    if (!(d2 < this.distanceToleranceSquare)) break;
                    this.points.add(new Vector3(x2.getX(), x2.getY(), x2.getZ()));
                    this.direction.add(x4.minus(x1));
                    return;
                }
                if (!(d3 < this.distanceToleranceSquare)) break;
                this.points.add(new Vector3(x3.getX(), x3.getY(), x3.getZ()));
                this.direction.add(x4.minus(x1));
                return;
            }
            case 1: {
                if (!(d3 * d3 <= this.distanceToleranceSquare * (dx * dx + dy * dy + dz * dz))) break;
                this.points.add(x23);
                this.direction.add(x4.minus(x1));
                return;
            }
            case 2: {
                if (!(d2 * d2 <= this.distanceToleranceSquare * (dx * dx + dy * dy + dz * dz))) break;
                this.points.add(x23);
                this.direction.add(x4.minus(x1));
                return;
            }
            case 3: {
                if (!((d2 + d3) * (d2 + d3) <= this.distanceToleranceSquare * (dx * dx + dy * dy + dz * dz))) break;
                this.points.add(x23);
                this.direction.add(x4.minus(x1));
                return;
            }
        }
        this.sample(x1, x12, x123, x1234, level + 1);
        this.sample(x1234, x234, x34, x4, level + 1);
    }

    public BezierCubicSampler3D() {
        this.recursionLimit = 8;
        boolean bl = false;
        this.points = new ArrayList();
        bl = false;
        this.direction = new ArrayList();
        this.distanceTolerance = 0.5;
    }

    static {
        Companion = new Companion(null);
        colinearityEpsilon = 1.0E-30;
        angleToleranceEpsilon = 0.01;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/openrndr/shape/internal/BezierCubicSampler3D$Companion;", "", "()V", "angleToleranceEpsilon", "", "colinearityEpsilon", "squareDistance", "x", "y", "z", "x1", "y1", "z1", "openrndr-core"})
    public static final class Companion {
        private final double squareDistance(double x, double y, double z, double x1, double y1, double z1) {
            double dx = x1 - x;
            double dy = y1 - y;
            double dz = z1 - z;
            return dx * dx + dy * dy + dz * dz;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

