/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.openrndr.math.Vector2;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.Color;
import org.openrndr.shape.CompositionColor;
import org.openrndr.shape.CompositionStrokeWeight;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.InheritColor;
import org.openrndr.shape.InheritStrokeWeight;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.StrokeWeight;
import org.openrndr.svg.Command;
import org.openrndr.svg.SVGElement;
import org.openrndr.svg.SVGLoaderKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lorg/openrndr/svg/SVGPath;", "Lorg/openrndr/svg/SVGElement;", "()V", "commands", "", "Lorg/openrndr/svg/Command;", "getCommands", "()Ljava/util/List;", "fill", "Lorg/openrndr/shape/CompositionColor;", "getFill", "()Lorg/openrndr/shape/CompositionColor;", "setFill", "(Lorg/openrndr/shape/CompositionColor;)V", "stroke", "getStroke", "setStroke", "strokeWeight", "Lorg/openrndr/shape/CompositionStrokeWeight;", "getStrokeWeight", "()Lorg/openrndr/shape/CompositionStrokeWeight;", "setStrokeWeight", "(Lorg/openrndr/shape/CompositionStrokeWeight;)V", "compounds", "", "parseDrawAttributes", "", "e", "Lorg/jsoup/nodes/Element;", "shape", "Lorg/openrndr/shape/Shape;", "Companion", "openrndr-svg"})
public final class SVGPath
extends SVGElement {
    @NotNull
    private final List<Command> commands;
    @NotNull
    private CompositionColor fill;
    @NotNull
    private CompositionColor stroke;
    @NotNull
    private CompositionStrokeWeight strokeWeight;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Command> getCommands() {
        return this.commands;
    }

    @NotNull
    public final CompositionColor getFill() {
        return this.fill;
    }

    public final void setFill(@NotNull CompositionColor compositionColor) {
        Intrinsics.checkNotNullParameter(compositionColor, "<set-?>");
        this.fill = compositionColor;
    }

    @NotNull
    public final CompositionColor getStroke() {
        return this.stroke;
    }

    public final void setStroke(@NotNull CompositionColor compositionColor) {
        Intrinsics.checkNotNullParameter(compositionColor, "<set-?>");
        this.stroke = compositionColor;
    }

    @NotNull
    public final CompositionStrokeWeight getStrokeWeight() {
        return this.strokeWeight;
    }

    public final void setStrokeWeight(@NotNull CompositionStrokeWeight compositionStrokeWeight) {
        Intrinsics.checkNotNullParameter(compositionStrokeWeight, "<set-?>");
        this.strokeWeight = compositionStrokeWeight;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SVGPath> compounds() {
        int index;
        boolean bl;
        int n;
        boolean bl2 = false;
        List compounds = new ArrayList();
        boolean bl3 = false;
        List compoundIndices = new ArrayList();
        Iterable $this$forEachIndexed$iv = this.commands;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            n = index$iv++;
            bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Command command = (Command)item$iv;
            index = n;
            boolean bl4 = false;
            if (!Intrinsics.areEqual(it.getOp(), "M") && !Intrinsics.areEqual(it.getOp(), "m")) continue;
            compoundIndices.add(index);
        }
        $this$forEachIndexed$iv = compoundIndices;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            n = index$iv++;
            bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int it = ((Number)item$iv).intValue();
            index = n;
            boolean bl5 = false;
            int cs = ((Number)compoundIndices.get(index)).intValue();
            int ce = index + 1 < compoundIndices.size() ? ((Number)compoundIndices.get(index + 1)).intValue() : this.commands.size();
            SVGPath path = new SVGPath();
            path.commands.addAll((Collection<Command>)this.commands.subList(cs, ce));
            compounds.add(path);
        }
        return compounds;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shape shape() {
        void $this$mapTo$iv$iv;
        void cursor;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new Vector2(0.0, 0.0);
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = Vector2.copy$default((Vector2)cursor.element, 0.0, 0.0, 3, null);
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = new Vector2(0.0, 0.0);
        Iterable $this$map$iv = this.compounds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void closed;
            void compound;
            SVGPath sVGPath = (SVGPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            List segments = new ArrayList();
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            Iterable $this$forEach$iv = compound.commands;
            boolean $i$f$forEach = false;
            block39: for (Object element$iv : $this$forEach$iv) {
                Command command = (Command)element$iv;
                boolean bl3 = false;
                switch (command.getOp()) {
                    case "a": 
                    case "A": {
                        void relativeControl;
                        void anchor;
                        void end2;
                        Object object = command.getOperands();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Object object2 = object;
                        boolean bl6 = false;
                        Object rx = object2[0];
                        Object ry = object2[1];
                        Object xAxisRot = object2[2];
                        boolean largeArcFlag = SVGLoaderKt.toBoolean((double)object2[3]);
                        boolean sweepFlag = SVGLoaderKt.toBoolean((double)object2[4]);
                        Ref.ObjectRef objectRef4 = new Ref.ObjectRef();
                        objectRef4.element = new Vector2((double)object2[5], (double)object2[6]);
                        if (Intrinsics.areEqual(command.getOp(), "a")) {
                            end2.element = ((Vector2)end2.element).plus((Vector2)cursor.element);
                        }
                        List<Segment> c = ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>((double)rx, (double)ry, (double)xAxisRot, largeArcFlag, sweepFlag, (Ref.ObjectRef)end2, command, segments, (Ref.BooleanRef)closed, (Ref.ObjectRef)cursor, (Ref.ObjectRef)anchor, (Ref.ObjectRef)relativeControl){
                            final /* synthetic */ double $rx;
                            final /* synthetic */ double $ry;
                            final /* synthetic */ double $xAxisRot;
                            final /* synthetic */ boolean $largeArcFlag;
                            final /* synthetic */ boolean $sweepFlag;
                            final /* synthetic */ Ref.ObjectRef $end;
                            final /* synthetic */ Command $command$inlined;
                            final /* synthetic */ List $segments$inlined;
                            final /* synthetic */ Ref.BooleanRef $closed$inlined;
                            final /* synthetic */ Ref.ObjectRef $cursor$inlined;
                            final /* synthetic */ Ref.ObjectRef $anchor$inlined;
                            final /* synthetic */ Ref.ObjectRef $relativeControl$inlined;
                            {
                                this.$rx = d;
                                this.$ry = d2;
                                this.$xAxisRot = d3;
                                this.$largeArcFlag = bl;
                                this.$sweepFlag = bl2;
                                this.$end = objectRef;
                                this.$command$inlined = command;
                                this.$segments$inlined = list;
                                this.$closed$inlined = booleanRef;
                                this.$cursor$inlined = objectRef2;
                                this.$anchor$inlined = objectRef3;
                                this.$relativeControl$inlined = objectRef4;
                                super(1);
                            }

                            public final void invoke(@NotNull ContourBuilder $this$contour) {
                                Intrinsics.checkNotNullParameter($this$contour, "$receiver");
                                $this$contour.moveTo((Vector2)this.$cursor$inlined.element);
                                $this$contour.arcTo(this.$rx, this.$ry, this.$xAxisRot, this.$largeArcFlag, this.$sweepFlag, (Vector2)this.$end.element);
                            }
                        }).getSegments();
                        Collection collection2 = segments;
                        boolean bl7 = false;
                        CollectionsKt.addAll(collection2, (Iterable)c);
                        cursor.element = (Vector2)end2.element;
                        break;
                    }
                    case "M": {
                        cursor.element = command.vector(0, 1);
                        anchor.element = (Vector2)cursor.element;
                        List<Vector2> allPoints = command.vectors();
                        int n = 1;
                        int n2 = allPoints.size();
                        while (n < n2) {
                            void i;
                            Vector2 vector2 = allPoints.get((int)i);
                            Collection bl6 = segments;
                            Segment segment = new Segment((Vector2)cursor.element, vector2, false, 4, null);
                            boolean bl8 = false;
                            bl6.add(segment);
                            cursor.element = vector2;
                            ++i;
                        }
                        continue block39;
                    }
                    case "m": {
                        List<Vector2> allPoints = command.vectors();
                        cursor.element = ((Vector2)cursor.element).plus(command.vector(0, 1));
                        anchor.element = (Vector2)cursor.element;
                        int n = allPoints.size();
                        for (int i = 1; i < n; ++i) {
                            Vector2 vector2 = allPoints.get(i);
                            Collection bl6 = segments;
                            Segment segment = new Segment((Vector2)cursor.element, ((Vector2)cursor.element).plus(vector2), false, 4, null);
                            boolean bl9 = false;
                            bl6.add(segment);
                            cursor.element = ((Vector2)cursor.element).plus(vector2);
                        }
                        continue block39;
                    }
                    case "L": {
                        List<Vector2> allPoints = command.vectors();
                        for (Vector2 point2 : allPoints) {
                            Collection collection3 = segments;
                            Segment bl6 = new Segment((Vector2)cursor.element, point2, false, 4, null);
                            boolean bl10 = false;
                            collection3.add(bl6);
                            cursor.element = point2;
                        }
                        continue block39;
                    }
                    case "l": {
                        List<Vector2> allPoints = command.vectors();
                        for (Vector2 point : allPoints) {
                            Vector2 vector2 = ((Vector2)cursor.element).plus(point);
                            Collection bl6 = segments;
                            Segment segment = new Segment((Vector2)cursor.element, vector2, false, 4, null);
                            boolean bl11 = false;
                            bl6.add(segment);
                            cursor.element = vector2;
                        }
                        continue block39;
                    }
                    case "h": {
                        boolean bl12;
                        Segment segment;
                        for (double operand : command.getOperands()) {
                            Vector2 startCursor = (Vector2)cursor.element;
                            Vector2 target3 = startCursor.plus(new Vector2(operand, 0.0));
                            Collection collection4 = segments;
                            segment = new Segment((Vector2)cursor.element, target3, false, 4, null);
                            bl12 = false;
                            collection4.add(segment);
                            cursor.element = target3;
                        }
                        continue block39;
                    }
                    case "H": {
                        for (double operand : command.getOperands()) {
                            Vector2 target4 = new Vector2(operand, ((Vector2)cursor.element).getY());
                            Collection target3 = segments;
                            Segment segment = new Segment((Vector2)cursor.element, target4, false, 4, null);
                            boolean bl13 = false;
                            target3.add(segment);
                            cursor.element = target4;
                        }
                        continue block39;
                    }
                    case "v": {
                        for (double operand : command.getOperands()) {
                            Vector2 target5 = ((Vector2)cursor.element).plus(new Vector2(0.0, operand));
                            Collection target3 = segments;
                            Segment segment = new Segment((Vector2)cursor.element, target5, false, 4, null);
                            boolean bl14 = false;
                            target3.add(segment);
                            cursor.element = target5;
                        }
                        continue block39;
                    }
                    case "V": {
                        for (double operand : command.getOperands()) {
                            Vector2 target6 = new Vector2(((Vector2)cursor.element).getX(), operand);
                            Collection target3 = segments;
                            Segment segment = new Segment((Vector2)cursor.element, target6, false, 4, null);
                            boolean bl15 = false;
                            target3.add(segment);
                            cursor.element = target6;
                        }
                        continue block39;
                    }
                    case "C": {
                        boolean bl12;
                        Segment segment;
                        List<Vector2> allPoints = command.vectors();
                        Iterable $this$forEach$iv2 = CollectionsKt.windowed$default(allPoints, 3, 3, false, 4, null);
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            List points = (List)element$iv2;
                            boolean bl16 = false;
                            Collection collection5 = segments;
                            segment = new Segment((Vector2)cursor.element, (Vector2)points.get(0), (Vector2)points.get(1), (Vector2)points.get(2), false, 16, null);
                            bl12 = false;
                            collection5.add(segment);
                            cursor.element = (Vector2)points.get(2);
                            relativeControl.element = ((Vector2)points.get(1)).minus((Vector2)points.get(2));
                        }
                        continue block39;
                    }
                    case "c": {
                        boolean bl12;
                        Segment segment;
                        List<Vector2> allPoints = command.vectors();
                        Iterable $this$forEach$iv3 = CollectionsKt.windowed$default(allPoints, 3, 3, false, 4, null);
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv3 : $this$forEach$iv3) {
                            List points = (List)element$iv3;
                            boolean bl17 = false;
                            Collection collection6 = segments;
                            segment = new Segment((Vector2)cursor.element, ((Vector2)cursor.element).plus((Vector2)points.get(0)), ((Vector2)cursor.element).plus((Vector2)points.get(1)), ((Vector2)cursor.element).plus((Vector2)points.get(2)), false, 16, null);
                            bl12 = false;
                            collection6.add(segment);
                            relativeControl.element = ((Vector2)cursor.element).plus((Vector2)points.get(1)).minus(((Vector2)cursor.element).plus((Vector2)points.get(2)));
                            cursor.element = ((Vector2)cursor.element).plus((Vector2)points.get(2));
                        }
                        continue block39;
                    }
                    case "Q": {
                        List<Vector2> allPoints = command.vectors();
                        if (allPoints.size() % 2 != 0) {
                            String $this$forEach$iv3 = "invalid number of operands for Q-op (operands=" + allPoints.size() + ')';
                            boolean $i$f$forEach3 = false;
                            throw (Throwable)new IllegalStateException($this$forEach$iv3.toString());
                        }
                        int $this$forEach$iv3 = 0;
                        int $i$f$forEach3 = allPoints.size() / 2;
                        while ($this$forEach$iv3 < $i$f$forEach3) {
                            void c;
                            List<Vector2> list = allPoints.subList((int)(c * 2), (int)(c * 2 + 2));
                            Collection element$iv3 = segments;
                            Segment segment = new Segment((Vector2)cursor.element, list.get(0), list.get(1), false, 8, null);
                            boolean bl16 = false;
                            element$iv3.add(segment);
                            cursor.element = list.get(1);
                            relativeControl.element = list.get(0).minus(list.get(1));
                            ++c;
                        }
                        continue block39;
                    }
                    case "q": {
                        List<Vector2> allPoints = command.vectors();
                        if (allPoints.size() % 2 != 0) {
                            String c = "invalid number of operands for q-op (operands=" + allPoints.size() + ')';
                            boolean $i$f$forEach3 = false;
                            throw (Throwable)new IllegalStateException(c.toString());
                        }
                        int $i$f$forEach3 = allPoints.size() / 2;
                        for (int c = 0; c < $i$f$forEach3; ++c) {
                            List<Vector2> list = allPoints.subList(c * 2, c * 2 + 2);
                            Vector2 target7 = ((Vector2)cursor.element).plus(list.get(1));
                            Collection collection7 = segments;
                            Segment segment = new Segment((Vector2)cursor.element, ((Vector2)cursor.element).plus(list.get(0)), target7, false, 8, null);
                            boolean bl17 = false;
                            collection7.add(segment);
                            relativeControl.element = ((Vector2)cursor.element).plus(list.get(0)).minus(((Vector2)cursor.element).plus(list.get(1)));
                            cursor.element = target7;
                        }
                        continue block39;
                    }
                    case "s": {
                        void relativeControl;
                        Vector2 reflected = ((Vector2)relativeControl.element).times(-1.0);
                        Vector2 cp0 = ((Vector2)cursor.element).plus(reflected);
                        Vector2 cp1 = ((Vector2)cursor.element).plus(command.vector(0, 1));
                        Vector2 vector2 = ((Vector2)cursor.element).plus(command.vector(2, 3));
                        Collection collection8 = segments;
                        Segment segment = new Segment((Vector2)cursor.element, cp0, cp1, vector2, false, 16, null);
                        boolean bl18 = false;
                        collection8.add(segment);
                        cursor.element = vector2;
                        relativeControl.element = cp1.minus(vector2);
                        break;
                    }
                    case "S": {
                        void relativeControl;
                        Vector2 reflected = ((Vector2)relativeControl.element).times(-1.0);
                        Vector2 cp0 = ((Vector2)cursor.element).plus(reflected);
                        Vector2 cp1 = command.vector(0, 1);
                        Vector2 vector2 = command.vector(2, 3);
                        Collection collection9 = segments;
                        Segment segment = new Segment((Vector2)cursor.element, cp0, cp1, vector2, false, 16, null);
                        boolean bl18 = false;
                        collection9.add(segment);
                        cursor.element = vector2;
                        relativeControl.element = cp1.minus(vector2);
                        break;
                    }
                    case "Z": 
                    case "z": {
                        void anchor;
                        Object object;
                        if (((Vector2)cursor.element).minus((Vector2)anchor.element).getLength() >= 0.001) {
                            object = segments;
                            Segment segment = new Segment((Vector2)cursor.element, (Vector2)anchor.element, false, 4, null);
                            boolean bl21 = false;
                            object.add(segment);
                        }
                        closed.element = true;
                        break;
                    }
                    default: {
                        Object object = "unsupported op: " + command.getOp() + ", is this a TinySVG 1.x document?";
                        boolean bl22 = false;
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                }
            }
            ShapeContour shapeContour = new ShapeContour(segments, closed.element, YPolarity.CW_NEGATIVE_Y);
            collection.add(shapeContour);
        }
        List contours = (List)destination$iv$iv;
        return new Shape(contours);
    }

    public final void parseDrawAttributes(@NotNull Element e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.hasAttr("fill")) {
            String string = e.attr("fill");
            Intrinsics.checkNotNullExpressionValue(string, "e.attr(\"fill\")");
            this.fill = new Color(SVGLoaderKt.parseColor(string));
        }
        if (e.hasAttr("stroke")) {
            String string = e.attr("stroke");
            Intrinsics.checkNotNullExpressionValue(string, "e.attr(\"stroke\")");
            this.stroke = new Color(SVGLoaderKt.parseColor(string));
        }
        if (e.hasAttr("stroke-width")) {
            String string = e.attr("stroke-width");
            Intrinsics.checkNotNullExpressionValue(string, "e.attr(\"stroke-width\")");
            String string2 = string;
            boolean bl = false;
            this.strokeWeight = new StrokeWeight(Double.parseDouble(string2));
        }
        String string = e.attr("style");
        Intrinsics.checkNotNullExpressionValue(string, "e.attr(\"style\")");
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, new String[]{";"}, false, 0, 6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            List tokens = StringsKt.split$default((CharSequence)it, new String[]{":"}, false, 0, 6, null);
            String string3 = (String)tokens.get(0);
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
            string3 = string5;
            bl2 = false;
            String string6 = string3;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String attribute = ((Object)StringsKt.trim((CharSequence)string6)).toString();
            Function0<String> $fun$value$1 = new Function0<String>(tokens){
                final /* synthetic */ List $tokens;

                @NotNull
                public final String invoke() {
                    String string;
                    if (this.$tokens.size() >= 2) {
                        String string2 = (String)this.$tokens.get(1);
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    } else {
                        string = "";
                    }
                    return string;
                }
                {
                    this.$tokens = list;
                    super(0);
                }
            };
            switch (attribute) {
                case "fill": {
                    this.fill = new Color(SVGLoaderKt.parseColor((String)$fun$value$1.invoke()));
                    break;
                }
                case "stroke": {
                    this.stroke = new Color(SVGLoaderKt.parseColor((String)$fun$value$1.invoke()));
                    break;
                }
                case "stroke-width": {
                    Object object = $fun$value$1.invoke();
                    boolean bl3 = false;
                    this.strokeWeight = new StrokeWeight(Double.parseDouble((String)object));
                }
            }
        }
    }

    public SVGPath() {
        super(null);
        boolean bl = false;
        this.commands = new ArrayList();
        this.fill = InheritColor.INSTANCE;
        this.stroke = InheritColor.INSTANCE;
        this.strokeWeight = InheritStrokeWeight.INSTANCE;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/svg/SVGPath$Companion;", "", "()V", "fromSVGPathString", "Lorg/openrndr/svg/SVGPath;", "svgPath", "", "openrndr-svg"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SVGPath fromSVGPathString(@NotNull String svgPath) {
            List<String> list;
            boolean bl;
            Intrinsics.checkNotNullParameter(svgPath, "svgPath");
            SVGPath path = new SVGPath();
            CharSequence charSequence = svgPath;
            Object object = "(?=[MmZzLlHhVvCcSsQqTtAa])";
            int n = 0;
            object = new Regex((String)object);
            n = 0;
            boolean bl2 = false;
            List<String> $this$dropLastWhile$iv = ((Regex)object).split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = iterator$iv.previous();
                    boolean bl3 = false;
                    CharSequence charSequence2 = it;
                    bl = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List<String> rawCommands = list;
            Pattern numbers = Pattern.compile("[-+]?[0-9]*[.]?[0-9]+(?:[eE][-+]?[0-9]+)?");
            Pattern arcOpReg = Pattern.compile("[aA]");
            for (String rawCommand : rawCommands) {
                CharSequence bl3 = rawCommand;
                int n2 = 0;
                if (!(bl3.length() > 0)) continue;
                if (arcOpReg.matcher(String.valueOf(rawCommand.charAt(0))).find()) {
                    bl3 = rawCommand;
                    n2 = 1;
                    bl = false;
                    CharSequence charSequence2 = bl3;
                    if (charSequence2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string = ((String)charSequence2).substring(n2);
                    Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.String).substring(startIndex)");
                    Iterable $this$forEach$iv = SVGLoaderKt.parseArcCommand(string);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$mapTo$iv$iv;
                        List it = (List)element$iv;
                        boolean bl4 = false;
                        Iterable $this$map$iv = it;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void operand;
                            String string2 = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl5 = false;
                            void var24_36 = operand;
                            boolean bl6 = false;
                            Double d = Double.parseDouble((String)var24_36);
                            collection.add(d);
                        }
                        List operands = (List)destination$iv$iv;
                        double[] dArray = CollectionsKt.toDoubleArray(operands);
                        path.getCommands().add(new Command(String.valueOf(rawCommand.charAt(0)), Arrays.copyOf(dArray, dArray.length)));
                    }
                    continue;
                }
                Matcher numberMatcher = numbers.matcher(rawCommand);
                bl = false;
                List operands = new ArrayList();
                while (numberMatcher.find()) {
                    String string;
                    Intrinsics.checkNotNullExpressionValue(numberMatcher.group(), "numberMatcher.group()");
                    boolean bl7 = false;
                    operands.add(Double.parseDouble(string));
                }
                double[] dArray = CollectionsKt.toDoubleArray(operands);
                path.getCommands().add(new Command(String.valueOf(rawCommand.charAt(0)), Arrays.copyOf(dArray, dArray.length)));
            }
            return path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

