/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Entities;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.math.Matrix44;
import org.openrndr.shape.Color;
import org.openrndr.shape.Composition;
import org.openrndr.shape.CompositionColor;
import org.openrndr.shape.CompositionNode;
import org.openrndr.shape.CompositionStrokeWeight;
import org.openrndr.shape.GroupNode;
import org.openrndr.shape.ImageNode;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeNode;
import org.openrndr.shape.StrokeWeight;
import org.openrndr.shape.TextNode;
import org.openrndr.svg.SVGWriterKt;
import org.openrndr.svg.VisitStage;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a>\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2,\u0010\u0016\u001a(\u0012\u0004\u0012\u00020\n\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00140\u0017\u00a2\u0006\u0002\b\u001cH\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u0001\u001a\u0012\u0010!\u001a\u00020\u0014*\u00020\u001f2\u0006\u0010\"\u001a\u00020#\u001a\n\u0010$\u001a\u00020\u0001*\u00020\u001f\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u00020\u0001*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"svg", "", "Lorg/openrndr/color/ColorRGBa;", "getSvg", "(Lorg/openrndr/color/ColorRGBa;)Ljava/lang/String;", "Lorg/openrndr/shape/Shape;", "(Lorg/openrndr/shape/Shape;)Ljava/lang/String;", "Lorg/openrndr/shape/ShapeContour;", "(Lorg/openrndr/shape/ShapeContour;)Ljava/lang/String;", "svgAttributes", "Lorg/openrndr/shape/CompositionNode;", "getSvgAttributes", "(Lorg/openrndr/shape/CompositionNode;)Ljava/lang/String;", "svgId", "getSvgId", "svgTransform", "Lorg/openrndr/math/Matrix44;", "getSvgTransform", "(Lorg/openrndr/math/Matrix44;)Ljava/lang/String;", "process", "", "compositionNode", "visitor", "Lkotlin/Function2;", "Lorg/openrndr/svg/VisitStage;", "Lkotlin/ParameterName;", "name", "stage", "Lkotlin/ExtensionFunctionType;", "writeSVG", "composition", "Lorg/openrndr/shape/Composition;", "topLevelId", "saveToFile", "file", "Ljava/io/File;", "toSVG", "openrndr-svg"})
public final class SVGWriterKt {
    public static final void saveToFile(@NotNull Composition $this$saveToFile, @NotNull File file) {
        Intrinsics.checkNotNullParameter($this$saveToFile, "$this$saveToFile");
        Intrinsics.checkNotNullParameter(file, "file");
        if (!Intrinsics.areEqual(FilesKt.getExtension(file), "svg")) {
            throw (Throwable)new IllegalArgumentException("can only write svg files, the extension '" + FilesKt.getExtension(file) + "' is not supported");
        }
        String svg = SVGWriterKt.writeSVG$default($this$saveToFile, null, 2, null);
        FilesKt.writeText$default(file, svg, null, 2, null);
    }

    @NotNull
    public static final String toSVG(@NotNull Composition $this$toSVG) {
        Intrinsics.checkNotNullParameter($this$toSVG, "$this$toSVG");
        return SVGWriterKt.writeSVG$default($this$toSVG, null, 2, null);
    }

    private static final String getSvgId(CompositionNode $this$svgId) {
        String string;
        if ($this$svgId.getId() != null) {
            String string2 = $this$svgId.getId();
            if (string2 == null) {
                String string3 = "id = null";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            string = "id=\"" + string2 + '\"';
        } else {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvgAttributes(CompositionNode $this$svgAttributes) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = $this$svgAttributes.getAttributes();
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var6_6.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = it.getValue() != null ? (String)it.getKey() + "=\"" + Entities.escape((String)it.getValue()) + '\"' : String.valueOf(it.getKey());
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String writeSVG(@NotNull Composition composition3, @NotNull String topLevelId) {
        void textPathID;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(composition3, "composition");
        Intrinsics.checkNotNullParameter(topLevelId, "topLevelId");
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1 Tiny//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd\">\n");
        Map defaultNamespaces = MapsKt.mapOf(TuplesKt.to("xmlns", "http://www.w3.org/2000/svg"), TuplesKt.to("xmlns:xlink", "http://www.w3.org/1999/xlink"));
        Map<String, String> $this$map$iv = MapsKt.plus(defaultNamespaces, composition3.getNamespaces());
        boolean $i$f$map22 = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var10_10 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var10_10.entrySet().iterator();
        while (iterator2.hasNext()) {
            void k;
            void $dstr$k$v;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var16_16 = $dstr$k$v;
            boolean bl3 = false;
            String string = (String)var16_16.getKey();
            var16_16 = $dstr$k$v;
            bl3 = false;
            String v = (String)var16_16.getValue();
            String string2 = (String)k + "=\"" + v + '\"';
            collection.add(string2);
        }
        String namespaces = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
        writeSVG.1 $fun$svgAttributes$1 = writeSVG.1.INSTANCE;
        sb.append("<svg version=\"1.1\" baseProfile=\"tiny\" id=\"" + topLevelId + "\" " + namespaces + ' ' + $fun$svgAttributes$1.invoke(composition3.getDocumentBounds()) + '>');
        Ref.IntRef $i$f$map22 = new Ref.IntRef();
        $i$f$map22.element = 0;
        SVGWriterKt.process(composition3.getRoot(), (Function2<? super CompositionNode, ? super VisitStage, Unit>)new Function2<CompositionNode, VisitStage, Unit>(sb, (Ref.IntRef)textPathID){
            final /* synthetic */ StringBuilder $sb;
            final /* synthetic */ Ref.IntRef $textPathID;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CompositionNode $this$process, @NotNull VisitStage stage) {
                block12: {
                    block10: {
                        CompositionNode compositionNode;
                        block20: {
                            Object object;
                            int n;
                            block23: {
                                block21: {
                                    block22: {
                                        block13: {
                                            void $this$filterTo$iv$iv;
                                            Object object2;
                                            boolean f2;
                                            String fillAttribute;
                                            block19: {
                                                block17: {
                                                    block18: {
                                                        boolean element$iv$iv2;
                                                        Object object3;
                                                        boolean $i$f$filter2;
                                                        block16: {
                                                            block14: {
                                                                block15: {
                                                                    block11: {
                                                                        void $this$filterTo$iv$iv2;
                                                                        Intrinsics.checkNotNullParameter($this$process, "$receiver");
                                                                        Intrinsics.checkNotNullParameter((Object)((Object)stage), "stage");
                                                                        if (stage != VisitStage.PRE) break block10;
                                                                        compositionNode = $this$process;
                                                                        if (!(compositionNode instanceof GroupNode)) break block11;
                                                                        String transformAttribute = $this$process.getTransform() != Matrix44.Companion.getIDENTITY() ? "transform=\"" + SVGWriterKt.access$getSvgTransform$p($this$process.getTransform()) + '\"' : "";
                                                                        Iterable $this$filter$iv = CollectionsKt.listOf(SVGWriterKt.access$getSvgId$p($this$process), transformAttribute, SVGWriterKt.access$getSvgAttributes$p($this$process));
                                                                        boolean $i$f$filter2 = false;
                                                                        Iterable iterable = $this$filter$iv;
                                                                        Collection destination$iv$iv = new ArrayList<E>();
                                                                        boolean $i$f$filterTo = false;
                                                                        for (T element$iv$iv2 : $this$filterTo$iv$iv2) {
                                                                            String a2 = (String)element$iv$iv2;
                                                                            boolean bl = false;
                                                                            CharSequence charSequence = a2;
                                                                            boolean bl2 = false;
                                                                            if (!(!StringsKt.isBlank(charSequence))) continue;
                                                                            destination$iv$iv.add(element$iv$iv2);
                                                                        }
                                                                        String attributes = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
                                                                        this.$sb.append("<g " + attributes + ">\n");
                                                                        break block12;
                                                                    }
                                                                    if (!(compositionNode instanceof ShapeNode)) break block13;
                                                                    CompositionColor attributes = $this$process.getFill();
                                                                    boolean $this$filter$iv = false;
                                                                    $i$f$filter2 = false;
                                                                    CompositionColor f2 = attributes;
                                                                    boolean bl = false;
                                                                    if (!(f2 instanceof Color)) break block14;
                                                                    object3 = ((Color)f2).getColor();
                                                                    if (object3 == null) break block15;
                                                                    Object $i$f$filterTo = object3;
                                                                    boolean bl3 = false;
                                                                    element$iv$iv2 = false;
                                                                    Object c = $i$f$filterTo;
                                                                    boolean bl4 = false;
                                                                    object3 = "fill=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)c) + '\"';
                                                                    if (object3 != null) break block16;
                                                                }
                                                                object3 = "fill=\"none\"";
                                                                break block16;
                                                            }
                                                            object3 = "";
                                                        }
                                                        fillAttribute = object3;
                                                        CompositionColor $this$filter$iv = $this$process.getStroke();
                                                        $i$f$filter2 = false;
                                                        f2 = false;
                                                        CompositionColor s2 = $this$filter$iv;
                                                        boolean bl = false;
                                                        if (!(s2 instanceof Color)) break block17;
                                                        object2 = ((Color)s2).getColor();
                                                        if (object2 == null) break block18;
                                                        Object object4 = object2;
                                                        element$iv$iv2 = false;
                                                        boolean c = false;
                                                        Object c2 = object4;
                                                        boolean bl5 = false;
                                                        object2 = "stroke=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)c2) + '\"';
                                                        if (object2 != null) break block19;
                                                    }
                                                    object2 = "stroke=\"none\"";
                                                    break block19;
                                                }
                                                object2 = "";
                                            }
                                            String strokeAttribute = object2;
                                            CompositionStrokeWeight $i$f$filter2 = $this$process.getStrokeWeight();
                                            f2 = false;
                                            boolean s2 = false;
                                            CompositionStrokeWeight w = $i$f$filter2;
                                            boolean bl = false;
                                            String strokeWidthAttribute = w instanceof StrokeWeight ? "stroke-width=\"" + ((StrokeWeight)w).getWeight() + '\"' : "";
                                            String transformAttribute = $this$process.getTransform() != Matrix44.Companion.getIDENTITY() ? "transform=\"" + SVGWriterKt.access$getSvgTransform$p($this$process.getTransform()) + '\"' : "";
                                            String pathAttribute = "d=\"" + SVGWriterKt.access$getSvg$p(((ShapeNode)$this$process).getShape()) + '\"';
                                            Iterable $this$filter$iv = CollectionsKt.listOf(SVGWriterKt.access$getSvgId$p($this$process), transformAttribute, fillAttribute, strokeAttribute, strokeWidthAttribute, SVGWriterKt.access$getSvgAttributes$p($this$process), pathAttribute);
                                            boolean $i$f$filter = false;
                                            Iterable element$iv$iv2 = $this$filter$iv;
                                            Collection destination$iv$iv = new ArrayList<E>();
                                            boolean $i$f$filterTo = false;
                                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                                String it = (String)element$iv$iv;
                                                boolean bl6 = false;
                                                CharSequence charSequence = it;
                                                boolean bl7 = false;
                                                if (!(!StringsKt.isBlank(charSequence))) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            String attributes = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
                                            this.$sb.append("<path " + attributes + "/>\n");
                                            break block12;
                                        }
                                        if (!(compositionNode instanceof TextNode)) break block20;
                                        CompositionColor strokeAttribute = $this$process.getFill();
                                        boolean strokeWidthAttribute = false;
                                        n = 0;
                                        CompositionColor f = strokeAttribute;
                                        boolean bl = false;
                                        if (!(f instanceof Color)) break block21;
                                        object = ((Color)f).getColor();
                                        if (object == null) break block22;
                                        Object object5 = object;
                                        boolean bl8 = false;
                                        boolean bl9 = false;
                                        Object c = object5;
                                        boolean bl10 = false;
                                        object = "fill=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)c) + '\"';
                                        if (object != null) break block23;
                                    }
                                    object = "fill=\"none\"";
                                    break block23;
                                }
                                object = "";
                            }
                            String fillAttribute = object;
                            ShapeContour contour2 = ((TextNode)$this$process).getContour();
                            String escapedText = Entities.escape(((TextNode)$this$process).getText());
                            if (contour2 == null) {
                                this.$sb.append("<text " + SVGWriterKt.access$getSvgId$p($this$process) + ' ' + fillAttribute + ' ' + SVGWriterKt.access$getSvgAttributes$p($this$process) + '>' + escapedText + "</text>");
                            } else {
                                this.$sb.append("<defs>");
                                this.$sb.append("<path id=\"text" + this.$textPathID.element + "\" d=\"" + SVGWriterKt.access$getSvg$p(contour2) + "\"/>");
                                this.$sb.append("</defs>");
                                this.$sb.append("<text " + fillAttribute + "><textPath href=\"#text" + this.$textPathID.element + "\">" + escapedText + "</textPath></text>");
                                n = this.$textPathID.element;
                                this.$textPathID.element = n + 1;
                            }
                            break block12;
                        }
                        if (!(compositionNode instanceof ImageNode)) break block12;
                        String dataUrl = ColorBuffer.DefaultImpls.toDataUrl$default(((ImageNode)$this$process).getImage(), null, 1, null);
                        this.$sb.append("<image xlink:href=\"" + dataUrl + "\" height=\"" + ((ImageNode)$this$process).getImage().getHeight() + "\" width=\"" + ((ImageNode)$this$process).getImage().getWidth() + "\"/>");
                        break block12;
                    }
                    CompositionNode compositionNode = $this$process;
                    if (!(compositionNode instanceof GroupNode)) break block12;
                    this.$sb.append("</g>\n");
                }
            }
            {
                this.$sb = stringBuilder;
                this.$textPathID = intRef;
                super(2);
            }
        });
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    public static /* synthetic */ String writeSVG$default(Composition composition3, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "openrndr-svg";
        }
        return SVGWriterKt.writeSVG(composition3, string);
    }

    private static final String getSvg(ColorRGBa $this$svg) {
        int ir = (int)(RangesKt.coerceIn($this$svg.getR(), 0.0, 1.0) * 255.0);
        int ig = (int)(RangesKt.coerceIn($this$svg.getG(), 0.0, 1.0) * 255.0);
        int ib = (int)(RangesKt.coerceIn($this$svg.getB(), 0.0, 1.0) * 255.0);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "#%02x%02x%02x";
        Object[] objectArray = new Object[]{ir, ig, ib};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(format, *args)");
        return string2;
    }

    private static final String getSvgTransform(Matrix44 $this$svgTransform) {
        return Intrinsics.areEqual($this$svgTransform, Matrix44.Companion.getIDENTITY()) ? null : "matrix(" + $this$svgTransform.getC0r0() + ", " + $this$svgTransform.getC0r1() + ", " + $this$svgTransform.getC1r0() + ", " + $this$svgTransform.getC1r1() + ", " + $this$svgTransform.getC3r0() + ", " + $this$svgTransform.getC3r1() + ')';
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvg(Shape $this$svg) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = $this$svg.getContours();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShapeContour it = (ShapeContour)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = it.getSegments();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String string;
                void segment;
                int n = index$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Segment segment2 = (Segment)item$iv;
                int index = n;
                boolean bl3 = false;
                if (index == 0) {
                    sb.append("M " + segment.getStart().getX() + ", " + segment.getStart().getY());
                }
                switch (segment.getControl().length) {
                    case 1: {
                        string = "" + 'Q' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                        break;
                    }
                    case 2: {
                        string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getControl()[1].getX() + ", " + segment.getControl()[1].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                        break;
                    }
                    default: {
                        string = "" + 'L' + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    }
                }
                sb.append(string);
            }
            if (!it.getClosed()) continue;
            sb.append("Z ");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvg(ShapeContour $this$svg) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = $this$svg.getSegments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String string;
            void segment;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Segment segment2 = (Segment)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index == 0) {
                sb.append("M " + segment.getStart().getX() + ", " + segment.getStart().getY());
            }
            switch (segment.getControl().length) {
                case 1: {
                    string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    break;
                }
                case 2: {
                    string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getControl()[1].getX() + ", " + segment.getControl()[1].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    break;
                }
                default: {
                    string = "" + 'L' + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                }
            }
            sb.append(string);
        }
        if ($this$svg.getClosed()) {
            sb.append("Z ");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    private static final void process(CompositionNode compositionNode, Function2<? super CompositionNode, ? super VisitStage, Unit> visitor2) {
        visitor2.invoke(compositionNode, VisitStage.PRE);
        if (compositionNode instanceof GroupNode) {
            Iterable $this$forEach$iv = ((GroupNode)compositionNode).getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompositionNode it = (CompositionNode)element$iv;
                boolean bl = false;
                SVGWriterKt.process(it, visitor2);
            }
        }
        visitor2.invoke(compositionNode, VisitStage.POST);
    }

    public static final /* synthetic */ String access$getSvgTransform$p(Matrix44 $this$access_u24svgTransform_u24p) {
        return SVGWriterKt.getSvgTransform($this$access_u24svgTransform_u24p);
    }

    public static final /* synthetic */ String access$getSvgId$p(CompositionNode $this$access_u24svgId_u24p) {
        return SVGWriterKt.getSvgId($this$access_u24svgId_u24p);
    }

    public static final /* synthetic */ String access$getSvgAttributes$p(CompositionNode $this$access_u24svgAttributes_u24p) {
        return SVGWriterKt.getSvgAttributes($this$access_u24svgAttributes_u24p);
    }

    public static final /* synthetic */ String access$getSvg$p(ColorRGBa $this$access_u24svg_u24p) {
        return SVGWriterKt.getSvg($this$access_u24svg_u24p);
    }

    public static final /* synthetic */ String access$getSvg$p(Shape $this$access_u24svg_u24p) {
        return SVGWriterKt.getSvg($this$access_u24svg_u24p);
    }

    public static final /* synthetic */ String access$getSvg$p(ShapeContour $this$access_u24svg_u24p) {
        return SVGWriterKt.getSvg($this$access_u24svg_u24p);
    }
}

