/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.ISortedMap;
import io.lacuna.bifurcan.IntMap;
import io.lacuna.bifurcan.List;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.Maps;
import io.lacuna.bifurcan.utils.Encodings;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;

public class FloatMap<V>
implements ISortedMap<Double, V>,
Cloneable {
    private static final ToIntFunction<Double> HASH = n -> IntMap.HASH.applyAsInt(Encodings.doubleToLong(n));
    private IntMap<V> map;

    public static <V> FloatMap<V> from(IMap<Number, V> m) {
        if (m instanceof FloatMap) {
            return (FloatMap)m.forked();
        }
        return FloatMap.from(m.entries());
    }

    public static <V> FloatMap<V> from(Map<Number, V> m) {
        return FloatMap.from(m.entrySet());
    }

    public static <V> FloatMap<V> from(Collection<Map.Entry<Number, V>> collection) {
        FloatMap<V> map2 = new FloatMap<V>().linear();
        for (Map.Entry<Number, V> entry : collection) {
            map2 = map2.put(entry.getKey().doubleValue(), entry.getValue());
        }
        return map2.forked();
    }

    public static <V> FloatMap<V> from(IList<IEntry<Number, V>> list) {
        FloatMap<V> map2 = new FloatMap<V>().linear();
        for (IEntry<Number, V> entry : list) {
            map2 = map2.put(entry.key().doubleValue(), entry.value());
        }
        return map2.forked();
    }

    public FloatMap() {
        this.map = new IntMap();
    }

    private FloatMap(IntMap<V> map2) {
        this.map = map2;
    }

    @Override
    public ToIntFunction<Double> keyHash() {
        return HASH;
    }

    @Override
    public BiPredicate<Double, Double> keyEquality() {
        return Double::equals;
    }

    @Override
    public boolean contains(double key) {
        return this.map.contains(Encodings.doubleToLong(key));
    }

    @Override
    public boolean contains(Double key) {
        return this.contains((double)key);
    }

    @Override
    public IList<IEntry<Double, V>> entries() {
        return Lists.lazyMap(this.map.entries(), FloatMap::convertEntry);
    }

    @Override
    public long indexOf(double key) {
        return this.map.indexOf(Encodings.doubleToLong(key));
    }

    @Override
    public long indexOf(Double key) {
        return this.indexOf((double)key);
    }

    @Override
    public IEntry<Double, V> nth(long index) {
        return FloatMap.convertEntry(this.map.nth(index));
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public IEntry<Double, V> floor(double key) {
        return FloatMap.convertEntry(this.map.floor(Encodings.doubleToLong(key)));
    }

    @Override
    public IEntry<Double, V> floor(Double key) {
        return this.floor((double)key);
    }

    @Override
    public IEntry<Double, V> ceil(double key) {
        return FloatMap.convertEntry(this.map.ceil(Encodings.doubleToLong(key)));
    }

    @Override
    public IEntry<Double, V> ceil(Double key) {
        return this.ceil((double)key);
    }

    public FloatMap<V> slice(double min, double max) {
        return new FloatMap<V>(this.map.slice(Encodings.doubleToLong(min), Encodings.doubleToLong(max)));
    }

    public FloatMap<V> slice(Double min, Double max) {
        return this.slice((double)min, (double)max);
    }

    public FloatMap<V> merge(IMap<Double, V> b, BinaryOperator<V> mergeFn) {
        if (b instanceof FloatMap) {
            FloatMap m = (FloatMap)b;
            return new FloatMap<V>(this.map.merge((IMap)m.map, (BinaryOperator)mergeFn));
        }
        return (FloatMap)Maps.merge(this.clone(), b, mergeFn);
    }

    public FloatMap<V> difference(IMap<Double, ?> b) {
        if (b instanceof FloatMap) {
            FloatMap m = (FloatMap)b;
            return new FloatMap<V>(this.map.difference(m.map));
        }
        return (FloatMap)Maps.difference(this.clone(), b.keys());
    }

    public FloatMap<V> intersection(IMap<Double, ?> b) {
        if (b instanceof FloatMap) {
            FloatMap m = (FloatMap)b;
            return new FloatMap<V>(this.map.intersection(m.map));
        }
        FloatMap result2 = (FloatMap)Maps.intersection(new FloatMap<V>().linear(), this, b.keys());
        return this.isLinear() ? result2 : result2.forked();
    }

    public FloatMap<V> put(double key, V value2) {
        return this.put(key, value2, (BinaryOperator<V>)Maps.MERGE_LAST_WRITE_WINS);
    }

    public FloatMap<V> put(double key, V value2, Object editor) {
        return this.put(key, value2, Maps.MERGE_LAST_WRITE_WINS, editor);
    }

    public FloatMap<V> put(double key, V value2, BinaryOperator<V> merge) {
        return this.put(key, value2, merge, this.isLinear() ? this.map.editor : new Object());
    }

    public FloatMap<V> put(double key, V value2, BinaryOperator<V> merge, Object editor) {
        if (Double.isNaN(key)) {
            throw new IllegalArgumentException("FloatMap does not support NaN");
        }
        IntMap<V> mapPrime = this.map.put(Encodings.doubleToLong(key), value2, merge, editor);
        if (this.isLinear()) {
            this.map = mapPrime;
            return this;
        }
        return new FloatMap<V>(mapPrime);
    }

    public FloatMap<V> put(Double key, V value2) {
        return this.put(key, value2, (BinaryOperator<V>)Maps.MERGE_LAST_WRITE_WINS);
    }

    public FloatMap<V> put(Double key, V value2, BinaryOperator<V> merge) {
        return this.put((double)key, value2, merge);
    }

    public FloatMap<V> remove(double key) {
        return this.remove(key, this.isLinear() ? this.map.editor : new Object());
    }

    public FloatMap<V> remove(double key, Object editor) {
        IntMap<V> mapPrime = this.map.remove(Encodings.doubleToLong(key), editor);
        if (this.isLinear()) {
            this.map = mapPrime;
            return this;
        }
        return new FloatMap<V>(mapPrime);
    }

    public FloatMap<V> remove(Double key) {
        return this.remove((double)key);
    }

    public <U> FloatMap<U> mapValues(BiFunction<Double, V, U> f) {
        return new FloatMap<V>(this.map.mapValues((T k, U v) -> f.apply(Encodings.longToDouble(k), v)));
    }

    @Override
    public Optional<V> get(double key) {
        return this.map.get(Encodings.doubleToLong(key));
    }

    @Override
    public V get(double key, V defaultValue) {
        return this.map.get(Encodings.doubleToLong(key), defaultValue);
    }

    @Override
    public V get(Double key, V defaultValue) {
        return this.get((double)key, defaultValue);
    }

    @Override
    public IMap<Double, V> update(Double key, UnaryOperator<V> update) {
        return this.update((double)key, update);
    }

    public FloatMap<V> update(double key, UnaryOperator<V> update) {
        return this.put(key, update.apply(this.get(key, (V)null)), this.isLinear() ? Boolean.valueOf(this.isLinear()) : new Object());
    }

    public FloatMap<V> update(double key, UnaryOperator<V> update, Object editor) {
        return this.put(key, update.apply(this.get(key, (V)null)), editor);
    }

    @Override
    public List<FloatMap<V>> split(int parts) {
        return this.map.split(parts).stream().map(m -> new FloatMap(m)).collect(Lists.collector());
    }

    @Override
    public boolean isLinear() {
        return this.map.isLinear();
    }

    @Override
    public FloatMap<V> forked() {
        return this.isLinear() ? new FloatMap<V>(this.map.forked()) : this;
    }

    @Override
    public FloatMap<V> linear() {
        return this.isLinear() ? this : new FloatMap<V>(this.map.linear());
    }

    public FloatMap<V> clone() {
        return new FloatMap<V>(this.map.clone());
    }

    public int hashCode() {
        return (int)Maps.hash(this);
    }

    @Override
    public boolean equals(IMap<Double, V> o, BiPredicate<V, V> valEquals) {
        if (o instanceof FloatMap) {
            FloatMap m = (FloatMap)o;
            return this.map.equals(m.map, valEquals);
        }
        return Maps.equals(this, o, valEquals);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMap) {
            return this.equals((IMap)obj, (BiPredicate<V, V>)((BiPredicate<Object, Object>)Objects::equals));
        }
        return false;
    }

    public String toString() {
        return Maps.toString(this);
    }

    private static <V> IEntry<Double, V> convertEntry(IEntry<Long, V> e) {
        return e != null ? new Maps.Entry<Double, V>(Encodings.longToDouble(e.key()), e.value()) : null;
    }
}

