/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.List;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.Map;
import io.lacuna.bifurcan.Maps;
import io.lacuna.bifurcan.Sets;
import io.lacuna.bifurcan.utils.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class Set<V>
implements ISet<V>,
Cloneable {
    Map<V, Void> map;
    private int hash = -1;

    public static <V> Set<V> from(ISet<V> s2) {
        if (s2 instanceof Set) {
            return ((Set)s2).forked();
        }
        ISet result2 = new Set<V>(s2.valueHash(), s2.valueEquality()).linear();
        s2.forEach(object -> this.add(object));
        return ((Set)result2).forked();
    }

    public static <V> Set<V> from(Iterator<V> iterator2) {
        ISet set = new Set<V>().linear();
        iterator2.forEachRemaining(object -> this.add(object));
        return ((Set)set).forked();
    }

    public static <V> Set<V> from(Iterable<V> iterable) {
        return Set.from(iterable.iterator());
    }

    public static <V> Set<V> of(V ... elements) {
        ISet set = new Set<V>().linear();
        for (V e : elements) {
            ((Set)set).add((Object)e);
        }
        return ((Set)set).forked();
    }

    public Set() {
        this(Objects::hashCode, Objects::equals);
    }

    public Set(ToIntFunction<V> hashFn, BiPredicate<V, V> equalsFn) {
        this.map = new Map(hashFn, equalsFn);
    }

    Set(Map<V, Void> map2) {
        this.map = map2;
    }

    @Override
    public boolean isLinear() {
        return this.map.isLinear();
    }

    @Override
    public ToIntFunction<V> valueHash() {
        return this.map.keyHash();
    }

    @Override
    public BiPredicate<V, V> valueEquality() {
        return this.map.keyEquality();
    }

    @Override
    public boolean contains(V value2) {
        return this.map.contains(value2);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public long indexOf(V element) {
        return this.map.indexOf(element);
    }

    @Override
    public V nth(long index) {
        return this.map.nth(index).key();
    }

    @Override
    public Set<V> add(V value2) {
        return this.add(value2, this.isLinear() ? this.map.editor : new Object());
    }

    public Set<V> add(V value2, Object editor) {
        Map<V, Void> mapPrime = this.map.put((Void)value2, (Void)null, Maps.MERGE_LAST_WRITE_WINS, editor);
        if (this.map == mapPrime) {
            this.hash = -1;
            return this;
        }
        return new Set<V>(mapPrime);
    }

    @Override
    public Set<V> remove(V value2) {
        return this.remove(value2, this.isLinear() ? this.map.editor : new Object());
    }

    public Set<V> remove(V value2, Object editor) {
        Map<V, Void> mapPrime = this.map.remove(value2, editor);
        if (this.map == mapPrime) {
            this.hash = -1;
            return this;
        }
        return new Set<V>(mapPrime);
    }

    @Override
    public List<Set<V>> split(int parts) {
        return this.map.split(parts).stream().map(m -> new Set(m)).collect(Lists.collector());
    }

    @Override
    public Iterator<V> iterator() {
        return Iterators.map(this.map.iterator(), IEntry::key);
    }

    @Override
    public <U> Map<V, U> zip(Function<V, U> f) {
        return ((Map)this.map.mapValues((k, v) -> f.apply(k))).forked();
    }

    @Override
    public Set<V> union(ISet<V> s2) {
        if (s2 instanceof Set) {
            return new Set<V>(this.map.union(((Set)s2).map));
        }
        return (Set)Sets.union(this, s2);
    }

    @Override
    public Set<V> difference(ISet<V> s2) {
        if (s2 instanceof Set) {
            return new Set<V>(this.map.difference(((Set)s2).map));
        }
        return (Set)Sets.difference(this, s2);
    }

    @Override
    public Set<V> intersection(ISet<V> s2) {
        if (s2 instanceof Set) {
            return new Set<V>(this.map.intersection(((Set)s2).map));
        }
        return (Set)Sets.intersection(new Set<V>().linear(), this, s2).forked();
    }

    @Override
    public Set<V> forked() {
        return this.map.isLinear() ? new Set<V>(this.map.forked()) : this;
    }

    @Override
    public Set<V> linear() {
        return this.map.isLinear() ? this : new Set<V>(this.map.linear());
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = (int)Sets.hash(this);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Set) {
            return this.map.equals(((Set)obj).map, (a2, b) -> true);
        }
        if (obj instanceof ISet) {
            return Sets.equals(this, (ISet)obj);
        }
        return false;
    }

    public String toString() {
        return Sets.toString(this);
    }

    @Override
    public Set<V> clone() {
        return new Set<V>(this.map.clone());
    }
}

