/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlinx.coroutines.DebugKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\b \u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00028\u00000\u00002\u00020\u0002B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\u000b\u001a\u00020\n2\b\u0010\b\u001a\u0004\u0018\u00018\u00002\b\u0010\t\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\r\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0004\u001a\u00020\u00038\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010\r\u001a\u0004\u0018\u00018\u00008F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001b\u001a\u00020\n8&@&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lkotlinx/coroutines/internal/Segment;", "S", "", "", "id", "prev", "<init>", "(JLkotlinx/coroutines/internal/Segment;)V", "expected", "value", "", "casNext", "(Lkotlinx/coroutines/internal/Segment;Lkotlinx/coroutines/internal/Segment;)Z", "next", "", "moveNextToRight", "(Lkotlinx/coroutines/internal/Segment;)V", "movePrevToLeft", "remove", "()V", "J", "getId", "()J", "getNext", "()Lkotlinx/coroutines/internal/Segment;", "getRemoved", "()Z", "removed", "kotlinx-coroutines-core"})
public abstract class Segment<S extends Segment<S>> {
    private volatile Object _next;
    private static final AtomicReferenceFieldUpdater _next$FU = AtomicReferenceFieldUpdater.newUpdater(Segment.class, Object.class, "_next");
    @NotNull
    volatile Object prev;
    static final AtomicReferenceFieldUpdater prev$FU = AtomicReferenceFieldUpdater.newUpdater(Segment.class, Object.class, "prev");
    private final long id;

    @Nullable
    public final S getNext() {
        return (S)((Segment)this._next);
    }

    public final boolean casNext(@Nullable S expected, @Nullable S value2) {
        return _next$FU.compareAndSet(this, expected, value2);
    }

    public abstract boolean getRemoved();

    public final void remove() {
        boolean bl = false;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl2 = false;
            if (!this.getRemoved()) {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        Segment segment = (Segment)this._next;
        if (segment == null) {
            return;
        }
        Segment<Segment> next = segment;
        Segment segment2 = (Segment)this.prev;
        if (segment2 == null) {
            return;
        }
        Segment prev = segment2;
        prev.moveNextToRight(next);
        while (prev.getRemoved()) {
            if ((Segment)prev.prev == null) {
                break;
            }
            prev.moveNextToRight(next);
        }
        next.movePrevToLeft(prev);
        while (next.getRemoved()) {
            if (next.getNext() == null) {
                break;
            }
            next.movePrevToLeft(prev);
        }
    }

    private final void moveNextToRight(S next) {
        Segment curNext;
        do {
            Object object = this._next;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type S");
            }
            curNext = (Segment)object;
            if (((Segment)next).id > curNext.id) continue;
            return;
        } while (!_next$FU.compareAndSet(this, curNext, next));
    }

    private final void movePrevToLeft(S prev) {
        Segment curPrev;
        do {
            if ((Segment)this.prev == null) {
                return;
            }
            if (curPrev.id > ((Segment)prev).id) continue;
            return;
        } while (!prev$FU.compareAndSet(this, curPrev, prev));
    }

    public final long getId() {
        return this.id;
    }

    public Segment(long id, @Nullable S prev) {
        this.id = id;
        this._next = null;
        this.prev = null;
        this.prev = prev;
    }
}

