/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct EGLClientPixmapHI")
public class EGLClientPixmapHI
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PDATA;
    public static final int IWIDTH;
    public static final int IHEIGHT;
    public static final int ISTRIDE;

    public EGLClientPixmapHI(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), EGLClientPixmapHI.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer pData(int capacity) {
        return EGLClientPixmapHI.npData(this.address(), capacity);
    }

    @NativeType(value="EGLint")
    public int iWidth() {
        return EGLClientPixmapHI.niWidth(this.address());
    }

    @NativeType(value="EGLint")
    public int iHeight() {
        return EGLClientPixmapHI.niHeight(this.address());
    }

    @NativeType(value="EGLint")
    public int iStride() {
        return EGLClientPixmapHI.niStride(this.address());
    }

    public EGLClientPixmapHI pData(@NativeType(value="void *") ByteBuffer value2) {
        EGLClientPixmapHI.npData(this.address(), value2);
        return this;
    }

    public EGLClientPixmapHI iWidth(@NativeType(value="EGLint") int value2) {
        EGLClientPixmapHI.niWidth(this.address(), value2);
        return this;
    }

    public EGLClientPixmapHI iHeight(@NativeType(value="EGLint") int value2) {
        EGLClientPixmapHI.niHeight(this.address(), value2);
        return this;
    }

    public EGLClientPixmapHI iStride(@NativeType(value="EGLint") int value2) {
        EGLClientPixmapHI.niStride(this.address(), value2);
        return this;
    }

    public EGLClientPixmapHI set(ByteBuffer pData, int iWidth, int iHeight, int iStride) {
        this.pData(pData);
        this.iWidth(iWidth);
        this.iHeight(iHeight);
        this.iStride(iStride);
        return this;
    }

    public EGLClientPixmapHI set(EGLClientPixmapHI src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EGLClientPixmapHI malloc() {
        return EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static EGLClientPixmapHI calloc() {
        return EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static EGLClientPixmapHI create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, MemoryUtil.memAddress(container), container);
    }

    public static EGLClientPixmapHI create(long address) {
        return EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, address);
    }

    @Nullable
    public static EGLClientPixmapHI createSafe(long address) {
        return address == 0L ? null : EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, address);
    }

    public static Buffer malloc(int capacity) {
        return EGLClientPixmapHI.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(EGLClientPixmapHI.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return EGLClientPixmapHI.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EGLClientPixmapHI.__create(capacity, SIZEOF);
        return EGLClientPixmapHI.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return EGLClientPixmapHI.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : EGLClientPixmapHI.wrap(Buffer.class, address, capacity);
    }

    public static EGLClientPixmapHI mallocStack() {
        return EGLClientPixmapHI.mallocStack(MemoryStack.stackGet());
    }

    public static EGLClientPixmapHI callocStack() {
        return EGLClientPixmapHI.callocStack(MemoryStack.stackGet());
    }

    public static EGLClientPixmapHI mallocStack(MemoryStack stack) {
        return EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EGLClientPixmapHI callocStack(MemoryStack stack) {
        return EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return EGLClientPixmapHI.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return EGLClientPixmapHI.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EGLClientPixmapHI.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EGLClientPixmapHI.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PDATA), capacity);
    }

    public static int niWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)IWIDTH);
    }

    public static int niHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)IHEIGHT);
    }

    public static int niStride(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISTRIDE);
    }

    public static void npData(long struct, ByteBuffer value2) {
        MemoryUtil.memPutAddress(struct + (long)PDATA, MemoryUtil.memAddress(value2));
    }

    public static void niWidth(long struct, int value2) {
        UNSAFE.putInt(null, struct + (long)IWIDTH, value2);
    }

    public static void niHeight(long struct, int value2) {
        UNSAFE.putInt(null, struct + (long)IHEIGHT, value2);
    }

    public static void niStride(long struct, int value2) {
        UNSAFE.putInt(null, struct + (long)ISTRIDE, value2);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDATA));
    }

    public static void validate(long array, int count2) {
        for (int i = 0; i < count2; ++i) {
            EGLClientPixmapHI.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = EGLClientPixmapHI.__struct(EGLClientPixmapHI.__member(POINTER_SIZE), EGLClientPixmapHI.__member(4), EGLClientPixmapHI.__member(4), EGLClientPixmapHI.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PDATA = layout.offsetof(0);
        IWIDTH = layout.offsetof(1);
        IHEIGHT = layout.offsetof(2);
        ISTRIDE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<EGLClientPixmapHI, Buffer>
    implements NativeResource {
        private static final EGLClientPixmapHI ELEMENT_FACTORY = EGLClientPixmapHI.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap2) {
            super(address, null, -1, 0, cap2, cap2);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap2) {
            super(address, container, mark, pos, lim, cap2);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected EGLClientPixmapHI getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer pData(int capacity) {
            return EGLClientPixmapHI.npData(this.address(), capacity);
        }

        @NativeType(value="EGLint")
        public int iWidth() {
            return EGLClientPixmapHI.niWidth(this.address());
        }

        @NativeType(value="EGLint")
        public int iHeight() {
            return EGLClientPixmapHI.niHeight(this.address());
        }

        @NativeType(value="EGLint")
        public int iStride() {
            return EGLClientPixmapHI.niStride(this.address());
        }

        public Buffer pData(@NativeType(value="void *") ByteBuffer value2) {
            EGLClientPixmapHI.npData(this.address(), value2);
            return this;
        }

        public Buffer iWidth(@NativeType(value="EGLint") int value2) {
            EGLClientPixmapHI.niWidth(this.address(), value2);
            return this;
        }

        public Buffer iHeight(@NativeType(value="EGLint") int value2) {
            EGLClientPixmapHI.niHeight(this.address(), value2);
            return this;
        }

        public Buffer iStride(@NativeType(value="EGLint") int value2) {
            EGLClientPixmapHI.niStride(this.address(), value2);
            return this;
        }
    }
}

