/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extras.meshgenerators;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extras.meshgenerators.MeshGeneratorsKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a6\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0081\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2O\u0010\f\u001aK\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000b0\rj\u0002`\u0015\u001a\u0089\u0001\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2O\u0010\f\u001aK\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000b0\rj\u0002`\u0015\u00a8\u0006\u0019"}, d2={"cylinderMesh", "Lorg/openrndr/draw/VertexBuffer;", "sides", "", "segments", "radius", "", "length", "invert", "", "generateCylinder", "", "vertexWriter", "Lkotlin/Function3;", "Lorg/openrndr/math/Vector3;", "Lkotlin/ParameterName;", "name", "position", "normal", "Lorg/openrndr/math/Vector2;", "texCoord", "Lorg/openrndr/extras/meshgenerators/VertexWriter;", "generateTaperedCylinder", "radiusStart", "radiusEnd", "orx-mesh-generators"})
public final class CylinderKt {
    @NotNull
    public static final VertexBuffer cylinderMesh(int sides, int segments, double radius, double length, boolean invert2) {
        int vertexCount2 = 6 * sides * segments;
        VertexBuffer vb2 = MeshGeneratorsKt.meshVertexBuffer(vertexCount2);
        vb2.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(sides, segments, radius, length, invert2){
            final /* synthetic */ int $sides;
            final /* synthetic */ int $segments;
            final /* synthetic */ double $radius;
            final /* synthetic */ double $length;
            final /* synthetic */ boolean $invert;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkParameterIsNotNull($this$put, "$receiver");
                CylinderKt.generateCylinder(this.$sides, this.$segments, this.$radius, this.$length, this.$invert, MeshGeneratorsKt.bufferWriter($this$put));
            }
            {
                this.$sides = n;
                this.$segments = n2;
                this.$radius = d;
                this.$length = d2;
                this.$invert = bl;
                super(1);
            }
        });
        return vb2;
    }

    public static /* synthetic */ VertexBuffer cylinderMesh$default(int n, int n2, double d, double d2, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 16;
        }
        if ((n3 & 2) != 0) {
            n2 = 16;
        }
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        return CylinderKt.cylinderMesh(n, n2, d, d2, bl);
    }

    public static final void generateCylinder(int sides, int segments, double radius, double length, boolean invert2, @NotNull Function3<? super Vector3, ? super Vector3, ? super Vector2, Unit> vertexWriter) {
        Intrinsics.checkParameterIsNotNull(vertexWriter, "vertexWriter");
        CylinderKt.generateTaperedCylinder(sides, segments, radius, radius, length, invert2, vertexWriter);
    }

    public static /* synthetic */ void generateCylinder$default(int n, int n2, double d, double d2, boolean bl, Function3 function3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        CylinderKt.generateCylinder(n, n2, d, d2, bl, function3);
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateTaperedCylinder(int sides, int segments, double radiusStart, double radiusEnd, double length, boolean invert2, @NotNull Function3<? super Vector3, ? super Vector3, ? super Vector2, Unit> vertexWriter) {
        Intrinsics.checkParameterIsNotNull(vertexWriter, "vertexWriter");
        double dphi = Math.PI * 2 / (double)sides;
        double ddeg = 360.0 / (double)sides;
        double invertFactor = invert2 ? -1.0 : 1.0;
        double dr = radiusEnd - radiusStart;
        Vector2 vector2 = new Vector2(length, dr).getNormalized().getPerpendicular();
        int n = 0;
        boolean bl = false;
        Vector2 it = vector2;
        boolean bl2 = false;
        Vector3 baseNormal = new Vector3(it.getY(), 0.0, it.getX());
        int n2 = 0;
        n = segments;
        while (n2 < n) {
            void segment;
            double radius0 = MappingKt.mix(radiusStart, radiusEnd, (double)segment * 1.0 / (double)segments);
            double radius1 = MappingKt.mix(radiusStart, radiusEnd, (double)(segment + true) * 1.0 / (double)segments);
            double z0 = length / (double)segments * (double)segment - length / 2.0;
            double z1 = length / (double)segments * (double)(segment + true) - length / 2.0;
            int n3 = 0;
            int n4 = sides;
            while (n3 < n4) {
                void side;
                double x00 = Math.cos((double)side * dphi) * radius0;
                double x10 = Math.cos((double)side * dphi + dphi) * radius0;
                double y00 = Math.sin((double)side * dphi) * radius0;
                double y10 = Math.sin((double)side * dphi + dphi) * radius0;
                double x01 = Math.cos((double)side * dphi) * radius1;
                double x11 = Math.cos((double)side * dphi + dphi) * radius1;
                double y01 = Math.sin((double)side * dphi) * radius1;
                double y11 = Math.sin((double)side * dphi + dphi) * radius1;
                double u0 = ((double)segment + 0.0) / (double)segments;
                double u1 = ((double)segment + 1.0) / (double)segments;
                double v0 = ((double)side + 0.0) / (double)sides;
                double v1 = ((double)side + 1.0) / (double)sides;
                Vector3 n0 = TransformsKt.rotateZ(Matrix44.Companion, (double)side * ddeg).times(baseNormal.getXyz0()).getXyz().getNormalized().times(invertFactor);
                Vector3 n1 = TransformsKt.rotateZ(Matrix44.Companion, (double)(side + true) * ddeg).times(baseNormal.getXyz0()).getXyz().getNormalized().times(invertFactor);
                if (!invert2) {
                    vertexWriter.invoke(new Vector3(x00, y00, z0), n0, new Vector2(u0, v0));
                    vertexWriter.invoke(new Vector3(x10, y10, z0), n1, new Vector2(u0, v1));
                    vertexWriter.invoke(new Vector3(x11, y11, z1), n1, new Vector2(u1, v1));
                    vertexWriter.invoke(new Vector3(x11, y11, z1), n1, new Vector2(u1, v1));
                    vertexWriter.invoke(new Vector3(x01, y01, z1), n0, new Vector2(u1, v0));
                    vertexWriter.invoke(new Vector3(x00, y00, z0), n0, new Vector2(u0, v0));
                } else {
                    vertexWriter.invoke(new Vector3(x00, y00, z0), n0, new Vector2(u0, v0));
                    vertexWriter.invoke(new Vector3(x01, y01, z1), n0, new Vector2(u1, v0));
                    vertexWriter.invoke(new Vector3(x11, y11, z1), n1, new Vector2(u1, v1));
                    vertexWriter.invoke(new Vector3(x11, y11, z1), n1, new Vector2(u1, v1));
                    vertexWriter.invoke(new Vector3(x10, y10, z0), n1, new Vector2(u0, v1));
                    vertexWriter.invoke(new Vector3(x00, y00, z0), n0, new Vector2(u0, v0));
                }
                ++side;
            }
            ++segment;
        }
    }

    public static /* synthetic */ void generateTaperedCylinder$default(int n, int n2, double d, double d2, double d3, boolean bl, Function3 function3, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        CylinderKt.generateTaperedCylinder(n, n2, d, d2, d3, bl, function3);
    }
}

