/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.internal.gl3.ShaderGeneratorsGL3Kt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/internal/gl3/ShaderGeneratorsGL3;", "Lorg/openrndr/internal/ShaderGenerators;", "()V", "circleFragmentShader", "", "shadeStructure", "Lorg/openrndr/draw/ShadeStructure;", "circleVertexShader", "expansionFragmentShader", "expansionVertexShader", "fastLineFragmentShader", "fastLineVertexShader", "fontImageMapFragmentShader", "fontImageMapVertexShader", "imageArrayTextureFragmentShader", "imageArrayTextureVertexShader", "imageFragmentShader", "imageVertexShader", "meshLineFragmentShader", "meshLineVertexShader", "rectangleFragmentShader", "rectangleVertexShader", "vertexBufferFragmentShader", "vertexBufferVertexShader", "openrndr-gl3"})
public final class ShaderGeneratorsGL3
implements ShaderGenerators {
    @Override
    @NotNull
    public String vertexBufferFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("|#version 330 core\n|").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_vertex_buffer")).append("\n|");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\n|layout(origin_upper_left) in vec4 gl_FragCoord;\n\n|uniform sampler2D image;\n|\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n|");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n|");
        String string3 = shadeStructure.getOutputs();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n|\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n\n\n|").append(!shadeStructure.getSuppressDefaultOutput() ? "out vec4 o_color;" : "").append("\n\n|");
        String string4 = shadeStructure.getFragmentPreamble();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n|flat in int v_instance;\n\n|void main(void) {\n|    ").append(ShaderGeneratorsGL3Kt.fragmentConstants$default(null, "v_instance", null, null, null, null, 61, null)).append("\n|    vec4 x_fill = u_fill;\n|    vec4 x_stroke = u_stroke;\n|    {\n|       ");
        String string5 = shadeStructure.getFragmentTransform();
        if (string5 == null) {
            string5 = "";
        }
        return StringsKt.trimMargin$default(stringBuilder5.append(string5).append("\n|    }\n     ").append(!shadeStructure.getSuppressDefaultOutput() ? "    o_color = x_fill;\n    o_color.rgb *= o_color.a;\n" : "").append("\n|}").toString(), null, 1, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String vertexBufferVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_vertex_buffer")).append("\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n\n");
        String string4 = shadeStructure.getVertexPreamble();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n\nflat out int v_instance;\nvoid main() {\n    int instance = gl_InstanceID; // this will go use c_instance instead\n").append(ShaderGeneratorsGL3Kt.vertexConstants$default(null, null, 3, null)).append('\n');
        String string5 = shadeStructure.getVaryingBridge();
        if (string5 == null) {
            string5 = "";
        }
        String string6 = shadeStructure.getAttributes();
        StringBuilder stringBuilder6 = stringBuilder5.append(string5).append("\n    vec3 x_normal = vec3(0.0, 0.0, 0.0);\n    ").append(string6 != null && StringsKt.contains$default((CharSequence)string6, "vec3 a_normal;", false, 2, null) ? "x_normal = a_normal;" : "").append("\n    vec3 x_position = a_position;\n\n    \n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n\n    {\n        ");
        String string7 = shadeStructure.getVertexTransform();
        if (string7 != null) {
            return StringsKt.trimMargin$default(stringBuilder6.append(string7).append("\n    }\n    \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n\n    v_instance = instance;\n    gl_Position = v_clipPosition;\n}\n            ").toString(), null, 1, null);
        }
        string7 = "";
        return StringsKt.trimMargin$default(stringBuilder6.append(string7).append("\n    }\n    \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n\n    v_instance = instance;\n    gl_Position = v_clipPosition;\n}\n            ").toString(), null, 1, null);
    }

    @Override
    @NotNull
    public String imageFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_image")).append('\n');
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nuniform sampler2D image;\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n\n\n").append(!shadeStructure.getSuppressDefaultOutput() ? "out vec4 o_color;" : "").append("\n\n");
        String string3 = shadeStructure.getFragmentPreamble();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nin vec3 v_boundsPosition;\nflat in int v_instance;\nvec4 colorTransform(vec4 color, float[25] matrix) {\n    float r = color.r * matrix[0] + color.g * matrix[5] + color.b * matrix[10] + color.a * matrix[15] + matrix[20];\n    float g = color.r * matrix[1] + color.g * matrix[6] + color.b * matrix[11] + color.a * matrix[16] + matrix[21];\n    float b = color.r * matrix[2] + color.g * matrix[7] + color.b * matrix[12] + color.a * matrix[17] + matrix[22];\n    float a = color.r * matrix[3] + color.g * matrix[8] + color.b * matrix[13] + color.a * matrix[18] + matrix[23];\n    return vec4(r, g, b, a);\n}\n\nvoid main(void) {\n    ").append(ShaderGeneratorsGL3Kt.fragmentConstants$default(null, null, null, null, "v_boundsPosition", null, 47, null)).append("\n    vec4 x_fill = texture(image, va_texCoord0);\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string4 = shadeStructure.getFragmentTransform();
        if (string4 == null) {
            string4 = "";
        }
        return stringBuilder4.append(string4).append("\n    }\n    float div = x_fill.a != 0.0 ? x_fill.a : 1.0;\n    x_fill.rgb /= div;\n    x_fill = colorTransform(x_fill, u_colorMatrix);\n    x_fill.rgb *= x_fill.a;\n    ").append(!shadeStructure.getSuppressDefaultOutput() ? "o_color = x_fill;" : "").append("\n}").toString();
    }

    @Override
    @NotNull
    public String imageVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("\n#version 330\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_image")).append("\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\nuniform int u_flipV;\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n\n\nflat out int v_instance;\n\nout vec3 v_boundsPosition;\nvoid main() {\n    v_instance = gl_InstanceID;\n    ").append(ShaderGeneratorsGL3Kt.vertexConstants$default(null, null, 3, null)).append("\n    ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n    \n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = a_normal;\n    vec3 x_position = a_position;\n    x_position.xy = a_position.xy * i_target.zw + i_target.xy;\n    v_boundsPosition = vec3(a_texCoord0.xy, 1.0);\n    va_texCoord0.xy = a_texCoord0.xy * i_source.zw + i_source.xy;\n    if (u_flipV == 0) {\n        va_texCoord0.y = 1.0 - va_texCoord0.y;\n    }\n    {\n        ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n    gl_Position = v_clipPosition;\n}\n").toString();
    }

    @Override
    @NotNull
    public String imageArrayTextureFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_image")).append('\n');
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nuniform sampler2DArray image;\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n\n\n").append(!shadeStructure.getSuppressDefaultOutput() ? "out vec4 o_color;" : "").append("\n\n");
        String string3 = shadeStructure.getFragmentPreamble();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nin vec3 v_boundsPosition;\nflat in int v_instance;\nflat in int v_layer;\nvec4 colorTransform(vec4 color, float[25] matrix) {\n    float r = color.r * matrix[0] + color.g * matrix[5] + color.b * matrix[10] + color.a * matrix[15] + matrix[20];\n    float g = color.r * matrix[1] + color.g * matrix[6] + color.b * matrix[11] + color.a * matrix[16] + matrix[21];\n    float b = color.r * matrix[2] + color.g * matrix[7] + color.b * matrix[12] + color.a * matrix[17] + matrix[22];\n    float a = color.r * matrix[3] + color.g * matrix[8] + color.b * matrix[13] + color.a * matrix[18] + matrix[23];\n    return vec4(r, g, b, a);\n}\n\nvoid main(void) {\n    ").append(ShaderGeneratorsGL3Kt.fragmentConstants$default(null, null, null, null, "v_boundsPosition", null, 47, null)).append("\n    vec4 x_fill = texture(image, vec3(va_texCoord0, v_layer*1.0));\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string4 = shadeStructure.getFragmentTransform();
        if (string4 == null) {
            string4 = "";
        }
        return stringBuilder4.append(string4).append("\n    }\n    float div = x_fill.a != 0.0 ? x_fill.a : 1.0;\n    x_fill.rgb /= div;\n    x_fill = colorTransform(x_fill, u_colorMatrix);\n    x_fill.rgb *= x_fill.a;\n    ").append(!shadeStructure.getSuppressDefaultOutput() ? "o_color = x_fill;" : "").append("\n}").toString();
    }

    @Override
    @NotNull
    public String imageArrayTextureVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("\n#version 330\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_image")).append("\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\nuniform int u_flipV;\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n\n\nflat out int v_instance;\nflat out int v_layer;\n\nout vec3 v_boundsPosition;\nvoid main() {\n    v_instance = gl_InstanceID;\n    ").append(ShaderGeneratorsGL3Kt.vertexConstants$default(null, null, 3, null)).append("\n    ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n    \n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = a_normal;\n    vec3 x_position = a_position;\n    x_position.xy = a_position.xy * i_target.zw + i_target.xy;\n    v_boundsPosition = vec3(a_texCoord0.xy, 1.0);\n    va_texCoord0.xy = a_texCoord0.xy * i_source.zw + i_source.xy;\n    v_layer = int(floor(i_layer+0.5));\n    if (u_flipV == 0) {\n        va_texCoord0.y = 1.0 - va_texCoord0.y;\n    }\n    {\n        ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n    gl_Position = v_clipPosition;\n}\n").toString();
    }

    @Override
    @NotNull
    public String circleFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_circle")).append('\n');
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n\n\n").append(!shadeStructure.getSuppressDefaultOutput() ? "out vec4 o_color;" : "").append("\nflat in int v_instance;\nin vec3 v_boundsSize;\nvoid main(void) {\n    ").append(ShaderGeneratorsGL3Kt.fragmentConstants$default(null, null, null, null, "vec3(va_texCoord0, 0.0)", "v_boundsSize", 15, null)).append("\n    float smoothFactor = 3.0;\n\n    vec4 x_fill = u_fill;\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string3 = shadeStructure.getFragmentTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append("\n    }\n    float wd = fwidth(length(va_texCoord0 - vec2(0.0)));\n    float d = length(va_texCoord0 - vec2(0.5)) * 2;\n\n    float or = smoothstep(0, wd * smoothFactor, 1.0 - d);\n    float b = u_strokeWeight / vi_radius;\n    float ir = smoothstep(0, wd * smoothFactor, 1.0 - b - d);\n\n    vec4 final = vec4(0.0);\n    final.rgb =  x_stroke.rgb;\n    final.a = or * (1.0 - ir) * x_stroke.a;\n    final.rgb *= final.a;\n\n    final.rgb += x_fill.rgb * ir * x_fill.a;\n    final.a += ir * x_fill.a;\n    ").append(!shadeStructure.getSuppressDefaultOutput() ? "o_color = final;" : "").append("\n}\n").toString();
    }

    @Override
    @NotNull
    public String circleVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_circle")).append("\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n\nflat out int v_instance;\nout vec3 v_boundsSize;\nvoid main() {\n    v_instance = gl_InstanceID;\n    ").append(ShaderGeneratorsGL3Kt.vertexConstants$default(null, null, 3, null)).append("\n    ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n\n    v_boundsSize = vec3(i_radius, i_radius, 0.0);\n    \n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = a_normal;\n    vec3 x_position = a_position * i_radius + i_offset;\n    {\n        ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    va_position = x_position;\n    \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n    gl_Position = v_clipPosition;\n\n}\n    ").toString();
    }

    @Override
    @NotNull
    public String fontImageMapFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_font_image_map")).append('\n');
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nuniform sampler2D image;\nflat in int v_instance;\n\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = "vec3(va_bounds.zw, 0.0)";
        String string4 = "vec3(va_bounds.xy, 0.0)";
        String string5 = null;
        String string6 = null;
        String string7 = "0";
        String string8 = "v_instance";
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n\n\n").append(!shadeStructure.getSuppressDefaultOutput() ? "out vec4 o_color;" : "").append("\n\nvoid main(void) {\n    ").append(ShaderGeneratorsGL3Kt.fragmentConstants$default(string7, string8, string6, string5, string4, string3, 12, null)).append("\n\n    float imageMap = texture(image, va_texCoord0).r;\n    vec4 x_fill = vec4(u_fill.rgb,u_fill.a * imageMap);\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string9 = shadeStructure.getFragmentTransform();
        if (string9 == null) {
            string9 = "";
        }
        return stringBuilder3.append(string9).append("\n    }\n    vec4 final = x_fill;\n    final.rgb *= final.a;\n    ").append(!shadeStructure.getSuppressDefaultOutput() ? "o_color = final;" : "").append("\n}\n").toString();
    }

    @Override
    @NotNull
    public String fontImageMapVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_font_image_map")).append("\n\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n\nflat out int v_instance;\n\nvoid main() {\n    ").append(ShaderGeneratorsGL3Kt.vertexConstants$default("int(a_position.z)", null, 2, null)).append("\n    vec3 decodedPosition = vec3(a_position.xy, 0.0);\n    v_instance = int(a_position.z);\n\n    ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n    \n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = vec3(0.0, 0.0, 1.0);\n    vec3 x_position = decodedPosition;\n    {\n        ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n    gl_Position = v_clipPosition;\n}\n            ").toString();
    }

    @Override
    @NotNull
    public String rectangleFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_rectangle")).append("\n\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getOutputs();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n\n\n");
        String string4 = shadeStructure.getFragmentPreamble();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\nflat in int v_instance;\nin vec3 v_boundsSize;\n").append(!shadeStructure.getSuppressDefaultOutput() ? "out vec4 o_color;" : "").append("\nvoid main(void) {\n    ").append(ShaderGeneratorsGL3Kt.fragmentConstants$default(null, null, null, null, "vec3(va_texCoord0, 0.0)", "v_boundsSize", 15, null)).append("\n    vec4 x_fill = u_fill;\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string5 = shadeStructure.getFragmentTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    vec2 wd = fwidth(va_texCoord0 - vec2(0.5));\n    vec2 d = abs((va_texCoord0 - vec2(0.5)) * 2);\n\n    float irx = smoothstep(0.0, wd.x * 2.5, 1.0-d.x - u_strokeWeight*2.0/vi_dimensions.x);\n    float iry = smoothstep(0.0, wd.y * 2.5, 1.0-d.y - u_strokeWeight*2.0/vi_dimensions.y);\n    float ir = irx*iry;\n\n    vec4 final = vec4(1.0);\n    final.rgb = x_fill.rgb * x_fill.a;\n    final.a = x_fill.a;\n\n    float sa = (1.0-ir) * x_stroke.a;\n    final.rgb = final.rgb * (1.0-sa) + x_stroke.rgb * sa;\n    final.a = final.a * (1.0-sa) + sa;\n\n    ").append(!shadeStructure.getSuppressDefaultOutput() ? "   o_color = final;" : "").append("\n}\n").toString();
    }

    @Override
    @NotNull
    public String rectangleVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_rectangle")).append("\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n\n\n");
        String string4 = shadeStructure.getVertexPreamble();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n\nflat out int v_instance;\nout vec3 v_boundsSize;\n\nvoid main() {\n    v_instance =  gl_InstanceID;\n    ").append(ShaderGeneratorsGL3Kt.vertexConstants$default(null, null, 3, null)).append("\n    ");
        String string5 = shadeStructure.getVaryingBridge();
        if (string5 == null) {
            string5 = "";
        }
        StringBuilder stringBuilder6 = stringBuilder5.append(string5).append("\n    \n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = vec3(0.0, 0.0, 1.0);\n    vec3 x_position = a_position * vec3(i_dimensions,1.0) + i_offset;\n    v_boundsSize = vec3(i_dimensions, 1.0);\n    {\n        ");
        String string6 = shadeStructure.getVertexTransform();
        if (string6 == null) {
            string6 = "";
        }
        return stringBuilder6.append(string6).append("\n    }\n    \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n    gl_Position = v_clipPosition;\n    }\n    ").toString();
    }

    @Override
    @NotNull
    public String expansionFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_expansion")).append("\n\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = "va_vertexOffset";
        String string4 = "vec3(bounds.zw, 0.0)";
        String string5 = "vec3(v_objectPosition.xy - bounds.xy, 0.0) / vec3(bounds.zw,1.0)";
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n\nflat in int v_instance;\nuniform float strokeMult;\nuniform float strokeThr;\nuniform float strokeFillFactor;\nuniform sampler2D tex;\nuniform vec4 bounds;\n\nin vec3 v_objectPosition;\nin vec2 v_ftcoord;\n").append(!shadeStructure.getSuppressDefaultOutput() ? "out vec4 o_color;" : "").append("\n\nfloat strokeMask() {\n\treturn min(1.0, (1.0-abs(v_ftcoord.x*2.0-1.0))*strokeMult) * min(1.0, v_ftcoord.y);\n}\n\nvoid main(void) {\n    ").append(ShaderGeneratorsGL3Kt.fragmentConstants$default(null, null, null, string3, string5, string4, 7, null)).append("\n\n\tfloat strokeAlpha = strokeMask();\n\n    vec4 x_stroke = u_stroke;\n    vec4 x_fill = u_fill;\n\n    { ");
        String string6 = shadeStructure.getFragmentTransform();
        if (string6 == null) {
            string6 = "";
        }
        return stringBuilder3.append(string6).append(" }\n\n    vec4 color = mix(x_stroke, x_fill, strokeFillFactor)  * vec4(1, 1, 1, strokeAlpha);\n    vec4 result = color;\n\n    if (strokeAlpha < strokeThr) {\n\t    discard;\n\t}\n\n    vec4 final = result;\n\tfinal = result;\n\tfinal.rgb *= final.a;\n    ").append(!shadeStructure.getSuppressDefaultOutput() ? "o_color = final;" : "").append("\n}\n").toString();
    }

    @Override
    @NotNull
    public String expansionVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_expansion")).append("\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n').append(shadeStructure.getAttributes()).append('\n');
        String string2 = shadeStructure.getVaryingOut();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n\n\nout vec2 v_ftcoord;\nout float v_offset;\n\nout vec3 v_objectPosition;\nflat out int v_instance;\n\nvoid main() {\n    v_instance = 0;\n    ").append(ShaderGeneratorsGL3Kt.vertexConstants$default(null, null, 3, null)).append("\n    ");
        String string3 = shadeStructure.getVaryingBridge();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n    v_objectPosition = vec3(a_position, 0.0);\n    v_ftcoord = a_texCoord0;\n\n    vec3 x_position = vec3(a_position, 0.0);\n    vec3 x_normal = vec3(0.0, 0.0, 1.0);\n    \n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n\n    {\n        ");
        String string4 = shadeStructure.getVertexTransform();
        if (string4 == null) {
            string4 = "";
        }
        return stringBuilder4.append(string4).append("\n    }\n    \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n\n    gl_Position = v_clipPosition;\n}\n").toString();
    }

    @Override
    @NotNull
    public String fastLineFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_fast_line")).append('\n');
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nuniform sampler2D image;\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n\nflat in int v_instance;\n").append(!shadeStructure.getSuppressDefaultOutput() ? "out vec4 o_color;" : "").append("\n\nvoid main(void) {\n    ").append(ShaderGeneratorsGL3Kt.fragmentConstants$default(null, null, null, null, null, null, 63, null)).append("\n    vec4 x_fill = u_fill;\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string3 = shadeStructure.getFragmentTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append("\n    }\n\n\n    vec4 final = x_stroke;\n    final = x_stroke;\n    final.rgb *= final.a;\n    ").append(!shadeStructure.getSuppressDefaultOutput() ? "o_color = final;" : "").append("\n}\n").toString();
    }

    @Override
    @NotNull
    public String fastLineVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330 core\n").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_fast_line")).append("\n\n\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n\nflat out int v_instance;\n\nvoid main() {\n    v_instance = gl_InstanceID;\n    ").append(ShaderGeneratorsGL3Kt.vertexConstants$default(null, null, 3, null)).append("\n    ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n    \n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = vec3(0.0, 0.0, 1.0);\n    vec3 x_position = a_position;\n    {\n        ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n    gl_Position = v_clipPosition;\n}\n").toString();
    }

    @Override
    @NotNull
    public String meshLineFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("\n        |#version 330 core\n        |").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_mesh_line")).append("\n        |");
        String string = shadeStructure.getOutputs();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\n        |");
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n        |layout(origin_upper_left) in vec4 gl_FragCoord;\n        |\n        |uniform sampler2D image;\n        |");
        String string3 = shadeStructure.getFragmentPreamble();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n        |\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n        |");
        String string4 = shadeStructure.getVaryingIn();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n        |\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n\n        |flat in int v_instance;\n        |").append(!shadeStructure.getSuppressDefaultOutput() ? "out vec4 o_color;" : "").append("\n        |void main(void) {\n        |   ").append(ShaderGeneratorsGL3Kt.fragmentConstants$default(null, null, null, null, null, null, 63, null)).append("\n        |   vec4 x_fill = u_fill;\n        |   vec4 x_stroke = va_color;\n        |   {\n        |       ");
        String string5 = shadeStructure.getFragmentTransform();
        if (string5 == null) {
            string5 = "";
        }
        return StringsKt.trimMargin$default(stringBuilder5.append(string5).append("\n        |   }\n        |").append(!shadeStructure.getSuppressDefaultOutput() ? "o_color = x_stroke;\no_color.rgb *= o_color.a;" : "").append("\n        |}\n        ").toString(), null, 1, null);
    }

    @Override
    @NotNull
    public String meshLineVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("\n        |#version 330 core\n        |").append(ShaderGeneratorsGL3Kt.access$primitiveTypes("d_mesh_line")).append("\n        |\nlayout(shared) uniform ContextBlock {\n    uniform mat4 u_modelNormalMatrix;\n    uniform mat4 u_modelMatrix;\n    uniform mat4 u_viewNormalMatrix;\n    uniform mat4 u_viewMatrix;\n    uniform mat4 u_projectionMatrix;\n    uniform float u_contentScale;\n    uniform vec2 u_viewDimensions;\n};\n\nlayout(shared) uniform StyleBlock {\n    uniform vec4 u_fill;\n    uniform vec4 u_stroke;\n    uniform float u_strokeWeight;\n    uniform float[25] u_colorMatrix;\n};\n\n        |");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\n        |");
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n        |");
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n        |\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n\n        |flat out int v_instance;\n        |\n        |vec2 fix(vec4 i, float aspect) {\n        |   vec2 res = i.xy / i.w;\n        |   res.x *= aspect;\n        |   return res;\n        |}\n        |\n        |void main() {\n        |   v_instance = gl_InstanceID;\n        |   ").append(ShaderGeneratorsGL3Kt.vertexConstants$default(null, "int(a_element)", 1, null)).append("\n        |   ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n        |   \n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n\n        |   vec3 x_normal = vec3(0.0, 0.0, 1.0);\n        |   vec3 x_position = a_position;\n        |\n        |   float aspect = u_viewDimensions.x / u_viewDimensions.y;\n        |   float pixelWidthRatio = 1. / (u_viewDimensions.x * u_projectionMatrix[0][0]);\n        |   mat4 pvm = u_projectionMatrix * u_viewMatrix * u_modelMatrix;\n        |   vec4 finalPosition = pvm * vec4(a_position, 1.0);\n        |   vec4 prevPosition = pvm * vec4(a_previous, 1.0);\n        |   vec4 nextPosition = pvm * vec4(a_next, 1.0);\n\n        |   vec2 currentP = fix(finalPosition, aspect);\n        |   vec2 prevP = fix(prevPosition, aspect);\n        |   vec2 nextP = fix(nextPosition, aspect);\n\n        |   float pixelWidth = finalPosition.w * pixelWidthRatio;\n        |   float w = 1.8 * pixelWidth * a_width;\n\n        |   vec2 dir;\n        |   if (nextP == currentP) {\n        |       dir = normalize(currentP - prevP);\n        |   } else if(prevP == currentP) {\n        |       dir = normalize( nextP - currentP );\n        |   } else {\n        |       vec2 dir1 = normalize(currentP - prevP);\n        |       vec2 dir2 = normalize(nextP - currentP);\n        |       dir = normalize(dir1 + dir2);\n        |   }\n        |   x_normal = ( cross( vec3( dir, 0. ), vec3( 0., 0., 1. ) ) );\n        |   vec2 normal = vec2(-dir.y, dir.x);\n        |   normal.x /= aspect;\n        |   normal *= .5 * w;\n        |   vec4 offset = vec4(normal * a_side, 0.0, 1.0);\n        |\n        |   finalPosition.xy += offset.xy;\n        |   v_clipPosition = finalPosition;\n        |   gl_Position = finalPosition;\n        |   {\n        |       ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return StringsKt.trimMargin$default(stringBuilder5.append(string5).append("\n        |   }\n        |   \n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n\n        |}\n        ").toString(), null, 1, null);
    }
}

