/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a.\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0012"}, d2={"linearstep", "", "edge0", "edge1", "x", "map", "beforeLeft", "beforeRight", "afterLeft", "afterRight", "value", "mix", "left", "right", "saturate", "smootherstep", "smoothstep", "smoothstepIn", "openrndr-math"})
public final class MappingKt {
    public static final double map(double beforeLeft, double beforeRight, double afterLeft, double afterRight, double value2) {
        double n = (value2 - beforeLeft) / (beforeRight - beforeLeft);
        return afterLeft + n * (afterRight - afterLeft);
    }

    public static final double linearstep(double edge0, double edge1, double x) {
        return MappingKt.saturate((x - edge0) / (edge1 - edge0));
    }

    public static final double smoothstep(double edge0, double edge1, double x) {
        double u = MappingKt.saturate((x - edge0) / (edge1 - edge0));
        return u * u * ((double)3 - (double)2 * u);
    }

    public static final double smoothstepIn(double edge0, double edge1, double x) {
        double u = MappingKt.saturate((x - edge0) / (edge1 - edge0));
        return x < 0.5 ? u * u * ((double)3 - (double)2 * u) : u;
    }

    public static final double smootherstep(double edge0, double edge1, double x) {
        double u = MappingKt.saturate((x - edge0) / (edge1 - edge0));
        return u * u * u * (u * (u * (double)6 - (double)15) + (double)10);
    }

    public static final double saturate(double x) {
        double d = 0.0;
        double d2 = 1.0;
        boolean bl = false;
        d2 = Math.min(d2, x);
        bl = false;
        return Math.max(d, d2);
    }

    public static final double mix(double left, double right, double x) {
        return left * (1.0 - x) + right * x;
    }
}

