/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ;2\u00020\u0001:\u0001;B_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003Jc\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0011\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0086\u0002J\t\u00101\u001a\u000200H\u00d6\u0001J\u0011\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0086\u0002J\u0011\u00104\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0086\u0002J\u0011\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0003H\u0086\u0002J\u0011\u00105\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0000H\u0086\u0002J\u0011\u00105\u001a\u00020.2\u0006\u00108\u001a\u00020.H\u0086\u0002J\b\u00109\u001a\u00020:H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u0011\u0010\u001d\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006<"}, d2={"Lorg/openrndr/math/Matrix33;", "", "c0r0", "", "c1r0", "c2r0", "c0r1", "c1r1", "c2r1", "c0r2", "c1r2", "c2r2", "(DDDDDDDDD)V", "getC0r0", "()D", "getC0r1", "getC0r2", "getC1r0", "getC1r1", "getC1r2", "getC2r0", "getC2r1", "getC2r2", "matrix44", "Lorg/openrndr/math/Matrix44;", "getMatrix44", "()Lorg/openrndr/math/Matrix44;", "trace", "getTrace", "transposed", "getTransposed", "()Lorg/openrndr/math/Matrix33;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "get", "Lorg/openrndr/math/Vector3;", "index", "", "hashCode", "minus", "o", "plus", "times", "s", "mat", "v", "toString", "", "Companion", "openrndr-math"})
public final class Matrix33 {
    private final double c0r0;
    private final double c1r0;
    private final double c2r0;
    private final double c0r1;
    private final double c1r1;
    private final double c2r1;
    private final double c0r2;
    private final double c1r2;
    private final double c2r2;
    @NotNull
    private static final Matrix33 IDENTITY;
    @NotNull
    private static final Matrix33 ZERO;
    public static final Companion Companion;

    @NotNull
    public final Vector3 get(int index) {
        Vector3 vector3;
        switch (index) {
            case 0: {
                vector3 = new Vector3(this.c0r0, this.c0r1, this.c0r2);
                break;
            }
            case 1: {
                vector3 = new Vector3(this.c1r0, this.c1r1, this.c1r2);
                break;
            }
            case 2: {
                vector3 = new Vector3(this.c2r0, this.c2r1, this.c2r2);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("not implemented");
            }
        }
        return vector3;
    }

    public final double getTrace() {
        return this.c0r0 + this.c1r1 + this.c2r2;
    }

    @NotNull
    public final Matrix33 plus(@NotNull Matrix33 o) {
        Intrinsics.checkParameterIsNotNull(o, "o");
        return new Matrix33(this.c0r0 + o.c0r0, this.c1r0 + o.c1r0, this.c2r0 + o.c2r0, this.c0r1 + o.c0r1, this.c1r1 + o.c1r1, this.c2r1 + o.c2r1, this.c0r2 + o.c0r2, this.c1r2 + o.c1r2, this.c2r2 + o.c2r2);
    }

    @NotNull
    public final Matrix33 minus(@NotNull Matrix33 o) {
        Intrinsics.checkParameterIsNotNull(o, "o");
        return new Matrix33(this.c0r0 - o.c0r0, this.c1r0 - o.c1r0, this.c2r0 - o.c2r0, this.c0r1 - o.c0r1, this.c1r1 - o.c1r1, this.c2r1 - o.c2r1, this.c0r2 - o.c0r2, this.c1r2 - o.c1r2, this.c2r2 - o.c2r2);
    }

    @NotNull
    public final Matrix33 getTransposed() {
        return new Matrix33(this.c0r0, this.c0r1, this.c0r2, this.c1r0, this.c1r1, this.c1r2, this.c2r0, this.c2r1, this.c2r2);
    }

    @NotNull
    public final Matrix44 getMatrix44() {
        return new Matrix44(this.c0r0, this.c1r0, this.c2r0, 0.0, this.c0r1, this.c1r1, this.c2r1, 0.0, this.c0r2, this.c1r2, this.c2r2, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public final Vector3 times(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vector3(v.getX() * this.c0r0 + v.getY() * this.c1r0 + v.getZ() * this.c2r0, v.getX() * this.c0r1 + v.getY() * this.c1r1 + v.getZ() * this.c2r1, v.getX() * this.c0r2 + v.getY() * this.c1r2 + v.getZ() * this.c2r2);
    }

    @NotNull
    public final Matrix33 times(double s2) {
        return new Matrix33(s2 * this.c0r0, s2 * this.c1r0, s2 * this.c2r0, s2 * this.c0r1, s2 * this.c1r1, s2 * this.c2r1, s2 * this.c0r2, s2 * this.c1r2, s2 * this.c2r2);
    }

    @NotNull
    public final Matrix33 times(@NotNull Matrix33 mat) {
        Intrinsics.checkParameterIsNotNull(mat, "mat");
        return new Matrix33(this.c0r0 * mat.c0r0 + this.c1r0 * mat.c0r1 + this.c2r0 * mat.c0r2, this.c0r0 * mat.c1r0 + this.c1r0 * mat.c1r1 + this.c2r0 * mat.c1r2, this.c0r0 * mat.c2r0 + this.c1r0 * mat.c2r1 + this.c2r0 * mat.c2r2, this.c0r1 * mat.c0r0 + this.c1r1 * mat.c0r1 + this.c2r1 * mat.c0r2, this.c0r1 * mat.c1r0 + this.c1r1 * mat.c1r1 + this.c2r1 * mat.c1r2, this.c0r1 * mat.c2r0 + this.c1r1 * mat.c2r1 + this.c2r1 * mat.c2r2, this.c0r2 * mat.c0r0 + this.c1r2 * mat.c0r1 + this.c2r2 * mat.c0r2, this.c0r2 * mat.c1r0 + this.c1r2 * mat.c1r1 + this.c2r2 * mat.c1r2, this.c0r2 * mat.c2r0 + this.c1r2 * mat.c2r1 + this.c2r2 * mat.c2r2);
    }

    @NotNull
    public String toString() {
        return this.c0r0 + ", " + this.c1r0 + ", " + this.c2r0 + '\n' + this.c0r1 + ", " + this.c1r1 + ", " + this.c2r1 + '\n' + this.c0r2 + ", " + this.c1r2 + ", " + this.c2r2 + '\n';
    }

    public final double getC0r0() {
        return this.c0r0;
    }

    public final double getC1r0() {
        return this.c1r0;
    }

    public final double getC2r0() {
        return this.c2r0;
    }

    public final double getC0r1() {
        return this.c0r1;
    }

    public final double getC1r1() {
        return this.c1r1;
    }

    public final double getC2r1() {
        return this.c2r1;
    }

    public final double getC0r2() {
        return this.c0r2;
    }

    public final double getC1r2() {
        return this.c1r2;
    }

    public final double getC2r2() {
        return this.c2r2;
    }

    public Matrix33(double c0r0, double c1r0, double c2r0, double c0r1, double c1r1, double c2r1, double c0r2, double c1r2, double c2r2) {
        this.c0r0 = c0r0;
        this.c1r0 = c1r0;
        this.c2r0 = c2r0;
        this.c0r1 = c0r1;
        this.c1r1 = c1r1;
        this.c2r1 = c2r1;
        this.c0r2 = c0r2;
        this.c1r2 = c1r2;
        this.c2r2 = c2r2;
    }

    public /* synthetic */ Matrix33(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        if ((n & 8) != 0) {
            d4 = 0.0;
        }
        if ((n & 0x10) != 0) {
            d5 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d6 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d7 = 0.0;
        }
        if ((n & 0x80) != 0) {
            d8 = 0.0;
        }
        if ((n & 0x100) != 0) {
            d9 = 0.0;
        }
        this(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public Matrix33() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 511, null);
    }

    static {
        Companion = new Companion(null);
        IDENTITY = new Matrix33(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 238, null);
        ZERO = new Matrix33(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 511, null);
    }

    public final double component1() {
        return this.c0r0;
    }

    public final double component2() {
        return this.c1r0;
    }

    public final double component3() {
        return this.c2r0;
    }

    public final double component4() {
        return this.c0r1;
    }

    public final double component5() {
        return this.c1r1;
    }

    public final double component6() {
        return this.c2r1;
    }

    public final double component7() {
        return this.c0r2;
    }

    public final double component8() {
        return this.c1r2;
    }

    public final double component9() {
        return this.c2r2;
    }

    @NotNull
    public final Matrix33 copy(double c0r0, double c1r0, double c2r0, double c0r1, double c1r1, double c2r1, double c0r2, double c1r2, double c2r2) {
        return new Matrix33(c0r0, c1r0, c2r0, c0r1, c1r1, c2r1, c0r2, c1r2, c2r2);
    }

    public static /* synthetic */ Matrix33 copy$default(Matrix33 matrix33, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, Object object) {
        if ((n & 1) != 0) {
            d = matrix33.c0r0;
        }
        if ((n & 2) != 0) {
            d2 = matrix33.c1r0;
        }
        if ((n & 4) != 0) {
            d3 = matrix33.c2r0;
        }
        if ((n & 8) != 0) {
            d4 = matrix33.c0r1;
        }
        if ((n & 0x10) != 0) {
            d5 = matrix33.c1r1;
        }
        if ((n & 0x20) != 0) {
            d6 = matrix33.c2r1;
        }
        if ((n & 0x40) != 0) {
            d7 = matrix33.c0r2;
        }
        if ((n & 0x80) != 0) {
            d8 = matrix33.c1r2;
        }
        if ((n & 0x100) != 0) {
            d9 = matrix33.c2r2;
        }
        return matrix33.copy(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public int hashCode() {
        return (((((((Double.hashCode(this.c0r0) * 31 + Double.hashCode(this.c1r0)) * 31 + Double.hashCode(this.c2r0)) * 31 + Double.hashCode(this.c0r1)) * 31 + Double.hashCode(this.c1r1)) * 31 + Double.hashCode(this.c2r1)) * 31 + Double.hashCode(this.c0r2)) * 31 + Double.hashCode(this.c1r2)) * 31 + Double.hashCode(this.c2r2);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Matrix33)) break block3;
                Matrix33 matrix33 = (Matrix33)object;
                if (Double.compare(this.c0r0, matrix33.c0r0) != 0 || Double.compare(this.c1r0, matrix33.c1r0) != 0 || Double.compare(this.c2r0, matrix33.c2r0) != 0 || Double.compare(this.c0r1, matrix33.c0r1) != 0 || Double.compare(this.c1r1, matrix33.c1r1) != 0 || Double.compare(this.c2r1, matrix33.c2r1) != 0 || Double.compare(this.c0r2, matrix33.c0r2) != 0 || Double.compare(this.c1r2, matrix33.c1r2) != 0 || Double.compare(this.c2r2, matrix33.c2r2) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/math/Matrix33$Companion;", "", "()V", "IDENTITY", "Lorg/openrndr/math/Matrix33;", "getIDENTITY", "()Lorg/openrndr/math/Matrix33;", "ZERO", "getZERO", "fromColumnVectors", "c0", "Lorg/openrndr/math/Vector3;", "c1", "c2", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Matrix33 getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Matrix33 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Matrix33 fromColumnVectors(@NotNull Vector3 c0, @NotNull Vector3 c1, @NotNull Vector3 c2) {
            Intrinsics.checkParameterIsNotNull(c0, "c0");
            Intrinsics.checkParameterIsNotNull(c1, "c1");
            Intrinsics.checkParameterIsNotNull(c2, "c2");
            return new Matrix33(c0.getX(), c1.getX(), c2.getX(), c0.getY(), c1.getY(), c2.getY(), c0.getZ(), c1.getZ(), c2.getZ());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

