/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.math.Matrix44;
import org.openrndr.shape.Color;
import org.openrndr.shape.Composition;
import org.openrndr.shape.CompositionColor;
import org.openrndr.shape.CompositionNode;
import org.openrndr.shape.CompositionStrokeWeight;
import org.openrndr.shape.GroupNode;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeNode;
import org.openrndr.shape.StrokeWeight;
import org.openrndr.shape.TextNode;
import org.openrndr.svg.VisitStage;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2,\u0010\u000f\u001a(\u0012\u0004\u0012\u00020\u000e\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0002\b\u0015H\u0002\u001a\u000e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010\u0019\u001a\u00020\f*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\n\u00a8\u0006\u001c"}, d2={"svg", "", "Lorg/openrndr/color/ColorRGBa;", "getSvg", "(Lorg/openrndr/color/ColorRGBa;)Ljava/lang/String;", "Lorg/openrndr/math/Matrix44;", "(Lorg/openrndr/math/Matrix44;)Ljava/lang/String;", "Lorg/openrndr/shape/Shape;", "(Lorg/openrndr/shape/Shape;)Ljava/lang/String;", "Lorg/openrndr/shape/ShapeContour;", "(Lorg/openrndr/shape/ShapeContour;)Ljava/lang/String;", "process", "", "compositionNode", "Lorg/openrndr/shape/CompositionNode;", "visitor", "Lkotlin/Function2;", "Lorg/openrndr/svg/VisitStage;", "Lkotlin/ParameterName;", "name", "stage", "Lkotlin/ExtensionFunctionType;", "writeSVG", "composition", "Lorg/openrndr/shape/Composition;", "saveToFile", "file", "Ljava/io/File;", "openrndr-svg"})
public final class SVGWriterKt {
    public static final void saveToFile(@NotNull Composition $this$saveToFile, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull($this$saveToFile, "$this$saveToFile");
        Intrinsics.checkParameterIsNotNull(file, "file");
        if (!Intrinsics.areEqual(FilesKt.getExtension(file), "svg")) {
            throw (Throwable)new IllegalArgumentException("can only write svg files, the extension '" + FilesKt.getExtension(file) + "' is not supported");
        }
        String svg = SVGWriterKt.writeSVG($this$saveToFile);
        FilesKt.writeText$default(file, svg, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String writeSVG(@NotNull Composition composition2) {
        void textPathID;
        Intrinsics.checkParameterIsNotNull(composition2, "composition");
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1 Tiny//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd\">\n");
        sb.append("<svg version=\"1.1\" baseProfile=\"tiny\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"  x=\"0px\" y=\"0px\"\n width=\"2676px\" height=\"2048px\">");
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        SVGWriterKt.process(composition2.getRoot(), (Function2<? super CompositionNode, ? super VisitStage, Unit>)new Function2<CompositionNode, VisitStage, Unit>(sb, (Ref.IntRef)textPathID){
            final /* synthetic */ StringBuilder $sb;
            final /* synthetic */ Ref.IntRef $textPathID;

            public final void invoke(@NotNull CompositionNode $this$process, @NotNull VisitStage it) {
                block13: {
                    block11: {
                        Object object;
                        int n;
                        block23: {
                            block21: {
                                block22: {
                                    CompositionNode compositionNode;
                                    block14: {
                                        Object object2;
                                        boolean it22;
                                        String fillAttribute;
                                        block20: {
                                            block18: {
                                                block19: {
                                                    boolean bl;
                                                    Object object3;
                                                    boolean bl2;
                                                    block17: {
                                                        block15: {
                                                            block16: {
                                                                block12: {
                                                                    Intrinsics.checkParameterIsNotNull($this$process, "$receiver");
                                                                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), "it");
                                                                    if (it != VisitStage.PRE) break block11;
                                                                    compositionNode = $this$process;
                                                                    if (!(compositionNode instanceof GroupNode)) break block12;
                                                                    if ($this$process.getTransform() != Matrix44.Companion.getIDENTITY()) {
                                                                        this.$sb.append("<g transform=\"" + SVGWriterKt.access$getSvg$p($this$process.getTransform()) + "\">\n");
                                                                    } else {
                                                                        this.$sb.append("<g>\n");
                                                                    }
                                                                    break block13;
                                                                }
                                                                if (!(compositionNode instanceof ShapeNode)) break block14;
                                                                CompositionColor compositionColor = $this$process.getFill();
                                                                boolean bl3 = false;
                                                                bl2 = false;
                                                                CompositionColor it22 = compositionColor;
                                                                boolean bl4 = false;
                                                                if (!(it22 instanceof Color)) break block15;
                                                                object3 = ((Color)it22).getColor();
                                                                if (object3 == null) break block16;
                                                                Object object4 = object3;
                                                                boolean bl5 = false;
                                                                bl = false;
                                                                Object it3 = object4;
                                                                boolean bl6 = false;
                                                                object3 = "fill=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)it3) + '\"';
                                                                if (object3 != null) break block17;
                                                            }
                                                            object3 = "fill=\"none\"";
                                                            break block17;
                                                        }
                                                        object3 = "";
                                                    }
                                                    fillAttribute = object3;
                                                    CompositionColor compositionColor = $this$process.getStroke();
                                                    bl2 = false;
                                                    it22 = false;
                                                    CompositionColor it4 = compositionColor;
                                                    boolean bl7 = false;
                                                    if (!(it4 instanceof Color)) break block18;
                                                    object2 = ((Color)it4).getColor();
                                                    if (object2 == null) break block19;
                                                    Object object5 = object2;
                                                    bl = false;
                                                    boolean it3 = false;
                                                    Object it5 = object5;
                                                    boolean bl8 = false;
                                                    object2 = "stroke=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)it5) + '\"';
                                                    if (object2 != null) break block20;
                                                }
                                                object2 = "stroke=\"none\"";
                                                break block20;
                                            }
                                            object2 = "";
                                        }
                                        String strokeAttribute = object2;
                                        CompositionStrokeWeight compositionStrokeWeight = $this$process.getStrokeWeight();
                                        it22 = false;
                                        boolean it4 = false;
                                        CompositionStrokeWeight it6 = compositionStrokeWeight;
                                        boolean bl = false;
                                        String strokeWidthAttribute = it6 instanceof StrokeWeight ? "stroke-width=\"" + ((StrokeWeight)it6).getWeight() + '\"' : "";
                                        String pathAttribute = "d=\"" + SVGWriterKt.access$getSvg$p(((ShapeNode)$this$process).getShape()) + '\"';
                                        this.$sb.append("<path " + fillAttribute + ' ' + strokeAttribute + ' ' + strokeWidthAttribute + ' ' + pathAttribute + "/>\n");
                                        break block13;
                                    }
                                    if (!(compositionNode instanceof TextNode)) break block13;
                                    CompositionColor strokeAttribute = $this$process.getFill();
                                    n = 0;
                                    boolean bl = false;
                                    CompositionColor it7 = strokeAttribute;
                                    boolean bl9 = false;
                                    if (!(it7 instanceof Color)) break block21;
                                    object = ((Color)it7).getColor();
                                    if (object == null) break block22;
                                    Object object6 = object;
                                    boolean bl10 = false;
                                    boolean bl11 = false;
                                    Object it8 = object6;
                                    boolean bl12 = false;
                                    object = "fill=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)it8) + '\"';
                                    if (object != null) break block23;
                                }
                                object = "fill=\"none\"";
                                break block23;
                            }
                            object = "";
                        }
                        String fillAttribute = object;
                        ShapeContour contour2 = ((TextNode)$this$process).getContour();
                        if (contour2 == null) {
                            this.$sb.append("<text " + fillAttribute + '>' + ((TextNode)$this$process).getText() + "</text>");
                        } else {
                            this.$sb.append("<defs>");
                            this.$sb.append("<path id=\"text" + this.$textPathID.element + "\" d=\"" + SVGWriterKt.access$getSvg$p(contour2) + "\"/>");
                            this.$sb.append("</defs>");
                            this.$sb.append("<text " + fillAttribute + "><textPath href=\"#text" + this.$textPathID.element + "\">" + ((TextNode)$this$process).getText() + "</textPath></text>");
                            n = this.$textPathID.element;
                            this.$textPathID.element = n + 1;
                        }
                        break block13;
                    }
                    CompositionNode compositionNode = $this$process;
                    if (compositionNode instanceof GroupNode) {
                        this.$sb.append("</g>\n");
                    }
                }
            }
            {
                this.$sb = stringBuilder;
                this.$textPathID = intRef;
                super(2);
            }
        });
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    private static final String getSvg(@NotNull ColorRGBa $this$svg) {
        int ir = (int)(RangesKt.coerceIn($this$svg.getR(), 0.0, 1.0) * 255.0);
        int ig = (int)(RangesKt.coerceIn($this$svg.getG(), 0.0, 1.0) * 255.0);
        int ib = (int)(RangesKt.coerceIn($this$svg.getB(), 0.0, 1.0) * 255.0);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "#%02X%02x%02x";
        Object[] objectArray = new Object[]{ir, ig, ib};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
        return string2;
    }

    private static final String getSvg(@NotNull Matrix44 $this$svg) {
        return "matrix(" + $this$svg.getC0r0() + ", " + $this$svg.getC0r1() + ", " + $this$svg.getC1r0() + ", " + $this$svg.getC1r1() + ", " + $this$svg.getC3r0() + ", " + $this$svg.getC3r1() + ')';
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvg(@NotNull Shape $this$svg) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = $this$svg.getContours();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShapeContour it = (ShapeContour)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = it.getSegments();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String string;
                void segment;
                int n = index$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                Segment segment2 = (Segment)item$iv;
                int index = n2;
                boolean bl3 = false;
                if (index == 0) {
                    sb.append("M " + segment.getStart().getX() + ", " + segment.getStart().getY());
                }
                switch (segment.getControl().length) {
                    case 1: {
                        string = "" + 'Q' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                        break;
                    }
                    case 2: {
                        string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getControl()[1].getX() + ", " + segment.getControl()[1].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                        break;
                    }
                    default: {
                        string = "" + 'L' + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    }
                }
                sb.append(string);
            }
            if (!it.getClosed()) continue;
            sb.append("Z ");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvg(@NotNull ShapeContour $this$svg) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = $this$svg.getSegments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String string;
            void segment;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Segment segment2 = (Segment)item$iv;
            int index = n2;
            boolean bl2 = false;
            if (index == 0) {
                sb.append("M " + segment.getStart().getX() + ", " + segment.getStart().getY());
            }
            switch (segment.getControl().length) {
                case 1: {
                    string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    break;
                }
                case 2: {
                    string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getControl()[1].getX() + ", " + segment.getControl()[1].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    break;
                }
                default: {
                    string = "" + 'L' + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                }
            }
            sb.append(string);
        }
        if ($this$svg.getClosed()) {
            sb.append("Z ");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    private static final void process(CompositionNode compositionNode, Function2<? super CompositionNode, ? super VisitStage, Unit> visitor2) {
        visitor2.invoke(compositionNode, VisitStage.PRE);
        if (compositionNode instanceof GroupNode) {
            Iterable $this$forEach$iv = ((GroupNode)compositionNode).getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompositionNode it = (CompositionNode)element$iv;
                boolean bl = false;
                SVGWriterKt.process(it, visitor2);
            }
        }
        visitor2.invoke(compositionNode, VisitStage.POST);
    }

    public static final /* synthetic */ String access$getSvg$p(Matrix44 $this$access_u24svg_u24p) {
        return SVGWriterKt.getSvg($this$access_u24svg_u24p);
    }

    public static final /* synthetic */ String access$getSvg$p(ColorRGBa $this$access_u24svg_u24p) {
        return SVGWriterKt.getSvg($this$access_u24svg_u24p);
    }

    public static final /* synthetic */ String access$getSvg$p(Shape $this$access_u24svg_u24p) {
        return SVGWriterKt.getSvg($this$access_u24svg_u24p);
    }

    public static final /* synthetic */ String access$getSvg$p(ShapeContour $this$access_u24svg_u24p) {
        return SVGWriterKt.getSvg($this$access_u24svg_u24p);
    }
}

