varying vec3 col; 
varying vec3 worldspaceSphereCenter;
uniform float pointSize;
/* varying vec4 baseZpos; */
/* varying vec4 zCorrectionVector; */

void main(void) 
{
  vec2 n = gl_TexCoord[0].xy*vec2(0.5,0.5); 
  float a =(n.x*n.x+n.y*n.y); 
  float z = -sqrt(1.0-4.0*a); 
  vec3 normal = vec3(2.0*n.x,2.0*n.y,z); 
  normal = normalize(normal);
    
  vec3 pos = worldspaceSphereCenter;

  vec4 up = gl_ModelViewProjectionMatrixInverse *
    vec4(0.0, 0.0, -1.0, 0.0);
  vec4 zPos = gl_ModelViewProjectionMatrix *
    vec4(pos.xyz + normalize(up.xyz) * z * pointSize, 1);

                    
  gl_FragDepth = ((zPos.z / zPos.w) + 1.0) * 0.5;
  float fogfactor = gl_FragDepth;//clamp( (zPos.z - 0.5)/5.0 , 0.0, 1.0);
  
  // for outputting the normals and the depth
  gl_FragColor.xyzw = vec4( 0.5+0.5*normal.x, 0.5+0.5*normal.y, fogfactor,1.0 );
}
