/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils;

import io.lacuna.artifex.utils.Scalars;

public class Equations {
    private static final double DISCRIMINANT_EPSILON = 1.0E-10;
    private static final double SOLUTION_EPSILON = 1.0E-8;

    private static double[] trim(double[] acc, int len) {
        if (len == acc.length) {
            return acc;
        }
        if (len == 0) {
            return new double[0];
        }
        double[] result2 = new double[len];
        System.arraycopy(acc, 0, result2, 0, len);
        return result2;
    }

    private static double[] split(double n) {
        double x = n * 1.34217729E8;
        double y = n - x;
        double hi = y + x;
        double lo = n - hi;
        return new double[]{hi, lo};
    }

    private static double discriminant(double a2, double b, double c2) {
        double D2 = b * b - a2 * c2;
        double E = b * b + a2 * c2;
        if (StrictMath.abs(D2) * 3.0 < E) {
            double[] ad = Equations.split(a2);
            double[] bd = Equations.split(b);
            double[] cd = Equations.split(c2);
            double p = b * b;
            double dp = bd[0] * bd[0] - p + 2.0 * bd[0] * bd[1] + bd[1] * bd[1];
            double q = a2 * c2;
            double dq = ad[0] * cd[0] - q + ad[0] * cd[1] + ad[1] * cd[0] + ad[1] * cd[1];
            D2 = p - q + (dp - dq);
        }
        return D2;
    }

    public static int solveLinear(double a2, double b, double[] acc) {
        if (StrictMath.abs(a2) < 1.0E-14) {
            return 0;
        }
        acc[0] = -b / a2;
        return 1;
    }

    public static double[] solveLinear(double a2, double b) {
        double[] acc = new double[1];
        return Equations.trim(acc, Equations.solveLinear(a2, b, acc));
    }

    public static int solveQuadratic(double a2, double b, double c2, double[] acc) {
        double k;
        double D2;
        if (StrictMath.abs(a2) < 1.0E-14) {
            return Equations.solveLinear(b, c2, acc);
        }
        b *= -0.5;
        if ((D2 = Equations.discriminant(a2 *= (k = Scalars.normalizationFactor(a2, b, c2)), b *= k, c2 *= k)) >= -1.0E-10) {
            double Q = D2 < 0.0 ? 0.0 : StrictMath.sqrt(D2);
            double R = b + (b < 0.0 ? -Q : Q);
            if (R == 0.0) {
                acc[0] = c2 / a2;
                acc[1] = -c2 / a2;
            } else {
                acc[0] = R / a2;
                acc[1] = c2 / R;
            }
            int writeIdx = 0;
            for (int readIdx = 0; readIdx < 2; ++readIdx) {
                double x = acc[readIdx];
                double y = a2 * x * x + -2.0 * b * x + c2;
                if (!(StrictMath.abs(y) < 1.0E-8)) continue;
                acc[writeIdx++] = x;
            }
            return writeIdx;
        }
        return 0;
    }

    public static double[] solveQuadratic(double a2, double b, double c2) {
        double[] acc = new double[2];
        return Equations.trim(acc, Equations.solveQuadratic(a2, b, c2, acc));
    }

    public static int solveCubic(double a2, double b, double c2, double d, double[] acc) {
        double x;
        double c22;
        double b1;
        double k = Scalars.normalizationFactor(a2, b, c2, d);
        a2 *= k;
        b *= k;
        c2 *= k;
        d *= k;
        if (StrictMath.abs(a2) < 1.0E-14) {
            return Equations.solveQuadratic(b, c2, d, acc);
        }
        if (StrictMath.abs(d) < 1.0E-14) {
            b1 = b;
            c22 = c2;
            x = 0.0;
        } else {
            double td;
            double rd;
            x = -(b / a2) / 3.0;
            b1 = a2 * x + b;
            c22 = b1 * x + c2;
            double qd = (a2 * x + b1) * x + c22;
            double q = c22 * x + d;
            double t = q / a2;
            double r = StrictMath.pow(StrictMath.abs(t), 0.3333333333333333);
            double s2 = t < 0.0 ? -1.0 : 1.0;
            double x0 = x - s2 * (rd = (td = -qd / a2) > 0.0 ? 1.324717957244746 * StrictMath.max(r, StrictMath.sqrt(td)) : r);
            if (x0 != x) {
                do {
                    x = x0;
                    b1 = a2 * x + b;
                    c22 = b1 * x + c2;
                    qd = (a2 * x + b1) * x + c22;
                    q = c22 * x + d;
                } while (s2 * (x0 = qd == 0.0 ? x : x - q / (qd / (1.0 + Scalars.MACHINE_EPSILON))) > s2 * x);
                if (StrictMath.abs(a2) * x * x > StrictMath.abs(d / x)) {
                    c22 = -d / x;
                    b1 = (c22 - c2) / x;
                }
            }
        }
        int solutions = Equations.solveQuadratic(a2, b1, c22, acc);
        for (int i = 0; i < solutions; ++i) {
            if (acc[i] != x) continue;
            return solutions;
        }
        double y = a2 * x * x * x + b * x * x + c2 * x + d;
        if (StrictMath.abs(y) < 1.0E-8) {
            acc[solutions++] = x;
        }
        return solutions;
    }

    public static double[] solveCubic(double a2, double b, double c2, double d) {
        double[] acc = new double[3];
        return Equations.trim(acc, Equations.solveCubic(a2, b, c2, d, acc));
    }
}

