/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.openrndr.binpack.IntPacker;
import org.openrndr.binpack.PackNode;
import org.openrndr.draw.CharacterPair;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.internal.FontMapManager;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.FontImageMapManagerGL3;
import org.openrndr.internal.gl3.FontImageMapManagerGL3Kt;
import org.openrndr.math.IntVector2;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/internal/gl3/FontImageMapManagerGL3;", "Lorg/openrndr/internal/FontMapManager;", "()V", "alphabet", "", "getAlphabet", "()[C", "cyrillic", "getCyrillic", "fontMaps", "", "", "Lorg/openrndr/draw/FontImageMap;", "getFontMaps$openrndr_gl3", "()Ljava/util/Map;", "standard", "getStandard", "fontMapFromUrl", "url", "size", "", "contentScale", "openrndr-gl3"})
public final class FontImageMapManagerGL3
extends FontMapManager {
    @NotNull
    private final Map<String, FontImageMap> fontMaps;
    @NotNull
    private final char[] standard;
    @NotNull
    private final char[] cyrillic;
    @NotNull
    private final char[] alphabet;

    @NotNull
    public final Map<String, FontImageMap> getFontMaps$openrndr_gl3() {
        return this.fontMaps;
    }

    @NotNull
    public final char[] getStandard() {
        return this.standard;
    }

    @NotNull
    public final char[] getCyrillic() {
        return this.cyrillic;
    }

    @NotNull
    public final char[] getAlphabet() {
        return this.alphabet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FontImageMap fontMapFromUrl(@NotNull String url, double size, double contentScale) {
        IntPacker packer;
        void packSize;
        PackNode root;
        void var23_45;
        void $this$associateTo$iv$iv232;
        Object it232;
        Object object;
        void $this$associateTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(url, "url");
        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
        FontImageMapManagerGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(contentScale){
            final /* synthetic */ double $contentScale;

            @NotNull
            public final String invoke() {
                return "content scale " + this.$contentScale;
            }
            {
                this.$contentScale = d;
                super(0);
            }
        });
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 256;
        byte[] byteArray = TextStreamsKt.readBytes(new URL(url));
        int fileSize = byteArray.length;
        if (fileSize == 0) {
            throw (Throwable)new RuntimeException("0 bytes read");
        }
        FontImageMapManagerGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(fileSize){
            final /* synthetic */ int $fileSize;

            @NotNull
            public final String invoke() {
                return "bytes read: " + this.$fileSize;
            }
            {
                this.$fileSize = n;
                super(0);
            }
        });
        ByteBuffer bb = BufferUtils.createByteBuffer(fileSize);
        bb.order(ByteOrder.nativeOrder());
        ByteBuffer byteBuffer = bb;
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).rewind();
        bb.put(byteArray, 0, fileSize);
        ((Buffer)bb).rewind();
        STBTTFontinfo info = STBTTFontinfo.create();
        boolean status = STBTruetype.stbtt_InitFont(info, bb);
        if (!status) {
            throw (Throwable)new RuntimeException("font error");
        }
        float scale2 = STBTruetype.stbtt_ScaleForPixelHeight(info, (float)(size * contentScale));
        double ascent = 0.0;
        double descent = 0.0;
        double lineGap = 0.0;
        MemoryStack memoryStack = MemoryStack.stackPush();
        boolean bl = false;
        boolean bl2 = false;
        MemoryStack it = memoryStack;
        boolean $i$a$-let-FontImageMapManagerGL3$fontMapFromUrl$432 = false;
        IntBuffer pAscent = it.mallocInt(1);
        IntBuffer pDescent = it.mallocInt(1);
        IntBuffer pLineGap = it.mallocInt(1);
        STBTruetype.stbtt_GetFontVMetrics(info, pAscent, pDescent, pLineGap);
        ascent = (double)((float)pAscent.get(0) * scale2) * 1.0;
        descent = (double)((float)pDescent.get(0) * scale2) * 1.0;
        lineGap = (double)((float)pLineGap.get(0) * scale2) * 1.0;
        char[] $this$associate$iv = this.alphabet;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associate$iv.length), 16);
        char[] $i$a$-let-FontImageMapManagerGL3$fontMapFromUrl$432 = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (IntBuffer intBuffer : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            IntBuffer it232 = intBuffer;
            boolean bl3 = false;
            it232 = new Pair<Character, Integer>(Character.valueOf((char)it232), STBTruetype.stbtt_FindGlyphIndex(info, (int)it232));
            bl3 = false;
            object.put(((Pair)it232).getFirst(), ((Pair)it232).getSecond());
        }
        Map glyphIndices = destination$iv$iv;
        char[] $this$associate$iv2 = this.alphabet;
        boolean $i$f$associate2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associate$iv2.length), 16);
        destination$iv$iv = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo2 = false;
        void var21_37 = $this$associateTo$iv$iv232;
        int n = ((void)var21_37).length;
        boolean bl3 = false;
        while (var23_45 < n) {
            Pair<Character, IntVector2> bl10;
            void element$iv$iv2 = var21_37[var23_45];
            it232 = destination$iv$iv2;
            void c232 = element$iv$iv2;
            boolean bl4 = false;
            AutoCloseable autoCloseable = MemoryStack.stackPush();
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                MemoryStack it3 = (MemoryStack)autoCloseable;
                boolean bl6 = false;
                IntBuffer px0 = it3.mallocInt(1);
                IntBuffer py0 = it3.mallocInt(1);
                IntBuffer px1 = it3.mallocInt(1);
                IntBuffer py1 = it3.mallocInt(1);
                Object v = glyphIndices.get(Character.valueOf((char)c232));
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel(info, ((Number)v).intValue(), scale2, scale2, 0.0f, 0.0f, px0, py0, px1, py1);
                bl10 = new Pair<Character, IntVector2>(Character.valueOf((char)c232), new IntVector2(px1.get() - px0.get(), py1.get() - py0.get()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
            Pair<Character, IntVector2> c232 = bl10;
            bl4 = false;
            it232.put(c232.getFirst(), c232.getSecond());
            ++var23_45;
        }
        Map glyphDimensions = destination$iv$iv2;
        int sanding = 3;
        while (!FontImageMapManagerGL3Kt.attemptPack(root = new PackNode(new IntRectangle(0, 0, packSize.element, packSize.element), null, 2, null), packer = new IntPacker(null, null, null, 7, null), glyphDimensions, sanding)) {
            packSize.element *= 2;
        }
        FontImageMapManagerGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>((Ref.IntRef)packSize){
            final /* synthetic */ Ref.IntRef $packSize;

            @NotNull
            public final String invoke() {
                return "final map size " + this.$packSize.element + 'x' + this.$packSize.element;
            }
            {
                this.$packSize = intRef;
                super(0);
            }
        });
        ColorBuffer image = ColorBuffer.Companion.create$default(ColorBuffer.Companion, packSize.element, packSize.element, 1.0, ColorFormat.R, null, null, 48, null);
        boolean $this$associateTo$iv$iv232 = false;
        Map map2 = new LinkedHashMap();
        PackNode root2 = new PackNode(new IntRectangle(0, 0, packSize.element, packSize.element), null, 2, null);
        IntPacker packer2 = new IntPacker(null, null, null, 7, null);
        boolean bl7 = false;
        Map glyphMetrics = new LinkedHashMap();
        ByteBuffer bitmap = BufferUtils.createByteBuffer(packSize.element * packSize.element);
        FontImageMapManagerGL3Kt.access$getLogger$p().debug(fontMapFromUrl.5.INSTANCE);
        Iterable $this$sortedByDescending$iv = glyphDimensions.entrySet();
        boolean bl6 = false;
        object = $this$sortedByDescending$iv;
        boolean it232 = false;
        Comparator c232 = new Comparator<T>(){

            public final int compare(T a2, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(((IntVector2)it.getValue()).getSquaredLength());
                it = (Map.Entry)a2;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ((IntVector2)it.getValue()).getSquaredLength();
                return ComparisonsKt.compareValues(comparable2, (Comparable)n);
            }
        };
        Iterable $this$forEach$iv = CollectionsKt.sortedWith(object, c232);
        boolean bl8 = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit unit;
            Map.Entry it4 = (Map.Entry)element$iv;
            boolean bl82 = false;
            PackNode target2 = IntPacker.insert$default(packer2, root2, new IntRectangle(0, 0, ((IntVector2)it4.getValue()).getX() + 2 * sanding, ((IntVector2)it4.getValue()).getY() + 2 * sanding), null, 4, null);
            if (target2 != null) {
                PackNode packNode;
                boolean bl9 = false;
                boolean bl10 = false;
                PackNode t = packNode;
                boolean bl11 = false;
                map2.put(it4.getKey(), new IntRectangle(t.getArea().getX() + sanding - 1, t.getArea().getY() + sanding - 1, t.getArea().getWidth() - 2 * sanding + 2, t.getArea().getHeight() - 2 * sanding + 2));
                Object v = glyphIndices.get(it4.getKey());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                int glyphIndex = ((Number)v).intValue();
                int advanceWidth = 0;
                int leftBearing = 0;
                AutoCloseable autoCloseable = MemoryStack.stackPush();
                boolean bl12 = false;
                Throwable throwable = null;
                try {
                    Object stack = (MemoryStack)autoCloseable;
                    boolean bl13 = false;
                    IntBuffer pAdvanceWidth = ((MemoryStack)stack).mallocInt(1);
                    IntBuffer pLeftBearing = ((MemoryStack)stack).mallocInt(1);
                    STBTruetype.stbtt_GetGlyphHMetrics(info, glyphIndex, pAdvanceWidth, pLeftBearing);
                    advanceWidth = pAdvanceWidth.get(0);
                    leftBearing = pLeftBearing.get(0);
                    stack = Unit.INSTANCE;
                }
                catch (Throwable stack) {
                    throwable = stack;
                    throw stack;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                int x0 = 0;
                int y0 = 0;
                int x1 = 0;
                int y1 = 0;
                AutoCloseable autoCloseable2 = MemoryStack.stackPush();
                boolean bl13 = false;
                Throwable throwable3 = null;
                try {
                    MemoryStack stack = (MemoryStack)autoCloseable2;
                    boolean bl15 = false;
                    IntBuffer px0 = stack.mallocInt(1);
                    IntBuffer py0 = stack.mallocInt(1);
                    IntBuffer px1 = stack.mallocInt(1);
                    IntBuffer py1 = stack.mallocInt(1);
                    STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel(info, glyphIndex, scale2, scale2, 0.0f, 0.0f, px0, py0, px1, py1);
                    x0 = px0.get(0);
                    y0 = py0.get(0);
                    x1 = px1.get(0);
                    y1 = py1.get(0);
                    Unit unit2 = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable2, throwable3);
                }
                double ascale = (double)scale2 / contentScale;
                glyphMetrics.put(it4.getKey(), new GlyphMetrics((double)advanceWidth * ascale, (double)leftBearing * ascale, x0, y0));
                ByteBuffer byteBuffer2 = bitmap;
                if (byteBuffer2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((Buffer)byteBuffer2).rewind();
                ((Buffer)bitmap).position((sanding + t.getArea().getY()) * packSize.element + sanding + t.getArea().getX());
                STBTruetype.stbtt_MakeGlyphBitmapSubpixel(info, bitmap, x1 - x0, y1 - y0, packSize.element, scale2, scale2, 0.0f, 0.0f, glyphIndex);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        FontImageMapManagerGL3Kt.access$getLogger$p().debug(fontMapFromUrl.8.INSTANCE);
        ColorBuffer colorBuffer = image;
        if (colorBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.openrndr.internal.gl3.ColorBufferGL3");
        }
        ColorBufferGL3 cfr_ignored_0 = (ColorBufferGL3)colorBuffer;
        ByteBuffer byteBuffer3 = bitmap;
        if (byteBuffer3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer3).rewind();
        image.write(bitmap);
        double leading = ascent - descent + lineGap;
        object = new FontImageMap(image, map2, glyphMetrics, size, contentScale, ascent / contentScale, descent / contentScale, (ascent + descent) / contentScale, leading / contentScale, url);
        boolean bl14 = false;
        boolean bl15 = false;
        Object $this$apply = object;
        boolean bl18 = false;
        for (char outer : this.standard) {
            for (char inner : this.standard) {
                Integer outerGlyph = (Integer)glyphIndices.get(Character.valueOf(outer));
                Integer innerGlyph = (Integer)glyphIndices.get(Character.valueOf(inner));
                if (outerGlyph == null || innerGlyph == null) continue;
                int kernInfo = STBTruetype.stbtt_GetGlyphKernAdvance(info, outerGlyph, innerGlyph);
                ((FontImageMap)$this$apply).getKerningTable().put(new CharacterPair(outer, inner), (double)((float)kernInfo * scale2) / contentScale);
            }
        }
        return object;
    }

    public FontImageMapManagerGL3() {
        Map map2;
        FontImageMapManagerGL3 fontImageMapManagerGL3 = this;
        boolean bl = false;
        fontImageMapManagerGL3.fontMaps = map2 = (Map)new LinkedHashMap();
        this.standard = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00eb', '\u00e4', '\u00f6', '\u00fc', '\u00ef', '\u00ff', '\u00cb', '\u00c4', '\u00d6', '\u00dc', '\u00cf', '\u0178', '\u00f1', '\u00d1', '\u00e7', '\u00c7', '\u00f8', '\u00d8', '\u00e9', '\u00e1', '\u00f3', '\u00ed', '\u00fa', '\u00c9', '\u00c1', '\u00d3', '\u00cd', '\u00da', '\u00e8', '\u00e0', '\u00f2', '\u00ec', '\u00f9', '\u00c8', '\u00c0', '\u00d2', '\u00cc', '\u00d9', '\u00e2', '\u00ea', '\u00ee', '\u00fb', '\u00f4', '\u00c2', '\u00ca', '\u00ce', '\u00db', '\u00d4', '\u0153', '\u0152', '\u00e6', '\u00c6', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '!', '?', '\u00bf', '\u00a1', '\u2026', '.', ',', ' ', ':', ';', '&', '#', '\u2116', '\u201c', '\u201d', '\u2018', '\u2019', '`', '\u00a4', '\u20ac', '$', '\u00a3', '\u2012', '-', '\u2014', '\u2013', '_', '\u00b7', '\u2022', '\u00b0', '@', '^', '*', '\u00ab', '\u00bb', '/', '\\', '\"', '\'', '+', '=', '\u00f7', '~', '%', '(', ')', '[', ']', '{', '}', '<', '>', '|'};
        this.cyrillic = new char[]{'\u0410', '\u0430', '\u0411', '\u0431', '\u0412', '\u0432', '\u0413', '\u0433', '\u0414', '\u0434', '\u0415', '\u0435', '\u0401', '\u0451', '\u0416', '\u0436', '\u0417', '\u0437', '\u0418', '\u0438', '\u0419', '\u0439', '\u041a', '\u043a', '\u041b', '\u043b', '\u041c', '\u043c', '\u041d', '\u043d', '\u041e', '\u043e', '\u041f', '\u043f', '\u0420', '\u0440', '\u0421', '\u0441', '\u0422', '\u0442', '\u0423', '\u0443', '\u0424', '\u0444', '\u0425', '\u0445', '\u0426', '\u0446', '\u0427', '\u0447', '\u0428', '\u0448', '\u0429', '\u0449', '\u042a', '\u044a', '\u042b', '\u044b', '\u042c', '\u044c', '\u042d', '\u044d', '\u042e', '\u044e', '\u042f', '\u044f', '\u0406', '\u0456', '\u040e', '\u045e', '\u0490', '\u0491', '\u0407', '\u0457', '\u0419', '\u0439'};
        this.alphabet = ArraysKt.plus(this.standard, this.cyrillic);
    }
}

