/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import demo.model.Layer;
import demo.view.CameraViewKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lib.EfcurveKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.fcurve.CompoundFCurve;
import org.openrndr.extra.fcurve.FCurve;
import org.openrndr.extra.fcurve.MultiFCurve;
import org.openrndr.extra.fcurve.MultiFCurveExtensionsKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Ldemo/view/CameraView;", "", "camera", "Ldemo/model/Layer$Camera;", "<init>", "(Ldemo/model/Layer$Camera;)V", "getCamera", "()Ldemo/model/Layer$Camera;", "animation", "Ldemo/view/CameraView$Animation;", "getAnimation", "()Ldemo/view/CameraView$Animation;", "animation$delegate", "Lkotlin/Lazy;", "Animation", "deminityy"})
public final class CameraView {
    @NotNull
    private final Layer.Camera camera;
    @NotNull
    private final Lazy animation$delegate;

    public CameraView(@NotNull Layer.Camera camera) {
        Intrinsics.checkNotNullParameter(camera, "camera");
        this.camera = camera;
        this.animation$delegate = LazyKt.lazy(() -> CameraView.animation_delegate$lambda$0(this));
    }

    @NotNull
    public final Layer.Camera getCamera() {
        return this.camera;
    }

    @NotNull
    public final Animation getAnimation() {
        Lazy lazy = this.animation$delegate;
        return (Animation)lazy.getValue();
    }

    private static final Animation animation_delegate$lambda$0(CameraView this$0) {
        return new Animation(this$0.camera.fcurves());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0086\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u001d\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0010R\u0011\u0010!\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0011\u0010&\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0011\u0010+\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010(R\u0011\u0010-\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010(R\u0011\u0010/\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010(R\u0011\u00101\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010(R\u0011\u00103\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010(R\u001a\u00105\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00106\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010(R\u001a\u00108\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002090\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010:\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u001a\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010>\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010(R\u001a\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010A\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010(R\u0011\u0010C\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010F\u00a8\u0006G"}, d2={"Ldemo/view/CameraView$Animation;", "Lorg/openrndr/extra/fcurve/MultiFCurve;", "fcurves", "", "", "<init>", "(Ljava/util/Map;)V", "time", "", "invoke", "", "t", "positionSampler", "Lkotlin/Function1;", "Lorg/openrndr/math/Vector3;", "getPositionSampler", "()Lkotlin/jvm/functions/Function1;", "orientationSampler", "getOrientationSampler", "scaleSampler", "getScaleSampler", "fovSampler", "getFovSampler", "orthoNearSampler", "getOrthoNearSampler", "orthoFarSampler", "getOrthoFarSampler", "perspectiveNearSampler", "getPerspectiveNearSampler", "perspectiveFarSampler", "getPerspectiveFarSampler", "magnitudeSampler", "getMagnitudeSampler", "position", "getPosition", "()Lorg/openrndr/math/Vector3;", "orientation", "getOrientation", "scale", "getScale", "()D", "fov", "getFov", "orthoNear", "getOrthoNear", "orthoFar", "getOrthoFar", "perspectiveNear", "getPerspectiveNear", "perspectiveFar", "getPerspectiveFar", "magnitude", "getMagnitude", "pathPositionSampler", "pathPosition", "getPathPosition", "pathIndexSampler", "", "pathIndex", "getPathIndex", "()I", "pathPoseRotationSampler", "pathPoseRotation", "getPathPoseRotation", "pathScaleSampler", "pathScale", "getPathScale", "transform", "Lorg/openrndr/math/Matrix44;", "getTransform", "()Lorg/openrndr/math/Matrix44;", "deminityy"})
    @SourceDebugExtension(value={"SMAP\nCameraView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraView.kt\ndemo/view/CameraView$Animation\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n462#2:75\n412#2:76\n1246#3,4:77\n*S KotlinDebug\n*F\n+ 1 CameraView.kt\ndemo/view/CameraView$Animation\n*L\n20#1:75\n20#1:76\n20#1:77,4\n*E\n"})
    public static final class Animation
    extends MultiFCurve {
        private double time;
        @NotNull
        private final Function1<Double, Vector3> positionSampler;
        @NotNull
        private final Function1<Double, Vector3> orientationSampler;
        @NotNull
        private final Function1<Double, Double> scaleSampler;
        @NotNull
        private final Function1<Double, Double> fovSampler;
        @NotNull
        private final Function1<Double, Double> orthoNearSampler;
        @NotNull
        private final Function1<Double, Double> orthoFarSampler;
        @NotNull
        private final Function1<Double, Double> perspectiveNearSampler;
        @NotNull
        private final Function1<Double, Double> perspectiveFarSampler;
        @NotNull
        private final Function1<Double, Double> magnitudeSampler;
        @NotNull
        private final Function1<Double, Double> pathPositionSampler;
        @NotNull
        private final Function1<Double, Integer> pathIndexSampler;
        @NotNull
        private final Function1<Double, Double> pathPoseRotationSampler;
        @NotNull
        private final Function1<Double, Double> pathScaleSampler;

        /*
         * WARNING - void declaration
         */
        public Animation(@NotNull Map<String, String> fcurves) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Intrinsics.checkNotNullParameter(fcurves, "fcurves");
            Map<String, String> map2 = fcurves;
            Animation animation = this;
            boolean $i$f$mapValues = false;
            void var4_5 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                FCurve fCurve = EfcurveKt.efcurveOrNull$default((String)it.getValue(), null, null, arg_0 -> Animation._init_$lambda$2$lambda$1((Map.Entry)it, arg_0), 6, null);
                map4.put(k, fCurve);
            }
            super(destination$iv$iv);
            this.positionSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.vector3$default(this, "x", "y", "z", null, 8, null), false, 1, null);
            this.orientationSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.vector3$default(this, "rx", "ry", "rz", null, 8, null), false, 1, null);
            this.scaleSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "scale", 1.0), false, 1, null);
            this.fovSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "fov", 45.0), false, 1, null);
            this.orthoNearSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "ortho-near", 1000.0), false, 1, null);
            this.orthoFarSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "ortho-far", -1000.0), false, 1, null);
            this.perspectiveNearSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "perspective-near", 0.1), false, 1, null);
            this.perspectiveFarSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "perspective-far", 1000.0), false, 1, null);
            this.magnitudeSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "magnitude", 720.0), false, 1, null);
            this.pathPositionSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "path-position", 0.0), false, 1, null);
            this.pathIndexSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.int(this, "path-index", 0), false, 1, null);
            this.pathPoseRotationSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "path-pose-rotation", 1.0), false, 1, null);
            this.pathScaleSampler = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.double(this, "path-scale", 1.0), false, 1, null);
        }

        public final void invoke(double t) {
            this.time = t;
        }

        @NotNull
        public final Function1<Double, Vector3> getPositionSampler() {
            return this.positionSampler;
        }

        @NotNull
        public final Function1<Double, Vector3> getOrientationSampler() {
            return this.orientationSampler;
        }

        @NotNull
        public final Function1<Double, Double> getScaleSampler() {
            return this.scaleSampler;
        }

        @NotNull
        public final Function1<Double, Double> getFovSampler() {
            return this.fovSampler;
        }

        @NotNull
        public final Function1<Double, Double> getOrthoNearSampler() {
            return this.orthoNearSampler;
        }

        @NotNull
        public final Function1<Double, Double> getOrthoFarSampler() {
            return this.orthoFarSampler;
        }

        @NotNull
        public final Function1<Double, Double> getPerspectiveNearSampler() {
            return this.perspectiveNearSampler;
        }

        @NotNull
        public final Function1<Double, Double> getPerspectiveFarSampler() {
            return this.perspectiveFarSampler;
        }

        @NotNull
        public final Function1<Double, Double> getMagnitudeSampler() {
            return this.magnitudeSampler;
        }

        @NotNull
        public final Vector3 getPosition() {
            return this.positionSampler.invoke(this.time);
        }

        @NotNull
        public final Vector3 getOrientation() {
            return this.orientationSampler.invoke(this.time);
        }

        public final double getScale() {
            return ((Number)this.scaleSampler.invoke(this.time)).doubleValue();
        }

        public final double getFov() {
            return ((Number)this.fovSampler.invoke(this.time)).doubleValue();
        }

        public final double getOrthoNear() {
            return ((Number)this.orthoNearSampler.invoke(this.time)).doubleValue();
        }

        public final double getOrthoFar() {
            return ((Number)this.orthoFarSampler.invoke(this.time)).doubleValue();
        }

        public final double getPerspectiveNear() {
            return ((Number)this.perspectiveNearSampler.invoke(this.time)).doubleValue();
        }

        public final double getPerspectiveFar() {
            return ((Number)this.perspectiveFarSampler.invoke(this.time)).doubleValue();
        }

        public final double getMagnitude() {
            return ((Number)this.magnitudeSampler.invoke(this.time)).doubleValue();
        }

        public final double getPathPosition() {
            return ((Number)this.pathPositionSampler.invoke(this.time)).doubleValue();
        }

        public final int getPathIndex() {
            return ((Number)this.pathIndexSampler.invoke(this.time)).intValue();
        }

        public final double getPathPoseRotation() {
            return ((Number)this.pathPoseRotationSampler.invoke(this.time)).doubleValue();
        }

        public final double getPathScale() {
            return ((Number)this.pathScaleSampler.invoke(this.time)).doubleValue();
        }

        @NotNull
        public final Matrix44 getTransform() {
            return TransformBuilderKt.buildTransform$default(null, arg_0 -> Animation._get_transform_$lambda$3(this, arg_0), 1, null);
        }

        private static final Object _init_$lambda$2$lambda$1$lambda$0(Map.Entry $it, Throwable $t) {
            return "camera " + $it.getKey() + ":" + $it.getValue() + " " + $t.getMessage();
        }

        private static final Unit _init_$lambda$2$lambda$1(Map.Entry $it, Throwable t) {
            Intrinsics.checkNotNullParameter(t, "t");
            CameraViewKt.access$getLogger$p().error(() -> Animation._init_$lambda$2$lambda$1$lambda$0($it, t));
            return Unit.INSTANCE;
        }

        private static final Unit _get_transform_$lambda$3(Animation this$0, TransformBuilder $this$buildTransform) {
            Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
            $this$buildTransform.translate(this$0.getPosition().unaryMinus().div(this$0.getScale()));
            $this$buildTransform.scale(this$0.getScale());
            $this$buildTransform.rotate(Vector3.Companion.getUNIT_Z(), this$0.getOrientation().z());
            $this$buildTransform.rotate(Vector3.Companion.getUNIT_Y(), this$0.getOrientation().y());
            $this$buildTransform.rotate(Vector3.Companion.getUNIT_X(), this$0.getOrientation().x());
            return Unit.INSTANCE;
        }
    }
}

