/*
 * Decompiled with CFR 0.152.
 */
package demo.view.renderers;

import demo.model.Layer;
import demo.view.IObjectView;
import demo.view.LayerRenderer;
import demo.view.LayerView;
import demo.view.ObjectRenderer;
import demo.view.ObjectView;
import demo.view.PaintView;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.FontMap;
import org.openrndr.extra.textwriter.DrawerExtensionsKt;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Ldemo/view/renderers/TextRenderer;", "Ldemo/view/ObjectRenderer;", "<init>", "()V", "draw", "", "objectContext", "Ldemo/view/LayerRenderer$ObjectContext;", "Ldemo/view/LayerRenderer;", "deminityy"})
@SourceDebugExtension(value={"SMAP\nTextRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRenderer.kt\ndemo/view/renderers/TextRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class TextRenderer
extends ObjectRenderer {
    @Override
    public void draw(@NotNull LayerRenderer.ObjectContext objectContext) {
        Intrinsics.checkNotNullParameter(objectContext, "objectContext");
        Layer layer = objectContext.getLayerView().getLayer();
        Layer.Object obj = objectContext.getObj();
        IObjectView iObjectView = objectContext.getObjectView();
        Intrinsics.checkNotNull(iObjectView, "null cannot be cast to non-null type demo.view.ObjectView");
        ObjectView ov = (ObjectView)iObjectView;
        LayerView layerView = objectContext.getLayerView();
        double ot = objectContext.getObjectTime();
        Map<String, Layer.Font> map2 = layer.getFonts();
        List<String> list = obj.getFonts();
        Layer.Font layerFont = map2.get(list != null ? CollectionsKt.getOrNull(list, ((Number)objectContext.getFunctions().getFontIndex().invoke(ot)).intValue()) : null);
        List<String> list2 = obj.getTexts();
        if (list2 == null || (list2 = (String)CollectionsKt.getOrNull(list2, ((Number)ov.getAnimation().getTextIndexSampler().invoke(ot)).intValue())) == null) {
            list2 = "ERROR no text";
        }
        List<String> text = list2;
        Vector2 textBoxDimensions = ov.getObjectFunctions().getTextBox().invoke(ot);
        double c0 = ((Number)ov.getObjectFunctions().getC0().invoke(ot)).doubleValue();
        double c1 = ((Number)ov.getObjectFunctions().getC1().invoke(ot)).doubleValue();
        int startIndex = (int)(c0 * (double)((String)((Object)text)).length());
        int endIndex = (int)(c1 * (double)((String)((Object)text)).length());
        String string = ((String)((Object)text)).substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String effectiveText = string;
        if (layerFont != null) {
            DrawerKt.isolated(this.getDrawer(), arg_0 -> TextRenderer.draw$lambda$3(this, objectContext, ot, layerView, layerFont, ov, (String)((Object)text), obj, textBoxDimensions, effectiveText, arg_0));
        }
    }

    private static final Unit draw$lambda$3$lambda$0(TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        TransformBuilder.scale$default($this$buildTransform, 1.0, -1.0, 0.0, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$3$lambda$2(Vector2 $textBoxDimensions, Layer.Object.TextAlign $effectiveTextAlign, String $effectiveText, TextRenderer this$0, ObjectView $ov, double $ot, TextWriter $this$writer) {
        Intrinsics.checkNotNullParameter($this$writer, "$this$writer");
        $this$writer.setBox(RectangleKt.Rectangle(0.0, 0.0, $textBoxDimensions.x(), $textBoxDimensions.y()));
        switch (WhenMappings.$EnumSwitchMapping$0[$effectiveTextAlign.ordinal()]) {
            case 1: {
                double tw = $this$writer.textWidth($effectiveText);
                Drawer drawer = this$0.getDrawer();
                double d = -tw / 2.0 + $ov.getAnimation().getPositionSampler().invoke($ot).x();
                FontMap fontMap = this$0.getDrawer().getFontMap();
                Intrinsics.checkNotNull(fontMap);
                Drawer.translate$default(drawer, d, fontMap.getHeight() / 2.0 + $ov.getAnimation().getPositionSampler().invoke($ot).y(), null, 4, null);
                break;
            }
            case 2: {
                Drawer drawer = this$0.getDrawer();
                double d = $ov.getAnimation().getPositionSampler().invoke($ot).x();
                FontMap fontMap = this$0.getDrawer().getFontMap();
                Intrinsics.checkNotNull(fontMap);
                Drawer.translate$default(drawer, d, fontMap.getHeight() / 2.0 + $ov.getAnimation().getPositionSampler().invoke($ot).y(), null, 4, null);
                break;
            }
            case 3: {
                double tw = $this$writer.textWidth($effectiveText);
                Drawer drawer = this$0.getDrawer();
                double d = -tw + $ov.getAnimation().getPositionSampler().invoke($ot).x();
                FontMap fontMap = this$0.getDrawer().getFontMap();
                Intrinsics.checkNotNull(fontMap);
                Drawer.translate$default(drawer, d, fontMap.getHeight() / 2.0 + $ov.getAnimation().getPositionSampler().invoke($ot).y(), null, 4, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TextWriter.text$default($this$writer, $effectiveText, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$3(TextRenderer this$0, LayerRenderer.ObjectContext $objectContext, double $ot, LayerView $layerView, Layer.Font $layerFont, ObjectView $ov, String $text, Layer.Object $obj, Vector2 $textBoxDimensions, String $effectiveText, Drawer $this$isolated) {
        Layer.Object.TextAlign textAlign;
        PaintView paint;
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        this$0.getDrawer().setFill($objectContext.getFunctions().getFill().invoke($ot));
        Drawer drawer = this$0.getDrawer();
        drawer.setModel(drawer.getModel().times(TransformBuilderKt.buildTransform$default(null, TextRenderer::draw$lambda$3$lambda$0, 1, null)));
        this$0.getDrawer().setFontMap($layerView.getFonts().get($layerFont).getFontMap());
        Pair<Layer.Paint, Map<String, Double>> pair = $ov.getEffectivePaint();
        if (pair != null) {
            Pair<Layer.Paint, Map<String, Double>> it = pair;
            boolean bl = false;
            v1 = $layerView.getPaints().get(it);
        } else {
            v1 = paint = null;
        }
        if (paint != null) {
            paint.apply(this$0.getDrawer(), this$0.getTargetManager(), this$0.getImages(), ((Number)$objectContext.getFunctions().getPaintTime().invoke($ot)).doubleValue());
            this$0.getDrawer().setShadeStyle(paint.getShadeStyle());
        }
        if (StringsKt.contains$default((CharSequence)$text, "\n", false, 2, null)) {
            textAlign = Layer.Object.TextAlign.LEFT;
        } else {
            textAlign = $obj.getTextAlign();
            if (textAlign == null) {
                textAlign = Layer.Object.TextAlign.CENTER;
            }
        }
        Layer.Object.TextAlign effectiveTextAlign = textAlign;
        DrawerExtensionsKt.drawerWriter(this$0.getDrawer(), arg_0 -> TextRenderer.draw$lambda$3$lambda$2($textBoxDimensions, effectiveTextAlign, $effectiveText, this$0, $ov, $ot, arg_0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Layer.Object.TextAlign.values().length];
            try {
                nArray[Layer.Object.TextAlign.CENTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.TextAlign.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.TextAlign.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

