/*
 * Decompiled with CFR 0.152.
 */
package lib;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Triangle;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J'\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001b\u0010\u000f\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\tR\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0012\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0012\u001a\u0004\b\u001d\u0010\t\u00a8\u0006*"}, d2={"Llib/Triangle3d;", "", "x1", "Lorg/openrndr/math/Vector3;", "x2", "x3", "<init>", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)V", "getX1", "()Lorg/openrndr/math/Vector3;", "getX2", "getX3", "randomPoint", "random", "Lkotlin/random/Random;", "normal", "getNormal", "normal$delegate", "Lkotlin/Lazy;", "orientation", "Lorg/openrndr/math/Matrix44;", "projectTo2d", "Lorg/openrndr/shape/Triangle;", "area", "", "getArea", "()D", "area$delegate", "centroid", "getCentroid", "centroid$delegate", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "deminityy"})
public final class Triangle3d {
    @NotNull
    private final Vector3 x1;
    @NotNull
    private final Vector3 x2;
    @NotNull
    private final Vector3 x3;
    @NotNull
    private final Lazy normal$delegate;
    @NotNull
    private final Lazy area$delegate;
    @NotNull
    private final Lazy centroid$delegate;

    public Triangle3d(@NotNull Vector3 x1, @NotNull Vector3 x2, @NotNull Vector3 x3) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
        this.normal$delegate = LazyKt.lazy(() -> Triangle3d.normal_delegate$lambda$0(this));
        this.area$delegate = LazyKt.lazy(() -> Triangle3d.area_delegate$lambda$1(this));
        this.centroid$delegate = LazyKt.lazy(() -> Triangle3d.centroid_delegate$lambda$2(this));
    }

    @NotNull
    public final Vector3 getX1() {
        return this.x1;
    }

    @NotNull
    public final Vector3 getX2() {
        return this.x2;
    }

    @NotNull
    public final Vector3 getX3() {
        return this.x3;
    }

    @NotNull
    public final Vector3 randomPoint(@NotNull Random random) {
        Intrinsics.checkNotNullParameter(random, "random");
        double u = random.nextDouble();
        double v = random.nextDouble();
        double su0 = Math.sqrt(u);
        double b0 = 1.0 - su0;
        double b1 = v * su0;
        Vector3 b = new Vector3(b0, b1, 1.0 - b0 - b1);
        return this.x1.times(b.x()).plus(this.x2.times(b.y())).plus(this.x3.times(b.z()));
    }

    public static /* synthetic */ Vector3 randomPoint$default(Triangle3d triangle3d, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = Random.Default;
        }
        return triangle3d.randomPoint(random);
    }

    @NotNull
    public final Vector3 getNormal() {
        Lazy lazy = this.normal$delegate;
        return (Vector3)lazy.getValue();
    }

    @NotNull
    public final Matrix44 orientation() {
        Vector3 right = (Vector3)this.x2.minus(this.x1).getNormalized();
        Vector3 up = this.getNormal();
        Vector3 forward = (Vector3)up.cross(right).getNormalized();
        return Matrix44.Companion.fromColumnVectors(right.xyz0(), forward.xyz0(), up.xyz0(), Vector4.Companion.getUNIT_W());
    }

    @NotNull
    public final Triangle projectTo2d() {
        Matrix44 oi = this.orientation().inversed();
        Vector2 y1 = new Vector2(0.0, 0.0);
        Vector3 y2 = oi.times(this.x2.minus(this.x1).xyz0()).xyz();
        Vector3 y3 = oi.times(this.x3.minus(this.x1).xyz0()).xyz();
        System.out.println(y2);
        System.out.println(y3);
        return new Triangle(y1, y2.xy(), y3.xy());
    }

    public final double getArea() {
        Lazy lazy = this.area$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @NotNull
    public final Vector3 getCentroid() {
        Lazy lazy = this.centroid$delegate;
        return (Vector3)lazy.getValue();
    }

    @NotNull
    public final Vector3 component1() {
        return this.x1;
    }

    @NotNull
    public final Vector3 component2() {
        return this.x2;
    }

    @NotNull
    public final Vector3 component3() {
        return this.x3;
    }

    @NotNull
    public final Triangle3d copy(@NotNull Vector3 x1, @NotNull Vector3 x2, @NotNull Vector3 x3) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        return new Triangle3d(x1, x2, x3);
    }

    public static /* synthetic */ Triangle3d copy$default(Triangle3d triangle3d, Vector3 vector3, Vector3 vector32, Vector3 vector33, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = triangle3d.x1;
        }
        if ((n & 2) != 0) {
            vector32 = triangle3d.x2;
        }
        if ((n & 4) != 0) {
            vector33 = triangle3d.x3;
        }
        return triangle3d.copy(vector3, vector32, vector33);
    }

    @NotNull
    public String toString() {
        return "Triangle3d(x1=" + this.x1 + ", x2=" + this.x2 + ", x3=" + this.x3 + ")";
    }

    public int hashCode() {
        int result = this.x1.hashCode();
        result = result * 31 + this.x2.hashCode();
        result = result * 31 + this.x3.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Triangle3d)) {
            return false;
        }
        Triangle3d triangle3d = (Triangle3d)other;
        if (!Intrinsics.areEqual(this.x1, triangle3d.x1)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.x2, triangle3d.x2)) {
            return false;
        }
        return Intrinsics.areEqual(this.x3, triangle3d.x3);
    }

    private static final Vector3 normal_delegate$lambda$0(Triangle3d this$0) {
        return (Vector3)((Vector3)this$0.x2.minus(this$0.x1).getNormalized()).cross((Vector3)this$0.x3.minus(this$0.x2).getNormalized()).getNormalized();
    }

    private static final double area_delegate$lambda$1(Triangle3d this$0) {
        Vector3 u = this$0.x2.minus(this$0.x1);
        Vector3 v = this$0.x3.minus(this$0.x1);
        return u.areaBetween((EuclideanVector)v) / 2.0;
    }

    private static final Vector3 centroid_delegate$lambda$2(Triangle3d this$0) {
        return this$0.x1.plus(this$0.x2).plus(this$0.x3).div(3.0);
    }
}

