/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.dfa;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.antlr.v4.kotlinruntime.Vocabulary;
import org.antlr.v4.kotlinruntime.dfa.DFA;
import org.antlr.v4.kotlinruntime.dfa.DFAState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0004J\b\u0010\u000e\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/antlr/v4/kotlinruntime/dfa/DFASerializer;", "", "dfa", "Lorg/antlr/v4/kotlinruntime/dfa/DFA;", "vocabulary", "Lorg/antlr/v4/kotlinruntime/Vocabulary;", "(Lorg/antlr/v4/kotlinruntime/dfa/DFA;Lorg/antlr/v4/kotlinruntime/Vocabulary;)V", "getEdgeLabel", "", "i", "", "getStateString", "s", "Lorg/antlr/v4/kotlinruntime/dfa/DFAState;", "toString", "antlr-kotlin-runtime"})
@SourceDebugExtension(value={"SMAP\nDFASerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DFASerializer.kt\norg/antlr/v4/kotlinruntime/dfa/DFASerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public class DFASerializer {
    @NotNull
    private final DFA dfa;
    @NotNull
    private final Vocabulary vocabulary;

    public DFASerializer(@NotNull DFA dfa, @NotNull Vocabulary vocabulary) {
        Intrinsics.checkNotNullParameter(dfa, "dfa");
        Intrinsics.checkNotNullParameter(vocabulary, "vocabulary");
        this.dfa = dfa;
        this.vocabulary = vocabulary;
    }

    @NotNull
    public String toString() {
        CharSequence charSequence;
        if (this.dfa.getS0() == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        List<DFAState> states = this.dfa.getStates();
        for (DFAState s : states) {
            int n = 0;
            DFAState[] edges = s.getEdges();
            if (edges != null) {
                n = edges.length;
            }
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                Intrinsics.checkNotNull(edges);
                DFAState t = edges[i];
                if (t == null || t.getStateNumber() == Integer.MAX_VALUE) continue;
                buf.append(this.getStateString(s));
                buf.append("-");
                buf.append(this.getEdgeLabel(i));
                buf.append("->");
                buf.append(this.getStateString(t));
                buf.append("\n");
            }
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String output = string;
        CharSequence charSequence2 = output;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "null";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    protected String getEdgeLabel(int i) {
        return this.vocabulary.getDisplayName(i - 1);
    }

    @NotNull
    protected final String getStateString(@NotNull DFAState s) {
        Object[] predicates;
        Intrinsics.checkNotNullParameter(s, "s");
        int n = s.getStateNumber();
        String baseStateStr = (s.isAcceptState() ? ":" : "") + 's' + n + (s.getRequiresFullContext() ? "^" : "");
        return s.isAcceptState() ? ((predicates = s.getPredicates()) != null ? baseStateStr + "=>" + ArraysKt.joinToString$default(predicates, null, null, null, 0, null, null, 63, null) : baseStateStr + "=>" + s.getPrediction()) : baseStateStr;
    }
}

