/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.tree.xpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.antlr.v4.kotlinruntime.AbstractCharStreams;
import org.antlr.v4.kotlinruntime.CharStream;
import org.antlr.v4.kotlinruntime.CharStreams;
import org.antlr.v4.kotlinruntime.CommonTokenStream;
import org.antlr.v4.kotlinruntime.LexerNoViableAltException;
import org.antlr.v4.kotlinruntime.Parser;
import org.antlr.v4.kotlinruntime.ParserRuleContext;
import org.antlr.v4.kotlinruntime.Token;
import org.antlr.v4.kotlinruntime.tree.ParseTree;
import org.antlr.v4.kotlinruntime.tree.xpath.XPathElement;
import org.antlr.v4.kotlinruntime.tree.xpath.XPathLexer;
import org.antlr.v4.kotlinruntime.tree.xpath.XPathLexerErrorListener;
import org.antlr.v4.kotlinruntime.tree.xpath.XPathRuleAnywhereElement;
import org.antlr.v4.kotlinruntime.tree.xpath.XPathRuleElement;
import org.antlr.v4.kotlinruntime.tree.xpath.XPathTokenAnywhereElement;
import org.antlr.v4.kotlinruntime.tree.xpath.XPathTokenElement;
import org.antlr.v4.kotlinruntime.tree.xpath.XPathWildcardAnywhereElement;
import org.antlr.v4.kotlinruntime.tree.xpath.XPathWildcardElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u001b\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010#R(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u000e\u00a2\u0006\u0016\n\u0002\u0010\u0010\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lorg/antlr/v4/kotlinruntime/tree/xpath/XPath;", "", "parser", "Lorg/antlr/v4/kotlinruntime/Parser;", "xpath", "", "(Lorg/antlr/v4/kotlinruntime/Parser;Ljava/lang/String;)V", "elements", "", "Lorg/antlr/v4/kotlinruntime/tree/xpath/XPathElement;", "getElements$annotations", "()V", "getElements", "()[Lorg/antlr/v4/kotlinruntime/tree/xpath/XPathElement;", "setElements", "([Lorg/antlr/v4/kotlinruntime/tree/xpath/XPathElement;)V", "[Lorg/antlr/v4/kotlinruntime/tree/xpath/XPathElement;", "getParser", "()Lorg/antlr/v4/kotlinruntime/Parser;", "setParser", "(Lorg/antlr/v4/kotlinruntime/Parser;)V", "getXpath", "()Ljava/lang/String;", "setXpath", "(Ljava/lang/String;)V", "evaluate", "", "Lorg/antlr/v4/kotlinruntime/tree/ParseTree;", "t", "getXPathElement", "wordToken", "Lorg/antlr/v4/kotlinruntime/Token;", "anywhere", "", "split", "(Ljava/lang/String;)[Lorg/antlr/v4/kotlinruntime/tree/xpath/XPathElement;", "Companion", "antlr-kotlin-runtime"})
@SourceDebugExtension(value={"SMAP\nXPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XPath.kt\norg/antlr/v4/kotlinruntime/tree/xpath/XPath\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,200:1\n37#2,2:201\n*S KotlinDebug\n*F\n+ 1 XPath.kt\norg/antlr/v4/kotlinruntime/tree/xpath/XPath\n*L\n117#1:201,2\n*E\n"})
public class XPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Parser parser;
    @NotNull
    private String xpath;
    @NotNull
    private XPathElement[] elements;
    @NotNull
    public static final String WILDCARD = "*";
    @NotNull
    public static final String NOT = "!";

    public XPath(@NotNull Parser parser, @NotNull String xpath) {
        Intrinsics.checkNotNullParameter(parser, "parser");
        Intrinsics.checkNotNullParameter(xpath, "xpath");
        this.parser = parser;
        this.xpath = xpath;
        this.elements = this.split(this.xpath);
    }

    @NotNull
    protected final Parser getParser() {
        return this.parser;
    }

    protected final void setParser(@NotNull Parser parser) {
        Intrinsics.checkNotNullParameter(parser, "<set-?>");
        this.parser = parser;
    }

    @NotNull
    protected final String getXpath() {
        return this.xpath;
    }

    protected final void setXpath(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.xpath = string;
    }

    @NotNull
    protected final XPathElement[] getElements() {
        return this.elements;
    }

    protected final void setElements(@NotNull XPathElement[] xPathElementArray) {
        Intrinsics.checkNotNullParameter(xPathElementArray, "<set-?>");
        this.elements = xPathElementArray;
    }

    protected static /* synthetic */ void getElements$annotations() {
    }

    @NotNull
    public XPathElement[] split(@NotNull String xpath) {
        Intrinsics.checkNotNullParameter(xpath, "xpath");
        CharStream input = AbstractCharStreams.fromString$default(CharStreams.INSTANCE, xpath, null, 2, null);
        XPathLexer lexer2 = new XPathLexer(input){

            public void recover(@NotNull LexerNoViableAltException e) {
                Intrinsics.checkNotNullParameter(e, "e");
                throw e;
            }
        };
        lexer2.removeErrorListeners();
        lexer2.addErrorListener(new XPathLexerErrorListener());
        CommonTokenStream tokenStream = new CommonTokenStream(lexer2);
        try {
            tokenStream.fill();
        }
        catch (LexerNoViableAltException e) {
            int pos = lexer2.getCharPositionInLine();
            String msg = "Invalid tokens or characters at index " + pos + " in path '" + xpath + '\'';
            throw new IllegalArgumentException(msg, e);
        }
        List<Token> tokens = tokenStream.getTokens();
        int n = tokens.size();
        ArrayList<XPathElement> elements = new ArrayList<XPathElement>(n);
        int i = 0;
        block7: while (i < n) {
            Token el = tokens.get(i);
            Token next = null;
            switch (el.getType()) {
                case 3: 
                case 4: {
                    boolean invert;
                    boolean anywhere = el.getType() == 3;
                    next = tokens.get(++i);
                    boolean bl = invert = next.getType() == 6;
                    if (invert) {
                        next = tokens.get(++i);
                    }
                    XPathElement pathElement = this.getXPathElement(next, anywhere);
                    pathElement.setInvert(invert);
                    elements.add(pathElement);
                    ++i;
                    continue block7;
                }
                case 1: 
                case 2: 
                case 5: {
                    elements.add(this.getXPathElement(el, false));
                    ++i;
                    continue block7;
                }
                case -1: {
                    break block7;
                }
                default: {
                    throw new IllegalArgumentException("Unknown path element " + el);
                }
            }
        }
        Collection $this$toTypedArray$iv = elements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new XPathElement[0]);
    }

    @NotNull
    protected XPathElement getXPathElement(@NotNull Token wordToken, boolean anywhere) {
        XPathElement xPathElement;
        Intrinsics.checkNotNullParameter(wordToken, "wordToken");
        if (wordToken.getType() == -1) {
            throw new IllegalArgumentException("Missing path element at end of path");
        }
        String string = wordToken.getText();
        if (string == null) {
            throw new IllegalStateException("Expected wordToken to have text content");
        }
        String word = string;
        int ttype = this.parser.getTokenType(word);
        int ruleIndex = this.parser.getRuleIndex(word);
        switch (wordToken.getType()) {
            case 5: {
                if (anywhere) {
                    xPathElement = new XPathWildcardAnywhereElement();
                    break;
                }
                xPathElement = new XPathWildcardElement();
                break;
            }
            case 1: 
            case 8: {
                if (ttype == 0) {
                    throw new IllegalArgumentException(word + " at index " + wordToken.getStartIndex() + " isn't a valid token name");
                }
                if (anywhere) {
                    xPathElement = new XPathTokenAnywhereElement(word, ttype);
                    break;
                }
                xPathElement = new XPathTokenElement(word, ttype);
                break;
            }
            default: {
                if (ruleIndex == -1) {
                    throw new IllegalArgumentException(word + " at index " + wordToken.getStartIndex() + " isn't a valid rule name");
                }
                xPathElement = anywhere ? (XPathElement)new XPathRuleAnywhereElement(word, ruleIndex) : (XPathElement)new XPathRuleElement(word, ruleIndex);
            }
        }
        return xPathElement;
    }

    @NotNull
    public Collection<ParseTree> evaluate(@NotNull ParseTree t) {
        Intrinsics.checkNotNullParameter(t, "t");
        ParserRuleContext dummyRoot = new ParserRuleContext();
        dummyRoot.addChild((ParserRuleContext)t);
        Set work = SetsKt.setOf(dummyRoot);
        for (int i = 0; i < this.elements.length; ++i) {
            LinkedHashSet<ParseTree> next = new LinkedHashSet<ParseTree>();
            for (ParseTree node : work) {
                if (node.getChildCount() <= 0) continue;
                Collection<ParseTree> matching = this.elements[i].evaluate(node);
                next.addAll(matching);
            }
            work = next;
        }
        return work;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/antlr/v4/kotlinruntime/tree/xpath/XPath$Companion;", "", "()V", "NOT", "", "WILDCARD", "findAll", "", "Lorg/antlr/v4/kotlinruntime/tree/ParseTree;", "tree", "xpath", "parser", "Lorg/antlr/v4/kotlinruntime/Parser;", "antlr-kotlin-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Collection<ParseTree> findAll(@NotNull ParseTree tree, @NotNull String xpath, @NotNull Parser parser) {
            Intrinsics.checkNotNullParameter(tree, "tree");
            Intrinsics.checkNotNullParameter(xpath, "xpath");
            Intrinsics.checkNotNullParameter(parser, "parser");
            XPath p = new XPath(parser, xpath);
            return p.evaluate(tree);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

