/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.tinyexr.EXRTile;

public class EXRImage
extends Struct<EXRImage>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TILES;
    public static final int NEXT_LEVEL;
    public static final int LEVEL_X;
    public static final int LEVEL_Y;
    public static final int IMAGES;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int NUM_CHANNELS;
    public static final int NUM_TILES;

    protected EXRImage(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected EXRImage create(long address, @Nullable ByteBuffer container) {
        return new EXRImage(address, container);
    }

    public EXRImage(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), EXRImage.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="EXRTile *")
    public @Nullable EXRTile.Buffer tiles() {
        return EXRImage.ntiles(this.address());
    }

    @NativeType(value="struct _EXRImage *")
    public @Nullable EXRImage next_level() {
        return EXRImage.nnext_level(this.address());
    }

    public int level_x() {
        return EXRImage.nlevel_x(this.address());
    }

    public int level_y() {
        return EXRImage.nlevel_y(this.address());
    }

    @NativeType(value="unsigned char **")
    public @Nullable PointerBuffer images() {
        return EXRImage.nimages(this.address());
    }

    public int width() {
        return EXRImage.nwidth(this.address());
    }

    public int height() {
        return EXRImage.nheight(this.address());
    }

    public int num_channels() {
        return EXRImage.nnum_channels(this.address());
    }

    public int num_tiles() {
        return EXRImage.nnum_tiles(this.address());
    }

    public EXRImage tiles(@NativeType(value="EXRTile *") @Nullable EXRTile.Buffer value) {
        EXRImage.ntiles(this.address(), value);
        return this;
    }

    public EXRImage next_level(@NativeType(value="struct _EXRImage *") @Nullable EXRImage value) {
        EXRImage.nnext_level(this.address(), value);
        return this;
    }

    public EXRImage level_x(int value) {
        EXRImage.nlevel_x(this.address(), value);
        return this;
    }

    public EXRImage level_y(int value) {
        EXRImage.nlevel_y(this.address(), value);
        return this;
    }

    public EXRImage images(@NativeType(value="unsigned char **") @Nullable PointerBuffer value) {
        EXRImage.nimages(this.address(), value);
        return this;
    }

    public EXRImage width(int value) {
        EXRImage.nwidth(this.address(), value);
        return this;
    }

    public EXRImage height(int value) {
        EXRImage.nheight(this.address(), value);
        return this;
    }

    public EXRImage num_channels(int value) {
        EXRImage.nnum_channels(this.address(), value);
        return this;
    }

    public EXRImage set(@Nullable EXRTile.Buffer tiles, @Nullable EXRImage next_level, int level_x, int level_y, @Nullable PointerBuffer images, int width, int height, int num_channels) {
        this.tiles(tiles);
        this.next_level(next_level);
        this.level_x(level_x);
        this.level_y(level_y);
        this.images(images);
        this.width(width);
        this.height(height);
        this.num_channels(num_channels);
        return this;
    }

    public EXRImage set(EXRImage src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EXRImage malloc() {
        return new EXRImage(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static EXRImage calloc() {
        return new EXRImage(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static EXRImage create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new EXRImage(MemoryUtil.memAddress(container), container);
    }

    public static EXRImage create(long address) {
        return new EXRImage(address, null);
    }

    public static @Nullable EXRImage createSafe(long address) {
        return address == 0L ? null : new EXRImage(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(EXRImage.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRImage.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static EXRImage mallocStack() {
        return EXRImage.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRImage callocStack() {
        return EXRImage.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRImage mallocStack(MemoryStack stack) {
        return EXRImage.malloc(stack);
    }

    @Deprecated
    public static EXRImage callocStack(MemoryStack stack) {
        return EXRImage.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return EXRImage.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return EXRImage.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRImage.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRImage.calloc(capacity, stack);
    }

    public static EXRImage malloc(MemoryStack stack) {
        return new EXRImage(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static EXRImage calloc(MemoryStack stack) {
        return new EXRImage(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable EXRTile.Buffer ntiles(long struct) {
        return EXRTile.createSafe(MemoryUtil.memGetAddress(struct + (long)TILES), EXRImage.nnum_tiles(struct));
    }

    public static @Nullable EXRImage nnext_level(long struct) {
        return EXRImage.createSafe(MemoryUtil.memGetAddress(struct + (long)NEXT_LEVEL));
    }

    public static int nlevel_x(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LEVEL_X);
    }

    public static int nlevel_y(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LEVEL_Y);
    }

    public static @Nullable PointerBuffer nimages(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)IMAGES), EXRImage.nnum_channels(struct));
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int nnum_channels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_CHANNELS);
    }

    public static int nnum_tiles(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_TILES);
    }

    public static void ntiles(long struct, @Nullable EXRTile.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)TILES, MemoryUtil.memAddressSafe(value));
        EXRImage.nnum_tiles(struct, value == null ? 0 : value.remaining());
    }

    public static void nnext_level(long struct, @Nullable EXRImage value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT_LEVEL, MemoryUtil.memAddressSafe(value));
    }

    public static void nlevel_x(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LEVEL_X, value);
    }

    public static void nlevel_y(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LEVEL_Y, value);
    }

    public static void nimages(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)IMAGES, MemoryUtil.memAddressSafe(value));
        EXRImage.nnum_channels(struct, value == null ? 0 : value.remaining());
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void nnum_channels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_CHANNELS, value);
    }

    public static void nnum_tiles(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_TILES, value);
    }

    public static void validate(long struct) {
        int num_tiles = EXRImage.nnum_tiles(struct);
        if (num_tiles != 0) {
            long tiles = MemoryUtil.memGetAddress(struct + (long)TILES);
            Checks.check(tiles);
            EXRImage.validate(tiles, num_tiles, EXRTile.SIZEOF, EXRTile::validate);
        }
    }

    static {
        Struct.Layout layout = EXRImage.__struct(EXRImage.__member(POINTER_SIZE), EXRImage.__member(POINTER_SIZE), EXRImage.__member(4), EXRImage.__member(4), EXRImage.__member(POINTER_SIZE), EXRImage.__member(4), EXRImage.__member(4), EXRImage.__member(4), EXRImage.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TILES = layout.offsetof(0);
        NEXT_LEVEL = layout.offsetof(1);
        LEVEL_X = layout.offsetof(2);
        LEVEL_Y = layout.offsetof(3);
        IMAGES = layout.offsetof(4);
        WIDTH = layout.offsetof(5);
        HEIGHT = layout.offsetof(6);
        NUM_CHANNELS = layout.offsetof(7);
        NUM_TILES = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<EXRImage, Buffer>
    implements NativeResource {
        private static final EXRImage ELEMENT_FACTORY = EXRImage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected EXRImage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="EXRTile *")
        public @Nullable EXRTile.Buffer tiles() {
            return EXRImage.ntiles(this.address());
        }

        @NativeType(value="struct _EXRImage *")
        public @Nullable EXRImage next_level() {
            return EXRImage.nnext_level(this.address());
        }

        public int level_x() {
            return EXRImage.nlevel_x(this.address());
        }

        public int level_y() {
            return EXRImage.nlevel_y(this.address());
        }

        @NativeType(value="unsigned char **")
        public @Nullable PointerBuffer images() {
            return EXRImage.nimages(this.address());
        }

        public int width() {
            return EXRImage.nwidth(this.address());
        }

        public int height() {
            return EXRImage.nheight(this.address());
        }

        public int num_channels() {
            return EXRImage.nnum_channels(this.address());
        }

        public int num_tiles() {
            return EXRImage.nnum_tiles(this.address());
        }

        public Buffer tiles(@NativeType(value="EXRTile *") @Nullable EXRTile.Buffer value) {
            EXRImage.ntiles(this.address(), value);
            return this;
        }

        public Buffer next_level(@NativeType(value="struct _EXRImage *") @Nullable EXRImage value) {
            EXRImage.nnext_level(this.address(), value);
            return this;
        }

        public Buffer level_x(int value) {
            EXRImage.nlevel_x(this.address(), value);
            return this;
        }

        public Buffer level_y(int value) {
            EXRImage.nlevel_y(this.address(), value);
            return this;
        }

        public Buffer images(@NativeType(value="unsigned char **") @Nullable PointerBuffer value) {
            EXRImage.nimages(this.address(), value);
            return this;
        }

        public Buffer width(int value) {
            EXRImage.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            EXRImage.nheight(this.address(), value);
            return this;
        }

        public Buffer num_channels(int value) {
            EXRImage.nnum_channels(this.address(), value);
            return this;
        }
    }
}

