/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRVersion
extends Struct<EXRVersion>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int TILED;
    public static final int LONG_NAME;
    public static final int NON_IMAGE;
    public static final int MULTIPART;

    protected EXRVersion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected EXRVersion create(long address, @Nullable ByteBuffer container) {
        return new EXRVersion(address, container);
    }

    public EXRVersion(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), EXRVersion.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int version() {
        return EXRVersion.nversion(this.address());
    }

    @NativeType(value="int")
    public boolean tiled() {
        return EXRVersion.ntiled(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean long_name() {
        return EXRVersion.nlong_name(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean non_image() {
        return EXRVersion.nnon_image(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean multipart() {
        return EXRVersion.nmultipart(this.address()) != 0;
    }

    public EXRVersion version(int value) {
        EXRVersion.nversion(this.address(), value);
        return this;
    }

    public EXRVersion tiled(@NativeType(value="int") boolean value) {
        EXRVersion.ntiled(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion long_name(@NativeType(value="int") boolean value) {
        EXRVersion.nlong_name(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion non_image(@NativeType(value="int") boolean value) {
        EXRVersion.nnon_image(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion multipart(@NativeType(value="int") boolean value) {
        EXRVersion.nmultipart(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion set(int version, boolean tiled, boolean long_name, boolean non_image, boolean multipart) {
        this.version(version);
        this.tiled(tiled);
        this.long_name(long_name);
        this.non_image(non_image);
        this.multipart(multipart);
        return this;
    }

    public EXRVersion set(EXRVersion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EXRVersion malloc() {
        return new EXRVersion(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static EXRVersion calloc() {
        return new EXRVersion(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static EXRVersion create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new EXRVersion(MemoryUtil.memAddress(container), container);
    }

    public static EXRVersion create(long address) {
        return new EXRVersion(address, null);
    }

    public static @Nullable EXRVersion createSafe(long address) {
        return address == 0L ? null : new EXRVersion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(EXRVersion.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRVersion.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static EXRVersion mallocStack() {
        return EXRVersion.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRVersion callocStack() {
        return EXRVersion.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRVersion mallocStack(MemoryStack stack) {
        return EXRVersion.malloc(stack);
    }

    @Deprecated
    public static EXRVersion callocStack(MemoryStack stack) {
        return EXRVersion.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return EXRVersion.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return EXRVersion.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRVersion.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRVersion.calloc(capacity, stack);
    }

    public static EXRVersion malloc(MemoryStack stack) {
        return new EXRVersion(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static EXRVersion calloc(MemoryStack stack) {
        return new EXRVersion(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nversion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERSION);
    }

    public static int ntiled(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TILED);
    }

    public static int nlong_name(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LONG_NAME);
    }

    public static int nnon_image(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NON_IMAGE);
    }

    public static int nmultipart(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MULTIPART);
    }

    public static void nversion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERSION, value);
    }

    public static void ntiled(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TILED, value);
    }

    public static void nlong_name(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LONG_NAME, value);
    }

    public static void nnon_image(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NON_IMAGE, value);
    }

    public static void nmultipart(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MULTIPART, value);
    }

    static {
        Struct.Layout layout = EXRVersion.__struct(EXRVersion.__member(4), EXRVersion.__member(4), EXRVersion.__member(4), EXRVersion.__member(4), EXRVersion.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        TILED = layout.offsetof(1);
        LONG_NAME = layout.offsetof(2);
        NON_IMAGE = layout.offsetof(3);
        MULTIPART = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<EXRVersion, Buffer>
    implements NativeResource {
        private static final EXRVersion ELEMENT_FACTORY = EXRVersion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected EXRVersion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int version() {
            return EXRVersion.nversion(this.address());
        }

        @NativeType(value="int")
        public boolean tiled() {
            return EXRVersion.ntiled(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean long_name() {
            return EXRVersion.nlong_name(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean non_image() {
            return EXRVersion.nnon_image(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean multipart() {
            return EXRVersion.nmultipart(this.address()) != 0;
        }

        public Buffer version(int value) {
            EXRVersion.nversion(this.address(), value);
            return this;
        }

        public Buffer tiled(@NativeType(value="int") boolean value) {
            EXRVersion.ntiled(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer long_name(@NativeType(value="int") boolean value) {
            EXRVersion.nlong_name(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer non_image(@NativeType(value="int") boolean value) {
            EXRVersion.nnon_image(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer multipart(@NativeType(value="int") boolean value) {
            EXRVersion.nmultipart(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

