/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ChromaColor;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHABa$;
import org.openrndr.color.ColorLCHABaKt;
import org.openrndr.color.ColorLSHABa;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ColorXYZa$;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.LuminosityColor;
import org.openrndr.color.ReferenceWhitePoint;
import org.openrndr.color.ShadableColor;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 M2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\b\u0012\u0004\u0012\u00020\u00000\u00062\b\u0012\u0004\u0012\u00020\u00000\u0007:\u0002MNB3\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010BE\b\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0015J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u000eJ\b\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\tH\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\tH\u0016J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\tH\u0096\u0002J\u0018\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\tH\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\tH\u0016J\u0010\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\tH\u0016J\u0010\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\tH\u0016J\t\u00109\u001a\u00020\tH\u00c6\u0003J\t\u0010:\u001a\u00020\tH\u00c6\u0003J\t\u0010;\u001a\u00020\tH\u00c6\u0003J\t\u0010<\u001a\u00020\tH\u00c6\u0003J\t\u0010=\u001a\u00020\u000eH\u00c6\u0003J;\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010?\u001a\u00020@2\b\u0010-\u001a\u0004\u0018\u00010AH\u00d6\u0003J\t\u0010B\u001a\u00020\u0012H\u00d6\u0001J\t\u0010C\u001a\u00020DH\u00d6\u0001J%\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0001\u00a2\u0006\u0002\bLR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u00101\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0017R\u0014\u00104\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0017R\u0014\u00107\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0017\u00a8\u0006O"}, d2={"Lorg/openrndr/color/ColorLCHABa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ReferenceWhitePoint;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/ChromaColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/LuminosityColor;", "Lorg/openrndr/color/AlgebraicColor;", "l", "", "c", "h", "alpha", "ref", "Lorg/openrndr/color/ColorXYZa;", "<init>", "(DDDDLorg/openrndr/color/ColorXYZa;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLorg/openrndr/color/ColorXYZa;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getL", "()D", "getC", "getH", "getAlpha", "getRef", "()Lorg/openrndr/color/ColorXYZa;", "toLABa", "Lorg/openrndr/color/ColorLABa;", "toXYZa", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toLSHABa", "Lorg/openrndr/color/ColorLSHABa;", "opacify", "factor", "shade", "plus", "right", "minus", "times", "scale", "mix", "other", "toVector4", "Lorg/openrndr/math/Vector4;", "withChroma", "chroma", "getChroma", "withHue", "hue", "getHue", "withLuminosity", "luminosity", "getLuminosity", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_color", "Companion", "$serializer", "openrndr-color"})
@SourceDebugExtension(value={"SMAP\nColorLCHABa.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorLCHABa.kt\norg/openrndr/color/ColorLCHABa\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,175:1\n86#2:176\n86#2:177\n*S KotlinDebug\n*F\n+ 1 ColorLCHABa.kt\norg/openrndr/color/ColorLCHABa\n*L\n115#1:176\n116#1:177\n*E\n"})
public final class ColorLCHABa
implements ColorModel<ColorLCHABa>,
ReferenceWhitePoint,
ShadableColor<ColorLCHABa>,
ChromaColor<ColorLCHABa>,
HueShiftableColor<ColorLCHABa>,
LuminosityColor<ColorLCHABa>,
AlgebraicColor<ColorLCHABa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double l;
    private final double c;
    private final double h;
    private final double alpha;
    @NotNull
    private final ColorXYZa ref;

    public ColorLCHABa(double l, double c2, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        this.l = l;
        this.c = c2;
        this.h = h;
        this.alpha = alpha;
        this.ref = ref;
    }

    public /* synthetic */ ColorLCHABa(double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        this(d, d2, d3, d4, colorXYZa);
    }

    public final double getL() {
        return this.l;
    }

    public final double getC() {
        return this.c;
    }

    public final double getH() {
        return this.h;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    @NotNull
    public ColorXYZa getRef() {
        return this.ref;
    }

    @NotNull
    public final ColorLABa toLABa() {
        double $this$asRadians$iv = this.h;
        boolean $i$f$getAsRadians = false;
        double a = this.c * Math.cos($this$asRadians$iv * (Math.PI / 180));
        double $this$asRadians$iv2 = this.h;
        boolean $i$f$getAsRadians2 = false;
        double b = this.c * Math.sin($this$asRadians$iv2 * (Math.PI / 180));
        return new ColorLABa(this.l, a, b, this.getAlpha(), this.getRef());
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        return this.toLABa().toXYZa();
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toLABa().toXYZa().toRGBa();
    }

    @NotNull
    public final ColorLSHABa toLSHABa() {
        return ColorLSHABa.Companion.fromLCHABa(this);
    }

    @Override
    @NotNull
    public ColorLCHABa opacify(double factor) {
        return ColorLCHABa.copy$default(this, 0.0, 0.0, 0.0, this.getAlpha() * factor, null, 23, null);
    }

    @Override
    @NotNull
    public ColorLCHABa shade(double factor) {
        return ColorLCHABa.copy$default(this, this.l * factor, 0.0, 0.0, 0.0, null, 30, null);
    }

    @Override
    @NotNull
    public ColorLCHABa plus(@NotNull ColorLCHABa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorLCHABa.copy$default(this, this.l + right.l, this.c + right.c, this.h + right.h, this.getAlpha() + right.getAlpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorLCHABa minus(@NotNull ColorLCHABa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorLCHABa.copy$default(this, this.l - right.l, this.c - right.c, this.h - right.h, this.getAlpha() - right.getAlpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorLCHABa times(double scale) {
        return ColorLCHABa.copy$default(this, this.l * scale, this.c * scale, this.h * scale, this.getAlpha() * scale, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLCHABa mix(@NotNull ColorLCHABa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorLCHABaKt.mix(this, other, factor);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.l, this.c, this.h, this.getAlpha());
    }

    @Override
    @NotNull
    public ColorLCHABa withChroma(double chroma) {
        return ColorLCHABa.copy$default(this, 0.0, chroma, 0.0, 0.0, null, 29, null);
    }

    @Override
    public double getChroma() {
        return this.c;
    }

    @Override
    @NotNull
    public ColorLCHABa withHue(double hue) {
        return ColorLCHABa.copy$default(this, 0.0, 0.0, hue, 0.0, null, 27, null);
    }

    @Override
    public double getHue() {
        return this.h;
    }

    @Override
    @NotNull
    public ColorLCHABa withLuminosity(double luminosity) {
        return ColorLCHABa.copy$default(this, luminosity, 0.0, 0.0, 0.0, null, 30, null);
    }

    @Override
    public double getLuminosity() {
        return this.l;
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.c;
    }

    public final double component3() {
        return this.h;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa component5() {
        return this.ref;
    }

    @NotNull
    public final ColorLCHABa copy(double l, double c2, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return new ColorLCHABa(l, c2, h, alpha, ref);
    }

    public static /* synthetic */ ColorLCHABa copy$default(ColorLCHABa colorLCHABa, double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorLCHABa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorLCHABa.c;
        }
        if ((n & 4) != 0) {
            d3 = colorLCHABa.h;
        }
        if ((n & 8) != 0) {
            d4 = colorLCHABa.alpha;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = colorLCHABa.ref;
        }
        return colorLCHABa.copy(d, d2, d3, d4, colorXYZa);
    }

    @NotNull
    public String toString() {
        return "ColorLCHABa(l=" + this.l + ", c=" + this.c + ", h=" + this.h + ", alpha=" + this.alpha + ", ref=" + this.ref + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.l);
        result = result * 31 + Double.hashCode(this.c);
        result = result * 31 + Double.hashCode(this.h);
        result = result * 31 + Double.hashCode(this.alpha);
        result = result * 31 + this.ref.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorLCHABa)) {
            return false;
        }
        ColorLCHABa colorLCHABa = (ColorLCHABa)other;
        if (Double.compare(this.l, colorLCHABa.l) != 0) {
            return false;
        }
        if (Double.compare(this.c, colorLCHABa.c) != 0) {
            return false;
        }
        if (Double.compare(this.h, colorLCHABa.h) != 0) {
            return false;
        }
        if (Double.compare(this.alpha, colorLCHABa.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.ref, colorLCHABa.ref);
    }

    @Override
    @NotNull
    public ColorLCHABa shiftChroma(double shift) {
        return ChromaColor.DefaultImpls.shiftChroma(this, shift);
    }

    @Override
    @NotNull
    public ColorLCHABa modulateChroma(double factor) {
        return ChromaColor.DefaultImpls.modulateChroma(this, factor);
    }

    @Override
    @NotNull
    public ColorLCHABa mixChroma(double target2, double factor) {
        return ChromaColor.DefaultImpls.mixChroma(this, target2, factor);
    }

    @Override
    @NotNull
    public ColorLCHABa shiftHue(double shiftInDegrees) {
        return HueShiftableColor.DefaultImpls.shiftHue(this, shiftInDegrees);
    }

    @Override
    @NotNull
    public ColorLCHABa mixHue(double hue, double factor) {
        return HueShiftableColor.DefaultImpls.mixHue(this, hue, factor);
    }

    @Override
    @NotNull
    public ColorLCHABa shadeLuminosity(double factor) {
        return LuminosityColor.DefaultImpls.shadeLuminosity(this, factor);
    }

    @Override
    @NotNull
    public ColorLCHABa mixLuminosity(double luminosity, double factor) {
        return LuminosityColor.DefaultImpls.mixLuminosity(this, luminosity, factor);
    }

    @Override
    @NotNull
    public ColorLCHABa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_color(ColorLCHABa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.l);
        output.encodeDoubleElement(serialDesc, 1, self.c);
        output.encodeDoubleElement(serialDesc, 2, self.h);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.getAlpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.getAlpha());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual(self.getRef(), ColorXYZa.Companion.getNEUTRAL())) {
            output.encodeSerializableElement(serialDesc, 4, ColorXYZa$.serializer.INSTANCE, self.getRef());
        }
    }

    public /* synthetic */ ColorLCHABa(int seen0, double l, double c2, double h, double alpha, ColorXYZa ref, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.l = l;
        this.c = c2;
        this.h = h;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
        this.ref = (seen0 & 0x10) == 0 ? ColorXYZa.Companion.getNEUTRAL() : ref;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/color/ColorLCHABa$Companion;", "", "<init>", "()V", "findMaxChroma", "", "l", "h", "ref", "Lorg/openrndr/color/ColorXYZa;", "fromLABa", "Lorg/openrndr/color/ColorLCHABa;", "laba", "Lorg/openrndr/color/ColorLABa;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-color"})
    @SourceDebugExtension(value={"SMAP\nColorLCHABa.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorLCHABa.kt\norg/openrndr/color/ColorLCHABa$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,175:1\n1#2:176\n87#3:177\n*S KotlinDebug\n*F\n+ 1 ColorLCHABa.kt\norg/openrndr/color/ColorLCHABa$Companion\n*L\n99#1:177\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final double findMaxChroma(double l, double h, @NotNull ColorXYZa ref) {
            boolean rightValid;
            boolean middleValid;
            boolean leftValid;
            Intrinsics.checkNotNullParameter(ref, "ref");
            double left = 0.0;
            double right = 2000.0;
            double bestGuess = left;
            do {
                if (right - left < 1.0E-4) {
                    return bestGuess;
                }
                ColorLCHABa leftTry = new ColorLCHABa(l, left, h, 1.0, ref);
                ColorLCHABa rightTry = new ColorLCHABa(l, right, h, 1.0, ref);
                double middle = (left + right) / (double)2;
                ColorLCHABa middleTry = new ColorLCHABa(l, middle, h, 1.0, ref);
                ColorRGBa it = leftTry.toRGBa();
                boolean bl = false;
                leftValid = it.getMinValue() >= 0.0 && it.getMaxValue() <= 1.0;
                ColorRGBa it2 = rightTry.toRGBa();
                boolean bl2 = false;
                rightValid = it2.getMinValue() >= 0.0 && it2.getMaxValue() <= 1.0;
                ColorRGBa it3 = middleTry.toRGBa();
                boolean bl3 = false;
                middleValid = it3.getMinValue() >= 0.0 && it3.getMaxValue() <= 1.0;
                if (leftValid && middleValid && !rightValid) {
                    double newLeft = middle;
                    double newRight = right;
                    bestGuess = middle;
                    left = newLeft;
                    right = newRight;
                }
                if (!leftValid || middleValid || rightValid) continue;
                double newLeft = left;
                double newRight = middle;
                left = newLeft;
                right = newRight;
            } while (leftValid != middleValid || middleValid != rightValid);
            return bestGuess;
        }

        @NotNull
        public final ColorLCHABa fromLABa(@NotNull ColorLABa laba) {
            Intrinsics.checkNotNullParameter(laba, "laba");
            double l = laba.l();
            double c2 = Math.sqrt(laba.a() * laba.a() + laba.b() * laba.b());
            double h = Math.atan2(laba.b(), laba.a());
            if (h < 0.0) {
                h += Math.PI * 2;
            }
            double $this$asDegrees$iv = h;
            boolean $i$f$getAsDegrees = false;
            h = $this$asDegrees$iv * 57.29577951308232;
            return new ColorLCHABa(l, c2, h, laba.alpha(), laba.ref());
        }

        @NotNull
        public final KSerializer<ColorLCHABa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

