/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHABa;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa$;
import org.openrndr.color.ColorRGBaKt;
import org.openrndr.color.ColorXSLa;
import org.openrndr.color.ColorXSVa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.Linearity;
import org.openrndr.color.ShadableColor;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\b\u0018\u0000 c2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0003bcdB3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fBM\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u000b\u0010\u0012J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000209J\u0010\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u000209J\u0010\u0010=\u001a\u00020>2\b\b\u0002\u0010<\u001a\u000209J\u0010\u0010?\u001a\u00020@2\b\b\u0002\u0010<\u001a\u000209J\u0010\u0010A\u001a\u00020B2\b\b\u0002\u0010<\u001a\u000209J\u0006\u0010C\u001a\u00020\u0000J\u0006\u0010D\u001a\u00020\u0000J\b\u0010E\u001a\u00020\u0000H\u0016J\b\u0010F\u001a\u00020\u000eH\u0016J\u0011\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010I\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0005H\u0096\u0002J\u0018\u0010L\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010M\u001a\u00020NH\u0016J\t\u0010O\u001a\u00020\u0005H\u00c6\u0003J\t\u0010P\u001a\u00020\u0005H\u00c6\u0003J\t\u0010Q\u001a\u00020\u0005H\u00c6\u0003J\t\u0010R\u001a\u00020\u0005H\u00c6\u0003J\t\u0010S\u001a\u00020\nH\u00c6\u0003J;\u0010T\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010U\u001a\u00020V2\b\u0010/\u001a\u0004\u0018\u00010WH\u00d6\u0003J\t\u0010X\u001a\u00020YH\u00d6\u0001J%\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u00002\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0001\u00a2\u0006\u0002\baR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u000f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u0014R\u001a\u0010 \u001a\u00020\u00008FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b!\u0010\u001b\u001a\u0004\b\"\u0010#R\u0011\u0010%\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b&\u0010#R\u0011\u0010'\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0014R\u0011\u0010)\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0014R\u0011\u0010+\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0014\u00a8\u0006e"}, d2={"Lorg/openrndr/color/ColorRGBa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/AlgebraicColor;", "r", "", "g", "b", "alpha", "linearity", "Lorg/openrndr/color/Linearity;", "<init>", "(DDDDLorg/openrndr/color/Linearity;)V", "seen0", "", "a", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLorg/openrndr/color/Linearity;DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getR", "()D", "getG", "getB", "getAlpha", "getLinearity", "()Lorg/openrndr/color/Linearity;", "getA$annotations", "()V", "getA", "opacify", "factor", "shade", "saturated", "getSaturated$annotations", "getSaturated", "()Lorg/openrndr/color/ColorRGBa;", "clip", "alphaMultiplied", "getAlphaMultiplied", "minValue", "getMinValue", "maxValue", "getMaxValue", "luminance", "getLuminance", "toLinearity", "getContrastRatio", "other", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toHSLa", "Lorg/openrndr/color/ColorHSLa;", "toXSVa", "Lorg/openrndr/color/ColorXSVa;", "toXSLa", "Lorg/openrndr/color/ColorXSLa;", "toXYZa", "Lorg/openrndr/color/ColorXYZa;", "toLABa", "Lorg/openrndr/color/ColorLABa;", "ref", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toLCHABa", "Lorg/openrndr/color/ColorLCHABa;", "toLCHUVa", "Lorg/openrndr/color/ColorLCHUVa;", "toLinear", "toSRGB", "toRGBa", "hashCode", "plus", "right", "minus", "times", "scale", "mix", "toVector4", "Lorg/openrndr/math/Vector4;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_color", "Component", "Companion", "$serializer", "openrndr-color"})
public final class ColorRGBa
implements ColorModel<ColorRGBa>,
ShadableColor<ColorRGBa>,
AlgebraicColor<ColorRGBa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double r;
    private final double g;
    private final double b;
    private final double alpha;
    @NotNull
    private final Linearity linearity;
    private final double a;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;
    @NotNull
    private static final ColorRGBa PINK;
    @NotNull
    private static final ColorRGBa BLACK;
    @NotNull
    private static final ColorRGBa WHITE;
    @NotNull
    private static final ColorRGBa RED;
    @NotNull
    private static final ColorRGBa BLUE;
    @NotNull
    private static final ColorRGBa GREEN;
    @NotNull
    private static final ColorRGBa YELLOW;
    @NotNull
    private static final ColorRGBa CYAN;
    @NotNull
    private static final ColorRGBa MAGENTA;
    @NotNull
    private static final ColorRGBa GRAY;
    @NotNull
    private static final ColorRGBa TRANSPARENT;

    public ColorRGBa(double r, double g, double b, double alpha, @NotNull Linearity linearity) {
        Intrinsics.checkNotNullParameter((Object)linearity, "linearity");
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = alpha;
        this.linearity = linearity;
        this.a = this.getAlpha();
    }

    public /* synthetic */ ColorRGBa(double d, double d2, double d3, double d4, Linearity linearity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            linearity = Linearity.LINEAR;
        }
        this(d, d2, d3, d4, linearity);
    }

    public final double getR() {
        return this.r;
    }

    public final double getG() {
        return this.g;
    }

    public final double getB() {
        return this.b;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @NotNull
    public final Linearity getLinearity() {
        return this.linearity;
    }

    public final double getA() {
        return this.a;
    }

    @Deprecated(message="Legacy alpha parameter name", replaceWith=@ReplaceWith(expression="alpha", imports={}))
    public static /* synthetic */ void getA$annotations() {
    }

    @Override
    @NotNull
    public ColorRGBa opacify(double factor) {
        return new ColorRGBa(this.r, this.g, this.b, this.getAlpha() * factor, this.linearity);
    }

    @Override
    @NotNull
    public ColorRGBa shade(double factor) {
        return new ColorRGBa(this.r * factor, this.g * factor, this.b * factor, this.getAlpha(), this.linearity);
    }

    @NotNull
    public final ColorRGBa getSaturated() {
        return this.clip();
    }

    @Deprecated(message="Use clip() instead", replaceWith=@ReplaceWith(expression="clip()", imports={}))
    public static /* synthetic */ void getSaturated$annotations() {
    }

    @NotNull
    public final ColorRGBa clip() {
        return ColorRGBa.copy$default(this, ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(this.r), RangesKt.rangeTo(0.0, 1.0))).doubleValue(), ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(this.g), RangesKt.rangeTo(0.0, 1.0))).doubleValue(), ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(this.b), RangesKt.rangeTo(0.0, 1.0))).doubleValue(), ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(this.getAlpha()), RangesKt.rangeTo(0.0, 1.0))).doubleValue(), null, 16, null);
    }

    @NotNull
    public final ColorRGBa getAlphaMultiplied() {
        return new ColorRGBa(this.r * this.getAlpha(), this.g * this.getAlpha(), this.b * this.getAlpha(), this.getAlpha(), this.linearity);
    }

    public final double getMinValue() {
        return RangesKt.coerceAtMost(RangesKt.coerceAtMost(this.r, this.g), this.b);
    }

    public final double getMaxValue() {
        return RangesKt.coerceAtLeast(RangesKt.coerceAtLeast(this.r, this.g), this.b);
    }

    public final double getLuminance() {
        return WhenMappings.$EnumSwitchMapping$0[this.linearity.ordinal()] == 1 ? this.toLinear().getLuminance() : 0.2126 * this.r + 0.7152 * this.g + 0.0722 * this.b;
    }

    @NotNull
    public final ColorRGBa toLinearity(@NotNull Linearity linearity) {
        Intrinsics.checkNotNullParameter((Object)linearity, "linearity");
        return switch (WhenMappings.$EnumSwitchMapping$0[linearity.ordinal()]) {
            case 1 -> this.toSRGB();
            case 2 -> this.toLinear();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final double getContrastRatio(@NotNull ColorRGBa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double l1 = this.getLuminance();
        double l2 = other.getLuminance();
        return l1 > l2 ? (l1 + 0.05) / (l2 + 0.05) : (l2 + 0.05) / (l1 + 0.05);
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        return ColorHSVa.Companion.fromRGBa(this.toSRGB());
    }

    @NotNull
    public final ColorHSLa toHSLa() {
        return ColorHSLa.Companion.fromRGBa(this.toSRGB());
    }

    @NotNull
    public final ColorXSVa toXSVa() {
        return ColorHSVa.Companion.fromRGBa(this.toSRGB()).toXSVa();
    }

    @NotNull
    public final ColorXSLa toXSLa() {
        return ColorHSLa.Companion.fromRGBa(this.toSRGB()).toXSLa();
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        return ColorXYZa.Companion.fromRGBa(this.toLinear());
    }

    @NotNull
    public final ColorLABa toLABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return ColorLABa.Companion.fromRGBa(this.toLinear(), ref);
    }

    public static /* synthetic */ ColorLABa toLABa$default(ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorRGBa.toLABa(colorXYZa);
    }

    @NotNull
    public final ColorLUVa toLUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return ColorLUVa.Companion.fromRGBa(this.toLinear(), ref);
    }

    public static /* synthetic */ ColorLUVa toLUVa$default(ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorRGBa.toLUVa(colorXYZa);
    }

    @NotNull
    public final ColorLCHABa toLCHABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toXYZa().toLABa(ref).toLCHABa();
    }

    public static /* synthetic */ ColorLCHABa toLCHABa$default(ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorRGBa.toLCHABa(colorXYZa);
    }

    @NotNull
    public final ColorLCHUVa toLCHUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toLUVa(ref).toLCHUVa();
    }

    public static /* synthetic */ ColorLCHUVa toLCHUVa$default(ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorRGBa.toLCHUVa(colorXYZa);
    }

    @NotNull
    public final ColorRGBa toLinear() {
        return WhenMappings.$EnumSwitchMapping$0[this.linearity.ordinal()] == 1 ? new ColorRGBa(ColorRGBa.toLinear$t(this.r), ColorRGBa.toLinear$t(this.g), ColorRGBa.toLinear$t(this.b), this.getAlpha(), Linearity.LINEAR) : this;
    }

    @NotNull
    public final ColorRGBa toSRGB() {
        return WhenMappings.$EnumSwitchMapping$0[this.linearity.ordinal()] == 2 ? new ColorRGBa(ColorRGBa.toSRGB$t$0(this.r), ColorRGBa.toSRGB$t$0(this.g), ColorRGBa.toSRGB$t$0(this.b), this.getAlpha(), Linearity.SRGB) : this;
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this;
    }

    public int hashCode() {
        int result = Double.hashCode(this.r);
        result = 31 * result + Double.hashCode(this.g);
        result = 31 * result + Double.hashCode(this.b);
        result = 31 * result + Double.hashCode(this.getAlpha());
        result = 31 * result + Integer.hashCode(this.linearity.ordinal());
        return result;
    }

    @Override
    @NotNull
    public ColorRGBa plus(@NotNull ColorRGBa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorRGBa.copy$default(this, this.r + right.r, this.g + right.g, this.b + right.b, this.getAlpha() + right.getAlpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorRGBa minus(@NotNull ColorRGBa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorRGBa.copy$default(this, this.r - right.r, this.g - right.g, this.b - right.b, this.getAlpha() - right.getAlpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorRGBa times(double scale) {
        return ColorRGBa.copy$default(this, this.r * scale, this.g * scale, this.b * scale, this.getAlpha() * scale, null, 16, null);
    }

    @Override
    @NotNull
    public ColorRGBa mix(@NotNull ColorRGBa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorRGBaKt.mix(this, other, factor);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.r, this.g, this.b, this.getAlpha());
    }

    public final double component1() {
        return this.r;
    }

    public final double component2() {
        return this.g;
    }

    public final double component3() {
        return this.b;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final Linearity component5() {
        return this.linearity;
    }

    @NotNull
    public final ColorRGBa copy(double r, double g, double b, double alpha, @NotNull Linearity linearity) {
        Intrinsics.checkNotNullParameter((Object)linearity, "linearity");
        return new ColorRGBa(r, g, b, alpha, linearity);
    }

    public static /* synthetic */ ColorRGBa copy$default(ColorRGBa colorRGBa, double d, double d2, double d3, double d4, Linearity linearity, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorRGBa.r;
        }
        if ((n & 2) != 0) {
            d2 = colorRGBa.g;
        }
        if ((n & 4) != 0) {
            d3 = colorRGBa.b;
        }
        if ((n & 8) != 0) {
            d4 = colorRGBa.alpha;
        }
        if ((n & 0x10) != 0) {
            linearity = colorRGBa.linearity;
        }
        return colorRGBa.copy(d, d2, d3, d4, linearity);
    }

    @NotNull
    public String toString() {
        return "ColorRGBa(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", alpha=" + this.alpha + ", linearity=" + this.linearity + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorRGBa)) {
            return false;
        }
        ColorRGBa colorRGBa = (ColorRGBa)other;
        if (Double.compare(this.r, colorRGBa.r) != 0) {
            return false;
        }
        if (Double.compare(this.g, colorRGBa.g) != 0) {
            return false;
        }
        if (Double.compare(this.b, colorRGBa.b) != 0) {
            return false;
        }
        if (Double.compare(this.alpha, colorRGBa.alpha) != 0) {
            return false;
        }
        return this.linearity == colorRGBa.linearity;
    }

    @Override
    @NotNull
    public ColorRGBa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_color(ColorRGBa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeDoubleElement(serialDesc, 0, self.r);
        output.encodeDoubleElement(serialDesc, 1, self.g);
        output.encodeDoubleElement(serialDesc, 2, self.b);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.getAlpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.getAlpha());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.linearity != Linearity.LINEAR) {
            output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)kSerializerArray[4], self.linearity);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : Double.compare(self.a, self.getAlpha()) != 0) {
            output.encodeDoubleElement(serialDesc, 5, self.a);
        }
    }

    public /* synthetic */ ColorRGBa(int seen0, double r, double g, double b, double alpha, Linearity linearity, double a, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
        this.linearity = (seen0 & 0x10) == 0 ? Linearity.LINEAR : linearity;
        this.a = (seen0 & 0x20) == 0 ? this.getAlpha() : a;
    }

    private static final double toLinear$t(double x) {
        return x <= 0.04045 ? x / 12.92 : Math.pow((x + 0.055) / 1.055, 2.4);
    }

    private static final double toSRGB$t$0(double x) {
        return x <= 0.0031308 ? 12.92 * x : 1.055 * Math.pow(x, 0.4166666666666667) - 0.055;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{null, null, null, null, Linearity.Companion.serializer(), null};
        $childSerializers = kSerializerArray;
        PINK = Companion.fromHex(16761035);
        BLACK = new ColorRGBa(0.0, 0.0, 0.0, 1.0, Linearity.SRGB);
        WHITE = new ColorRGBa(1.0, 1.0, 1.0, 1.0, Linearity.SRGB);
        RED = new ColorRGBa(1.0, 0.0, 0.0, 1.0, Linearity.SRGB);
        BLUE = new ColorRGBa(0.0, 0.0, 1.0, 1.0, Linearity.SRGB);
        GREEN = new ColorRGBa(0.0, 1.0, 0.0, 1.0, Linearity.SRGB);
        YELLOW = new ColorRGBa(1.0, 1.0, 0.0, 1.0, Linearity.SRGB);
        CYAN = new ColorRGBa(0.0, 1.0, 1.0, 1.0, Linearity.SRGB);
        MAGENTA = new ColorRGBa(1.0, 0.0, 1.0, 1.0, Linearity.SRGB);
        GRAY = new ColorRGBa(0.5, 0.5, 0.5, 1.0, Linearity.SRGB);
        TRANSPARENT = new ColorRGBa(0.0, 0.0, 0.0, 0.0, Linearity.LINEAR);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bJ\"\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020'2\b\b\u0002\u0010%\u001a\u00020&J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000bR\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000b\u00a8\u0006*"}, d2={"Lorg/openrndr/color/ColorRGBa$Companion;", "", "<init>", "()V", "fromHex", "Lorg/openrndr/color/ColorRGBa;", "hex", "", "", "PINK", "getPINK", "()Lorg/openrndr/color/ColorRGBa;", "BLACK", "getBLACK", "WHITE", "getWHITE", "RED", "getRED", "BLUE", "getBLUE", "GREEN", "getGREEN", "YELLOW", "getYELLOW", "CYAN", "getCYAN", "MAGENTA", "getMAGENTA", "GRAY", "getGRAY", "TRANSPARENT", "getTRANSPARENT", "fromVector", "vector", "Lorg/openrndr/math/Vector3;", "alpha", "", "linearity", "Lorg/openrndr/color/Linearity;", "Lorg/openrndr/math/Vector4;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorRGBa fromHex(int hex) {
            int r = (hex & 0xFF0000) >> 16;
            int g = (hex & 0xFF00) >> 8;
            int b = hex & 0xFF;
            return new ColorRGBa((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, 1.0, Linearity.SRGB);
        }

        @NotNull
        public final ColorRGBa fromHex(@NotNull String hex) {
            Intrinsics.checkNotNullParameter(hex, "hex");
            int pos = StringsKt.startsWith$default(hex, "#", false, 2, null) ? 1 : (StringsKt.startsWith$default(hex, "0x", false, 2, null) ? 2 : 0);
            return switch (hex.length() - pos) {
                case 3 -> new ColorRGBa(org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex1(hex, pos), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex1(hex, pos + 1), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex1(hex, pos + 2), 1.0, Linearity.SRGB);
                case 4 -> new ColorRGBa(org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex1(hex, pos), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex1(hex, pos + 1), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex1(hex, pos + 2), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex1(hex, pos + 3), Linearity.SRGB);
                case 6 -> new ColorRGBa(org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex2(hex, pos), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex2(hex, pos + 2), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex2(hex, pos + 4), 1.0, Linearity.SRGB);
                case 8 -> new ColorRGBa(org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex2(hex, pos), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex2(hex, pos + 2), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex2(hex, pos + 4), org.openrndr.color.ColorRGBa$Companion.fromHex$fromHex2(hex, pos + 6), Linearity.SRGB);
                default -> throw new IllegalArgumentException("Invalid hex length/format for '" + hex + "'");
            };
        }

        @NotNull
        public final ColorRGBa getPINK() {
            return PINK;
        }

        @NotNull
        public final ColorRGBa getBLACK() {
            return BLACK;
        }

        @NotNull
        public final ColorRGBa getWHITE() {
            return WHITE;
        }

        @NotNull
        public final ColorRGBa getRED() {
            return RED;
        }

        @NotNull
        public final ColorRGBa getBLUE() {
            return BLUE;
        }

        @NotNull
        public final ColorRGBa getGREEN() {
            return GREEN;
        }

        @NotNull
        public final ColorRGBa getYELLOW() {
            return YELLOW;
        }

        @NotNull
        public final ColorRGBa getCYAN() {
            return CYAN;
        }

        @NotNull
        public final ColorRGBa getMAGENTA() {
            return MAGENTA;
        }

        @NotNull
        public final ColorRGBa getGRAY() {
            return GRAY;
        }

        @NotNull
        public final ColorRGBa getTRANSPARENT() {
            return TRANSPARENT;
        }

        @NotNull
        public final ColorRGBa fromVector(@NotNull Vector3 vector, double alpha, @NotNull Linearity linearity) {
            Intrinsics.checkNotNullParameter(vector, "vector");
            Intrinsics.checkNotNullParameter((Object)linearity, "linearity");
            return new ColorRGBa(vector.x(), vector.y(), vector.z(), alpha, linearity);
        }

        public static /* synthetic */ ColorRGBa fromVector$default(Companion companion, Vector3 vector3, double d, Linearity linearity, int n, Object object) {
            if ((n & 2) != 0) {
                d = 1.0;
            }
            if ((n & 4) != 0) {
                linearity = Linearity.LINEAR;
            }
            return companion.fromVector(vector3, d, linearity);
        }

        @NotNull
        public final ColorRGBa fromVector(@NotNull Vector4 vector, @NotNull Linearity linearity) {
            Intrinsics.checkNotNullParameter(vector, "vector");
            Intrinsics.checkNotNullParameter((Object)linearity, "linearity");
            return new ColorRGBa(vector.x(), vector.y(), vector.z(), vector.w(), linearity);
        }

        public static /* synthetic */ ColorRGBa fromVector$default(Companion companion, Vector4 vector4, Linearity linearity, int n, Object object) {
            if ((n & 2) != 0) {
                linearity = Linearity.LINEAR;
            }
            return companion.fromVector(vector4, linearity);
        }

        @NotNull
        public final KSerializer<ColorRGBa> serializer() {
            return $serializer.INSTANCE;
        }

        private static final double fromHex$fromHex1(String str, int pos) {
            return (double)(17 * CharsKt.digitToInt(str.charAt(pos), 16)) / 255.0;
        }

        private static final double fromHex$fromHex2(String str, int pos) {
            return (double)(16 * CharsKt.digitToInt(str.charAt(pos), 16) + CharsKt.digitToInt(str.charAt(pos + 1), 16)) / 255.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/color/ColorRGBa$Component;", "", "<init>", "(Ljava/lang/String;I)V", "R", "G", "B", "openrndr-color"})
    public static final class Component
    extends Enum<Component> {
        public static final /* enum */ Component R = new Component();
        public static final /* enum */ Component G = new Component();
        public static final /* enum */ Component B = new Component();
        private static final /* synthetic */ Component[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Component[] values() {
            return (Component[])$VALUES.clone();
        }

        public static Component valueOf(String value) {
            return Enum.valueOf(Component.class, value);
        }

        @NotNull
        public static EnumEntries<Component> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = componentArray = new Component[]{Component.R, Component.G, Component.B};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Linearity.values().length];
            try {
                nArray[Linearity.SRGB.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Linearity.LINEAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

