/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.dds;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.CubemapFunctions;
import org.openrndr.draw.CubemapSide;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.draw.Session;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0007J\u0010\u0010\u001a\u001a\u00020\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u0007J\u0010\u0010\u001b\u001a\u00020\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\u00020\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u0007J\u0010\u0010\u001d\u001a\u00020\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u0007J\u0010\u0010\u001e\u001a\u00020\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u0007J\u0016\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u0007J\u0012\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&J\u0012\u0010'\u001a\u00020(2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0007H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\t\u0010.\u001a\u00020\u000bH\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\t\u00101\u001a\u00020\u000bH\u00c6\u0003Jo\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000bH\u00c6\u0001J\u0013\u00103\u001a\u00020\u000b2\b\u00104\u001a\u0004\u0018\u000105H\u00d6\u0003J\t\u00106\u001a\u00020\u0007H\u00d6\u0001J\t\u00107\u001a\u000208H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0016R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0017R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0017R\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0016\u00a8\u00069"}, d2={"Lorg/openrndr/dds/DDSData;", "Ljava/lang/Record;", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "width", "", "height", "mipmaps", "cubeMap", "", "bdata", "", "Lorg/openrndr/utils/buffer/MPPBuffer;", "bdata2", "flipV", "<init>", "(Lorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;IIIZLjava/util/List;Ljava/util/List;Z)V", "()Lorg/openrndr/draw/ColorFormat;", "()Lorg/openrndr/draw/ColorType;", "()I", "()Z", "()Ljava/util/List;", "image", "level", "sidePX", "sideNX", "sidePY", "sideNY", "sidePZ", "sideNZ", "side", "cubemapSide", "Lorg/openrndr/draw/CubemapSide;", "toColorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "session", "Lorg/openrndr/draw/Session;", "toCubemap", "Lorg/openrndr/draw/Cubemap;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "toString", "", "openrndr-dds"})
public final class DDSData
extends Record {
    @NotNull
    private final ColorFormat format;
    @NotNull
    private final ColorType type;
    private final int width;
    private final int height;
    private final int mipmaps;
    private final boolean cubeMap;
    @NotNull
    private final List<MPPBuffer> bdata;
    @NotNull
    private final List<MPPBuffer> bdata2;
    private final boolean flipV;

    public DDSData(@NotNull ColorFormat format, @NotNull ColorType type, int width, int height, int mipmaps, boolean cubeMap, @NotNull List<MPPBuffer> bdata, @NotNull List<MPPBuffer> bdata2, boolean flipV) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(bdata, "bdata");
        Intrinsics.checkNotNullParameter(bdata2, "bdata2");
        this.format = format;
        this.type = type;
        this.width = width;
        this.height = height;
        this.mipmaps = mipmaps;
        this.cubeMap = cubeMap;
        this.bdata = bdata;
        this.bdata2 = bdata2;
        this.flipV = flipV;
    }

    @NotNull
    public final ColorFormat format() {
        return this.format;
    }

    @NotNull
    public final ColorType type() {
        return this.type;
    }

    public final int width() {
        return this.width;
    }

    public final int height() {
        return this.height;
    }

    public final int mipmaps() {
        return this.mipmaps;
    }

    public final boolean cubeMap() {
        return this.cubeMap;
    }

    @NotNull
    public final List<MPPBuffer> bdata() {
        return this.bdata;
    }

    @NotNull
    public final List<MPPBuffer> bdata2() {
        return this.bdata2;
    }

    public final boolean flipV() {
        return this.flipV;
    }

    @NotNull
    public final MPPBuffer image(int level) {
        return level == 0 ? this.bdata.get(0) : this.bdata2.get(level - 1);
    }

    @NotNull
    public final MPPBuffer sidePX(int level) {
        return level == 0 ? this.bdata.get(0) : this.bdata2.get(level - 1 + 0 * (this.mipmaps - 1));
    }

    public static /* synthetic */ MPPBuffer sidePX$default(DDSData dDSData, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return dDSData.sidePX(n);
    }

    @NotNull
    public final MPPBuffer sideNX(int level) {
        return level == 0 ? this.bdata.get(1) : this.bdata2.get(level - 1 + 1 * (this.mipmaps - 1));
    }

    public static /* synthetic */ MPPBuffer sideNX$default(DDSData dDSData, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return dDSData.sideNX(n);
    }

    @NotNull
    public final MPPBuffer sidePY(int level) {
        return level == 0 ? this.bdata.get(2) : this.bdata2.get(level - 1 + 2 * (this.mipmaps - 1));
    }

    public static /* synthetic */ MPPBuffer sidePY$default(DDSData dDSData, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return dDSData.sidePY(n);
    }

    @NotNull
    public final MPPBuffer sideNY(int level) {
        return level == 0 ? this.bdata.get(3) : this.bdata2.get(level - 1 + 3 * (this.mipmaps - 1));
    }

    public static /* synthetic */ MPPBuffer sideNY$default(DDSData dDSData, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return dDSData.sideNY(n);
    }

    @NotNull
    public final MPPBuffer sidePZ(int level) {
        return level == 0 ? this.bdata.get(4) : this.bdata2.get(level - 1 + 4 * (this.mipmaps - 1));
    }

    public static /* synthetic */ MPPBuffer sidePZ$default(DDSData dDSData, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return dDSData.sidePZ(n);
    }

    @NotNull
    public final MPPBuffer sideNZ(int level) {
        return level == 0 ? this.bdata.get(5) : this.bdata2.get(level - 1 + 5 * (this.mipmaps - 1));
    }

    public static /* synthetic */ MPPBuffer sideNZ$default(DDSData dDSData, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return dDSData.sideNZ(n);
    }

    @NotNull
    public final MPPBuffer side(@NotNull CubemapSide cubemapSide, int level) {
        Intrinsics.checkNotNullParameter((Object)cubemapSide, "cubemapSide");
        return switch (WhenMappings.$EnumSwitchMapping$0[cubemapSide.ordinal()]) {
            case 1 -> this.sidePX(level);
            case 2 -> this.sidePY(level);
            case 3 -> this.sidePZ(level);
            case 4 -> this.sideNX(level);
            case 5 -> this.sideNY(level);
            case 6 -> this.sideNZ(level);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final ColorBuffer toColorBuffer(@Nullable Session session) {
        ColorBuffer colorBuffer;
        if (!(!this.cubeMap)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ColorBuffer $this$toColorBuffer_u24lambda_u240 = colorBuffer = ColorBufferKt.colorBuffer$default(this.width, this.height, 1.0, this.format, this.type, null, this.mipmaps, session, 32, null);
        boolean bl = false;
        $this$toColorBuffer_u24lambda_u240.setFlipV(this.flipV);
        ColorBuffer cb = colorBuffer;
        int n = this.mipmaps;
        for (int level = 0; level < n; ++level) {
            int div = 1 << level;
            ColorBuffer.write$default(cb, this.image(0), this.format, this.type, 0, 0, this.width / div, this.height / div, level, 24, null);
        }
        return cb;
    }

    public static /* synthetic */ ColorBuffer toColorBuffer$default(DDSData dDSData, Session session, int n, Object object) {
        if ((n & 1) != 0) {
            session = Session.Companion.getActive();
        }
        return dDSData.toColorBuffer(session);
    }

    @NotNull
    public final Cubemap toCubemap(@Nullable Session session) {
        if (!this.cubeMap) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Cubemap cm = CubemapFunctions.cubemap(this.width, this.format, this.type, this.mipmaps, session);
        int n = this.mipmaps;
        for (int level = 0; level < n; ++level) {
            int levelWidth = this.width / (1 << level);
            for (CubemapSide side : CubemapSide.values()) {
                cm.write(side, this.side(side, level), this.format, this.type, 0, 0, levelWidth, levelWidth, level);
            }
        }
        if (this.mipmaps == 1) {
            cm.generateMipmaps();
        }
        cm.filter(MinifyingFilter.LINEAR, MagnifyingFilter.LINEAR);
        return cm;
    }

    public static /* synthetic */ Cubemap toCubemap$default(DDSData dDSData, Session session, int n, Object object) {
        if ((n & 1) != 0) {
            session = Session.Companion.getActive();
        }
        return dDSData.toCubemap(session);
    }

    @NotNull
    public final ColorFormat component1() {
        return this.format;
    }

    @NotNull
    public final ColorType component2() {
        return this.type;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    public final int component5() {
        return this.mipmaps;
    }

    public final boolean component6() {
        return this.cubeMap;
    }

    @NotNull
    public final List<MPPBuffer> component7() {
        return this.bdata;
    }

    @NotNull
    public final List<MPPBuffer> component8() {
        return this.bdata2;
    }

    public final boolean component9() {
        return this.flipV;
    }

    @NotNull
    public final DDSData copy(@NotNull ColorFormat format, @NotNull ColorType type, int width, int height, int mipmaps, boolean cubeMap, @NotNull List<MPPBuffer> bdata, @NotNull List<MPPBuffer> bdata2, boolean flipV) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(bdata, "bdata");
        Intrinsics.checkNotNullParameter(bdata2, "bdata2");
        return new DDSData(format, type, width, height, mipmaps, cubeMap, bdata, bdata2, flipV);
    }

    public static /* synthetic */ DDSData copy$default(DDSData dDSData, ColorFormat colorFormat, ColorType colorType, int n, int n2, int n3, boolean bl, List list, List list2, boolean bl2, int n4, Object object) {
        if ((n4 & 1) != 0) {
            colorFormat = dDSData.format;
        }
        if ((n4 & 2) != 0) {
            colorType = dDSData.type;
        }
        if ((n4 & 4) != 0) {
            n = dDSData.width;
        }
        if ((n4 & 8) != 0) {
            n2 = dDSData.height;
        }
        if ((n4 & 0x10) != 0) {
            n3 = dDSData.mipmaps;
        }
        if ((n4 & 0x20) != 0) {
            bl = dDSData.cubeMap;
        }
        if ((n4 & 0x40) != 0) {
            list = dDSData.bdata;
        }
        if ((n4 & 0x80) != 0) {
            list2 = dDSData.bdata2;
        }
        if ((n4 & 0x100) != 0) {
            bl2 = dDSData.flipV;
        }
        return dDSData.copy(colorFormat, colorType, n, n2, n3, bl, list, list2, bl2);
    }

    @Override
    @NotNull
    public String toString() {
        return "DDSData(format=" + this.format + ", type=" + this.type + ", width=" + this.width + ", height=" + this.height + ", mipmaps=" + this.mipmaps + ", cubeMap=" + this.cubeMap + ", bdata=" + this.bdata + ", bdata2=" + this.bdata2 + ", flipV=" + this.flipV + ")";
    }

    @Override
    public int hashCode() {
        int result = this.format.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + Integer.hashCode(this.width);
        result = result * 31 + Integer.hashCode(this.height);
        result = result * 31 + Integer.hashCode(this.mipmaps);
        result = result * 31 + Boolean.hashCode(this.cubeMap);
        result = result * 31 + ((Object)this.bdata).hashCode();
        result = result * 31 + ((Object)this.bdata2).hashCode();
        result = result * 31 + Boolean.hashCode(this.flipV);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DDSData)) {
            return false;
        }
        DDSData dDSData = (DDSData)other;
        if (this.format != dDSData.format) {
            return false;
        }
        if (this.type != dDSData.type) {
            return false;
        }
        if (this.width != dDSData.width) {
            return false;
        }
        if (this.height != dDSData.height) {
            return false;
        }
        if (this.mipmaps != dDSData.mipmaps) {
            return false;
        }
        if (this.cubeMap != dDSData.cubeMap) {
            return false;
        }
        if (!Intrinsics.areEqual(this.bdata, dDSData.bdata)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.bdata2, dDSData.bdata2)) {
            return false;
        }
        return this.flipV == dDSData.flipV;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CubemapSide.values().length];
            try {
                nArray[CubemapSide.POSITIVE_X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.POSITIVE_Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.POSITIVE_Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.NEGATIVE_X.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.NEGATIVE_Y.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.NEGATIVE_Z.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

