/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.nio.ByteBuffer;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferAlignment;
import org.openrndr.draw.BufferPrimitiveType;
import org.openrndr.draw.BufferReader;
import org.openrndr.draw.ByteBufferReaderKt;
import org.openrndr.draw.ShaderStorageElement;
import org.openrndr.draw.ShaderStoragePrimitive;
import org.openrndr.draw.ShaderStorageStruct;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lorg/openrndr/draw/ByteBufferReader;", "Lorg/openrndr/draw/BufferReader;", "buffer", "Ljava/nio/ByteBuffer;", "alignment", "Lorg/openrndr/draw/BufferAlignment;", "elementIterator", "", "Lorg/openrndr/draw/ShaderStorageElement;", "<init>", "(Ljava/nio/ByteBuffer;Lorg/openrndr/draw/BufferAlignment;Ljava/util/Iterator;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "getAlignment", "()Lorg/openrndr/draw/BufferAlignment;", "getElementIterator", "()Ljava/util/Iterator;", "next", "", "type", "Lorg/openrndr/draw/BufferPrimitiveType;", "rewind", "readVector2", "Lorg/openrndr/math/Vector2;", "readVector3", "Lorg/openrndr/math/Vector3;", "readVector4", "Lorg/openrndr/math/Vector4;", "readIntVector2", "Lorg/openrndr/math/IntVector2;", "readIntVector3", "Lorg/openrndr/math/IntVector3;", "readIntVector4", "Lorg/openrndr/math/IntVector4;", "readColorRGBa", "Lorg/openrndr/color/ColorRGBa;", "readFloat", "", "readMatrix33", "Lorg/openrndr/math/Matrix33;", "readMatrix44", "Lorg/openrndr/math/Matrix44;", "openrndr-draw"})
public final class ByteBufferReader
implements BufferReader {
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private final BufferAlignment alignment;
    @Nullable
    private final Iterator<ShaderStorageElement> elementIterator;

    public ByteBufferReader(@NotNull ByteBuffer buffer, @NotNull BufferAlignment alignment, @Nullable Iterator<? extends ShaderStorageElement> elementIterator) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter((Object)alignment, "alignment");
        this.buffer = buffer;
        this.alignment = alignment;
        this.elementIterator = elementIterator;
    }

    public /* synthetic */ ByteBufferReader(ByteBuffer byteBuffer, BufferAlignment bufferAlignment, Iterator iterator2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bufferAlignment = BufferAlignment.NONE;
        }
        this(byteBuffer, bufferAlignment, iterator2);
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final BufferAlignment getAlignment() {
        return this.alignment;
    }

    @Nullable
    public final Iterator<ShaderStorageElement> getElementIterator() {
        return this.elementIterator;
    }

    private final void next(BufferPrimitiveType type) {
        if (this.elementIterator != null) {
            ShaderStorageElement element = this.elementIterator.next();
            ShaderStorageElement shaderStorageElement = element;
            if (shaderStorageElement instanceof ShaderStoragePrimitive) {
                if (!(((ShaderStoragePrimitive)element).getType() == type)) {
                    boolean bl = false;
                    String string = "Type mismatch in ShaderStoragePrimitive: expected '" + ((ShaderStoragePrimitive)element).getType() + "', but received '" + type + "'.";
                    throw new IllegalArgumentException(string.toString());
                }
            } else if (shaderStorageElement instanceof ShaderStorageStruct) {
                int n;
                int n2 = this.buffer.position();
                int n3 = n2 % (n = ((ShaderStorageStruct)element).alignmentInBytes());
                if (n3 + (n & ((n3 ^ n) & (n3 | -n3)) >> 31) != 0) {
                    n2 = this.buffer.position();
                    n = ((ShaderStorageStruct)element).alignmentInBytes();
                    n3 = n2 % n;
                    this.buffer.position(this.buffer.position() + ((ShaderStorageStruct)element).alignmentInBytes() - (n3 + (n & ((n3 ^ n) & (n3 | -n3)) >> 31)));
                }
                this.next(type);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void rewind() {
        this.buffer.rewind();
    }

    @Override
    @NotNull
    public Vector2 readVector2() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 8);
        }
        this.next(BufferPrimitiveType.VECTOR2_FLOAT32);
        double x = this.buffer.getFloat();
        double y = this.buffer.getFloat();
        return new Vector2(x, y);
    }

    @Override
    @NotNull
    public Vector3 readVector3() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR3_FLOAT32);
        double x = this.buffer.getFloat();
        double y = this.buffer.getFloat();
        double z = this.buffer.getFloat();
        return new Vector3(x, y, z);
    }

    @Override
    @NotNull
    public Vector4 readVector4() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR4_FLOAT32);
        double x = this.buffer.getFloat();
        double y = this.buffer.getFloat();
        double z = this.buffer.getFloat();
        double w = this.buffer.getFloat();
        return new Vector4(x, y, z, w);
    }

    @Override
    @NotNull
    public IntVector2 readIntVector2() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 8);
        }
        this.next(BufferPrimitiveType.VECTOR2_INT32);
        int x = this.buffer.getInt();
        int y = this.buffer.getInt();
        return new IntVector2(x, y);
    }

    @Override
    @NotNull
    public IntVector3 readIntVector3() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR3_INT32);
        int x = this.buffer.getInt();
        int y = this.buffer.getInt();
        int z = this.buffer.getInt();
        return new IntVector3(x, y, z);
    }

    @Override
    @NotNull
    public IntVector4 readIntVector4() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR4_INT32);
        int x = this.buffer.getInt();
        int y = this.buffer.getInt();
        int z = this.buffer.getInt();
        int w = this.buffer.getInt();
        return new IntVector4(x, y, z, w);
    }

    @Override
    @NotNull
    public ColorRGBa readColorRGBa() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.VECTOR4_FLOAT32);
        double r = this.buffer.getFloat();
        double g = this.buffer.getFloat();
        double b = this.buffer.getFloat();
        double a = this.buffer.getFloat();
        return new ColorRGBa(r, g, b, a, null, 16, null);
    }

    @Override
    public float readFloat() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 4);
        }
        this.next(BufferPrimitiveType.FLOAT32);
        return this.buffer.getFloat();
    }

    @Override
    @NotNull
    public Matrix33 readMatrix33() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.MATRIX33_FLOAT32);
        double m00 = this.buffer.getFloat();
        double m01 = this.buffer.getFloat();
        double m02 = this.buffer.getFloat();
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 16);
        }
        double m10 = this.buffer.getFloat();
        double m11 = this.buffer.getFloat();
        double m12 = this.buffer.getFloat();
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 16);
        }
        double m20 = this.buffer.getFloat();
        double m21 = this.buffer.getFloat();
        double m22 = this.buffer.getFloat();
        return new Matrix33(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    @Override
    @NotNull
    public Matrix44 readMatrix44() {
        if (this.alignment == BufferAlignment.STD430) {
            ByteBufferReaderKt.access$alignTo(this.buffer, 16);
        }
        this.next(BufferPrimitiveType.MATRIX44_FLOAT32);
        double m00 = this.buffer.getFloat();
        double m01 = this.buffer.getFloat();
        double m02 = this.buffer.getFloat();
        double m03 = this.buffer.getFloat();
        double m10 = this.buffer.getFloat();
        double m11 = this.buffer.getFloat();
        double m12 = this.buffer.getFloat();
        double m13 = this.buffer.getFloat();
        double m20 = this.buffer.getFloat();
        double m21 = this.buffer.getFloat();
        double m22 = this.buffer.getFloat();
        double m23 = this.buffer.getFloat();
        double m30 = this.buffer.getFloat();
        double m31 = this.buffer.getFloat();
        double m32 = this.buffer.getFloat();
        double m33 = this.buffer.getFloat();
        return new Matrix44(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }
}

