/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw.font;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.openrndr.draw.font.Face;
import org.openrndr.draw.font.Glyph;
import org.openrndr.draw.font.GlyphStbTt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/draw/font/FaceStbTt;", "Lorg/openrndr/draw/font/Face;", "data", "Ljava/nio/ByteBuffer;", "fontInfo", "Lorg/lwjgl/stb/STBTTFontinfo;", "<init>", "(Ljava/nio/ByteBuffer;Lorg/lwjgl/stb/STBTTFontinfo;)V", "getFontInfo", "()Lorg/lwjgl/stb/STBTTFontinfo;", "state", "Lorg/openrndr/draw/font/FaceStbTt$State;", "ascentMetrics", "", "descentMetrics", "lineGapMetrics", "kernAdvance", "", "scale", "left", "", "right", "glyphForCharacter", "Lorg/openrndr/draw/font/Glyph;", "character", "bounds", "Lorg/openrndr/shape/Rectangle;", "close", "", "unitsPerEm", "State", "openrndr-gl3"})
public final class FaceStbTt
implements Face {
    @NotNull
    private final State state;

    public FaceStbTt(@NotNull ByteBuffer data, @NotNull STBTTFontinfo fontInfo) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(fontInfo, "fontInfo");
        this.state = new State(data, fontInfo);
    }

    @NotNull
    public final STBTTFontinfo getFontInfo() {
        return this.state.getFontInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ascentMetrics() {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack it = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer intBuffer = it.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer, "mallocInt(...)");
            IntBuffer ascent = intBuffer;
            STBTruetype.stbtt_GetFontVMetrics(this.state.getFontInfo(), ascent, null, null);
            int n = ascent.get(0);
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int descentMetrics() {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack it = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer intBuffer = it.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer, "mallocInt(...)");
            IntBuffer descent = intBuffer;
            STBTruetype.stbtt_GetFontVMetrics(this.state.getFontInfo(), null, descent, null);
            int n = descent.get(0);
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lineGapMetrics() {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack it = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer intBuffer = it.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer, "mallocInt(...)");
            IntBuffer lineGap = intBuffer;
            STBTruetype.stbtt_GetFontVMetrics(this.state.getFontInfo(), null, null, lineGap);
            int n = lineGap.get(0);
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public double kernAdvance(double scale, char left, char right) {
        int leftIdx = STBTruetype.stbtt_FindGlyphIndex(this.state.getFontInfo(), left);
        int rightIdx = STBTruetype.stbtt_FindGlyphIndex(this.state.getFontInfo(), right);
        return (double)STBTruetype.stbtt_GetGlyphKernAdvance(this.state.getFontInfo(), leftIdx, rightIdx) * scale;
    }

    @Override
    @NotNull
    public Glyph glyphForCharacter(char character) {
        int glyphIndex = STBTruetype.stbtt_FindGlyphIndex(this.state.getFontInfo(), character);
        return new GlyphStbTt(this, character, glyphIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Rectangle bounds(double scale) {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer intBuffer = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer, "mallocInt(...)");
            IntBuffer px0 = intBuffer;
            IntBuffer intBuffer2 = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer2, "mallocInt(...)");
            IntBuffer px1 = intBuffer2;
            IntBuffer intBuffer3 = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer3, "mallocInt(...)");
            IntBuffer py0 = intBuffer3;
            IntBuffer intBuffer4 = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer4, "mallocInt(...)");
            IntBuffer py1 = intBuffer4;
            STBTruetype.stbtt_GetFontBoundingBox(this.state.getFontInfo(), px0, py0, px1, py1);
            double x0 = (double)px0.get() * scale;
            double y0 = (double)py0.get() * scale;
            double x1 = (double)px1.get() * scale;
            double y1 = (double)py1.get() * scale;
            Rectangle rectangle = RectangleKt.Rectangle(x0, -y0, x1 - x0, -(y1 - y0)).normalized();
            return rectangle;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public void close() {
        this.state.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unitsPerEm() {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack it = (MemoryStack)autoCloseable;
            boolean bl = false;
            float scale = STBTruetype.stbtt_ScaleForMappingEmToPixels(this.state.getFontInfo(), 1000.0f);
            int n = (int)(1000.0f / scale);
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public double ascent(double scale) {
        return Face.DefaultImpls.ascent(this, scale);
    }

    @Override
    public double descent(double scale) {
        return Face.DefaultImpls.descent(this, scale);
    }

    @Override
    public double lineGap(double scale) {
        return Face.DefaultImpls.lineGap(this, scale);
    }

    @Override
    public double lineSpace(double scale) {
        return Face.DefaultImpls.lineSpace(this, scale);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/draw/font/FaceStbTt$State;", "", "data", "Ljava/nio/ByteBuffer;", "fontInfo", "Lorg/lwjgl/stb/STBTTFontinfo;", "<init>", "(Ljava/nio/ByteBuffer;Lorg/lwjgl/stb/STBTTFontinfo;)V", "getData", "()Ljava/nio/ByteBuffer;", "getFontInfo", "()Lorg/lwjgl/stb/STBTTFontinfo;", "destroy", "", "openrndr-gl3"})
    public static final class State {
        @NotNull
        private final ByteBuffer data;
        @NotNull
        private final STBTTFontinfo fontInfo;

        public State(@NotNull ByteBuffer data, @NotNull STBTTFontinfo fontInfo) {
            Intrinsics.checkNotNullParameter(data, "data");
            Intrinsics.checkNotNullParameter(fontInfo, "fontInfo");
            this.data = data;
            this.fontInfo = fontInfo;
        }

        @NotNull
        public final ByteBuffer getData() {
            return this.data;
        }

        @NotNull
        public final STBTTFontinfo getFontInfo() {
            return this.fontInfo;
        }

        public final void destroy() {
            MemoryUtil.memFree(this.data);
        }
    }
}

