/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.exceptions;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.exceptions.SanitizingUncaughtExceptionHandler;
import org.openrndr.platform.Platform;
import org.openrndr.platform.PlatformType;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0003\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\b\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "installUncaughtExceptionHandler", "", "color", "", "r", "", "g", "b", "colorReset", "cleanClassName", "name", "cleanMethodName", "findUserCause", "throwable", "", "openrndr-application"})
@SourceDebugExtension(value={"SMAP\nExceptionSanitizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionSanitizer.kt\norg/openrndr/exceptions/ExceptionSanitizerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n388#2,7:122\n1872#2,2:129\n774#2:131\n865#2,2:132\n1557#2:134\n1628#2,3:135\n1874#2:138\n*S KotlinDebug\n*F\n+ 1 ExceptionSanitizer.kt\norg/openrndr/exceptions/ExceptionSanitizerKt\n*L\n50#1:122,7\n54#1:129,2\n70#1:131\n70#1:132,2\n70#1:134\n70#1:135,3\n54#1:138\n*E\n"})
public final class ExceptionSanitizerKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger("");

    public static final void installUncaughtExceptionHandler() {
        if (Platform.INSTANCE.getType() != PlatformType.WINDOWS) {
            System.err.print(ExceptionSanitizerKt.color(127, 127, 127));
            if (Intrinsics.areEqual(System.getProperty("org.openrndr.exceptions"), "pretty")) {
                Thread.setDefaultUncaughtExceptionHandler(new SanitizingUncaughtExceptionHandler());
            }
        }
    }

    private static final String color(int r, int g, int b) {
        String string = "\u001b[38;2;%d;%d;%dm";
        Object[] objectArray = new Object[]{r, g, b};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final String colorReset() {
        return "\u001b[0m";
    }

    private static final String cleanClassName(String name) {
        CharSequence charSequence = StringsKt.replace$default(name, "Kt$", ".", false, 4, null);
        Regex regex = new Regex("\\$[0-9]+");
        String string = ".{ }";
        return StringsKt.replace$default(regex.replace(charSequence, string), "$", ".", false, 4, null);
    }

    private static final String cleanMethodName(String name) {
        return Intrinsics.areEqual(name, "invoke") ? ".{ }" : "." + name;
    }

    /*
     * WARNING - void declaration
     */
    public static final void findUserCause(@NotNull Throwable throwable) {
        int n;
        block14: {
            Intrinsics.checkNotNullParameter(throwable, "throwable");
            logger.info(ExceptionSanitizerKt::findUserCause$lambda$0);
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "getStackTrace(...)");
            List<Object> $this$indexOfLast$iv = ArraysKt.reversed((Object[])stackTraceElementArray);
            boolean $i$f$indexOfLast = false;
            ListIterator<Object> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                StackTraceElement it = (StackTraceElement)iterator$iv.previous();
                boolean bl = false;
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue(string, "getClassName(...)");
                if (!(!StringsKt.contains$default((CharSequence)string, "org.openrndr", false, 2, null))) continue;
                n = iterator$iv.nextIndex();
                break block14;
            }
            n = -1;
        }
        int bestSolution = n;
        System.err.println();
        System.err.println();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "getStackTrace(...)");
        Iterable $this$forEachIndexed$iv = ArraysKt.reversed((Object[])stackTraceElementArray);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object part22;
            void it;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            StackTraceElement stackTraceElement = (StackTraceElement)item$iv;
            int index = n2;
            boolean bl = false;
            throwable.getStackTrace();
            String string = it.getClassName();
            Intrinsics.checkNotNullExpressionValue(string, "getClassName(...)");
            String[] stringArray = new String[]{"$"};
            List parts = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            Object query = (String)parts.get(0);
            List lambdaReceiverTypes = new ArrayList();
            for (Object part22 : CollectionsKt.drop(parts, 1)) {
                query = (String)query + "$" + (String)part22;
                try {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    String it2;
                    void $this$filterTo$iv$iv;
                    Metadata annotation;
                    Class<?> cl = Class.forName((String)query);
                    if (cl == null || !Intrinsics.areEqual(cl.getSuperclass().getTypeName(), "kotlin.jvm.internal.Lambda") || (annotation = cl.getAnnotation(Metadata.class)) == null) continue;
                    String[] stringArray2 = new String[]{";"};
                    Iterable $this$filter$iv = StringsKt.split$default((CharSequence)annotation.d2()[2], stringArray2, false, 0, 6, null);
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it2 = (String)element$iv$iv;
                        boolean bl2 = false;
                        boolean bl3 = !StringsKt.isBlank(it2);
                        if (!bl3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        it2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        String[] stringArray3 = new String[]{"/"};
                        collection.add((String)CollectionsKt.last(StringsKt.split$default((CharSequence)it3, stringArray3, false, 0, 6, null)));
                    }
                    String types = CollectionsKt.joinToString$default((List)destination$iv$iv, ", ", null, null, 0, null, null, 62, null);
                    lambdaReceiverTypes.add(types);
                }
                catch (ClassNotFoundException cl) {}
            }
            String string2 = it.getClassName();
            Intrinsics.checkNotNullExpressionValue(string2, "getClassName(...)");
            String filledName = ExceptionSanitizerKt.cleanClassName(string2);
            part22 = lambdaReceiverTypes.iterator();
            while (part22.hasNext()) {
                String receiver = (String)part22.next();
                filledName = StringsKt.replaceFirst$default(filledName, "{ }", "{ :" + receiver + " }", false, 4, null);
            }
            String string3 = it.getMethodName();
            Intrinsics.checkNotNullExpressionValue(string3, "getMethodName(...)");
            String cleanName = filledName + ExceptionSanitizerKt.cleanMethodName(string3);
            String string4 = it.getClassName();
            Intrinsics.checkNotNullExpressionValue(string4, "getClassName(...)");
            if (!StringsKt.contains$default((CharSequence)string4, "org.openrndr", false, 2, null) && it.getLineNumber() >= 0) {
                if (index == bestSolution) {
                    System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u251c\u2500 " + ExceptionSanitizerKt.color(255, 192, 203) + cleanName + "(" + it.getFileName() + ":" + it.getLineNumber() + ")" + ExceptionSanitizerKt.colorReset());
                    continue;
                }
                System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u251c\u2500 " + ExceptionSanitizerKt.color(127, 127, 127) + cleanName + "(" + it.getFileName() + ":" + it.getLineNumber() + ")" + ExceptionSanitizerKt.colorReset());
                continue;
            }
            System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u2502  " + ExceptionSanitizerKt.color(79, 79, 79) + cleanName + "(" + it.getFileName() + ":" + it.getLineNumber() + ")" + ExceptionSanitizerKt.colorReset());
        }
        System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u2502" + ExceptionSanitizerKt.colorReset());
        System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u2191 " + ExceptionSanitizerKt.color(255, 192, 203) + throwable.getMessage() + " (" + Reflection.getOrCreateKotlinClass(throwable.getClass()).getSimpleName() + ")" + ExceptionSanitizerKt.colorReset() + " ");
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            StackTraceElement[] stackTraceElementArray2 = cause.getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray2, "getStackTrace(...)");
            StackTraceElement line = (StackTraceElement)ArraysKt.first((Object[])stackTraceElementArray2);
            String string = line.getClassName();
            Intrinsics.checkNotNullExpressionValue(string, "getClassName(...)");
            String filledName = ExceptionSanitizerKt.cleanClassName(string);
            String string5 = line.getMethodName();
            Intrinsics.checkNotNullExpressionValue(string5, "getMethodName(...)");
            String cleanName = filledName + ExceptionSanitizerKt.cleanMethodName(string5);
            System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u251c\u2500 " + ExceptionSanitizerKt.color(127, 127, 127) + cleanName + "(" + line.getFileName() + ":" + line.getLineNumber() + ")" + ExceptionSanitizerKt.colorReset());
        }
        if (throwable instanceof NoSuchMethodError || throwable instanceof ClassNotFoundException) {
            String string = throwable.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, "org.openrndr", false, 2, null) : false;
            if (bl) {
                System.err.println();
                logger.error(ExceptionSanitizerKt::findUserCause$lambda$5);
            }
        }
    }

    private static final Object findUserCause$lambda$0() {
        return "Set -Dorg.openrndr.exceptions=JVM for conventional exception-handling";
    }

    private static final Object findUserCause$lambda$5() {
        return "You are likely using incompatible versions of OPENRNDR and ORX. Fix imports and make sure to clean and rebuild your project.";
    }
}

